/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.cdma;

import org.seamcat.model.factory.Factory;
import org.seamcat.model.types.CDMALLDPoint;

public class CDMALinkLevelDataPoint {
    private static int geometryPrecission = 1;
    private double ecior;
    private double frequency;
    private double geometry;
    private int path;
    private double speed;

    public CDMALinkLevelDataPoint(CDMALinkLevelDataPoint pt) {
        this.frequency = pt.frequency;
        this.path = pt.path;
        this.geometry = pt.geometry;
        this.speed = pt.speed;
        this.ecior = pt.ecior;
    }

    public CDMALinkLevelDataPoint(double frequency, int path, double geometry, double speed, double ecior) {
        this.frequency = frequency;
        this.path = path;
        this.geometry = geometry;
        this.speed = speed;
        this.ecior = ecior;
    }

    public CDMALinkLevelDataPoint(CDMALLDPoint point, double frequency, int path) {
        this.geometry = point.geo();
        this.speed = point.speed();
        this.ecior = point.ecior();
        this.frequency = frequency;
        this.path = path;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CDMALinkLevelDataPoint)) {
            return false;
        }
        CDMALinkLevelDataPoint p = (CDMALinkLevelDataPoint)obj;
        return this.getPath() == p.getPath() && (int)this.getFrequency() == (int)p.getFrequency() && (int)this.getSpeed() == (int)p.getSpeed() && this.getGeometry() == p.getGeometry();
    }

    public double getEbNo() {
        return this.ecior;
    }

    public double getEcIor() {
        return this.ecior;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public double getGeometry() {
        double geo = Math.rint(this.geometry * (double)geometryPrecission) / (double)geometryPrecission;
        return geo;
    }

    public int getPath() {
        return this.path;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setEcior(double ecior) {
        this.ecior = ecior;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public void setGeometry(double geometry) {
        this.geometry = geometry;
    }

    public void setPath(int path) {
        this.path = path;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public CDMALLDPoint getModel() {
        CDMALLDPoint prototype = Factory.prototype(CDMALLDPoint.class);
        Factory.when(prototype.geo()).thenReturn(this.geometry);
        Factory.when(prototype.speed()).thenReturn(this.speed);
        Factory.when(prototype.ecior()).thenReturn(this.ecior);
        return Factory.build(prototype);
    }

    public String toString() {
        return this.frequency + "MHz, " + this.path + "-path, " + (int)this.geometry + "dB Geometry, " + this.speed + "km/h";
    }
}

