/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.cdma;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.seamcat.cdma.CDMALinkLevelDataPoint;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.types.CDMALLD;
import org.seamcat.model.types.CDMALLDPath;
import org.seamcat.model.types.CDMALLDPoint;
import org.seamcat.presentation.systems.cdma.CDMAEditModel;

public class CDMALinkLevelData {
    private static final Comparator<CDMALinkLevelDataPoint> DATAPOINT_COMPARATOR_ASCENDING_GEOMETRY = new Comparator<CDMALinkLevelDataPoint>(){

        @Override
        public int compare(CDMALinkLevelDataPoint p1, CDMALinkLevelDataPoint p2) {
            return -DATAPOINT_COMPARATOR_DESCENDING_GEOMETRY.compare(p1, p2);
        }
    };
    private static final Comparator<CDMALinkLevelDataPoint> DATAPOINT_COMPARATOR_DESCENDING_GEOMETRY = new Comparator<CDMALinkLevelDataPoint>(){

        @Override
        public int compare(CDMALinkLevelDataPoint p1, CDMALinkLevelDataPoint p2) {
            double result = p1.getPath() != p2.getPath() ? (double)(p2.getPath() - p1.getPath()) : (p1.getGeometry() != p2.getGeometry() ? (p2.getGeometry() > p1.getGeometry() ? 1.0 : -1.0) : ((int)p1.getSpeed() != (int)p2.getSpeed() ? (double)((int)(p2.getSpeed() - p1.getSpeed())) : 0.0));
            return (int)Math.rint(result);
        }
    };
    private static final Logger LOG = Logger.getLogger(CDMALinkLevelData.class);
    public static final double MAX_EC_IOR = 0.0;
    private static final int MAX_PATH_VALUE = 2;
    public static final double[] SPEED_VALUES = new double[]{0.0, 3.0, 30.0, 100.0};
    private int currentPath = 1;
    private List<CDMALinkLevelDataPoint> definedPoints = new ArrayList<CDMALinkLevelDataPoint>();
    private List<CDMALinkLevelDataPoint> dataPoints = new ArrayList<CDMALinkLevelDataPoint>();
    private double frequency;
    private double initialMinGeometry;
    private double initialMaxGeometry;
    private LinkType linkType = LinkType.DOWNLINK;
    private String name;
    private String[] pathDescription = new String[3];
    private boolean sorted = false;
    private String source;
    private String system;
    private String targetERpct;
    private TargetERType targetERType;

    public CDMALinkLevelData() {
        this.setPathDescription(1, "");
        this.setPathDescription(2, "");
        this.setFrequency(0.0);
        this.setSystem("");
        this.setSource("");
        this.setTargetERpct("1");
        this.setTargetERType(TargetERType.FER);
        this.initialMinGeometry = -6.0;
        this.initialMaxGeometry = 12.0;
        this.sortAll();
    }

    public CDMALinkLevelData(CDMALLD data) {
        String linkType = data.systemType();
        if (linkType.equals("uplink")) {
            this.linkType = LinkType.UPLINK;
        } else if (linkType.equals("downlink")) {
            this.linkType = LinkType.DOWNLINK;
        } else {
            throw new IllegalArgumentException("system-type must be uplink or downlink (" + linkType + ")");
        }
        this.source = data.source();
        this.system = data.system();
        this.frequency = data.frequency();
        this.targetERpct = data.targetPct();
        String targetERType = data.targetType();
        if (targetERType.equals(TargetERType.BLER.toString())) {
            this.targetERType = TargetERType.BLER;
        } else if (targetERType.equals(TargetERType.FER.toString())) {
            this.targetERType = TargetERType.FER;
        } else {
            throw new IllegalArgumentException("targetERType must be FER or BLER (" + (Object)((Object)this.targetERType) + ")");
        }
        for (CDMALLDPath path : data.paths()) {
            int pathNo = path.no();
            this.setPathDescription(pathNo, path.caption());
            for (CDMALLDPoint point : path.points()) {
                CDMALinkLevelDataPoint p = new CDMALinkLevelDataPoint(point, this.frequency, pathNo);
                this.dataPoints.add(p);
                this.definedPoints.add(p);
            }
        }
        this.sortAll();
    }

    private void sortAll() {
        Collections.sort(this.dataPoints, DATAPOINT_COMPARATOR_DESCENDING_GEOMETRY);
        Collections.sort(this.definedPoints, DATAPOINT_COMPARATOR_DESCENDING_GEOMETRY);
        this.sorted = true;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof CDMALinkLevelData && this.toString().equals(o.toString());
    }

    public int getCurrentPath() {
        return this.currentPath;
    }

    public List<CDMALinkLevelDataPoint> getDataPoints() {
        return this.getDataPoints(this.currentPath);
    }

    public List<CDMALinkLevelDataPoint> getDataPoints(int pathNo) {
        ArrayList<CDMALinkLevelDataPoint> points = new ArrayList<CDMALinkLevelDataPoint>();
        for (CDMALinkLevelDataPoint point : this.definedPoints) {
            if (point.getPath() != pathNo) continue;
            points.add(point);
        }
        return points;
    }

    public CDMALinkLevelDataPoint[] getDataSet(CDMALinkLevelDataPoint key) {
        ArrayList<CDMALinkLevelDataPoint> t = new ArrayList<CDMALinkLevelDataPoint>();
        for (CDMALinkLevelDataPoint pt : this.dataPoints) {
            if ((int)pt.getSpeed() != (int)key.getSpeed() || pt.getPath() != key.getPath()) continue;
            t.add(pt);
        }
        return t.toArray(new CDMALinkLevelDataPoint[t.size()]);
    }

    public double getFrequency() {
        return this.frequency;
    }

    public CDMALinkLevelDataPoint getLinkLevelDataPoint(CDMALinkLevelDataPoint keypoint) {
        if (this.dataPoints.size() < 1) {
            throw new IllegalStateException("No Link Level Data Points found");
        }
        this.sort();
        int index = Collections.binarySearch(this.dataPoints, keypoint, DATAPOINT_COMPARATOR_DESCENDING_GEOMETRY);
        if (index > 0 && index < this.dataPoints.size()) {
            return this.dataPoints.get(index);
        }
        CDMALinkLevelDataPoint[] data = this.getDataSet(keypoint);
        CDMALinkLevelDataPoint p1 = null;
        CDMALinkLevelDataPoint p2 = null;
        if (data.length == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No matching data was found for keypoint: " + keypoint);
            }
            throw new IllegalStateException("No matching data was found for keypoint = " + keypoint);
        }
        if (data.length == 1) {
            if (LOG.isDebugEnabled()) {
                // empty if block
            }
            return data[0];
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extrapolating new value for: " + keypoint);
        }
        Arrays.sort(data, DATAPOINT_COMPARATOR_ASCENDING_GEOMETRY);
        if (keypoint.getGeometry() > data[data.length - 1].getGeometry()) {
            p1 = data[data.length - 2];
            p2 = data[data.length - 1];
        } else if (keypoint.getGeometry() < data[0].getGeometry()) {
            p1 = data[0];
            p2 = data[1];
        } else {
            int stop = data.length - 1;
            for (int i = 0; i < stop; ++i) {
                p1 = data[i];
                p2 = data[i + 1];
                if (keypoint.getGeometry() > p1.getGeometry() && keypoint.getGeometry() < p2.getGeometry()) break;
            }
        }
        double a = (p2.getEcIor() - p1.getEcIor()) / (p2.getGeometry() - p1.getGeometry());
        double b = -(a * p1.getGeometry()) + p1.getEcIor();
        keypoint.setEcior(a * keypoint.getGeometry() + b);
        if (Double.isNaN(keypoint.getEcIor())) {
            if (LOG.isDebugEnabled()) {
                LOG.error("P1: " + p1);
                LOG.error("P2: " + p2);
                LOG.error("Keypoint: " + keypoint);
            }
            throw new IllegalStateException("Invalid extrapolation for keypoint = " + keypoint);
        }
        this.dataPoints.add(new CDMALinkLevelDataPoint(keypoint));
        this.sorted = false;
        return keypoint;
    }

    public LinkType getLinkType() {
        return this.linkType;
    }

    public double getInitialMaximumGeometry() {
        return this.initialMaxGeometry;
    }

    public double getInitialMinimumGeometry() {
        return this.initialMinGeometry;
    }

    public String getName() {
        return this.name;
    }

    public String getPathDescription(int path) {
        return this.pathDescription[path];
    }

    public String getSource() {
        return this.source;
    }

    public String getSystem() {
        return this.system;
    }

    public TableModel getTableModel(int pathNo) {
        CDMAEditModel model = new CDMAEditModel();
        model.setData(this.loadDataFromSource(pathNo));
        return model;
    }

    public String getTargetERpct() {
        return this.targetERpct;
    }

    public TargetERType getTargetERType() {
        return this.targetERType;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private Vector<Vector<Double>> loadDataFromSource(int pathNo) {
        this.setCurrentPath(pathNo);
        Vector<Vector<Double>> result = new Vector<Vector<Double>>();
        double currentGeom = -2.147483648E9;
        Vector<Double> tmp = null;
        for (CDMALinkLevelDataPoint point : this.getDataPoints(pathNo)) {
            double geom = point.getGeometry();
            if (geom != currentGeom) {
                currentGeom = geom;
                tmp = new Vector<Double>(5);
                tmp.add(geom);
                for (int x = 1; x < 5; ++x) {
                    tmp.add(null);
                }
                result.add(tmp);
            }
            switch ((int)point.getSpeed()) {
                case 0: {
                    tmp.set(1, point.getEcIor());
                    break;
                }
                case 3: {
                    tmp.set(2, point.getEcIor());
                    break;
                }
                case 30: {
                    tmp.set(3, point.getEcIor());
                    break;
                }
                case 100: {
                    tmp.set(4, point.getEcIor());
                }
            }
        }
        return result;
    }

    public void setCurrentPath(int path) {
        if (path < 1 || path > 2) {
            throw new IllegalArgumentException("Path must be 0 or 1 (" + path + ")");
        }
        this.currentPath = path;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public void setLinkType(LinkType linkType) {
        if (linkType == null) {
            throw new IllegalArgumentException("LinkType cannot be null");
        }
        this.linkType = linkType;
    }

    public void setPathDescription(int path, String desc) {
        this.pathDescription[path] = desc;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public void setTargetERpct(String targetERpct) {
        this.targetERpct = targetERpct;
    }

    public void setTargetERType(TargetERType targetERType) {
        this.targetERType = targetERType;
    }

    private void sort() {
        if (!this.sorted) {
            Collections.sort(this.dataPoints, DATAPOINT_COMPARATOR_DESCENDING_GEOMETRY);
            this.sorted = true;
        }
    }

    public CDMALLD getModel() {
        CDMALLD prototype = Factory.prototype(CDMALLD.class);
        Factory.when(prototype.frequency()).thenReturn(this.frequency);
        Factory.when(prototype.source()).thenReturn(this.source);
        Factory.when(prototype.system()).thenReturn(this.system);
        Factory.when(prototype.systemType()).thenReturn(this.linkType == LinkType.UPLINK ? "uplink" : "downlink");
        Factory.when(prototype.targetPct()).thenReturn(this.targetERpct);
        Factory.when(prototype.targetType()).thenReturn(this.targetERType.toString());
        ArrayList<CDMALLDPath> paths = new ArrayList<CDMALLDPath>();
        for (int pathNo = 1; pathNo <= 2; ++pathNo) {
            CDMALLDPath pathProto = Factory.prototype(CDMALLDPath.class);
            Factory.when(pathProto.no()).thenReturn(pathNo);
            Factory.when(pathProto.caption()).thenReturn(this.getPathDescription(pathNo));
            ArrayList<CDMALLDPoint> points = new ArrayList<CDMALLDPoint>();
            for (CDMALinkLevelDataPoint point : this.definedPoints) {
                if (point.getPath() != pathNo) continue;
                points.add(point.getModel());
            }
            Factory.when(pathProto.points()).thenReturn(points);
            paths.add(Factory.build(pathProto));
        }
        Factory.when(prototype.paths()).thenReturn(paths);
        return Factory.build(prototype);
    }

    public String toString() {
        return this.shortText();
    }

    public String fullText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.system != null ? this.system : "").append(" : ");
        sb.append(this.source != null ? this.source : "").append(" : ");
        sb.append(this.frequency).append(" MHz : ");
        sb.append(this.linkType == LinkType.UPLINK ? "uplink" : "downlink").append(" : ").append(this.targetERpct);
        sb.append("% ").append(this.targetERType.toString());
        return sb.toString();
    }

    public String shortText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.system != null ? this.system : "").append(": ").append(this.frequency).append(" MHz");
        return sb.toString();
    }

    public void updatePath(int currentPath2, List<CDMALinkLevelDataPoint> values) {
        this.definedPoints.removeAll(this.getDataPoints());
        this.definedPoints.addAll(values);
        this.dataPoints.clear();
        this.dataPoints.addAll(this.definedPoints);
        this.sortAll();
    }

    public static enum TargetERType {
        BLER,
        FER;

    }

    public static enum LinkType {
        DOWNLINK,
        UPLINK;

    }
}

