/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.cdma;

import org.seamcat.cdma.CDMADownlinkSystem;
import org.seamcat.cdma.CDMASystem;
import org.seamcat.cdma.CdmaBaseStation;
import org.seamcat.cdma.CdmaUserTerminal;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.model.mathematics.Mathematics;

public class CDMADownlink
extends AbstractDmaLink {
    protected CDMASystem cdmasystem;
    protected double receivedTrafficChannelPowerdBm;

    public CDMADownlink(CdmaBaseStation _cell, CdmaUserTerminal _user, CDMASystem _cdmasystem) {
        super(false, _cell, _user, _cdmasystem.getFrequency());
        this.cdmasystem = _cdmasystem;
    }

    @Override
    public double calculateCurrentReceivePower_dBm() {
        this.totalReceivedPower = this.getBaseStation().getCurrentTransmitPower_dBm() - this.getEffectivePathloss();
        return this.totalReceivedPower;
    }

    @Override
    public CdmaBaseStation getBaseStation() {
        return (CdmaBaseStation)super.getBaseStation();
    }

    public double calculateTransmittedTrafficChannelPowerIndBm() {
        this.transmittedTrafficChannelPowerdBm = this.getEffectivePathloss() + this.receivedTrafficChannelPowerdBm;
        double pMax = ((CDMADownlinkSystem)this.cdmasystem).getMaxTrafficChannelPowerIndBm();
        if (this.transmittedTrafficChannelPowerdBm > pMax) {
            double difference = this.transmittedTrafficChannelPowerdBm - pMax;
            this.transmittedTrafficChannelPowerdBm = pMax;
            this.receivedTrafficChannelPowerdBm -= difference;
            this.powerScaledDownToMax = true;
        } else {
            this.powerScaledDownToMax = false;
        }
        return this.transmittedTrafficChannelPowerdBm;
    }

    @Override
    public void activateLink() {
    }

    public double getReceivedTrafficChannelPowerdBm() {
        return this.receivedTrafficChannelPowerdBm;
    }

    public void scaleTransmitPower(double scaleValue) {
        this.transmittedTrafficChannelPowerdBm = Mathematics.fromWatt2dBm(Mathematics.fromdBm2Watt(this.transmittedTrafficChannelPowerdBm) * scaleValue);
        this.receivedTrafficChannelPowerdBm = this.transmittedTrafficChannelPowerdBm - this.getEffectivePathloss();
    }

    public void setReceivedTrafficChannelPowerdBm(double receivedTrafficChannelPowerdBm) {
        this.receivedTrafficChannelPowerdBm = receivedTrafficChannelPowerdBm;
    }
}

