/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.calculator;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.border.CompoundBorder;

public class ImageIconBorder
extends AbstractBorder {
    private CompoundBorder border;

    public ImageIconBorder(JComponent owner, ImageIcon icon, ImageIcon disabledIcon) {
        ButtonBorder buttonBorder = new ButtonBorder(icon, disabledIcon);
        this.border = new CompoundBorder(owner.getBorder(), buttonBorder);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.border.getBorderInsets(c);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return this.border.getBorderInsets(c, insets);
    }

    @Override
    public Rectangle getInteriorRectangle(Component c, int x, int y, int width, int height) {
        return this.border.getInteriorRectangle(c, x, y, width, height);
    }

    @Override
    public boolean isBorderOpaque() {
        return this.border.isBorderOpaque();
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.border.paintBorder(c, g, x, y, width, height);
    }

    private class ButtonBorder
    extends AbstractBorder {
        private ImageIcon disabledIcon;
        private ImageIcon icon;

        private ButtonBorder(ImageIcon _icon, ImageIcon _disabledIcon) {
            this.icon = _icon;
            this.disabledIcon = _disabledIcon == null ? this.icon : _disabledIcon;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, this.icon.getIconWidth());
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.set(0, 0, 0, 0);
            return insets;
        }

        @Override
        public Rectangle getInteriorRectangle(Component c, int x, int y, int width, int height) {
            return super.getInteriorRectangle(c, x, y, width - this.icon.getIconWidth(), height);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D gr = (Graphics2D)g;
            ImageIcon img = c.isEnabled() ? this.icon : this.disabledIcon;
            gr.drawImage(img.getImage(), x + width - this.icon.getIconWidth() + 2, y, null);
        }
    }
}

