/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat;

import java.io.File;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.seamcat.model.factory.Model;

public class Logging {
    private static final String LOG4J_FILE_NAME = "log4j.properties";

    public static void initialize() {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.DEBUG);
    }

    public static void initializeCommandLine() {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.ERROR);
    }

    public static void initializeFromHomeDir(String seamcatHomeDir) {
        File log4jConfigurationFile = Logging.getLog4jConfigurationFileFromHomeDir(seamcatHomeDir);
        if (log4jConfigurationFile != null) {
            PropertyConfigurator.configureAndWatch(new File(Model.getSeamcatHomeDir()).getAbsolutePath() + File.separator + LOG4J_FILE_NAME, 2000L);
        } else {
            Logger.getRootLogger().setLevel(Level.INFO);
        }
    }

    private static File getLog4jConfigurationFileFromHomeDir(String seamcatHomeDirString) {
        File file = new File(seamcatHomeDirString, LOG4J_FILE_NAME);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private static void showMessage(String message) {
        System.err.println(message);
    }
}

