;                       /|
;                      //|.
;                     //_| .
;                 __ // /| .
;                /_ \/\__|. 
;                \\_/  _/|_
;                .g.e.n.d.a.
;
;______________________________________________________
;
;
;              firestarter 256b
;
;______________________________________________________
;
;	CODE:	        svoy
;______________________________________________________
;
;         Riverwash 256b intro (compo filler)
;______________________________________________________
; tomaswoj@gmail.com
; http://pl.linkedin.com/in/tomaswoj
; Cracow

	opt h+
	
	org $2200 ; moved to $2200 to make space for charset in $1200

sindex	equ $d8 ; used only for depack of dither pattern
tindex	equ $d9 ; used only for depack of dither pattern	
curad_h equ $e1 ; current screen line address
curad_l	equ $e2
val	equ $e3 ; temporary fire value
		       

; depacking stuff... compression/depack in 256b :)
dpack
	ldy sindex 
	lax pvals,y
	and #%00001111	
	jsr storev
	txa
	lsr
	lsr
	lsr
	lsr
	jsr storev
	lda #54 ; 52 values to be decoded to 104 + 8 (of zero'es)
	sta $D000 ; use 54 to set logo horizontal position 
	sta $D407 ; reuse 54 to set PM memory page, needs to be /4!
	isb sindex ; nice illegal, increases mem, and subs from accu
	bne dpack		
		
	;lda #%11100000 ; make some nooooise! :)
	tsx ; stack happen to have $F9, that plays nice as 1110000 replacement
	    ; ...and this is the final byte I shaved in this intro :)
	stx $D208 ; AUDCTL
	; li'l AUDCTL info (after some wise books):
	; 7 Makes the 17-bit poly counter into a 9-bit poly
	; 6 Clock channel one with 1.79 MHz
	; 5 Clock channel three with I. 79 MHz
	; 4 Join channels one and two (16 bi t)
	; 3 Join channels three and four (16 bits)
	; 2 Insert high pass filter into channel one, clocked by channel two
	; 1 Insert high pass filter into channel two, clocked by channel four
	; 0 Switch main clock base from 64 KHz to 15 KHz

; unpacked dither patterns, so now set the proper ANTIC GPU mode
       
	;lda #$c	; set text mode (12)	
	;tax	; keep it in X for charset and then for 'flash' color
	lax $2a ; looks like $0c is in this location (ICAX1Z) just after boot, 
		; but can we rely on it?
	jsr $EF9C
	stx $2f4 ; set charset pointer (to depacked dither chars)
			
		
; sprites setup
	lda #$2a ; standard playfield, PM enabled
	sta $22f ; set standard playfield, PM enabled
	; priorities setup below (in pixels)	
	; players enabled below (in pixels)
	; PM memory page set above (in depacker)
	
; frame code that lives forever	
frame: 
	lda $14 ; every 1 second (or so) switch the fire palette, blink the screen, wobble logo
	;and #%00011111	
	;lsr
	alr #%00011111 ; what a nice illegal, 1 byte shaved of the above 2 lines
		       ; and accu with byte and lsr	
	lsr
	bne skipcol ; if not the 1sec 'beat', skip color scheme change
	ora #%11110000 ; nicer? POT savings of 2 bytes
	;ora #%10110000 ; POT savings of 2 bytes
	sta $D200 ; AUDCF#0

	;ldy #4 - not needed, as we can iterate from $c down (pick $c from X-reg)
	txa
	tay 	
coliter: ; randomize the colors (708-712 and more, but we just want to reuse $c) every 1s or so
	sta 708,y
	lda $D20a
	dey
	bne coliter
	sta $D008 ; wobble the logo (via PM size)
	stx 712 ; flash to white
		
skipcol: ; skip col scheme change, that will be most of the time	
	; set screen mem pointer to the 1st pixel
	lda 88 ;lda fm1_h
	sta curad_h	
	lda 89 ;lda fm1_l
	sta curad_l	
		
	; i'm the firestarter, twisted firestarter.... yeah!
pixels:	
	; calculate fire values, according to this formula:
	; i=1/2 *(i+39) + 2*(i+40) + 1/2*(i+40) + 1*(i+80)  
	; the code below could be possibly simplified/shaved by 1-2 bytes, but running out of time 
	ldy #39	
	lda (curad_h),y	
	iny
	iny
	adc (curad_h),y		
	lsr
	sta val
	dey
	lda (curad_h),y	
	asl	
	adc val
	ldy #80 ; 79 - wind to right, 81, wind to left
	adc (curad_h),y
	lsr
	lsr			
	cmp #19 ; if new fire val more than 19 - cap it at 19 (to get nice 'full' color at the bottom)	
	bcc store
	lda #19	
	sta $26f ; ... but also use this 19 val to set pmg priorities (logo PMG on front)	
	sta $D01D ; ... and reuse that to enable players	
store:		
	; store new value in screen mem
	ldy #0 ; expensive, but proper "0" is invaluable in this context :)
	sta (curad_h),y
	ora $14; POTential saving of 2b but does not sound that nice
	;ora $13
	and #%10111111 ; 1111 highest volume 	
	sta $D201 ; AUDCT#0	
	; 7 6 5
	; 0 0 0 - 5bit, then 17-bit polys
	; 0 0 1 - 5bit poly only
	; 0 1 0 - 5bit poly, then 4 bit polys
	; 0 1 1 - 5 bit poly only
	; 1 0 0 - 17bit poly only
	; 1 0 1 - no poly counters (pure tone)
	; 1 1 0 - 4 bit poly only
	; 1 1 1 - inifinite poly counters (pure tone)
	; 4 - volume only
	; 3 2 1 0 - volume control
	

	; screen address is $bba0
	; so initial curad_h - a0, curad_l - bb
	; end of screen adress is $bf88 (assuming 40x24)
	; end of screen address is $c020 (assuming 48x24, ???)	 
	; last line begins at - $bf38	

	inc curad_h ; now move 1pixel right...	
	bne nocarry ; if no carry (not equal - not $0) - skip add of curad_l
	inc curad_l	
nocarry:
	;  now check if not reaching the end of screen, if so - continue with pixels
	lda #$bf ; God, I pray this is always the $bf value 
	cmp curad_l
	bne pixels
	lda #$88 ; God, I pray for that one too....
	;lda #$b0 ; one more line?
	cmp curad_h
	bne pixels ;if not reaching end of screen, so continue with pixels

	; end of screen reached 
	; ldy #0 ; skip as it's already set by pixel store above
	; back to black background after frame is drawn
	sty 712	
	sty $D008 ; back to PM size normal
	
	; end of frame, randomize bottom
	; just keep using the addresses from the pixels calc above
fillbot: ; fill bottom line, as a fire generator		
	tya ; this is not needed after all... but nicer colors POT 1b	
	ora $d20a ; randomize bottom
	;lda $d20a	 	
	sta (curad_h),y
	;sta $3622,y
	iny
	;cpy #40 ; we can skip it as we can carry it till forever, or 255 at least :)
	bne fillbot		

	;jmp frame ; endless fire....
	beq frame  ; simple trick to use beq instead of jmp, 1 byte shaved :)		

; proc used in depack
storev:
	tay
	lda vals,y
	;sta $2808,y
	;sta $282f,y ; with leading 4 0s
	;sta $2838,y ; without leading 4 0s
	;sta $3e38,y ; without leading 4 0s
	;sta $2e38,y ; without leading 4 0s
	;...huh, as you can see, it took a while to find the right plot for this charset estate
	ldy tindex	
	sta $0c38,y ; without leading 4 0s
	inc tindex
	rts
	
; packed dithered letters
pvals ;dta b($0,$0,$0,$0) ; obtained by a proper offset
      dta b($12,$20,$01,$12)
      dta b($12,$23,$31,$12)  	
      dta b($31,$32,$31,$32)
      dta b($33,$33,$33,$33)
      dta b($35,$34,$35,$34)   
      dta b($45,$53,$34,$45)
      dta b($45,$56,$64,$45)
      dta b($64,$65,$64,$65) 
      dta b($66,$66,$66,$66)
      dta b($68,$67,$68,$67)
      dta b($78,$86,$67,$78)
      dta b($78,$89,$97,$78)
      dta b($99,$99,$99,$99)

; values for dithered letters depacker
vals  dta b(0,17,68,85,102,153,170,187,238,255)

; agenda logo (always!) 	
	org $3617
;agpmg 	dta b($ff,$0,$2,$6,$a,$52,$bf,$e2,$43,$0,$ff) ; with upper and lower borders
;agpmg 	dta b($ff,$81,$82,$86,$A,$52,$BF,$E2,$43,$81,$FF) ; with frame
;agpmg 	dta b($ff,$82,$86,$A,$52,$BF,$E2,$43,$81,$FF) ; with frame
agpmg 	dta b($2,$6,$a,$52,$bf,$e2,$43) ; $43 POT

        		