

; Data format
; 1 byte			nVtx		Number of vertices
; 6 bytes * nVtx	XYZ * nVtx	Vertex coordinates
; 1 byte			nEdge		Number of edges
; 2 bytes * nEdge	vtId-VtId	Edge vertex ID pairs

; Output LINEBUF Repeat of
; 2 bytes			X0
; 1 byte			Y0
; 2 bytes			X1
; 1 byte			Y1

TO_SCREEN_GEOMDATAADDR	FDB		0				; Input geometry address.
TO_SCREEN_LINEOUTADDR	FDB		0				; Input address to store lines. / Output next line out address.
TO_SCREEN_TFMBUFADDR	FDB		0				; Output Transformation buffer.  Vertices in the view-coordinate.
TO_SCREEN_NUMLINE		FCB		0				; Output number of lines added.
TO_SCREEN_NEARZ			FDB		10
TO_SCREEN_SKIP_MODELVIEW	FCB		0				; If nonzero, it skips modelview transformation.
												; GEOMDATAADDR and TFMBUFADDR must be the same to make it nonzero.

; The following parameters must also be set.
TO_SCREEN_TRANS3D_OBJX	EQU		TRANS3D_OBJX
TO_SCREEN_TRANS3D_OBJY	EQU		TRANS3D_OBJY
TO_SCREEN_TRANS3D_OBJZ	EQU		TRANS3D_OBJZ
TO_SCREEN_TRANS3D_OBJH	EQU		TRANS3D_OBJH
TO_SCREEN_TRANS3D_OBJP	EQU		TRANS3D_OBJP
TO_SCREEN_TRANS3D_OBJB	EQU		TRANS3D_OBJB
TO_SCREEN_TRANS3D_VIEWX	EQU		TRANS3D_VIEWX
TO_SCREEN_TRANS3D_VIEWY	EQU		TRANS3D_VIEWY
TO_SCREEN_TRANS3D_VIEWZ	EQU		TRANS3D_VIEWZ
TO_SCREEN_TRANS3D_VIEWH	EQU		TRANS3D_VIEWH
TO_SCREEN_TRANS3D_VIEWP	EQU		TRANS3D_VIEWP
TO_SCREEN_TRANS3D_VIEWB	EQU		TRANS3D_VIEWB

TO_SCREEN_PERS_CX		EQU		PERSPECTIVE_CX
TO_SCREEN_PERS_CY		EQU		PERSPECTIVE_CY
TO_SCREEN_PERS_XSHIFT	EQU		PERSPECTIVE_XSHIFT
TO_SCREEN_PERS_YSHIFT	EQU		PERSPECTIVE_YSHIFT

TO_SCREEN_WX0			EQU		SCLIP_WX0
TO_SCREEN_WY0			EQU		SCLIP_WY0
TO_SCREEN_WX1			EQU		SCLIP_WX1
TO_SCREEN_WY1			EQU		SCLIP_WY1

TO_SCREEN			PSHS	A,B,X,Y,U

					LDU		TO_SCREEN_GEOMDATAADDR,PCR
					LEAX	1,U
					CLRA
					LDB		,U	; nVtx

					ASLB
					ROLA
					LEAX	D,X	; +2*nVtx
					ASLB
					ROLA
					LEAX	D,X	; +4*nVtx (6*nVtx total)

					STX		TO_SCREEN_LINEPTR,PCR


					LDA		,U
					LEAX	1,U
					STA		TRANS3D_MULTI_NVTX,PCR
					STX		TRANS3D_MULTI_SRC,PCR
					LDX		TO_SCREEN_TFMBUFADDR,PCR
					STX		TRANS3D_MULTI_DST,PCR
					LDB		TO_SCREEN_SKIP_MODELVIEW,PCR
					BNE		TO_SCREEN_MODELVIEW_DONE
					LBSR	TRANS3D_MULTI
TO_SCREEN_MODELVIEW_DONE

					CLR		TO_SCREEN_NUMLINE,PCR

					LDY		TO_SCREEN_LINEPTR,PCR
					LDB		,Y+
					STY		TO_SCREEN_LINEPTR,PCR

TO_SCREEN_LINE_LOOP	PSHS	B

					LDY		TO_SCREEN_LINEPTR,PCR
					LEAU	TO_SCREEN_X0,PCR
					STU		NEARZCLIP_LINEPTR,PCR

					LDX		TO_SCREEN_TFMBUFADDR,PCR
					CLRA
					LDB		,Y+
					ASLB
					ROLA
					LEAX	D,X
					ASLB
					ROLA
					LEAX	D,X	; X=TFMBUF+6*vtId
					LDD		,X++
					STD		,U++
					LDD		,X++
					STD		,U++
					LDD		,X++
					STD		,U++

					LDX		TO_SCREEN_TFMBUFADDR,PCR
					CLRA
					LDB		,Y+
					ASLB
					ROLA
					LEAX	D,X
					ASLB
					ROLA
					LEAX	D,X	; X=TFMBUF+6*vtId
					LDD		,X++
					STD		,U++
					LDD		,X++
					STD		,U++
					LDD		,X++
					STD		,U++

					STY		TO_SCREEN_LINEPTR,PCR


					LDD		TO_SCREEN_NEARZ,PCR
					STD		NEARZCLIP_NEARZ,PCR
					LBSR	NEARZCLIP
					LDA		NEARZCLIP_VISIBLE,PCR
					STA		SCLIP_VISIBLE,PCR		; 2018/09/22 Isn't it necessary?
					BEQ		TO_SCREEN_LINE_LOOP_NEXT


					; Then clip by nearZ.  Not implemented yet.
					; If invisible, go to next.

					LEAX	TO_SCREEN_X1,PCR
					STX		PERSPECTIVE_VTXPTR,PCR
					LBSR	PERSPECTIVE

					LEAX	TO_SCREEN_X0,PCR
					STX		PERSPECTIVE_VTXPTR,PCR
					LBSR	PERSPECTIVE

					LEAU	SCLIP_LX0,PCR
					LDD		,X++
					STD		,U++
					LDD		,X++
					STD		,U++
					LDD		,X++

					LDD		,X++
					STD		,U++
					LDD		,X++
					STD		,U++
					LBSR	SCRNCLIP

TO_SCREEN_LINE_LOOP_NEXT
					PULS	B

					LDA		SCLIP_VISIBLE,PCR	; 2018/09/22 Need to check also NEARZCLIP_VISIBLE. See above.
					BEQ		TO_SCREEN_LINE_LOOP_DONTADD

					LDU		TO_SCREEN_LINEOUTADDR,PCR

					LDY		SCLIP_LX0,PCR
					STY		,U++
					LDA		SCLIP_LY0+1,PCR
					STA		,U+
					LDY		SCLIP_LX1,PCR
					STY		,U++
					LDA		SCLIP_LY1+1,PCR
					STA		,U+

					STU		TO_SCREEN_LINEOUTADDR,PCR
					INC		TO_SCREEN_NUMLINE,PCR

TO_SCREEN_LINE_LOOP_DONTADD
					DECB
					LBNE	TO_SCREEN_LINE_LOOP

					PULS	A,B,X,Y,U
					RTS

					; How can I define a macro line 1,S?
					; I want to put local variables in the stack.
TO_SCREEN_LINEPTR	FDB		0
TO_SCREEN_X0		FDB		0
TO_SCREEN_Y0		FDB		0
TO_SCREEN_Z0		FDB		0
TO_SCREEN_X1		FDB		0
TO_SCREEN_Y1		FDB		0
TO_SCREEN_Z1		FDB		0


NEARZCLIP_LINEPTR	FDB		0
NEARZCLIP_NEARZ		FDB		10
NEARZCLIP_VISIBLE	FCB		0	; 0 Invisible Non-zero Visible

NEARZCLIP			PSHS	A,B,X,Y,U

					CLR		NEARZCLIP_VISIBLE,PCR
					CLR		NEARZCLIP_NEEDCLIP,PCR

					LDY		NEARZCLIP_LINEPTR,PCR
					LDD		#0
					SUBD	4,Y	; Z0
					STD		4,Y

					INC		NEARZCLIP_NEEDCLIP,PCR
					CMPD	NEARZCLIP_NEARZ,PCR
					BLT		NEARZCLIP_Z0INVISIBLE
					DEC		NEARZCLIP_NEEDCLIP,PCR
					INC		NEARZCLIP_VISIBLE,PCR
NEARZCLIP_Z0INVISIBLE

					LDD		#0
					SUBD	10,Y	; Z1
					STD		10,Y

					INC		NEARZCLIP_NEEDCLIP,PCR
					CMPD	NEARZCLIP_NEARZ,PCR
					BLT		NEARZCLIP_Z1INVISIBLE
					DEC		NEARZCLIP_NEEDCLIP,PCR
					INC		NEARZCLIP_VISIBLE,PCR
NEARZCLIP_Z1INVISIBLE

					LDA		NEARZCLIP_VISIBLE,PCR
					ANDA	NEARZCLIP_NEEDCLIP,PCR
					LBEQ	NEARZCLIP_END

					LDD		10,Y	;Z1
					SUBD	4,Y		;Z0
					STD		NEARZCLIP_DZ,PCR
					BGT		NEARZCLIP_Z0Z1ORDERED
					LBEQ	NEARZCLIP_END

					COMA
					COMB
					ADDD	#1
					STD		NEARZCLIP_DZ,PCR
					LDD		,Y
					LDU		6,Y
					STU		,Y
					STD		6,Y
					LDD		2,Y
					LDU		8,Y
					STU		2,Y
					STD		8,Y
					LDD		4,Y
					LDU		10,Y
					STU		4,Y
					STD		10,Y

NEARZCLIP_Z0Z1ORDERED	; Force Z0<Z1
					; X'=X0+(Z-Z0)*(X1-X0)/DZ

					LDD		NEARZCLIP_NEARZ,PCR
					SUBD	4,Y		;Z0
					STD		MUL16_NUM0,PCR
					LDD		6,Y		;X1
					SUBD	,Y		;X0
					STD		MUL16_NUM1,PCR
					LBSR	MUL16

					LDD		MUL16_NUM0,PCR
					STD		DIV32_16_NUMER_HI,PCR
					LDD		MUL16_NUM1,PCR
					STD		DIV32_16_NUMER_LO,PCR
					LDD		NEARZCLIP_DZ,PCR
					STD		DIV32_16_DENOM,PCR
					LBSR	DIV32_16

					LDD		DIV32_16_DENOM,PCR
					ADDD	,Y		;X0
					PSHS	A,B


					; Y'=Y0+(Z-Z0)*(Y1-Y0)/DZ

					LDD		NEARZCLIP_NEARZ,PCR
					SUBD	4,Y		;Z0
					STD		MUL16_NUM0,PCR
					LDD		8,Y		;Y1
					SUBD	2,Y		;Y0
					STD		MUL16_NUM1,PCR
					LBSR	MUL16

					LDD		MUL16_NUM0,PCR
					STD		DIV32_16_NUMER_HI,PCR
					LDD		MUL16_NUM1,PCR
					STD		DIV32_16_NUMER_LO,PCR
					LDD		NEARZCLIP_DZ,PCR
					STD		DIV32_16_DENOM,PCR
					LBSR	DIV32_16

					LDD		DIV32_16_DENOM,PCR
					ADDD	2,Y		;Y0
					STD		2,Y


					PULS	A,B
					STD		,Y
					LDD		NEARZCLIP_NEARZ,PCR
					STD		4,Y

NEARZCLIP_END
					LDD		#0
					SUBD	4,Y	; Z0
					STD		4,Y
					LDD		#0
					SUBD	10,Y	; Z1
					STD		10,Y

					PULS	A,B,X,Y,U
					RTS

NEARZCLIP_NEEDCLIP	FCB		0
NEARZCLIP_DZ		FDB		0

					EXPORT	RENDER_GNDLATTICE_TEST
RENDER_GNDLATTICE_TEST
					PSHS 	A,B,X,Y,U

					LBSR	INSTALL_LINEDDA_IN_SUBCPU
					LBSR	INSTALL_CLEAR_BITPLANE_IN_SUBCPU

					CLR		TRANS3D_VIEWH,PCR

RENDER_GNDLATTICE_TEST_LOOP
					LBSR	CLEAR_SCREEN

					LDX		#0
					STX		TRANS3D_MULTI_VIEWZ,PCR
					LDX		#150
					STX		TRANS3D_MULTI_VIEWY,PCR
					LBSR	RENDER_GNDLATTICE

					LDA		#-10
					STA		TRANS3D_VIEWP,PCR
					LDA		TRANS3D_VIEWH,PCR
					ADDA	#4
					STA		TRANS3D_VIEWH,PCR
					BCC		RENDER_GNDLATTICE_TEST_LOOP

					PULS 	A,B,X,Y,U
					RTS

					EXPORT	RENDER_GNDLATTICE
					EXPORT	RENDER_GNDLATTICE_DEBUG_LAST_B0
					EXPORT	RENDER_GNDLATTICE_DEBUG_LAST_B1
					EXPORT	RENDER_GNDLATTICE_DEBUG_LAST_B2
					EXPORT	RENDER_GNDLATTICE_DEBUG_LAST_B3
					EXPORT	GNDLATTICE_VTXBUFPTR

					; Turns out 17x17 was too heavy.  Go down to 9x9
					;	8192x8192 Centered at (0,0,0)
					;   8 squares in one direction : 1024 interval
					;	9 x 9 coordinates
					;(-4096, 4096)     ( 4096, 4096)
					;          #0  ->  #8
					;	         +-----+   
					;	      #18|     |#25
					;            |     |
					;	      #24|     |#31
					;	         +-----+   
					;          #9  ->  #17
					;(-4096,-4096)     ( 4096,-4096)

GNDLATTICE_DIM			EQU		4096
GNDLATTICE_STEP			EQU		1024

										; 9+9+6+6=32 vertices, 9+9=18 lines
GNDLATTICE_LINEBUFPTR	FDB		COMMON_LINEBUFPTR

GNDLATTICE_NUMVTX		FCB		34
GNDLATTICE_VTXBUFPTR	RZB		34*6	; 34*6=204 bytes.
GNDLATTICE_LINEDATA		FCB		18
						FCB		 0, 9, 1,10, 2,11, 3,12, 4,13, 5,14, 6,15, 7,16, 8,17
						FCB		 0, 8,18,25,19,26,20,27,21,28,22,29,23,30,24,31, 9,17


GNDLATTICE_VIEWX	EQU		TRANS3D_MULTI_VIEWX
GNDLATTICE_VIEWY	EQU		TRANS3D_MULTI_VIEWY
GNDLATTICE_VIEWZ	EQU		TRANS3D_MULTI_VIEWZ
GNDLATTICE_VIEWH	EQU		TRANS3D_MULTI_VIEWH
GNDLATTICE_VIEWP	EQU		TRANS3D_MULTI_VIEWP
GNDLATTICE_VIEWB	EQU		TRANS3D_MULTI_VIEWB

					; Calculate lines for the ground lattice and adds to the LINEBUF.
					; LINEBUF must be initialized before this function, and the address
					; of the LINEBUF needs to be given in GNDLATTICE_LINEBUFPTR.
RENDER_GNDLATTICE	PSHS	A,B,X,Y,U

					LBSR	RENDER_GNDLATTICE_CALC_ORIGIN_IN_VIEW
					LEAX	RENDER_GNDLATTICE_VX0_IN_VIEW,PCR
					LEAU	RENDER_GNDLATTICE_ORIGINX_IN_VIEW,PCR
					LDD		,X++
					STD		,U++
					LDD		,X++
					STD		,U++
					LDD		,X++
					STD		,U++

					;          #0  ->  #8
					;	         *******     <- Rotate only * and use symmetry
					;	      #18|     |#25  <- Rotate only * and use symmetry
					;            |     |
					;	      #24|     |#31
					;	         +-----+   
					;          #9  ->  #17

					; Calculate U-Vec and W-Vec
					LDD		#2*GNDLATTICE_DIM
					STD		RENDER_GNDLATTICE_VX0_IN_VIEW,PCR
					LDD		#0
					STD		RENDER_GNDLATTICE_VY0_IN_VIEW,PCR
					LDD		#0
					STD		RENDER_GNDLATTICE_VZ0_IN_VIEW,PCR
					LBSR	RENDER_GNDLATTICE_ROTATE_TO_VIEW
					LDD		RENDER_GNDLATTICE_VX0_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_UX,PCR
					LDD		RENDER_GNDLATTICE_VY0_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_UY,PCR
					LDD		RENDER_GNDLATTICE_VZ0_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_UZ,PCR

					LEAU	RENDER_GNDLATTICE_UX,PCR
					LBSR	RENDER_GNDLATTICE_CALCDIV
					LEAU	RENDER_GNDLATTICE_UY,PCR
					LBSR	RENDER_GNDLATTICE_CALCDIV
					LEAU	RENDER_GNDLATTICE_UZ,PCR
					LBSR	RENDER_GNDLATTICE_CALCDIV


					LDD		#0
					STD		RENDER_GNDLATTICE_VX0_IN_VIEW,PCR
					LDD		#0
					STD		RENDER_GNDLATTICE_VY0_IN_VIEW,PCR
					LDD		#-2*GNDLATTICE_DIM
					STD		RENDER_GNDLATTICE_VZ0_IN_VIEW,PCR
					LBSR	RENDER_GNDLATTICE_ROTATE_TO_VIEW
					LDD		RENDER_GNDLATTICE_VX0_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_WX,PCR
					LDD		RENDER_GNDLATTICE_VY0_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_WY,PCR
					LDD		RENDER_GNDLATTICE_VZ0_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_WZ,PCR

					LEAU	RENDER_GNDLATTICE_WX,PCR
					LBSR	RENDER_GNDLATTICE_CALCDIV
					LEAU	RENDER_GNDLATTICE_WY,PCR
					LBSR	RENDER_GNDLATTICE_CALCDIV
					LEAU	RENDER_GNDLATTICE_WZ,PCR
					LBSR	RENDER_GNDLATTICE_CALCDIV



					; Calculate four corners
					LDD		#-GNDLATTICE_DIM
					STD		RENDER_GNDLATTICE_VX0_IN_VIEW,PCR
					LDD		#0
					STD		RENDER_GNDLATTICE_VY0_IN_VIEW,PCR
					LDD		#GNDLATTICE_DIM
					STD		RENDER_GNDLATTICE_VZ0_IN_VIEW,PCR
					LBSR	RENDER_GNDLATTICE_ROTATE_TO_VIEW

					LDD		RENDER_GNDLATTICE_VX0_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_TOP_LEFT_X,PCR
					STD		RENDER_GNDLATTICE_VX_IN_VIEW,PCR
					LDD		RENDER_GNDLATTICE_VY0_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_TOP_LEFT_Y,PCR
					STD		RENDER_GNDLATTICE_VY_IN_VIEW,PCR
					LDD		RENDER_GNDLATTICE_VZ0_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_TOP_LEFT_Z,PCR
					STD		RENDER_GNDLATTICE_VZ_IN_VIEW,PCR
					CLRB	; Index #0
					LBSR	RENDER_GNDLATTICE_CALC_AND_STORE

					LDD		RENDER_GNDLATTICE_TOP_LEFT_X,PCR
					ADDD	RENDER_GNDLATTICE_UX,PCR
					STD		RENDER_GNDLATTICE_TOP_RIGHT_X,PCR
					STD		RENDER_GNDLATTICE_VX_IN_VIEW,PCR
					LDD		RENDER_GNDLATTICE_TOP_LEFT_Y,PCR
					ADDD	RENDER_GNDLATTICE_UY,PCR
					STD		RENDER_GNDLATTICE_TOP_RIGHT_Y,PCR
					STD		RENDER_GNDLATTICE_VY_IN_VIEW,PCR
					LDD		RENDER_GNDLATTICE_TOP_LEFT_Z,PCR
					ADDD	RENDER_GNDLATTICE_UZ,PCR
					STD		RENDER_GNDLATTICE_TOP_RIGHT_Z,PCR
					STD		RENDER_GNDLATTICE_VZ_IN_VIEW,PCR
					LDB		#8
					LBSR	RENDER_GNDLATTICE_CALC_AND_STORE


					LDD		RENDER_GNDLATTICE_TOP_LEFT_X,PCR
					ADDD	RENDER_GNDLATTICE_WX,PCR
					STD		RENDER_GNDLATTICE_BOTTOM_LEFT_X,PCR
					STD		RENDER_GNDLATTICE_VX_IN_VIEW,PCR
					LDD		RENDER_GNDLATTICE_TOP_LEFT_Y,PCR
					ADDD	RENDER_GNDLATTICE_WY,PCR
					STD		RENDER_GNDLATTICE_BOTTOM_LEFT_Y,PCR
					STD		RENDER_GNDLATTICE_VY_IN_VIEW,PCR
					LDD		RENDER_GNDLATTICE_TOP_LEFT_Z,PCR
					ADDD	RENDER_GNDLATTICE_WZ,PCR
					STD		RENDER_GNDLATTICE_BOTTOM_LEFT_Z,PCR
					STD		RENDER_GNDLATTICE_VZ_IN_VIEW,PCR
					LDB		#9
					LBSR	RENDER_GNDLATTICE_CALC_AND_STORE

					LDD		RENDER_GNDLATTICE_TOP_LEFT_X,PCR
					ADDD	RENDER_GNDLATTICE_UX,PCR
					ADDD	RENDER_GNDLATTICE_WX,PCR
					STD		RENDER_GNDLATTICE_VX_IN_VIEW,PCR
					LDD		RENDER_GNDLATTICE_TOP_LEFT_Y,PCR
					ADDD	RENDER_GNDLATTICE_UY,PCR
					ADDD	RENDER_GNDLATTICE_WY,PCR
					STD		RENDER_GNDLATTICE_VY_IN_VIEW,PCR
					LDD		RENDER_GNDLATTICE_TOP_LEFT_Z,PCR
					ADDD	RENDER_GNDLATTICE_UZ,PCR
					ADDD	RENDER_GNDLATTICE_WZ,PCR
					STD		RENDER_GNDLATTICE_VZ_IN_VIEW,PCR
					LDB		#17
					LBSR	RENDER_GNDLATTICE_CALC_AND_STORE



					LDB		#1
					STB		RENDER_GNDLATTICE_COUNTER,PCR
					STB		RENDER_GNDLATTICE_OFSETTER,PCR
					; Top edge
RENDER_GNDLATTICE_TOPEDGE_LOOP
					; Base=Top-Left
					LDD		RENDER_GNDLATTICE_TOP_LEFT_X,PCR
					STD		RENDER_GNDLATTICE_VX_IN_VIEW,PCR
					LDD		RENDER_GNDLATTICE_TOP_LEFT_Y,PCR
					STD		RENDER_GNDLATTICE_VY_IN_VIEW,PCR
					LDD		RENDER_GNDLATTICE_TOP_LEFT_Z,PCR
					STD		RENDER_GNDLATTICE_VZ_IN_VIEW,PCR

					LDB		#1
					STB		RENDER_GNDLATTICE_SHIFTER,PCR
					STB		RENDER_GNDLATTICE_OFSETTER,PCR
RENDER_GNDLATTICE_TOPEDGE_SHIFT_LOOP
					LDB		RENDER_GNDLATTICE_SHIFTER,PCR
					BITB	RENDER_GNDLATTICE_COUNTER,PCR
					BEQ		RENDER_GNDLATTICE_TOPEDGE_SHIFT_LOOP_NEXT

					; Dir UX
					LEAX	RENDER_GNDLATTICE_ZEROUX,PCR
					LDB		RENDER_GNDLATTICE_OFSETTER,PCR
					LSLB
					LDD		B,X
					ADDD	RENDER_GNDLATTICE_VX_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_VX_IN_VIEW,PCR

					LEAX	RENDER_GNDLATTICE_ZEROUY,PCR
					LDB		RENDER_GNDLATTICE_OFSETTER,PCR
					LSLB
					LDD		B,X
					ADDD	RENDER_GNDLATTICE_VY_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_VY_IN_VIEW,PCR

					LEAX	RENDER_GNDLATTICE_ZEROUZ,PCR
					LDB		RENDER_GNDLATTICE_OFSETTER,PCR
					LSLB
					LDD		B,X
					ADDD	RENDER_GNDLATTICE_VZ_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_VZ_IN_VIEW,PCR

RENDER_GNDLATTICE_TOPEDGE_SHIFT_LOOP_NEXT
					INC		RENDER_GNDLATTICE_OFSETTER,PCR
					LSL		RENDER_GNDLATTICE_SHIFTER,PCR
					LDA		RENDER_GNDLATTICE_SHIFTER,PCR
					CMPA	#8
					BLO		RENDER_GNDLATTICE_TOPEDGE_SHIFT_LOOP

					LDB		RENDER_GNDLATTICE_COUNTER,PCR ; Index=0+COUNTER
					LBSR	RENDER_GNDLATTICE_CALC_AND_STORE

					INC		RENDER_GNDLATTICE_COUNTER,PCR
					LDA		RENDER_GNDLATTICE_COUNTER,PCR
					CMPA	#8
					LBLO		RENDER_GNDLATTICE_TOPEDGE_LOOP



					LDB		#1
					STB		RENDER_GNDLATTICE_COUNTER,PCR
					; Top edge
RENDER_GNDLATTICE_BOTTOMEDGE_LOOP
					; Base=Bottom-Left
					LDD		RENDER_GNDLATTICE_BOTTOM_LEFT_X,PCR
					STD		RENDER_GNDLATTICE_VX_IN_VIEW,PCR
					LDD		RENDER_GNDLATTICE_BOTTOM_LEFT_Y,PCR
					STD		RENDER_GNDLATTICE_VY_IN_VIEW,PCR
					LDD		RENDER_GNDLATTICE_BOTTOM_LEFT_Z,PCR
					STD		RENDER_GNDLATTICE_VZ_IN_VIEW,PCR

					LDB		#1
					STB		RENDER_GNDLATTICE_SHIFTER,PCR
					STB		RENDER_GNDLATTICE_OFSETTER,PCR
RENDER_GNDLATTICE_BOTTOMEDGE_SHIFT_LOOP
					LDB		RENDER_GNDLATTICE_SHIFTER,PCR
					BITB	RENDER_GNDLATTICE_COUNTER,PCR
					BEQ		RENDER_GNDLATTICE_BOTTOMEDGE_SHIFT_LOOP_NEXT

					; Dir UX
					LEAX	RENDER_GNDLATTICE_ZEROUX,PCR
					LDB		RENDER_GNDLATTICE_OFSETTER,PCR
					LSLB
					LDD		B,X
					ADDD	RENDER_GNDLATTICE_VX_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_VX_IN_VIEW,PCR

					LEAX	RENDER_GNDLATTICE_ZEROUY,PCR
					LDB		RENDER_GNDLATTICE_OFSETTER,PCR
					LSLB
					LDD		B,X
					ADDD	RENDER_GNDLATTICE_VY_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_VY_IN_VIEW,PCR

					LEAX	RENDER_GNDLATTICE_ZEROUZ,PCR
					LDB		RENDER_GNDLATTICE_OFSETTER,PCR
					LSLB
					LDD		B,X
					ADDD	RENDER_GNDLATTICE_VZ_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_VZ_IN_VIEW,PCR

RENDER_GNDLATTICE_BOTTOMEDGE_SHIFT_LOOP_NEXT
					INC		RENDER_GNDLATTICE_OFSETTER,PCR
					LSL		RENDER_GNDLATTICE_SHIFTER,PCR
					LDA		RENDER_GNDLATTICE_SHIFTER,PCR
					CMPA	#8
					BLO		RENDER_GNDLATTICE_BOTTOMEDGE_SHIFT_LOOP

					LDB		RENDER_GNDLATTICE_COUNTER,PCR ; Index=9+COUNTER
					ADDB	#9
					LBSR	RENDER_GNDLATTICE_CALC_AND_STORE

					INC		RENDER_GNDLATTICE_COUNTER,PCR
					LDA		RENDER_GNDLATTICE_COUNTER,PCR
					CMPA	#8
					LBLO		RENDER_GNDLATTICE_BOTTOMEDGE_LOOP



					LDB		#1
					STB		RENDER_GNDLATTICE_COUNTER,PCR
					; Left edge
RENDER_GNDLATTICE_LEFTEDGE_LOOP
					; Base=Top-Left
					LDD		RENDER_GNDLATTICE_TOP_LEFT_X,PCR
					STD		RENDER_GNDLATTICE_VX_IN_VIEW,PCR
					LDD		RENDER_GNDLATTICE_TOP_LEFT_Y,PCR
					STD		RENDER_GNDLATTICE_VY_IN_VIEW,PCR
					LDD		RENDER_GNDLATTICE_TOP_LEFT_Z,PCR
					STD		RENDER_GNDLATTICE_VZ_IN_VIEW,PCR

					LDB		#1
					STB		RENDER_GNDLATTICE_SHIFTER,PCR
					STB		RENDER_GNDLATTICE_OFSETTER,PCR
RENDER_GNDLATTICE_LEFTEDGE_SHIFT_LOOP
					LDB		RENDER_GNDLATTICE_SHIFTER,PCR
					BITB	RENDER_GNDLATTICE_COUNTER,PCR
					BEQ		RENDER_GNDLATTICE_LEFTEDGE_SHIFT_LOOP_NEXT

					; Dir WX
					LEAX	RENDER_GNDLATTICE_ZEROWX,PCR
					LDB		RENDER_GNDLATTICE_OFSETTER,PCR
					LSLB
					LDD		B,X
					ADDD	RENDER_GNDLATTICE_VX_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_VX_IN_VIEW,PCR

					LEAX	RENDER_GNDLATTICE_ZEROWY,PCR
					LDB		RENDER_GNDLATTICE_OFSETTER,PCR
					LSLB
					LDD		B,X
					ADDD	RENDER_GNDLATTICE_VY_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_VY_IN_VIEW,PCR

					LEAX	RENDER_GNDLATTICE_ZEROWZ,PCR
					LDB		RENDER_GNDLATTICE_OFSETTER,PCR
					LSLB
					LDD		B,X
					ADDD	RENDER_GNDLATTICE_VZ_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_VZ_IN_VIEW,PCR

RENDER_GNDLATTICE_LEFTEDGE_SHIFT_LOOP_NEXT
					INC		RENDER_GNDLATTICE_OFSETTER,PCR
					LSL		RENDER_GNDLATTICE_SHIFTER,PCR
					LDA		RENDER_GNDLATTICE_SHIFTER,PCR
					CMPA	#8
					BLO		RENDER_GNDLATTICE_LEFTEDGE_SHIFT_LOOP

					LDB		RENDER_GNDLATTICE_COUNTER,PCR ; Index=17+COUNTER
					ADDB	#17
					LBSR	RENDER_GNDLATTICE_CALC_AND_STORE

					INC		RENDER_GNDLATTICE_COUNTER,PCR
					LDA		RENDER_GNDLATTICE_COUNTER,PCR
					CMPA	#8
					LBLO		RENDER_GNDLATTICE_LEFTEDGE_LOOP



					LDB		#1
					STB		RENDER_GNDLATTICE_COUNTER,PCR
					; Right edge
RENDER_GNDLATTICE_RIGHTEDGE_LOOP
					; Base=Top-Right
					LDD		RENDER_GNDLATTICE_TOP_RIGHT_X,PCR
					STD		RENDER_GNDLATTICE_VX_IN_VIEW,PCR
					LDD		RENDER_GNDLATTICE_TOP_RIGHT_Y,PCR
					STD		RENDER_GNDLATTICE_VY_IN_VIEW,PCR
					LDD		RENDER_GNDLATTICE_TOP_RIGHT_Z,PCR
					STD		RENDER_GNDLATTICE_VZ_IN_VIEW,PCR

					LDB		#1
					STB		RENDER_GNDLATTICE_SHIFTER,PCR
					STB		RENDER_GNDLATTICE_OFSETTER,PCR
RENDER_GNDLATTICE_RIGHTEDGE_SHIFT_LOOP
					LDB		RENDER_GNDLATTICE_SHIFTER,PCR
					BITB	RENDER_GNDLATTICE_COUNTER,PCR
					BEQ		RENDER_GNDLATTICE_RIGHTEDGE_SHIFT_LOOP_NEXT

					; Dir WX
					LEAX	RENDER_GNDLATTICE_ZEROWX,PCR
					LDB		RENDER_GNDLATTICE_OFSETTER,PCR
					LSLB
					LDD		B,X
					ADDD	RENDER_GNDLATTICE_VX_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_VX_IN_VIEW,PCR

					LEAX	RENDER_GNDLATTICE_ZEROWY,PCR
					LDB		RENDER_GNDLATTICE_OFSETTER,PCR
					LSLB
					LDD		B,X
					ADDD	RENDER_GNDLATTICE_VY_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_VY_IN_VIEW,PCR

					LEAX	RENDER_GNDLATTICE_ZEROWZ,PCR
					LDB		RENDER_GNDLATTICE_OFSETTER,PCR
					LSLB
					LDD		B,X
					ADDD	RENDER_GNDLATTICE_VZ_IN_VIEW,PCR
					STD		RENDER_GNDLATTICE_VZ_IN_VIEW,PCR

RENDER_GNDLATTICE_RIGHTEDGE_SHIFT_LOOP_NEXT
					INC		RENDER_GNDLATTICE_OFSETTER,PCR
					LSL		RENDER_GNDLATTICE_SHIFTER,PCR
					LDA		RENDER_GNDLATTICE_SHIFTER,PCR
					CMPA	#8
					BLO		RENDER_GNDLATTICE_RIGHTEDGE_SHIFT_LOOP

					LDB		RENDER_GNDLATTICE_COUNTER,PCR ; Index=24+COUNTER
					ADDB	#24
					LBSR	RENDER_GNDLATTICE_CALC_AND_STORE

					INC		RENDER_GNDLATTICE_COUNTER,PCR
					LDA		RENDER_GNDLATTICE_COUNTER,PCR
					CMPA	#8
					LBLO		RENDER_GNDLATTICE_RIGHTEDGE_LOOP



					; Transform and render
					LDX		#320
					STX		TO_SCREEN_PERS_CX,PCR
					LDX		#100
					STX		TO_SCREEN_PERS_CY,PCR
					LDA		#8
					STA		TO_SCREEN_PERS_XSHIFT,PCR
					LDA		#7
					STA		TO_SCREEN_PERS_YSHIFT,PCR


					LDX		#0
					STX		TO_SCREEN_WX0,PCR
					STX		TO_SCREEN_WY0
					LDX		#639
					STX		TO_SCREEN_WX1,PCR
					LDX		#199
					STX		TO_SCREEN_WY1,PCR

					; It is a large square.  If NEARZ (denominator for perspective)
					; is too small, the window coodinate will overflow.
					LDX		#100
					STX		TO_SCREEN_NEARZ,PCR

					LEAX	GNDLATTICE_NUMVTX,PCR
					STX		TO_SCREEN_GEOMDATAADDR,PCR

					LEAX	GNDLATTICE_VTXBUFPTR,PCR
					STX		TO_SCREEN_TFMBUFADDR,PCR


					LDU		GNDLATTICE_LINEBUFPTR,PCR
					STU		LINEDDA_LINEBUF_PTR,PCR
					STU		CALL_LINEDDA_SUBCPU_DATAADDR,PCR

					LBSR	LINEDDA_GET_LINECOUNT_AND_NEXTLINE_PTR
					LDY		LINEDDA_LINECOUNT_PTR,PCR

					LDU		LINEDDA_NEXTLINE_PTR,PCR
					STU		TO_SCREEN_LINEOUTADDR,PCR

					LDA		#1
					STA		TO_SCREEN_SKIP_MODELVIEW,PCR
					LBSR	TO_SCREEN
					CLR		TO_SCREEN_SKIP_MODELVIEW,PCR

					LDA		TO_SCREEN_NUMLINE,PCR
					ADDA	,Y
					STA		,Y

RENDER_GNDLATTICE_END
					PULS	A,B,X,Y,U
					RTS

					; B is the index
RENDER_GNDLATTICE_CALC_AND_STORE
					LEAX	GNDLATTICE_VTXBUFPTR,PCR
					LSLB
					ABX
					LSLB
					ABX
					LDD		RENDER_GNDLATTICE_ORIGINX_IN_VIEW,PCR
					ADDD	RENDER_GNDLATTICE_VX_IN_VIEW,PCR
					STD		,X++
					LDD		RENDER_GNDLATTICE_ORIGINY_IN_VIEW,PCR
					ADDD	RENDER_GNDLATTICE_VY_IN_VIEW,PCR
					STD		,X++
					LDD		RENDER_GNDLATTICE_ORIGINZ_IN_VIEW,PCR
					ADDD	RENDER_GNDLATTICE_VZ_IN_VIEW,PCR
					STD		,X++
					RTS

RENDER_GNDLATTICE_CALC_ORIGIN_IN_VIEW
					LEAX	RENDER_GNDLATTICE_VX0_IN_VIEW,PCR
					LEAY	TRANS3D_VIEWX,PCR
					LDD		#0
					SUBD	,Y++
					STD		,X++
					LDD		#0
					SUBD	,Y++
					STD		,X++
					LDD		#0
					SUBD	,Y++
					STD		,X++
RENDER_GNDLATTICE_ROTATE_TO_VIEW
					LEAX	RENDER_GNDLATTICE_VZ0_IN_VIEW,PCR
					LEAY	RENDER_GNDLATTICE_VX0_IN_VIEW,PCR
					LDA		TRANS3D_VIEWH,PCR
					NEGA
					LBSR	TRANS3D_ROTATION

					LEAX	RENDER_GNDLATTICE_VY0_IN_VIEW,PCR
					LEAY	RENDER_GNDLATTICE_VZ0_IN_VIEW,PCR
					LDA		TRANS3D_VIEWP,PCR
					NEGA
					LBSR	TRANS3D_ROTATION

					LEAX	RENDER_GNDLATTICE_VX0_IN_VIEW,PCR
					LEAY	RENDER_GNDLATTICE_VY0_IN_VIEW,PCR
					LDA		TRANS3D_VIEWB,PCR
					NEGA
					LBSR	TRANS3D_ROTATION
					RTS

RENDER_GNDLATTICE_CALCDIV
					LDD		,U
					ASRA
					RORB
					STD		,--U	;Half
					ASRA
					RORB
					STD		,--U	;Quarter
					ASRA
					RORB
					STD		,--U	;Octa
					RTS


RENDER_GNDLATTICE_COUNTER			FCB		0
RENDER_GNDLATTICE_SHIFTER			FCB		0
RENDER_GNDLATTICE_OFSETTER			FCB		0
RENDER_GNDLATTICE_X_IN_VIEW			FDB		0
RENDER_GNDLATTICE_Y_IN_VIEW			FDB		0
RENDER_GNDLATTICE_Z_IN_VIEW			FDB		0
RENDER_GNDLATTICE_VX_IN_VIEW		FDB		0
RENDER_GNDLATTICE_VY_IN_VIEW		FDB		0
RENDER_GNDLATTICE_VZ_IN_VIEW		FDB		0
RENDER_GNDLATTICE_VX0_IN_VIEW		FDB		0
RENDER_GNDLATTICE_VY0_IN_VIEW		FDB		0
RENDER_GNDLATTICE_VZ0_IN_VIEW		FDB		0
RENDER_GNDLATTICE_ORIGINX_IN_VIEW	FDB 	0
RENDER_GNDLATTICE_ORIGINY_IN_VIEW	FDB 	0
RENDER_GNDLATTICE_ORIGINZ_IN_VIEW	FDB 	0

RENDER_GNDLATTICE_TOP_LEFT_X		FDB		0
RENDER_GNDLATTICE_TOP_LEFT_Y		FDB		0
RENDER_GNDLATTICE_TOP_LEFT_Z		FDB		0
RENDER_GNDLATTICE_TOP_RIGHT_X		FDB		0
RENDER_GNDLATTICE_TOP_RIGHT_Y		FDB		0
RENDER_GNDLATTICE_TOP_RIGHT_Z		FDB		0
RENDER_GNDLATTICE_BOTTOM_LEFT_X		FDB		0
RENDER_GNDLATTICE_BOTTOM_LEFT_Y		FDB		0
RENDER_GNDLATTICE_BOTTOM_LEFT_Z		FDB		0

RENDER_GNDLATTICE_ZEROUX			EQU		RENDER_GNDLATTICE_OCTAUX-2
RENDER_GNDLATTICE_OCTAUX			FDB		0
RENDER_GNDLATTICE_QUARTERUX			FDB		0
RENDER_GNDLATTICE_HALFUX			FDB		0
RENDER_GNDLATTICE_UX				FDB		0

RENDER_GNDLATTICE_ZEROUY			EQU		RENDER_GNDLATTICE_OCTAUY-2
RENDER_GNDLATTICE_OCTAUY			FDB		0
RENDER_GNDLATTICE_QUARTERUY			FDB		0
RENDER_GNDLATTICE_HALFUY			FDB		0
RENDER_GNDLATTICE_UY				FDB		0

RENDER_GNDLATTICE_ZEROUZ			EQU		RENDER_GNDLATTICE_OCTAUZ-2
RENDER_GNDLATTICE_OCTAUZ			FDB		0
RENDER_GNDLATTICE_QUARTERUZ			FDB		0
RENDER_GNDLATTICE_HALFUZ			FDB		0
RENDER_GNDLATTICE_UZ				FDB		0

RENDER_GNDLATTICE_ZEROWX			EQU		RENDER_GNDLATTICE_OCTAWX-2
RENDER_GNDLATTICE_OCTAWX			FDB		0
RENDER_GNDLATTICE_QUARTERWX			FDB		0
RENDER_GNDLATTICE_HALFWX			FDB		0
RENDER_GNDLATTICE_WX				FDB		0

RENDER_GNDLATTICE_ZEROWY			EQU		RENDER_GNDLATTICE_OCTAWY-2
RENDER_GNDLATTICE_OCTAWY			FDB		0
RENDER_GNDLATTICE_QUARTERWY			FDB		0
RENDER_GNDLATTICE_HALFWY			FDB		0
RENDER_GNDLATTICE_WY				FDB		0

RENDER_GNDLATTICE_ZEROWZ			EQU		RENDER_GNDLATTICE_OCTAWZ-2
RENDER_GNDLATTICE_OCTAWZ			FDB		0
RENDER_GNDLATTICE_QUARTERWZ			FDB		0
RENDER_GNDLATTICE_HALFWZ			FDB		0
RENDER_GNDLATTICE_WZ				FDB		0



RENDER_GNDLATTICE_DEBUG_LAST_B0		FCB		0
RENDER_GNDLATTICE_DEBUG_LAST_B1		FCB		0
RENDER_GNDLATTICE_DEBUG_LAST_B2		FCB		0
RENDER_GNDLATTICE_DEBUG_LAST_B3		FCB		0
