; Circle drawing by Soji Yamakawa 2017/11/1

						; Requires lineddasubcpu, scrnclip

						EXPORT	DRAW_CIRCLE_VRAMADDR
						EXPORT	DRAW_CIRCLE_SUBCPU_CX
						EXPORT	DRAW_CIRCLE_SUBCPU_CY
						EXPORT	DRAW_CIRCLE_SUBCPU_R
						EXPORT	DRAW_CIRCLE_SUBCPU


DRAW_CIRCLE_VRAMADDR	FDB		0
DRAW_CIRCLE_SUBCPU_CX	FDB		0
DRAW_CIRCLE_SUBCPU_CY	FDB		0
DRAW_CIRCLE_SUBCPU_R	FDB		0
DRAW_CIRCLE_BUFFADDR	FDB		LINEDDA_IN_SUBCPU_BUFFER
DRAW_CIRCLE_COLOR		FCB		0	; For DRAW_CIRCLE_COLOR_SUBCPU



DRAW_CIRCLE_SUBCPU	PSHS	A,B,X,Y,U

					BSR		DRAW_CIRCLE_MAKE_VERTEX_BUFFER

					LDU		DRAW_CIRCLE_BUFFADDR,PCR
					STU		CALL_LINEDDA_SUBCPU_DATAADDR,PCR
					LBSR	CALL_LINEDDA_SUBCPU

					PULS	A,B,X,Y,U,PC



DRAW_CIRCLE_COLOR_SUBCPU
					PSHS	A,B,X,Y,U

					BSR		DRAW_CIRCLE_MAKE_VERTEX_BUFFER

					LDA		DRAW_CIRCLE_COLOR,PCR
					LDU		DRAW_CIRCLE_BUFFADDR,PCR
					STU		CALL_LINEDDA_SUBCPU_DATAADDR,PCR

					LSRA
					BCC		DRAW_CIRCLE_COLOR_SUBCPU_BLUE_DONE
					LDX		#$0
					STX		,U
					LBSR	CALL_LINEDDA_SUBCPU
DRAW_CIRCLE_COLOR_SUBCPU_BLUE_DONE

					LSRA
					BCC		DRAW_CIRCLE_COLOR_SUBCPU_RED_DONE
					LDX		#$4000
					STX		,U
					LBSR	CALL_LINEDDA_SUBCPU
DRAW_CIRCLE_COLOR_SUBCPU_RED_DONE

					LSRA
					BCC		DRAW_CIRCLE_COLOR_SUBCPU_GREEN_DONE
					LDX		#$8000
					STX		,U
					LBSR	CALL_LINEDDA_SUBCPU
DRAW_CIRCLE_COLOR_SUBCPU_GREEN_DONE

					PULS	A,B,X,Y,U,PC


DRAW_CIRCLE_MAKE_VERTEX_BUFFER
					PSHS	A,B,X,Y,U

					LDX		#0
					STX		SCLIP_WX0,PCR
					LDX		#0
					STX		SCLIP_WY0,PCR
					LDX		#639
					STX		SCLIP_WX1,PCR
					LDX		#199
					STX		SCLIP_WY1,PCR


					LDU		DRAW_CIRCLE_BUFFADDR,PCR

					LDX		DRAW_CIRCLE_VRAMADDR,PCR
					STX		,U++

					LDA		#80
					STA		,U+		; 80 bytes per line

					LDA		#1
					STA		,U+		; Needs to be one.

					LEAY	0,U
					CLR		,U+		; Number of lines

					LDA		#0		; A as angle
					LDX		DRAW_CIRCLE_SUBCPU_R,PCR
					STX		DRAW_CIRCLE_SUBCPU_DX1,PCR
					LDX		#0
					STX		DRAW_CIRCLE_SUBCPU_DY1,PCR

DRAW_CIRCLE_LOOP		LDX		DRAW_CIRCLE_SUBCPU_DX1,PCR
					STX		DRAW_CIRCLE_SUBCPU_DX0,PCR
					LDX		DRAW_CIRCLE_SUBCPU_DY1,PCR
					STX		DRAW_CIRCLE_SUBCPU_DY0,PCR

					ADDA	#4

					LDX		DRAW_CIRCLE_SUBCPU_R,PCR
					STX		COS_MULTIPLIER,PCR
					STA		COS_ANGLE,PCR
					LBSR	CALC_COS
					LDX		COS_MULTIPLIER,PCR
					STX		DRAW_CIRCLE_SUBCPU_DX1,PCR

					LDX		DRAW_CIRCLE_SUBCPU_R,PCR
					STX		SIN_MULTIPLIER,PCR
					STA		SIN_ANGLE,PCR
					LBSR	CALC_SIN
					LDX		SIN_MULTIPLIER,PCR
					STX		DRAW_CIRCLE_SUBCPU_DY1,PCR

					PSHS	A

					LDD		DRAW_CIRCLE_SUBCPU_CX,PCR
					ADDD	DRAW_CIRCLE_SUBCPU_DX0,PCR
					STD		SCLIP_LX0,PCR

					LDD		DRAW_CIRCLE_SUBCPU_DY0,PCR
					ASRA
					RORB
					ADDD	DRAW_CIRCLE_SUBCPU_CY,PCR
					STD		SCLIP_LY0,PCR

					LDD		DRAW_CIRCLE_SUBCPU_CX,PCR
					ADDD	DRAW_CIRCLE_SUBCPU_DX1,PCR
					STD		SCLIP_LX1,PCR

					LDD		DRAW_CIRCLE_SUBCPU_DY1,PCR
					ASRA
					RORB
					ADDD	DRAW_CIRCLE_SUBCPU_CY,PCR
					STD		SCLIP_LY1,PCR

					LBSR	SCRNCLIP

					LDA		SCLIP_VISIBLE,PCR
					BEQ		DRAW_CIRCLE_SUBCPU_LINE1

					LEAX	SCLIP_LX0,PCR
					LDD		,X++
					STD		,U++
					LDD		,X++
					STB		,U+
					LDD		,X++
					STD		,U++
					LDD		,X++
					STB		,U+
					INC		,Y
DRAW_CIRCLE_SUBCPU_LINE1


					LDD		DRAW_CIRCLE_SUBCPU_CX,PCR
					SUBD	DRAW_CIRCLE_SUBCPU_DX0,PCR
					STD		SCLIP_LX0,PCR

					LDD		DRAW_CIRCLE_SUBCPU_DY0,PCR
					ASRA
					RORB
					ADDD	DRAW_CIRCLE_SUBCPU_CY,PCR
					STD		SCLIP_LY0,PCR

					LDD		DRAW_CIRCLE_SUBCPU_CX,PCR
					SUBD	DRAW_CIRCLE_SUBCPU_DX1,PCR
					STD		SCLIP_LX1,PCR

					LDD		DRAW_CIRCLE_SUBCPU_DY1,PCR
					ASRA
					RORB
					ADDD	DRAW_CIRCLE_SUBCPU_CY,PCR
					STD		SCLIP_LY1,PCR

					LBSR	SCRNCLIP

					LDA		SCLIP_VISIBLE,PCR
					BEQ		DRAW_CIRCLE_SUBCPU_LINE2

					LEAX	SCLIP_LX0,PCR
					LDD		,X++
					STD		,U++
					LDD		,X++
					STB		,U+
					LDD		,X++
					STD		,U++
					LDD		,X++
					STB		,U+
					INC		,Y
DRAW_CIRCLE_SUBCPU_LINE2


					LDD		DRAW_CIRCLE_SUBCPU_CX,PCR
					ADDD	DRAW_CIRCLE_SUBCPU_DX0,PCR
					STD		SCLIP_LX0,PCR

					LDD		DRAW_CIRCLE_SUBCPU_DY0,PCR
					COMA
					COMB
					ADDD	#1
					ASRA
					RORB
					ADDD	DRAW_CIRCLE_SUBCPU_CY,PCR
					STD		SCLIP_LY0,PCR

					LDD		DRAW_CIRCLE_SUBCPU_CX,PCR
					ADDD	DRAW_CIRCLE_SUBCPU_DX1,PCR
					STD		SCLIP_LX1,PCR

					LDD		DRAW_CIRCLE_SUBCPU_DY1,PCR
					COMA
					COMB
					ADDD	#1
					ASRA
					RORB
					ADDD	DRAW_CIRCLE_SUBCPU_CY,PCR
					STD		SCLIP_LY1,PCR

					LBSR	SCRNCLIP

					LDA		SCLIP_VISIBLE,PCR
					BEQ		DRAW_CIRCLE_SUBCPU_LINE3

					LEAX	SCLIP_LX0,PCR
					LDD		,X++
					STD		,U++
					LDD		,X++
					STB		,U+
					LDD		,X++
					STD		,U++
					LDD		,X++
					STB		,U+
					INC		,Y
DRAW_CIRCLE_SUBCPU_LINE3


					LDD		DRAW_CIRCLE_SUBCPU_CX,PCR
					SUBD	DRAW_CIRCLE_SUBCPU_DX0,PCR
					STD		SCLIP_LX0,PCR

					LDD		DRAW_CIRCLE_SUBCPU_DY0,PCR
					COMA
					COMB
					ADDD	#1
					ASRA
					RORB
					ADDD	DRAW_CIRCLE_SUBCPU_CY,PCR
					STD		SCLIP_LY0,PCR

					LDD		DRAW_CIRCLE_SUBCPU_CX,PCR
					SUBD	DRAW_CIRCLE_SUBCPU_DX1,PCR
					STD		SCLIP_LX1,PCR

					LDD		DRAW_CIRCLE_SUBCPU_DY1,PCR
					COMA
					COMB
					ADDD	#1
					ASRA
					RORB
					ADDD	DRAW_CIRCLE_SUBCPU_CY,PCR
					STD		SCLIP_LY1,PCR

					LBSR	SCRNCLIP

					LDA		SCLIP_VISIBLE,PCR
					BEQ		DRAW_CIRCLE_SUBCPU_LINE4

					LEAX	SCLIP_LX0,PCR
					LDD		,X++
					STD		,U++
					LDD		,X++
					STB		,U+
					LDD		,X++
					STD		,U++
					LDD		,X++
					STB		,U+
					INC		,Y
DRAW_CIRCLE_SUBCPU_LINE4


DRAW_CIRCLE_SUBCPU_ONELINEDONE
					PULS	A
					CMPA	#$40
					LBNE	DRAW_CIRCLE_LOOP

					PULS	A,B,X,Y,U,PC




DRAW_CIRCLE_SUBCPU_DX0			FDB		0
DRAW_CIRCLE_SUBCPU_DY0			FDB		0
DRAW_CIRCLE_SUBCPU_DX1			FDB		0
DRAW_CIRCLE_SUBCPU_DY1			FDB		0
