BALLDEMO_CTR		FDB		0
BALLDEMO_DELAY		FDB		1
BALLDEMO_SPRITE_COLOR	FCB	1

BALLDEMO_GRAVITY	EQU		2

BALLDATA_PTR		EQU		$6700

BALLSPRITE_PTR		EQU		$6800

BALLDEMO_BGMSTOP	FDB		0
BALLDEMO_DONTINIT	FCB		0

MAX_NUM_BALL		EQU		12
					;				WORD	First word Number of balls
					; 10 bytes each.  Max 25 balls.
					;		PTR		WORD	x
					;		PTR+2	WORD	y
					;		PTR+4	WORD	vx
					;		PTR+6	WORD	vy
					;		PTR+8	BYTE	c
					;		PTR+9	BYTE	unused


BALLDEMO			PSHS	A,B,X,Y,U

					LBSR 	INSTALL_SPRITE_SUBCPU
					LBSR	INSTALL_BALL_SPRITE_PATTERN_SUBCPU
					LBSR	RESET_PALETTE

					TST		BALLDEMO_DONTINIT,PCR
					BNE		BALLDEMO_SKIP_INIT
					BSR		BALLDEMO_INIT
BALLDEMO_SKIP_INIT
					LBSR	BALLDEMO_INITSPRITE

					LDX		#10000
					STX		BALLDEMO_DELAY,PCR

BALLDEMO_OUTER_LOOP
					LDX		#50
					STX		BALLDEMO_CTR,PCR
					BSR		BALLDEMO_LOOP

					LDA		$FD04
					BITA	#2
					BEQ		BALLDEMO_MAIN_EXIT

					LBSR	BALLDEMO_ADD_BALL
					LBSR	BALLDEMO_INITSPRITE

					LDD		BALLDEMO_DELAY,PCR
					SUBD	#500
					BCC		BALLDEMO_OUTER_LOOP_UPDATE_DELAY
					LDD		#0
BALLDEMO_OUTER_LOOP_UPDATE_DELAY
					STD		BALLDEMO_DELAY,PCR

					LBSR	PSGPLAY_GET_COUNTER
					CMPD	BALLDEMO_BGMSTOP,PCR
					BLE		BALLDEMO_OUTER_LOOP



BALLDEMO_MAIN_EXIT
					BSR	BALLDEMO_CLEANUP

					PULS	A,B,X,Y,U,PC



BALLDEMO_LOOP		LBSR	BALLDEMO_ONESTEP

					LDX		BALLDEMO_DELAY,PCR
BALLDEMO_WAIT_LOOP	LEAX	-1,X
					BNE		BALLDEMO_WAIT_LOOP

					LDA		$FD04
					BITA	#2
					BEQ		BALLDEMO_LOOP_EXIT

					LBSR	PSGPLAY_GET_COUNTER
					CMPD	BALLDEMO_BGMSTOP,PCR
					BGE		BALLDEMO_LOOP_EXIT

					LDD		BALLDEMO_CTR,PCR
					SUBD	#1
					STD		BALLDEMO_CTR,PCR
					BNE		BALLDEMO_LOOP
BALLDEMO_LOOP_EXIT
					RTS



BALLDEMO_CLEANUP	PSHS	A,B,X,Y,U
					PULS	A,B,X,Y,U,PC



BALLDEMO_INIT		PSHS	A,B,X,Y,U

					LDX		#BALLDATA_PTR

					LDD		#1
					STD		,X++

					LDD		#320
					STD		,X++
					LDD		#300
					STD		,X++
					LDD		#8
					STD		,X++
					LDD		#0
					STD		,X++
					LDD		#$0700
					STD		,X++

					; LDD		#320
					; STD		,X++
					; LDD		#200
					; STD		,X++
					; LDD		#-8
					; STD		,X++
					; LDD		#0
					; STD		,X++
					; LDD		#$0700
					; STD		,X++

					; LDD		#200
					; STD		,X++
					; LDD		#30
					; STD		,X++
					; LDD		#0
					; STD		,X++
					; LDD		#0
					; STD		,X++
					; LDD		#$0700
					; STD		,X++

					; LDD		#80
					; STD		,X++
					; LDD		#30
					; STD		,X++
					; LDD		#0
					; STD		,X++
					; LDD		#0
					; STD		,X++
					; LDD		#$0700
					; STD		,X++

					; LDD		#40
					; STD		,X++
					; LDD		#30
					; STD		,X++
					; LDD		#0
					; STD		,X++
					; LDD		#0
					; STD		,X++
					; LDD		#$0700
					; STD		,X++

					PULS	A,B,X,Y,U,PC



BALLDEMO_ONESTEP	PSHS	A,B,X,Y,U
					BSR		BALLDEMO_MOVE
					LBSR	BALLDEMO_COLLISION
					LBSR	BALLDEMO_DRAW
					PULS	A,B,X,Y,U,PC



BALLDEMO_MOVE		LDX		#BALLDATA_PTR
					LDY		,X++

BALLDEMO_MOVE_LOOP	LDD		,X
					ADDD	4,X
					STD		,X
					LDD		2,X
					ADDD	6,X
					STD		2,X

					LDD		6,X
					ADDD	#BALLDEMO_GRAVITY
					STD		6,X


					LDD		,X
					CMPD	#20
					BGT		BALLDEMO_MOVE_LEFT_CHECKED
					LDD		4,X
					BPL		BALLDEMO_MOVE_LEFT_CHECKED

					COMA
					COMB
					ADDD	#1
					STD		4,X
					LDD		#20
					STD		,X

BALLDEMO_MOVE_LEFT_CHECKED
					LDD		,X
					CMPD	#620
					BLT		BALLDEMO_MOVE_RIGHT_CHECKED
					LDD		4,X
					BMI		BALLDEMO_MOVE_RIGHT_CHECKED
					COMA
					COMB
					ADDD	#1
					STD		4,X
					LDD		#620
					STD		,X

BALLDEMO_MOVE_RIGHT_CHECKED
					LDD		2,X
					BPL		BALLDEMO_MOVE_TOP_CHECKED
					LDD		6,X
					BPL		BALLDEMO_MOVE_TOP_CHECKED
					LDD		#0
					STD		6,X

BALLDEMO_MOVE_TOP_CHECKED
					LDD		2,X
					CMPD	#380
					BLT		BALLDEMO_BOTTOM_CHECKED
					LDD		6,X
					BMI		BALLDEMO_BOTTOM_CHECKED
					CMPD	#30
					BLE		BALLDEMO_MOVE_CUTDOWN_ENERGY
					LDD		#30
BALLDEMO_MOVE_CUTDOWN_ENERGY
					COMA
					COMB
					ADDD	#1
					STD		6,X
					LDD		#380
					STD		2,X

BALLDEMO_BOTTOM_CHECKED

					LEAX	10,X
					LEAY	-1,Y
					CMPY	#0
					BNE		BALLDEMO_MOVE_LOOP

					RTS



BALLDEMO_COLLISION	LDX		#BALLDATA_PTR
					LDA		1,X
					BEQ		BALLDEMO_COLLISION_EXIT
					LEAX	2,X
BALLDEMO_COLLISION_OUTERLOOP
					LEAY	10,X
					PSHS	A
					PULS	B
					DECB
					BEQ		BALLDEMO_COLLISION_EXIT
BALLDEMO_COLLISION_INNERLOOP
					BSR		BALLDEMO_COLLISION_PER_PAIR
					LEAY	10,Y
					DECB
					BNE		BALLDEMO_COLLISION_INNERLOOP
					LEAX	10,X
					DECA
					BNE		BALLDEMO_COLLISION_OUTERLOOP

BALLDEMO_COLLISION_EXIT
					RTS




					; X	Ball1
					; Y Ball2
BALLDEMO_COLLISION_PER_PAIR
					PSHS	A,B,X,Y
					LEAS	-26,S
					LEAU	,S

					LDD		,Y
					SUBD	,X
					CMPD	#-40
					LBLT	BALLDEMO_COLLISION_PER_PAIR_END
					CMPD	#40
					LBGT	BALLDEMO_COLLISION_PER_PAIR_END
					STD		,U   	; NX		2

					LDD		2,Y
					SUBD	2,X
					CMPD	#-40
					LBLT	BALLDEMO_COLLISION_PER_PAIR_END
					CMPD	#40
					LBGT	BALLDEMO_COLLISION_PER_PAIR_END
					STD		2,U  	; NY		2

					LDD		4,Y
					SUBD	4,X  	; RVX		2
					STD		MUL16_NUM0,PCR
					LDD		,U   	; NX		2
					STD		MUL16_NUM1,PCR
					LBSR	MUL16
					LDD		MUL16_NUM1,PCR
					STD		24,U	; tmp 32-bit addition
					LDD		MUL16_NUM0,PCR
					STD		22,U	; tmp 32-bit addition

					LDD		6,Y
					SUBD	6,X  	; RVY		2
					STD		MUL16_NUM0,PCR
					LDD		2,U  	; NY		2
					STD		MUL16_NUM1,PCR
					LBSR	MUL16

					LDD		MUL16_NUM1,PCR
					ADDD	24,U	; tmp 32-bit addition
					STD		24,U	; tmp 32-bit addition
					LDD		MUL16_NUM0,PCR
					ADCB	23,U
					ADCA	22,U
					STD		22,U	; tmp 32-bit addition
					BMI		BALLDEMO_COLLISION_PER_PAIR_RELVEL_CHECKED
					LBNE	BALLDEMO_COLLISION_PER_PAIR_END
					LDD		24,U	; Higher-Bit zero.  Check lower bit.
					LBNE	BALLDEMO_COLLISION_PER_PAIR_END

BALLDEMO_COLLISION_PER_PAIR_RELVEL_CHECKED
					LDD		,U   	; NX		2
					STD		MUL16_NUM0,PCR
					STD		MUL16_NUM1,PCR
					LBSR	MUL16
					LDD		MUL16_NUM1,PCR
					STD		24,U	; tmp 32-bit addition
					LDD		MUL16_NUM0,PCR
					STD		22,U	; tmp 32-bit addition

					LDD		2,U  	; NY		2
					STD		MUL16_NUM0,PCR
					STD		MUL16_NUM1,PCR
					LBSR	MUL16

					LDD		MUL16_NUM1,PCR
					ADDD	24,U	; tmp 32-bit addition
					STD		SQRT32_INPUT_LO,PCR
					LDD		MUL16_NUM0,PCR
					ADCB	23,U
					ADCA	22,U
					STD		SQRT32_INPUT_HI,PCR
					LBNE	BALLDEMO_COLLISION_PER_PAIR_END

					LDD		SQRT32_INPUT_LO,PCR
					CMPD	#1600
					LBGE	BALLDEMO_COLLISION_PER_PAIR_END

					LBSR	SQRT32
					LDD		SQRT32_OUTPUT,PCR
					STD		12,U	; NL		2
					LBEQ	BALLDEMO_COLLISION_PER_PAIR_END


					; Normalizing (NX,NY)
					LDD		,U   	; NX		2
					STD		DIV32_16_NUMER+2,PCR
					TFR		B,A
					SEX
					STA		DIV32_16_NUMER,PCR
					STA		DIV32_16_NUMER+1,PCR
					LDA		#7
BALLDEMO_COLLISION_PER_PAIR_MUL_NX_128
					ASL		DIV32_16_NUMER+3,PCR
					ROL		DIV32_16_NUMER+2,PCR
					ROL		DIV32_16_NUMER+1,PCR
					ROL		DIV32_16_NUMER  ,PCR
					DECA
					BNE		BALLDEMO_COLLISION_PER_PAIR_MUL_NX_128

					LDD		12,U	; NL		2
					STD		DIV32_16_DENOM,PCR
					LBSR	DIV32_16
					LDD		DIV32_16_DENOM,PCR
					STD		,U   	; NX		2


					LDD		2,U  	; NY		2
					STD		DIV32_16_NUMER+2,PCR
					TFR		B,A
					SEX
					STA		DIV32_16_NUMER,PCR
					STA		DIV32_16_NUMER+1,PCR
					LDA		#7
BALLDEMO_COLLISION_PER_PAIR_MUL_NY_128
					ASL		DIV32_16_NUMER+3,PCR
					ROL		DIV32_16_NUMER+2,PCR
					ROL		DIV32_16_NUMER+1,PCR
					ROL		DIV32_16_NUMER  ,PCR
					DECA
					BNE		BALLDEMO_COLLISION_PER_PAIR_MUL_NY_128

					LDD		12,U	; NL		2
					STD		DIV32_16_DENOM,PCR
					LBSR	DIV32_16
					LDD		DIV32_16_DENOM,PCR
					STD		2,U  	; NY		2


					LDD		,U   	; NX		2
					STD		MUL16_NUM0,PCR
					LDD		4,X		; a->vx
					STD		MUL16_NUM1,PCR
					LBSR	MUL16
					LDD		MUL16_NUM1,PCR
					STD		14,U	; K1		2

					LDD		2,U  	; NY		2
					STD		MUL16_NUM0,PCR
					LDD		6,X		; a->vy
					STD		MUL16_NUM1,PCR
					LBSR	MUL16
					LDD		MUL16_NUM1,PCR
					ADDD	14,U	; K1		2
					STD		14,U	; K1		2
					; NX, NY are order of 128.  VX,VY are 10-20ish.  Hope 16-bit won't overflow

					LDD		,U   	; NX		2
					STD		MUL16_NUM0,PCR
					LDD		4,Y		; b->vx
					STD		MUL16_NUM1,PCR
					LBSR	MUL16
					LDD		MUL16_NUM1,PCR
					STD		16,U	; K2		2

					LDD		2,U  	; NY		2
					STD		MUL16_NUM0,PCR
					LDD		6,Y		; b->vy
					STD		MUL16_NUM1,PCR
					LBSR	MUL16
					LDD		MUL16_NUM1,PCR
					ADDD	16,U	; K2		2
					STD		16,U	; K2		2


					LDD		16,U	; K2		2
					SUBD	14,U	; K1		2
					STD		MUL16_NUM0,PCR
					LDD		,U   	; NX		2
					STD		MUL16_NUM1,PCR
					LBSR	MUL16
					LBSR	BALLDEMO_DOWNSHIFT_MUL16
					LDD		MUL16_NUM1,PCR
					ADDD	4,X
					STD		4,X

					LDD		16,U	; K2		2
					SUBD	14,U	; K1		2
					STD		MUL16_NUM0,PCR
					LDD		2,U  	; NY		2
					STD		MUL16_NUM1,PCR
					LBSR	MUL16
					LBSR	BALLDEMO_DOWNSHIFT_MUL16
					LDD		MUL16_NUM1,PCR
					ADDD	6,X
					STD		6,X

					LDD		14,U	; K1		2
					SUBD	16,U	; K2		2
					STD		MUL16_NUM0,PCR
					LDD		,U   	; NX		2
					STD		MUL16_NUM1,PCR
					LBSR	MUL16
					LBSR	BALLDEMO_DOWNSHIFT_MUL16
					LDD		MUL16_NUM1,PCR
					ADDD	4,Y
					STD		4,Y

					LDD		14,U	; K1		2
					SUBD	16,U	; K2		2
					STD		MUL16_NUM0,PCR
					LDD		2,U  	; NY		2
					STD		MUL16_NUM1,PCR
					LBSR	MUL16
					LBSR	BALLDEMO_DOWNSHIFT_MUL16
					LDD		MUL16_NUM1,PCR
					ADDD	6,Y
					STD		6,Y

					; 	,U   	; NX		2
					; 	2,U  	; NY		2
					; 	4,U  	
					; 	6,U  	
					; 	8,U  	
					; 	12,U	; NL		2
					; 	14,U	; K1		2
					; 	16,U	; K2		2
					; 	18,U	; nextVX	2
					; 	20,U	; nextVY	2
					;	22,U	; tmp 32-bit addition
					;      26 bytes

BALLDEMO_COLLISION_PER_PAIR_END
					LEAS	26,S
					PULS	A,B,X,Y,PC



BALLDEMO_DOWNSHIFT_MUL16
					LDA		#14
BALLDEMO_DOWNSHIFT_MUL16_LOOP
					ASR		MUL16_NUM0,PCR
					ROR		MUL16_NUM0+1,PCR
					ROR		MUL16_NUM0+2,PCR
					ROR		MUL16_NUM0+3,PCR
					DECA
					BNE		BALLDEMO_DOWNSHIFT_MUL16_LOOP
					RTS


BALLDEMO_DRAW
					LDX		#BALLDATA_PTR
					LDU		#BALLSPRITE_PTR

					LDY		,X++

BALLDEMO_DRAW_UPDATESPRITE_LOOP
					LDD		6,U
					STD		3,U
					LDA		8,U
					STA		5,U

					LDD		,X
					SUBD	#16
					STD		6,U
					LDD		2,X
					ASRA
					RORB
					SUBB	#8
					STB		8,U

					LEAX	10,X
					LEAU	9,U

					LEAY	-1,Y
					CMPY	#0
					BNE		BALLDEMO_DRAW_UPDATESPRITE_LOOP

					LDA		#9
					LDB		BALLDATA_PTR+1
					MUL
					ADDD	#1 ; For Terminator
					LDX		#BALLSPRITE_PTR
					LBSR	CALL_SPRITE_SUBCPU

					RTS



BALLDEMO_INITSPRITE
					LDX		#BALLDATA_PTR
					LDU		#BALLSPRITE_PTR

					LDA		#1
					STA		BALLDEMO_SPRITE_COLOR,PCR

					LDY		,X++
BALLDEMO_INITSPRITE_LOOP
					LDA		BALLDEMO_SPRITE_COLOR,PCR
					STA		,U

					LDD		#BALL_SPRITE_SUBCPU_INSTALL_ADDR
					STD		1,U

					LDD		,X
					SUBD	#16
					STD		3,U
					STD		6,U
					LDD		2,X
					ASRA
					RORB
					SUBB	#8
					STB		5,U
					STB		8,U

					LEAX	10,X
					LEAU	9,U

					LDA		BALLDEMO_SPRITE_COLOR,PCR
					INCA
					ANDA	#7
					BNE		BALLDEMO_SPRITE_COLOR_OVERFLOW
					INCA
BALLDEMO_SPRITE_COLOR_OVERFLOW
					STA		BALLDEMO_SPRITE_COLOR,PCR

					LEAY	-1,Y
					CMPY	#0
					BNE		BALLDEMO_INITSPRITE_LOOP

					LDA		#$80
					STA		,U

					RTS




BALLDEMO_ADD_BALL
					LDD		BALLDATA_PTR
					CMPB	#MAX_NUM_BALL
					BGE		BALLDEMO_DONT_ADD_BALL

					LDA		#10
					MUL
					ADDD	#2
					TFR		D,X
					LEAX	BALLDATA_PTR,X

					LDD		#320
					STD		,X++
					LDD		#0
					STD		,X++
					LDD		#0
					STD		,X++
					LDD		#0
					STD		,X++
					LDD		#$0700
					STD		,X++

					LDD		BALLDATA_PTR
					ADDD	#1
					STD		BALLDATA_PTR

BALLDEMO_DONT_ADD_BALL
					RTS
