AIRPLANE_DEMO_VRAMADDR	FDB		0
AIRPLANE_DEMO_VX		FCB		8
AIRPLANE_DEMO_CTR		FCB		0
AIRPLANE_DEMO_OVER		FCB		1
AIRPLANE_DEMO_MODE		FCB		0
AIRPLANE_DEMO_GEOMDATA	FDB		0



AIRPLANE_DEMO_NAIR		FCB		0
AIRPLANE_DEMO_X0		FDB		0
AIRPLANE_DEMO_Y0		FDB		0
AIRPLANE_DEMO_Z0		FDB		0
AIRPLANE_DEMO_H0		FCB		0
AIRPLANE_DEMO_P0		FCB		0
AIRPLANE_DEMO_B0		FCB		0
AIRPLANE_DEMO_X1		FDB		0
AIRPLANE_DEMO_Y1		FDB		0
AIRPLANE_DEMO_Z1		FDB		0
AIRPLANE_DEMO_H1		FCB		0
AIRPLANE_DEMO_P1		FCB		0
AIRPLANE_DEMO_B1		FCB		0



AIRPLANE_DEMO		PSHS	A,B,X,Y,U,CC
					ORCC	#$40

					BSR		AIRPLANE_DEMO_INIT
AIRPLANE_DEMO_LOOP	LBSR	AIRPLANE_DEMO_ONESTEP
					LDA		$FD04
					BITA	#2
					BEQ		AIRPLANE_DEMO_LOOP_OUT
					TST		AIRPLANE_DEMO_OVER,PCR
					BEQ		AIRPLANE_DEMO_LOOP
					BSR		AIRPLANE_DEMO_CLEANUP

AIRPLANE_DEMO_LOOP_OUT
					PULS	A,B,X,Y,U,CC
					RTS



AIRPLANE_DEMO_INIT	PSHS	A,B,X,Y,U

					CLR		AIRPLANE_DEMO_OVER,PCR
					CLR		AIRPLANE_DEMO_CTR,PCR

					LBSR	INSTALL_LINEDDA_IN_SUBCPU
					LBSR	INSTALL_CLEAR_BITPLANE_IN_SUBCPU

					LBSR	CLEAR_SCREEN
					LBSR	AIRPLANE_DEMO_DRAW_GNDLATTICE
					LBSR	AIRPLANEDEMO_INIT_MODE0

					STX		TO_SCREEN_TRANS3D_VIEWX,PCR
					STX		TO_SCREEN_TRANS3D_VIEWY,PCR
					CLR		TO_SCREEN_TRANS3D_VIEWH,PCR
					CLR		TO_SCREEN_TRANS3D_VIEWP,PCR
					CLR		TO_SCREEN_TRANS3D_VIEWB,PCR
					LDX		#500
					STX		TO_SCREEN_TRANS3D_VIEWZ,PCR


					LDX		#$4000
					STX		AIRPLANE_DEMO_VRAMADDR,PCR

					CLR		$FD38
					CLR		$FD39
					CLR		$FD3A
					CLR		$FD3B
					CLR		$FD3C
					CLR		$FD3D
					CLR		$FD3E
					CLR		$FD3F
					PULS	A,B,X,Y,U,PC


AIRPLANE_DEMO_CLEANUP	
					LBSR	CLEAR_SCREEN
					CLRA
					LDX		#$FD38
					STA		,X+
					INCA
					STA		,X+
					INCA
					STA		,X+
					INCA
					STA		,X+
					INCA
					STA		,X+
					INCA
					STA		,X+
					INCA
					STA		,X+
					INCA
					STA		,X+
					INCA

					RTS


AIRPLANE_DEMO_ONESTEP	PSHS	A,B,X,Y,U
					BSR		AIRPLANE_DEMO_MAIN
					INC		AIRPLANE_DEMO_CTR,PCR
					PULS	A,B,X,Y,U,PC


AIRPLANE_DEMO_MAIN		PSHS	A,B,X,Y,U

					LBSR	RENDER_AIRPLANE_BEGIN

					LDA		AIRPLANE_DEMO_NAIR,PCR
					LEAX	AIRPLANE_DEMO_X0,PCR
AIRPLANE_DEMO_RENDER_LOOP
					LBSR	RENDER_AIRPLANE
					LEAX	9,X
					DECA
					BNE		AIRPLANE_DEMO_RENDER_LOOP

					LBSR	RENDER_AIRPLANE_FLUSH

					LDX		AIRPLANE_DEMO_VRAMADDR,PCR

					; Due to hardware problem, Blue Plane is not healthy.
					; Avoid Blue Plane in Mode 0
					LDB		#4
					LDA		#5
					CMPX	#$4000
					BEQ		AIRPLANE_DEMO_GREEN_ON ; To draw on Red.  Turn on Green
AIRPLANE_DEMO_RED_ON		STB		$FD39	' 001
					STA		$FD3A	' 010
					STA		$FD3B	' 011
					CLR		$FD3C	' 100
					STB		$FD3D	' 101
					STA		$FD3E	' 110
					STA		$FD3F	' 111
					BRA		AIRPLANE_DEMO_LOOP_PALETTE_DONE
AIRPLANE_DEMO_GREEN_ON	STB		$FD39	' 001
					CLR		$FD3A	' 010
					STB		$FD3B	' 011
					STA		$FD3C	' 100
					STA		$FD3D	' 101
					STA		$FD3E	' 110
					STA		$FD3F	' 111


AIRPLANE_DEMO_LOOP_PALETTE_DONE
					LEAX	$4000,X
					CMPX	#$8000
					BCS		AIRPLANE_DEMO_LOOP_NEXTVRAM
					BEQ		AIRPLANE_DEMO_LOOP_NEXTVRAM
					LDX		#0
AIRPLANE_DEMO_LOOP_NEXTVRAM
					STX		AIRPLANE_DEMO_VRAMADDR,PCR

					; Avoid Blue Plane
					CMPX	#0
					BNE		AIRPLANE_DEMO_LOOP_MOVE
					LDX		#$4000
					STX		AIRPLANE_DEMO_VRAMADDR,PCR

AIRPLANE_DEMO_LOOP_MOVE
					LDA		AIRPLANE_DEMO_MODE,PCR
					BEQ		AIRPLANEDEMO_MOVE_MODE0
					DECA
					BEQ		AIRPLANEDEMO_MOVE_MODE1
					DECA
					BEQ		AIRPLANEDEMO_MOVE_MODE2
					DECA
					BEQ		AIRPLANEDEMO_MOVE_MODE3
					DECA
					BEQ		AIRPLANEDEMO_MOVE_MODE4
					DECA
					BEQ		AIRPLANEDEMO_MOVE_MODE5
					DECA
					BEQ		AIRPLANEDEMO_MOVE_MODE6

					LDA		#1
					STA		AIRPLANE_DEMO_OVER,PCR
					LBRA	AIRPLANE_DEMO_MAIN_END

AIRPLANEDEMO_MOVE_MODE0
					LDA		AIRPLANE_DEMO_B0,PCR
					ADDA	#16
					STA		AIRPLANE_DEMO_B0,PCR

					LDD		AIRPLANE_DEMO_X0,PCR
					ADDD	#40
					STD		AIRPLANE_DEMO_X0,PCR
					CMPD	#500
					BLT		AIRPLANE_DEMO_MAIN_END
					LBSR	AIRPLANEDEMO_INIT_MODE1
					BRA		AIRPLANE_DEMO_MAIN_END

AIRPLANEDEMO_MOVE_MODE1
					LDD		AIRPLANE_DEMO_Z0,PCR
					SUBD	#40
					STD		AIRPLANE_DEMO_Z0,PCR
					CMPD	#-300
					BGE		AIRPLANE_DEMO_MAIN_END
					LBSR	AIRPLANEDEMO_INIT_MODE2
					BRA		AIRPLANE_DEMO_MAIN_END

AIRPLANEDEMO_MOVE_MODE2
					LDD		AIRPLANE_DEMO_Z0,PCR
					ADDD	#40
					STD		AIRPLANE_DEMO_Z0,PCR
					CMPD	#600
					BLE		AIRPLANE_DEMO_MAIN_END
					LBSR	AIRPLANEDEMO_INIT_MODE3
					BRA		AIRPLANE_DEMO_MAIN_END

AIRPLANEDEMO_MOVE_MODE3
					LBSR	AIRPLANEDEMO_MOVE_MODE3_CALC
					BRA		AIRPLANE_DEMO_MAIN_END

AIRPLANEDEMO_MOVE_MODE4
					LBSR	AIRPLANEDEMO_MOVE_MODE4_CALC
					BRA		AIRPLANE_DEMO_MAIN_END

AIRPLANEDEMO_MOVE_MODE5
					LBSR	AIRPLANEDEMO_MOVE_MODE5_CALC
					BRA		AIRPLANE_DEMO_MAIN_END

AIRPLANEDEMO_MOVE_MODE6
					LBSR	AIRPLANEDEMO_MOVE_MODE6_CALC
					BRA		AIRPLANE_DEMO_MAIN_END

AIRPLANE_DEMO_MAIN_END	PULS	A,B,X,Y,U
					RTS



RENDER_AIRPLANE_BEGIN
					LDX		#320
					STX		TO_SCREEN_PERS_CX,PCR
					LDX		#100
					STX		TO_SCREEN_PERS_CY,PCR
					LDA		#8
					STA		TO_SCREEN_PERS_XSHIFT,PCR
					LDA		#7
					STA		TO_SCREEN_PERS_YSHIFT,PCR


					LDX		#0
					STX		TO_SCREEN_WX0,PCR
					STX		TO_SCREEN_WY0
					LDX		#639
					STX		TO_SCREEN_WX1,PCR
					LDX		#199
					STX		TO_SCREEN_WY1,PCR

					LDX		#10
					STX		TO_SCREEN_NEARZ,PCR

					LDU		#COMMON_LINEBUFPTR

					LDX		AIRPLANE_DEMO_VRAMADDR,PCR
					STX		,U++

					LDA		#80
					STA		,U+		; 80 bytes per line

					LDA		#1
					STA		,U+		; Needs to be one.

					CLR		,U+

					RTS



RENDER_AIRPLANE		PSHS	A,B,X,Y,U

					LDD		,X++
					STD		TO_SCREEN_TRANS3D_OBJX,PCR
					LDD		,X++
					STD		TO_SCREEN_TRANS3D_OBJY,PCR
					LDD		,X++
					STD		TO_SCREEN_TRANS3D_OBJZ,PCR
					LDD		,X++
					STD		TO_SCREEN_TRANS3D_OBJH,PCR
					LDA		,X
					STA		TO_SCREEN_TRANS3D_OBJB,PCR

					LDX		AIRPLANE_DEMO_GEOMDATA,PCR
					STX		TO_SCREEN_GEOMDATAADDR,PCR
					LEAX	AIRPLANE_VTX_TFMBUF,PCR
					STX		TO_SCREEN_TFMBUFADDR,PCR

					LDU		#COMMON_LINEBUFPTR
					LEAY	4,U

					LEAU	5,U
					LDA		,Y
					LDB		#6
					MUL
					LEAU	D,U
					STU		TO_SCREEN_LINEOUTADDR,PCR

					LBSR	TO_SCREEN

					LDA		TO_SCREEN_NUMLINE,PCR
					ADDA	,Y
					STA		,Y

					PULS	A,B,X,Y,U
					RTS



RENDER_AIRPLANE_FLUSH
					LDU		#COMMON_LINEBUFPTR
					STU		CALL_LINEDDA_SUBCPU_DATAADDR,PCR
					LBSR	CALL_CLS_AND_LINEDDA_SUBCPU
					RTS



AIRPLANEDEMO_INIT_MODE0
					CLR		AIRPLANE_DEMO_MODE,PCR

					LDA		#1
					STA		AIRPLANE_DEMO_NAIR,PCR

					LEAX	AIRPLANE_DATA,PCR
					STX		AIRPLANE_DEMO_GEOMDATA,PCR

					LDX		#-500
					STX		AIRPLANE_DEMO_X0,PCR
					LDX		#0
					STX		AIRPLANE_DEMO_Y0,PCR
					STX		AIRPLANE_DEMO_Z0,PCR
					LDA		#-64
					STA		AIRPLANE_DEMO_H0,PCR
					CLR		AIRPLANE_DEMO_P0,PCR
					CLR		AIRPLANE_DEMO_B0,PCR

					RTS




AIRPLANEDEMO_INIT_MODE1
					LDA		#1
					STA		AIRPLANE_DEMO_MODE,PCR
					STA		AIRPLANE_DEMO_NAIR,PCR

					LEAX	AIRPLANE_DATA,PCR
					STX		AIRPLANE_DEMO_GEOMDATA,PCR

					CLR		AIRPLANE_DEMO_H0,PCR
					CLR		AIRPLANE_DEMO_P0,PCR
					CLR		AIRPLANE_DEMO_B0,PCR

					LDD		#40
					STD		AIRPLANE_DEMO_X0,PCR
					STD		AIRPLANE_DEMO_Y0,PCR
					LDD		#600
					STD		AIRPLANE_DEMO_Z0,PCR

					CLR		AIRPLANE_DEMO_CTR,PCR
					RTS

AIRPLANEDEMO_INIT_MODE2
					LDA		#2
					STA		AIRPLANE_DEMO_MODE,PCR

					LEAX	AIRPLANE_DATA,PCR
					STX		AIRPLANE_DEMO_GEOMDATA,PCR

					LDA		#1
					STA		AIRPLANE_DEMO_NAIR,PCR

					LDA		#128
					STA		AIRPLANE_DEMO_H0,PCR
					CLR		AIRPLANE_DEMO_P0,PCR
					CLR		AIRPLANE_DEMO_B0,PCR

					LDD		#-40
					STD		AIRPLANE_DEMO_X0,PCR
					STD		AIRPLANE_DEMO_Y0,PCR
					LDD		#-300
					STD		AIRPLANE_DEMO_Z0,PCR

					CLR		AIRPLANE_DEMO_CTR,PCR
					RTS


AIRPLANEDEMO_INIT_MODE3
					LDA		#3
					STA		AIRPLANE_DEMO_MODE,PCR

					LEAX	AIRPLANE_DATA,PCR
					STX		AIRPLANE_DEMO_GEOMDATA,PCR

					LDA		#1
					STA		AIRPLANE_DEMO_NAIR,PCR

					LDA		#96
					STA		AIRPLANE_DEMO_H0,PCR
					CLR		AIRPLANE_DEMO_P0,PCR
					CLR		AIRPLANE_DEMO_B0,PCR

					LDD		#800
					STD		AIRPLANE_DEMO_X0,PCR
					LDD		#20
					STD		AIRPLANE_DEMO_Y0,PCR
					LDD		#-800
					STD		AIRPLANE_DEMO_Z0,PCR

					CLR		AIRPLANE_DEMO_CTR,PCR
					RTS

AIRPLANEDEMO_MOVE_MODE3_CALC
					LEAX	AIRPLANE_DEMO_X0,PCR
					LBSR	AIRPLANEDEMO_MOVE_FORWARD

					LDA		AIRPLANE_DEMO_CTR,PCR
					CMPA	#10
					BLT		AIRPLANEDEMO_MOVE_MODE3_BANK_IN
					CMPA	#42
					BLT		AIRPLANEDEMO_MOVE_MODE3_TURN
					CMPA	#52
					BLT		AIRPLANEDEMO_MOVE_MODE3_BANK_OUT
					CMPA	#62
					BLT		AIRPLANEDEMO_MOVE_MODE3_CALC_DONE
					BSR		AIRPLANEDEMO_INIT_MODE4
					BRA		AIRPLANEDEMO_MOVE_MODE3_CALC_DONE

AIRPLANEDEMO_MOVE_MODE3_BANK_IN
					LDA		AIRPLANE_DEMO_B0,PCR
					SUBA	#5
					STA		AIRPLANE_DEMO_B0,PCR
					BRA		AIRPLANEDEMO_MOVE_MODE3_CALC_DONE
AIRPLANEDEMO_MOVE_MODE3_TURN
					LDA		AIRPLANE_DEMO_H0,PCR
					SUBA	#8
					STA		AIRPLANE_DEMO_H0,PCR
					BRA		AIRPLANEDEMO_MOVE_MODE3_CALC_DONE
AIRPLANEDEMO_MOVE_MODE3_BANK_OUT
					LDA		AIRPLANE_DEMO_B0,PCR
					ADDA	#5
					STA		AIRPLANE_DEMO_B0,PCR

AIRPLANEDEMO_MOVE_MODE3_CALC_DONE
					RTS


AIRPLANEDEMO_INIT_MODE4
					LDA		#4
					STA		AIRPLANE_DEMO_MODE,PCR

					LEAX	AIRPLANE_DATA,PCR
					STX		AIRPLANE_DEMO_GEOMDATA,PCR

					LDA		#1
					STA		AIRPLANE_DEMO_NAIR,PCR

					LDA		#160
					STA		AIRPLANE_DEMO_H0,PCR
					CLR		AIRPLANE_DEMO_P0,PCR
					CLR		AIRPLANE_DEMO_B0,PCR

					LDD		#-800
					STD		AIRPLANE_DEMO_X0,PCR
					LDD		#-200
					STD		AIRPLANE_DEMO_Y0,PCR
					LDD		#-800
					STD		AIRPLANE_DEMO_Z0,PCR

					CLR		AIRPLANE_DEMO_CTR,PCR
					RTS

AIRPLANEDEMO_MOVE_MODE4_CALC
					LEAX	AIRPLANE_DEMO_X0,PCR
					LBSR	AIRPLANEDEMO_MOVE_FORWARD

					LDA		AIRPLANE_DEMO_CTR,PCR
					CMPA	#10
					BLT		AIRPLANEDEMO_MOVE_MODE4_CALC_DONE
					CMPA	#56
					BGE		AIRPLANEDEMO_MOVE_MODE4_CALC_SWITCH_TO_MODE5
					CMPA	#44
					BGE		AIRPLANEDEMO_MOVE_MODE4_CALC_DONE

					LDA		AIRPLANE_DEMO_P0,PCR
					ADDA	#8
					STA		AIRPLANE_DEMO_P0,PCR

AIRPLANEDEMO_MOVE_MODE4_CALC_DONE
					RTS
AIRPLANEDEMO_MOVE_MODE4_CALC_SWITCH_TO_MODE5
					BSR		AIRPLANEDEMO_MOVE_MODE5_INIT
					RTS



AIRPLANEDEMO_MOVE_MODE5_INIT
					LDA		#5
					STA		AIRPLANE_DEMO_MODE,PCR
					CLR		AIRPLANE_DEMO_CTR,PCR

					LEAX	AIRPLANE_DATA_SMALL,PCR
					STX		AIRPLANE_DEMO_GEOMDATA,PCR

					LDA		#2
					STA		AIRPLANE_DEMO_NAIR,PCR

					LDA		#160
					STA		AIRPLANE_DEMO_H0,PCR
					CLR		AIRPLANE_DEMO_P0,PCR
					CLR		AIRPLANE_DEMO_B0,PCR

					LDD		#-800
					STD		AIRPLANE_DEMO_X0,PCR
					LDD		#-40
					STD		AIRPLANE_DEMO_Y0,PCR
					LDD		#-900
					STD		AIRPLANE_DEMO_Z0,PCR

					LDA		#96
					STA		AIRPLANE_DEMO_H1,PCR
					CLR		AIRPLANE_DEMO_P1,PCR
					CLR		AIRPLANE_DEMO_B1,PCR

					LDD		#800
					STD		AIRPLANE_DEMO_X1,PCR
					LDD		#30
					STD		AIRPLANE_DEMO_Y1,PCR
					LDD		#-800
					STD		AIRPLANE_DEMO_Z1,PCR

					RTS


AIRPLANEDEMO_MOVE_MODE5_CALC
					LEAX	AIRPLANE_DEMO_X0,PCR
					LBSR	AIRPLANEDEMO_MOVE_FORWARD
					LEAX	AIRPLANE_DEMO_X1,PCR
					LBSR	AIRPLANEDEMO_MOVE_FORWARD

					LDA		AIRPLANE_DEMO_CTR,PCR
					CMPA	#10
					BLE		AIRPLANEDEMO_MOVE_MODE5_CALC_DONE
					CMPA	#20
					BLE		AIRPLANEDEMO_MOVE_MODE5_BANK_IN
					CMPA	#44
					BLE		AIRPLANEDEMO_MOVE_MODE5_TURN
					CMPA	#54
					BLE		AIRPLANEDEMO_MOVE_MODE5_ROLL_OUT

					CMPA	#64
					BGE		AIRPLANEDEMO_MOVE_MODE6_INIT
					BRA		AIRPLANEDEMO_MOVE_MODE5_CALC_DONE

AIRPLANEDEMO_MOVE_MODE5_BANK_IN
					LDA		AIRPLANE_DEMO_B0,PCR
					ADDA	#4
					STA		AIRPLANE_DEMO_B0,PCR
					LDA		AIRPLANE_DEMO_B1,PCR
					SUBA	#4
					STA		AIRPLANE_DEMO_B1,PCR
					BRA		AIRPLANEDEMO_MOVE_MODE5_CALC_DONE

AIRPLANEDEMO_MOVE_MODE5_TURN
					LDA		AIRPLANE_DEMO_H0,PCR
					ADDA	#8
					STA		AIRPLANE_DEMO_H0,PCR
					LDA		AIRPLANE_DEMO_H1,PCR
					SUBA	#8
					STA		AIRPLANE_DEMO_H1,PCR
					BRA		AIRPLANEDEMO_MOVE_MODE5_CALC_DONE

AIRPLANEDEMO_MOVE_MODE5_ROLL_OUT
					LDA		AIRPLANE_DEMO_B0,PCR
					SUBA	#4
					STA		AIRPLANE_DEMO_B0,PCR
					LDA		AIRPLANE_DEMO_B1,PCR
					ADDA	#4
					STA		AIRPLANE_DEMO_B1,PCR
					BRA		AIRPLANEDEMO_MOVE_MODE5_CALC_DONE

AIRPLANEDEMO_MOVE_MODE5_CALC_DONE
					RTS




AIRPLANEDEMO_MOVE_MODE6_INIT
					LDA		#6
					STA		AIRPLANE_DEMO_MODE,PCR
					CLR		AIRPLANE_DEMO_CTR,PCR

					LDA		#2
					STA		AIRPLANE_DEMO_NAIR,PCR

					LEAX	AIRPLANE_DATA_SMALL,PCR
					STX		AIRPLANE_DEMO_GEOMDATA,PCR

					LDX		#-800
					STX		AIRPLANE_DEMO_X0,PCR
					LDX		#-210
					STX		AIRPLANE_DEMO_Y0,PCR
					LDX		#-500
					STX		AIRPLANE_DEMO_Z0,PCR
					LDA		#-64
					STA		AIRPLANE_DEMO_H0,PCR
					CLR		AIRPLANE_DEMO_P0,PCR
					CLR		AIRPLANE_DEMO_B0,PCR

					LDX		#800
					STX		AIRPLANE_DEMO_X1,PCR
					LDX		#-10
					STX		AIRPLANE_DEMO_Y1,PCR
					LDX		#-620
					STX		AIRPLANE_DEMO_Z1,PCR
					LDA		#64
					STA		AIRPLANE_DEMO_H1,PCR
					CLR		AIRPLANE_DEMO_P1,PCR
					CLR		AIRPLANE_DEMO_B1,PCR

					RTS

AIRPLANEDEMO_MOVE_MODE6_CALC
					LEAX	AIRPLANE_DEMO_X0,PCR
					LBSR	AIRPLANEDEMO_MOVE_FORWARD
					LEAX	AIRPLANE_DEMO_X1,PCR
					LBSR	AIRPLANEDEMO_MOVE_FORWARD

					LDA		AIRPLANE_DEMO_CTR,PCR
					CMPA	#5
					BLE		AIRPLANEDEMO_MOVE_MODE6_CALC_DONE
					CMPA	#15
					BLE		AIRPLANEDEMO_MOVE_MODE6_ROLL_IN
					CMPA	#47
					BLE		AIRPLANEDEMO_MOVE_MODE6_TURN
					CMPA	#57
					BLE		AIRPLANEDEMO_MOVE_MODE6_ROLL_OUT
					CMPA	#89
					BLE		AIRPLANEDEMO_MOVE_MODE6_LOOP
					CMPA	#99
					BGE		AIRPLANEDEMO_MOVE_MODE7_INIT
					BRA		AIRPLANEDEMO_MOVE_MODE6_CALC_DONE

AIRPLANEDEMO_MOVE_MODE6_ROLL_IN
					LDA		AIRPLANE_DEMO_B0,PCR
					ADDA	#4
					STA		AIRPLANE_DEMO_B0,PCR
					LDA		AIRPLANE_DEMO_B1,PCR
					SUBA	#4
					STA		AIRPLANE_DEMO_B1,PCR
					BRA		AIRPLANEDEMO_MOVE_MODE6_CALC_DONE

AIRPLANEDEMO_MOVE_MODE6_TURN
					LDA		AIRPLANE_DEMO_H0,PCR
					ADDA	#8
					STA		AIRPLANE_DEMO_H0,PCR
					LDA		AIRPLANE_DEMO_H1,PCR
					SUBA	#8
					STA		AIRPLANE_DEMO_H1,PCR
					BRA		AIRPLANEDEMO_MOVE_MODE6_CALC_DONE

AIRPLANEDEMO_MOVE_MODE6_ROLL_OUT
					LDA		AIRPLANE_DEMO_B0,PCR
					SUBA	#4
					STA		AIRPLANE_DEMO_B0,PCR
					LDA		AIRPLANE_DEMO_B1,PCR
					ADDA	#4
					STA		AIRPLANE_DEMO_B1,PCR
					BRA		AIRPLANEDEMO_MOVE_MODE6_CALC_DONE

AIRPLANEDEMO_MOVE_MODE6_LOOP
					LDA		AIRPLANE_DEMO_P0,PCR
					ADDA	#8
					STA		AIRPLANE_DEMO_P0,PCR
					LDA		AIRPLANE_DEMO_P1,PCR
					ADDA	#8
					STA		AIRPLANE_DEMO_P1,PCR
					BRA		AIRPLANEDEMO_MOVE_MODE6_CALC_DONE

AIRPLANEDEMO_MOVE_MODE6_CALC_DONE
					RTS

AIRPLANEDEMO_MOVE_MODE7_INIT
					LDA		#7
					STA		AIRPLANE_DEMO_MODE,PCR
					CLR		AIRPLANE_DEMO_CTR,PCR
					RTS



AIRPLANEDEMO_MOVE_FORWARD
					LDA		7,X
					STA		CALC_FWD_VECTOR_P,PCR
					LDA		6,X
					STA		CALC_FWD_VECTOR_H,PCR
					LDA		8,X
					STA		CALC_FWD_VECTOR_B,PCR
					LBSR	CALC_FWD_VECTOR

					LDD		CALC_FWD_VECTOR_X,PCR
					ASRA
					RORB
					ASRA
					RORB
					ADDD	,X
					STD		,X

					LDD		CALC_FWD_VECTOR_Y,PCR
					ASRA
					RORB
					ASRA
					RORB
					ADDD	2,X
					STD		2,X

					LDD		CALC_FWD_VECTOR_Z,PCR
					ASRA
					RORB
					ASRA
					RORB
					ADDD	4,X
					STD		4,X
					RTS



AIRPLANE_DEMO_DRAW_GNDLATTICE
					LDX		#320
					STX		TO_SCREEN_PERS_CX,PCR
					LDX		#100
					STX		TO_SCREEN_PERS_CY,PCR
					LDA		#8
					STA		TO_SCREEN_PERS_XSHIFT,PCR
					LDA		#7
					STA		TO_SCREEN_PERS_YSHIFT,PCR


					LDX		#0
					STX		TO_SCREEN_WX0,PCR
					STX		TO_SCREEN_WY0
					LDX		#639
					STX		TO_SCREEN_WX1,PCR
					LDX		#199
					STX		TO_SCREEN_WY1,PCR

					LDX		#10
					STX		TO_SCREEN_NEARZ,PCR

					LDX		#COMMON_LINEBUFPTR
					STX		GNDLATTICE_LINEBUFPTR,PCR
					STX		LINEDDA_LINEBUF_PTR,PCR

					LDX		#0
					STX		LINEDDA_VRAMADDR,PCR

					LDA		#80
					STA		LINEDDA_BYTE_PER_LINE,PCR
					LBSR	LINEDDA_INIT_LINEBUF

					LDX		#0
					CLR		TRANS3D_OBJH,PCR
					CLR		TRANS3D_OBJP,PCR
					CLR		TRANS3D_OBJB,PCR
					STX		TRANS3D_OBJX,PCR
					STX		TRANS3D_OBJY,PCR
					STX		TRANS3D_OBJZ,PCR

					CLR		TRANS3D_VIEWH,PCR
					CLR		TRANS3D_VIEWP,PCR
					CLR		TRANS3D_VIEWB,PCR
					STX		TRANS3D_VIEWX,PCR
					STX		TRANS3D_VIEWZ,PCR

					LDX		#1000
					STX		TRANS3D_VIEWY,PCR

					LBSR	RENDER_GNDLATTICE

					LDU		GNDLATTICE_LINEBUFPTR,PCR
					STU		CALL_LINEDDA_SUBCPU_DATAADDR,PCR

					LBSR	CALL_CLS_AND_LINEDDA_SUBCPU

					RTS
