/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;

final class WeakKeyConcurrentHashMap<K, V> {
    private final ConcurrentHashMap<WeakKey<K>, V> hashmap = new ConcurrentHashMap();
    private final ReferenceQueue<K> lastQueue = new ReferenceQueue();

    public int size() {
        this.purgeStaleKeys();
        return this.hashmap.size();
    }

    public V get(K k) {
        Objects.requireNonNull(k, "key");
        this.purgeStaleKeys();
        WeakKey<K> weakKey = new WeakKey<K>(k, null);
        return this.hashmap.get(weakKey);
    }

    private boolean containsKey(K k) {
        Objects.requireNonNull(k, "key");
        WeakKey<K> weakKey = new WeakKey<K>(k, null);
        return this.hashmap.containsKey(weakKey);
    }

    public V put(K k, V v) {
        Objects.requireNonNull(k, "key");
        this.purgeStaleKeys();
        WeakKey<K> weakKey = new WeakKey<K>(k, this.lastQueue);
        return this.hashmap.put(weakKey, v);
    }

    public V remove(K k) {
        Objects.requireNonNull(k, "key");
        this.purgeStaleKeys();
        WeakKey<K> weakKey = new WeakKey<K>(k, null);
        return this.hashmap.remove(weakKey);
    }

    public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(function, "mappingFunction");
        this.purgeStaleKeys();
        WeakKey<K> weakKey2 = new WeakKey<K>(k, this.lastQueue);
        return (V)this.hashmap.computeIfAbsent(weakKey2, weakKey -> function.apply((Object)k));
    }

    public Stream<K> keysForValue(V v) {
        return this.hashmap.entrySet().stream().filter(entry -> entry.getValue() == v).map(entry -> ((WeakKey)entry.getKey()).get()).filter(object -> object != null);
    }

    public void purgeValue(V v) {
        this.purgeStaleKeys();
        Objects.requireNonNull(v, "value");
        this.hashmap.forEach((weakKey, object2) -> {
            if (v.equals(object2)) {
                this.hashmap.remove(weakKey, object2);
            }
        });
    }

    private void purgeStaleKeys() {
        Reference<K> reference;
        while ((reference = this.lastQueue.poll()) != null) {
            this.hashmap.remove(reference);
        }
    }

    static class WeakKey<K>
    extends WeakReference<K> {
        private final int hash;

        WeakKey(K k, ReferenceQueue<K> referenceQueue) {
            super(k, referenceQueue);
            this.hash = System.identityHashCode(k);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof WeakKey) {
                Object t = this.get();
                return t != null && t == ((WeakKey)object).get();
            }
            return false;
        }
    }
}

