/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import processing.core.PApplet;
import processing.sound.Engine;
import processing.sound.Noise;

public class BrownNoise
implements Noise {
    PApplet parent;
    private Engine m_engine;
    private int[] m_nodeId = new int[]{-1, -1};
    private float m_amp = 0.5f;
    private float m_add = 0.0f;
    private float m_pos = 0.0f;
    private int m_panBusId;

    public BrownNoise(PApplet pApplet) {
        this.parent = pApplet;
        this.parent.registerMethod("dispose", (Object)this);
        Engine.setPreferences(pApplet, 512, 44100);
        BrownNoise brownNoise = this;
        brownNoise.m_engine.start();
        BrownNoise brownNoise2 = this;
        this.m_panBusId = brownNoise2.m_engine.busConstructMono();
    }

    @Override
    public void play() {
        this.m_nodeId = Engine.brownNoisePlay(this.m_amp, this.m_add, this.m_pos, this.m_panBusId);
    }

    @Override
    public void play(float f, float f2, float f3) {
        this.m_amp = f;
        this.m_add = f2;
        this.m_pos = f3;
        this.play();
    }

    @Override
    public void play(float f, float f2) {
        this.m_amp = f;
        this.m_add = f2;
        this.play();
    }

    @Override
    public void play(float f) {
        this.m_amp = f;
        this.play();
    }

    private void set() {
        if (this.m_nodeId[0] != -1) {
            Engine.brownNoiseSet(this.m_amp, this.m_add, this.m_pos, this.m_nodeId);
        }
    }

    @Override
    public void set(float f, float f2, float f3) {
        this.m_amp = f;
        this.set();
    }

    @Override
    public void amp(float f) {
        this.m_amp = f;
        this.set();
    }

    @Override
    public void add(float f) {
        this.m_add = f;
        this.set();
    }

    @Override
    public void pan(float f) {
        this.m_pos = f;
        this.set();
    }

    @Override
    public void stop() {
        if (this.m_nodeId[0] != -1) {
            Engine.synthStop(this.m_nodeId);
            for (int i = 0; i < this.m_nodeId.length; ++i) {
                this.m_nodeId[i] = -1;
            }
        }
    }

    @Override
    public int[] returnId() {
        return this.m_nodeId;
    }

    @Override
    public void dispose() {
        Engine.synthStop(this.m_nodeId);
    }
}

