/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import processing.core.PApplet;
import processing.sound.Engine;
import processing.sound.SoundObject;

public class AudioIn
implements SoundObject {
    PApplet parent;
    private Engine m_engine;
    private int[] m_nodeId = new int[]{-1, -1};
    private float m_amp = 1.0f;
    private float m_add = 0.0f;
    private int m_in = 0;
    private float m_pos = 0.0f;

    public AudioIn(PApplet pApplet, int n) {
        this.parent = pApplet;
        this.parent.registerMethod("dispose", (Object)this);
        Engine.setPreferences(pApplet, 512, 44100);
        AudioIn audioIn = this;
        audioIn.m_engine.start();
        this.m_in = n;
    }

    public void start() {
        this.m_nodeId = Engine.audioInStart(this.m_amp, this.m_add, this.m_pos, this.m_in);
    }

    public void start(float f, float f2, float f3) {
        this.m_amp = f;
        this.m_add = f2;
        this.m_pos = f3;
        this.start();
    }

    public void start(float f, float f2) {
        this.m_amp = f;
        this.m_add = f2;
        this.start();
    }

    public void start(float f) {
        this.m_amp = f;
        this.start();
    }

    public void play() {
        if (this.m_nodeId[1] < 0) {
            this.start();
        }
        Engine.audioInPlay(this.m_nodeId[1]);
    }

    private void set() {
        if (this.m_nodeId[0] != -1) {
            Engine.audioInSet(this.m_amp, this.m_add, this.m_pos, this.m_nodeId);
        }
    }

    public void set(float f, float f2, float f3) {
        this.m_amp = f;
        this.m_add = f2;
        this.m_pos = f3;
        this.set();
    }

    public void amp(float f) {
        this.m_amp = f;
        this.set();
    }

    public void add(float f) {
        this.m_add = f;
        this.set();
    }

    public void pan(float f) {
        this.m_pos = f;
        this.set();
    }

    public void stop() {
        if (this.m_nodeId[0] != -1) {
            Engine.synthStop(this.m_nodeId);
            for (int i = 0; i < this.m_nodeId.length; ++i) {
                this.m_nodeId[i] = -1;
            }
        }
    }

    @Override
    public int[] returnId() {
        return this.m_nodeId;
    }

    public void dispose() {
        Engine.synthStop(this.m_nodeId);
    }
}

