#ifndef LOADER_H_
#define LOADER_H_

#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <GL/glew.h>
#include "math_3d.h"

struct ModelAsset
{
	GLuint shaderProgram;
	GLuint texture;

    GLuint vbo;
    GLuint vao;
    GLenum drawType;
    GLint drawStart;
    GLint drawCount;
};

struct ModelInstance {
    struct ModelAsset* asset;
    mat4_t transform;
};

ModelAsset CreateModelAsset(
	GLuint _shaderProgram,
	GLuint _texture, 
	GLuint _vbo, 
	GLuint _vao, 
	GLenum _drawType, 
	GLint _drawStart, 
	GLint _drawCount
	);

void LoadSomeData();
GLuint NewShader(GLenum shaderType, std::string filePath);
GLuint NewProgram(GLuint *shaders, int numberOfShaders);
GLuint LoadTexture(const char *filePath);
void LoadTestTriangle();
void LoadTestRectangle();
void LoadCube();

#endif