#include "draw.h"
#include "imgui_impl_sdl_gl3.h"
#include "math_3d.h"

void Draw()
{

    glEnable(GL_DEPTH_TEST);
    glDepthFunc(GL_LESS);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	glViewport(0, 0, (int)ImGui::GetIO().DisplaySize.x, (int)ImGui::GetIO().DisplaySize.y);

    //glClearColor(0.0f, 0.0f, 0.05f, 1.0f);
    if (demoTimer < 5500)
    {
    	glClearColor(1.0f, 1.0f, 1.05f, 1.0f);
    }
    else if ( demoTimer < 38000)
    {
    	glClearColor(0.0f, 0.0f, 0.05f, 1.0f);
    }
    else
    {
    	glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
    }
    
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);



    if (demoTimer > 9900)
    {

    	GLuint currentShader = NULL;
    	GLuint currentTexture = NULL;

    	CameraMatrix(&camera);

        for (int i = 0; i < NUMBER_OF_CUBES; i++)
        {
            DrawModelInstance(boxInstances[i], currentShader, currentTexture, 0.0f);
        }
    }
    if (demoPhase == 1)
    {
	    glBindVertexArray(rectVAO);
	    glUseProgram(rectProgram);
	    float tempValue = (float)demoTimer;
	    glUniform1f(timeLoc, tempValue);
	    glUniform1f(seaAlphaLoc, seaAlpha);
	    glDrawArrays(GL_TRIANGLE_STRIP, 0, 6);
	    glBindVertexArray(0);
	    glUseProgram(0);
    }
    if (demoPhase == 2)
    {
	    glBindVertexArray(rectVAO);
	    glUseProgram(voroProgram);
	    float tempValue = (float)demoTimer;
	    glUniform1f(voroTimeLoc, tempValue);
	    //glUniform1f(seaAlphaLoc, seaAlpha);
	    glDrawArrays(GL_TRIANGLE_STRIP, 0, 6);
	    glBindVertexArray(0);
	    glUseProgram(0);
    }
    ImGui::Render();
    SDL_GL_SwapWindow(window);
}

void DrawModelInstance(ModelInstance modelInstance, GLuint currentShader, GLuint currentTexture, GLfloat degreesRotated)
{
    struct ModelAsset modelAsset;
    modelAsset = *modelInstance.asset;

    if (modelAsset.shaderProgram != currentShader)
    {
       glUseProgram(modelAsset.shaderProgram);
    }

    GLint cameraUniform = glGetUniformLocation(modelAsset.shaderProgram, "camera");
    mat4_t cameraMatrix = camera.cameraMatrix;
    glUniformMatrix4fv(cameraUniform, 1, GL_FALSE, (const GLfloat*)&cameraMatrix);

    GLint modelUniform = glGetUniformLocation(modelAsset.shaderProgram, "model");
    mat4_t rotationMatrix = m4_rotation_y(degreesRotated);
    mat4_t modelMatrix = m4_mul(  modelInstance.transform, rotationMatrix);

    //mat4_t modelMatrix = m4_rotation_y(gDegreesRotated);
    glUniformMatrix4fv(modelUniform, 1, GL_FALSE, (const GLfloat*)&modelMatrix);
    //glUniformMatrix4fv(modelUniform, 1, GL_FALSE, &modelInstance.transform);

    GLint lightPositionUniform = glGetUniformLocation(modelAsset.shaderProgram, "light.position");
    GLint lightIntensitiesUniform = glGetUniformLocation(modelAsset.shaderProgram, "light.intensities");

    // invert light coordinates (why?)
    glUniform3f(lightPositionUniform, -gLight.position.x, -gLight.position.y, -gLight.position.z);
    //glUniform3fv(lightPositionUniform, 1, (GLfloat *)&gLight.position);

    glUniform3f(lightIntensitiesUniform, gLight.intensities.x, gLight.intensities.y, gLight.intensities.z);

    if (modelAsset.texture != currentTexture)
    {
        // bind the texture and set the "tex" uniform in the fragment shader
        glActiveTexture(GL_TEXTURE0);
        glBindTexture(GL_TEXTURE_2D, modelAsset.texture);
        //glBindTexture(GL_TEXTURE_2D, crateTexture);
        //set to 0 because the texture is bound to GL_TEXTURE0 // hÄH?
        glUniform1f("tex", 0);
    }

    // bind the VAO (the cube)
    glBindVertexArray(modelAsset.vao);
    
    // draw the VAO
    glDrawArrays(modelAsset.drawType, modelAsset.drawStart, modelAsset.drawCount);
    
    // unbind the VAO
    glBindVertexArray(0);

    // unbind texture
    //glBindTexture(GL_TEXTURE_2D, 0);

    // unbind the program
    glUseProgram(0);
}