/*
#version 330

//uniform mat4 projection;
uniform mat4 camera;
uniform mat4 model;

in vec3 vert;
in vec2 vertTexCoord;
in vec3 vertNormal;

out vec3 fragVert;
out vec2 fragTexCoord;
out vec3 fragNormal;

void main() {
    // Pass the tex coord straight through to the fragment shader
    fragTexCoord = vertTexCoord;
    fragNormal = vertNormal;
    fragVert = vert;

	// Apply all matrix transformations to vert
    //gl_Position = projection * camera * model * vec4(vert, 1);
    gl_Position = camera * model * vec4(vert, 1);
    // does not alter the verticies at all
    //gl_Position = vec4(vert, 1);
}
*/


#version 330
in vec4 in_position;
in vec2 vertexCoord;
out vec2 fragCoord;
void main() {
gl_Position = in_position;
fragCoord = vertexCoord;
}
