//#ifdef GL_ES
//precision mediump float;
//#endif
#version 330
out vec4 fragColor;
precision mediump float;
uniform float time;
uniform vec2 resolution;

#define TAU 6.283185307179586

#define nsin(x) ((sin(x) + 1.0) / 2.0)

vec3 rgb2hsv(vec3 c)
{
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

vec3 hsv2rgb(vec3 c) {
	vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
	vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
	return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

vec2 rotate(in vec2 point, in float rads) {
	float cs = cos(rads);
	float sn = sin(rads);
	return point * mat2(cs, -sn, sn, cs);
}

void main( void ) {
	vec2 uv = ((gl_FragCoord.xy / resolution.xy ) * 2.0) - 1.0;
	uv.x *= resolution.x/resolution.y;
	vec2 rotuv = rotate(abs(uv), time);
	float theta     = atan(abs(rotuv.y)/abs(rotuv.x));
	float r = length(rotuv);

	float p = pow(r / 2.0, nsin(r * 32.0));

	//float sat = 0.5 + (dot(rotuv, uv)/2.0);
	float sat = nsin(p * TAU );
	float hue = theta * floor(sat * 4.0);
	vec3 color = hsv2rgb(vec3(hue, sat, hue));
	
	fragColor = vec4(color, 1.0);

}