pico-8 cartridge // http://www.pico-8.com
version 8
__lua__
-- memory eliminator
-- elder scrolls (vanhus skrollaa)

tick = 0
stars = {}

function _init()
	-- initialize star table
	for i=0,100 do
		add(stars, {rnd(8)-4, rnd(8)-4, rnd(10)})
	end
	music()
end

function _update()
	tick += 1
end

function _draw()
	cls()
	local fade_length = 32
	if tick < 250 then
		-- draw startup sauna
		if tick < fade_length then
			fade_from_black(tick/2)
		elseif tick > (250-fade_length) then
			fade_to_black((tick-(250-fade_length)))
		end
		palt(0, false)
		map()
		-- draw marching sprites
		palt(0, true)
		local man_sprite=115
		if flr(tick/10)%2==0 then
			man_sprite=116
		end
		for i=0,6 do
			spr(man_sprite, 140+i*10-tick/3, 116)
		end
	else
		-- fade in to scroller scene
		if tick < 250 + fade_length then
			fade_from_black((tick - 250)/2)
		end
		-- draw 3d starfield
		palt(0, true)
		camera()
		for i=1,#stars do
			local new_coord = stars[i][3] - 0.1
			if new_coord < 1.0 then
				new_coord = 10
			end
			stars[i][3] = new_coord
			local screen_x = flr(stars[i][1]/new_coord * 128 + 64)
			local screen_y = flr(stars[i][2]/new_coord * 128 + 64)
			if new_coord < 5 then
				spr(114, screen_x, screen_y)
			else
				spr(113, screen_x, screen_y)
			end
		end
		local logo_origin_x = 0
		local logo_origin_y = 30
		for i=0,15 do
			camera(0, flr(sin(i/15+tick/30)*5))
			map(16+i, 0, logo_origin_x+i*8, logo_origin_y, 1, 4)
		end
		camera()
		rectfill(0, 95, 128, 110, 1)
		-- draw text scroller
		cursor(350 - tick, 100)
		color(7)
		print("hello, people of graffathon 2017! this old school scroller is brought to you by the one-man demogroup memory eliminator.             bunch of greetings to sooda, shaiggon, gluster, prismbeings, peisik and all the rest...           (including your mom)")
	end
	if tick > 1450 then
		fade_to_black((tick-1450)/2)
	end
	if tick > (1450+32+8) then
		stop()
	end
	-- uncomment call below
	-- to show frame counter
	--show_frame_counter()
end

function show_frame_counter()
	color(1)
	cursor(2, 120)
	print(tick)
end

fadetable_black={
	{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	{1,1,1,1,1,1,1,0,0,0,0,0,0,0,0},
	{2,2,2,2,2,2,1,1,1,0,0,0,0,0,0},
	{3,3,3,3,3,3,1,1,1,0,0,0,0,0,0},
	{4,4,4,2,2,2,2,2,1,1,0,0,0,0,0},
	{5,5,5,5,5,1,1,1,1,1,0,0,0,0,0},
	{6,6,13,13,13,13,5,5,5,5,1,1,1,0,0},
	{7,6,6,6,6,13,13,13,5,5,5,1,1,0,0},
	{8,8,8,8,2,2,2,2,2,2,0,0,0,0,0},
	{9,9,9,4,4,4,4,4,4,5,5,0,0,0,0},
	{10,10,9,9,9,4,4,4,5,5,5,5,0,0,0},
	{11,11,11,3,3,3,3,3,3,3,0,0,0,0,0},
	{12,12,12,12,12,3,3,1,1,1,1,1,1,0,0},
	{13,13,13,5,5,5,5,1,1,1,1,1,0,0,0},
	{14,14,14,13,4,4,2,2,2,2,2,1,1,0,0},
	{15,15,6,13,13,13,5,5,5,5,5,1,1,0,0}
}

function fade_to_black(i)
	for c=0,15 do
		if flr(i+1) >= 16 then
			pal(c, 0)
		else
			pal(c,fadetable_black[c+1][flr(i+1)])
		end
	end
end

function fade_from_black(i)
	for c=0,15 do
		if flr(i+1) >= 16 then
			pal(c, c)
		else
			pal(c, fadetable_black[c+1][flr(15-i+1)])
		end
	end
end
__gfx__
0000000000000000aa00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000009aaaa0000000000000000000000000000000000000000000000000000000000000000000009000000000000000000000000000000000000000
0000000000009aaaaaaa00000000000000000000000000000000000000000000000000000000000000000009a900000000000000000000000000000000000000
000000000009aaaaaaaaa0000000000000000000000000000000000aa000000000aa000000000000000000099aa0000000000000000000000000000000000000
00000000009aa99999aaa000000000000000000000000000000000aaaa0000000aaaa000000000000000000999aa000000000000000000000000000000000000
000000000999999999999000000000000000000000000000000009a99aa000009aaaaa0000000000a000000099aa000000000000000000000000000000000000
000000000999999999999000000000000000000000000000000099999aaa0009999aaaa000000009aa000000999a000000000000000000000000000000000000
0000000099999990000900000000000000000000000000000000999999aa000999999aa0000000099aa00000999a000000000000000000000000000000000000
000000009999990000000000000000000000000000000000000999999990009999999aa00000000999a00000999a000000000000000000000000000000000000
0000000999999000000000000000000000000000000000000009999900900099999999a00000000999a00000999a000000000000000000000000000000000000
0000009999990000000000000000000000000000000000000009999000000099990999900000000099a00000999a000000000000000000000000000000000000
000000999999000000000000000009aaa000aaaaa000000000aa999aaa00009990009990000000009990aa0099aa000000000000000000000000000000000000
000000999999000000000000000009aaaa0aaaaaaa0000000aa99999aaa00999900000900000000099999aa099aa000000000000000000000000000000000000
00000049999900000000000000000099999a99999a000000999999a4499099999aa000000000aaa9999999a099aa000000000000000000000000000000000000
0000004999a0000000000000000000999999999090000000994499a0090949999aaa000000009999999499009999000000000000000009a0000aa00000000000
0000004999a000000000aaaaaa0000999999990000000000944449a000004449999aa0000000999499a0000099900a0000000000000009a000aaaa0000000000
0000004999a00000000aaaaaaaa00099999990000000aaa0900049a0000000994449a0000000094449a000009990aaa000000009000009aa09aa9aa000000000
0000004499a00000009aaaaaaaaa0004999990000aaaaa00000099a000000099000900009aa0000049a000009999aaaa0000009aa000099a99999aa000000000
0000004499a00000099aaaaaa9aa900499999000a9994a90000099aa000000990000000999a0000049aa0000999999aaa0000999aa000999944044a000000000
0000004499aa000004499999999aa90499990009999004aa0000999a0000099900000099999a000049aa00009999999aa00099949a000999900004a000000000
0000004499aa0000044444444999900499990009990004aa000099990000049900000999009aa00099aa00009999099aa00099904a000999900004a000000000
00000044999a00000044400049999004499900099000049aa00049990000449990000990000aa000999a000099990099a00099004aa009999000049a00000000
00000004499aa000000000099999000049999009a000099aa000499900004499900009900009a000999a000099990099a000990009a009999000049a00000000
000000004499a000000099999999000049999009aa0099999000449900004499000099000009a900499a000049990099a009490009a004999000049a00000000
0000000004499a000099999999900000449900009aa9900900000499000044490000990000999900049a000044990099a000499009a004999000049a00000000
0000000000449999999999999900000004400000444900000000044400000440000099a09a99990000900000449900099000449099a004999000049a00000000
0000000000044999999999999000000000000000044000000000004000000000000009aaa9909900000000000499000990000449999004499000049900000000
00000000000049999999999900000000000000000000000000000000000000000000099999000000000000000444000900000049990000449000099000000000
00000000000004444499999000000000000000000000000000000000000000000000004440000000000000000040000000000004900000044000090000000000
00000000000000000449000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
cccccccccccccccccccccccc3b3b333b666666666666666600000000008888800008880008000008080000080888888808888880088888800000000000000000
ccccccccccccccc7777ccccc33333b33666666664444464400000000080000080080008008000008088000080000800008000008080000080000000000000000
cccccccccccccc777777cccc33b3333b666666664444464400000000080000000800000808000008080800080000800008000008080000080000000000000000
ccccccccccccc6777777cccc33333333666666664444464400000000008888800888888808000008080080080000800008888880088888800000000000000000
ccccccccccccc76777777ccc3b33b333666666666666666600000000000000080800000808000008080008080000800008000080080000000000000000000000
cccccccccc7676777777777c3333333b666666664464444400000000080000080800000808000008080000880000800008000008080000000000000000000000
ccccccccc76767677777777733b33b33666666664464444400000000008888800800000800888880080000080000800008000008080000000000000000000000
cccccccc767676777777777733333333666666664464444400000000000000000000000000000000000000000000000000000000000000000000000000000000
7777777777777777cccccccc77777777777777777600000000000067777777770000000000000000000000000000000000000000000000000000000000000000
77777777777777777cccc77776666666666666677600000000000067666666660000000000000000000000000000000000000000000000000000000000000000
77777777cccccccc77cc677776000000000000677600000000000067000000000000000000000000000000000000000000000000000000000000000000000000
77777777cccccccc7776767776000000000000677600000000000067000000000000000000000000000000000000000000000000000000000000000000000000
77777777cccccccc7767676776000000000000677600000000000067000000000000000000000000000000000000000000000000000000000000000000000000
77777777cccccccc7776767776000000000000677600000000000067000000000000000000000000000000000000000000000000000000000000000000000000
77777777cccccccc7777777776000000000000677600000000000067000000000000000000000000000000000000000000000000000000000000000000000000
77777777cccccccc7777777776000000000000677600000000000067000000000000000000000000000000000000000000000000000000000000000000000000
65656565765555555555555577777777777777777655555555555567777777775555556700000000000000000000000000000000000000000000000000000000
56565656765555555555555576666666666666667655555555555567666666675555556700000000000000000000000000000000000000000000000000000000
65656565765555555555555576555555555555557655555555555567555555675555556700000000000000000000000000000000000000000000000000000000
66566656765555555555555576555555555555557655555555555567555555675555556700000000000000000000000000000000000000000000000000000000
66666666765555555555555576555555555555557655555555555567555555675555556700000000000000000000000000000000000000000000000000000000
66666666765555555555555576555555555555557655555555555567555555675555556700000000000000000000000000000000000000000000000000000000
66666666766666666666666676555555555555557655555555555567555555676666666700000000000000000000000000000000000000000000000000000000
66666666777777777777777776555555555555557655555555555567555555677777777700000000000000000000000000000000000000000000000000000000
99999999000000000000000000000000000000003b3b33353b3b3336000000000000000000000000000000000000000000000000000000000000000000000000
999999990000000000000000004444000044440033333b3633333b36000000000000000000000000000000000000000000000000000000000000000000000000
454446440000000000000000001f1f00001f1f0033b3336533b33366000000000000000000000000000000000000000000000000000000000000000000000000
44444654000700000007700000ffff0000ffff003333336633333336000000000000000000000000000000000000000000000000000000000000000000000000
66666666000000000007700000dddd0000dddd003b33b3663b33b336000000000000000000000000000000000000000000000000000000000000000000000000
44644444000000000000000000dddd0000dddd003363666633333366000000000000000000000000000000000000000000000000000000000000000000000000
54644454000000000000000000100150000101003666666633b33b66000000000000000000000000000000000000000000000000000000000000000000000000
44654444000000000000000005500050005555003666666633333336000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__label__
cccccccccccccccc77777777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccccccccccccccc777777777777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc7777cccccccccccc7
cccccccccccccc77777777777777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc777777cccccccccc77
ccccccccccccc677777777777777ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc6777777ccccccccc677
ccccccccccccc7677777777777777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc76777777cccccccc767
cccccccccc767677777777777777777ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc7676777777777ccc767677
ccccccccc76767677777777777777777ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc767676777777777c7676767
cccccccc767676777777777777777777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc767676777777777776767677
cccccccc77777777777777777777777777777777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc777777777777777777777777
ccccccc777777777777777777777777777777777777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc7777777777777777777777777
cccccc77777777777777777777777777777777777777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccc77777777777777777777777777
ccccc677777777777777777777777777777777777777ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc677777777777777777777777777
ccccc7677777777777777777777777777777777777777cccccccccccccccccccccccccccccccccccccccccccccccccccccccc767777777777777777777777777
cc767677777777777777777777777777777777777777777ccccccccccccccccccccccccccccccccccccccccccccccccccc767677777777777777777777777777
c76767677777777777777777777777777777777777777777ccccccccccccccccccccccccccccccccccccccccccccccccc7676767777777777777777777777777
767676777777777777777777777777777777777777777777cccccccccccccccccccccccccccccccccccccccccccccccc76767677777777777777777777777777
777777777777777777777777777777777777777777777777cccccccccccccccccccccccccccccccccccccccccccccccc77777777777777777777777777777777
777777777777777777777777777777777777777777777777ccccccccccccccccccccccccccccccccccccccccccccccc777777777777777777777777777777777
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc7777777777777777777777777777777777
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc67777777777777777777777777777777777
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc76777777777777777777777777777777777
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc76767777777777777777777777777777777777
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc767676777777777777777777777777777777777
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc7676767777777777777777777777777777777777
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc7777777777777777777777777777777777777777
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc7777777777777777777777777777777777777777
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999
99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999
45444644454446444544464445444644454446444544464445444644454446444544464445444644454446444544464445444644454446444544464445444644
44444654444446544444465444444654444446544444465444444654444446544444465444444654444446544444465444444654444446544444465444444654
66666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666
44644444446444444464444444644444446444444464444444644444446444444464444444644444446444444464444444644444446444444464444444644444
54644454546444545464445454644454546444545464445454644454546444545464445454644454546444545464445454644454546444545464445454644454
44654444446544444465444444654444446544444465444444654444446544444465444444654444446544444465444444654444446544444465444444654444
66666666666666666666666600000000000000000000000000000000000000000000000000000000000000000000000000000000666666666666666666666666
44444644444446444444464400000000000000000000000000000000000000000000000000000000000000000000000000000000444446444444464444444644
44444644444446444444464400000000000000000000000000000000000000000000000000000000000000000000000000000000444446444444464444444644
44444644444446444444464400000000000000000000000000000000000000000000000000000000000000000000000000000000444446444444464444444644
66666666666666666666666600000000000000000000000000000000000000000000000000000000000000000000000000000000666666666666666666666666
44644444446444444464444400000000000000000000000000000000000000000000000000000000000000000000000000000000446444444464444444644444
44644444446444444464444400000000000000000000000000000000000000000000000000000000000000000000000000000000446444444464444444644444
44644444446444444464444400000000000000000000000000000000000000000000000000000000000000000000000000000000446444444464444444644444
66666666666666666666666600000000008888800888888800088800088888800888888808000008088888800000000000000000666666666666666666666666
44444644444446444444464400000000080000080000800000800080080000080000800008000008080000080000000000000000444446444444464444444644
44444644444446444444464400000000080000000000800008000008080000080000800008000008080000080000000000000000444446444444464444444644
44444644444446444444464400000000008888800000800008888888088888800000800008000008088888800000000000000000444446444444464444444644
66666666666666666666666600000000000000080000800008000008080000800000800008000008080000000000000000000000666666666666666666666666
44644444446444444464444400000000080000080000800008000008080000080000800008000008080000000000000000000000446444444464444444644444
44644444446444444464444400000000008888800000800008000008080000080000800000888880080000000000000000000000446444444464444444644444
44644444446444444464444400000000000000000000000000000000000000000000000000000000000000000000000000000000446444444464444444644444
66666666666666666666666600000000000000000000000000000000000000000000000000000000000000000000000000000000666666666666666666666666
44444644444446444444464400000000000000000000000000000000000000000000000000000000000000000000000000000000444446444444464444444644
44444644444446444444464400000000000000000000000000000000000000000000000000000000000000000000000000000000444446444444464444444644
44444644444446444444464400000000000000000000000000000000000000000000000000000000000000000000000000000000444446444444464444444644
66666666666666666666666600000000000000000000000000000000000000000000000000000000000000000000000000000000666666666666666666666666
44644444446444444464444400000000000000000000000000000000000000000000000000000000000000000000000000000000446444444464444444644444
44644444446444444464444400000000000000000000000000000000000000000000000000000000000000000000000000000000446444444464444444644444
44644444446444444464444400000000000000000000000000000000000000000000000000000000000000000000000000000000446444444464444444644444
66666666666666666666666600000000000000000000000000888880000888000800000808000008000888000000000000000000666666666666666666666666
44444644444446444444464400000000000000000000000008000008008000800800000808800008008000800000000000000000444446444444464444444644
44444644444446444444464400000000000000000000000008000000080000080800000808080008080000080000000000000000444446444444464444444644
44444644444446444444464400000000000000000000000000888880088888880800000808008008088888880000000000000000444446444444464444444644
66666666666666666666666600000000000000000000000000000008080000080800000808000808080000080000000000000000666666666666666666666666
44644444446444444464444400000000000000000000000008000008080000080800000808000088080000080000000000000000446444444464444444644444
44644444446444444464444400000000000000000000000000888880080000080088888008000008080000080000000000000000446444444464444444644444
44644444446444444464444400000000000000000000000000000000000000000000000000000000000000000000000000000000446444444464444444644444
66666666666666666666666600000000000000000000000000000000000000000000000000000000000000000000000000000000666666666666666666666666
44444644444446444444464400000000000000000000000000000000000000000000000000000000000000000000000000000000444446444444464444444644
44444644444446444444464400000000000000000000000000000000000000000000000000000000000000000000000000000000444446444444464444444644
44444644444446444444464400000000000000000000000000000000000000000000000000000000000000000000000000000000444446444444464444444644
66666666666666666666666600000000000000000000000000000000000000000000000000000000000000000000000000000000666666666666666666666666
44644444446444444464444400000000000000000000000000000000000000000000000000000000000000000000000000000000446444444464444444644444
44644444446444444464444400000000000000000000000000000000000000000000000000000000000000000000000000000000446444444464444444644444
44644444446444444464444400000000000000000000000000000000000000000000000000000000000000000000000000000000446444444464444444644444
66666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666
44444644444446444444464444444644444446444444464444444644444446444444464444444644444446444444464444444644444446444444464444444644
44444644444446444444464444444644444446444444464444444644444446444444464444444644444446444444464444444644444446444444464444444644
44444644444446444444464444444644444446444444464444444644444446444444464444444644444446444444464444444644444446444444464444444644
66666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666
44644444446444444464444444644444446444444464444444644444446444444464444444644444446444444464444444644444446444444464444444644444
44644444446444444464444444644444446444444464444444644444446444444464444444644444446444444464444444644444446444444464444444644444
44644444446444444464444444644444446444444464444444644444446444444464444444644444446444444464444444644444446444444464444444644444
66666666666666666666666666666666666666666666666666666666777777777777777777777777666666666666666666666666666666666666666666666666
44444644444446444444464444444644444446444444464444444644766666666666666666666667444446444444464444444644444446444444464444444644
44444644444446444444464444444644444446444444464444444644760000000000000000000067444446444444464444444644444446444444464444444644
44444644444446444444464444444644444446444444464444444644760000000000000000000067444446444444464444444644444446444444464444444644
66666666666666666666666666666666666666666666666666666666760000000000000000000067666666666666666666666666666666666666666666666666
44644444446444444464444444644444446444444464444444644444760000000000000000000067446444444464444444644444446444444464444444644444
44644444446444444464444444644444446444444464444444644444760000000000000000000067446444444464444444644444446444444464444444644444
44644444446444444464444444644444446444444464444444644444760000000000000000000067446444444464444444644444446444444464444444644444
66666666666666666666666666666666666666666666666666666666760000000000000000000067666666666666666677777777777777777777777777777777
44444644444446444444464444444644444446444444464444444644760000000000000000000067444446444444464476666666666666666666666766666666
44444644444446444444464444444644444446444444464444444644760000000000000000000067444446444444464476555555555555555555556755555555
44444644444446444444464444444644444446444444464444444644760000000000000000000067444446444444464476555555555555555555556755555555
66666666666666666666666666666666666666666666666666666666760000000000000000000067666666666666666676555555555555555555556755555555
44644444446444444464444444644444446444444464444444644444760000000000000000000067446444444464444476555555555555555555556755555555
44644444446444444464444444644444446444444464444444644444760000000000000000000067446444444464444476555555555555555555556755555555
44644444446444444464444444644444446444444464444444644444760000000000000000000067446444444464444476555555555555555555556755555555
66666666666666666666666666666666666666666666666666666666760000000000000000000067666666666666666676555555555555555555556755555555
44444644444446444444464444444644444446444444464444444644760000000000000000000067444446444444464476555555555555555555556755555555
44444644444446444444464444444644444446444444464444444644760000000000000000000067444446444444464476555555555555555555556755555555
44444644444446444444464444444644444446444444464444444644760000000000000000000067444446444444464476555555555555555555556755555555
66666666666666666666666666666666666666666666666666666666760000000000000000000067666666666666666676555555555555555555556755555555
44644444446444444464444444644444446444444464444444644444760000000000000000000067446444444464444476555555555555555555556755555555
44644444446444444464444444644444446444444464444444644444760000000000000000000067446444444464444476666666666666666666666766666666
44644444446444444464444444644444446444444464444444644444760000000000000000000067446444444464444477777777777777777777777777777777
3b3b333b3b3b333b3b3b333565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565
33333b3333333b3333333b3656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656
33b3333b33b3333b33b3336565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565656565
33333333333333333333336666566656665666566656665666566656665666566656665666566656665666566656665666566656665666566656665666566656
3b33b3333b33b3333b33b36666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666
3333333b3333333b3363666666666666666666666666666666666666666666666666666666666666666666664444666666444466666644446666664444666666
33b33b3333b33b333666666666666666666666666666666666666666666666666666666666666666666666661f1f6666661f1f6666661f1f6666661f1f666666
3333333333333333366666666666666666666666666666666666666666666666666666666666666666666666ffff666666ffff666666ffff666666ffff666666
3b3b333b3b3b3336666666666666666666666666666666666666666666666666666666666666666666666666dddd666666dddd666666dddd666666dddd666666
33333b3333333b36666666666666666666666666666666666666666666666666666666666666666666666666dddd666666dddd666666dddd666666dddd666666
33b3333b33b333666666666666666666666666666666666666666666666666666666666666666666666666666161666666616166666661616666666161666666
33333333333333366666666666666666666666666666666666666666666666666666666666666666666666665555666666555566666655556666665555666666
3b33b3333b33b3366666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666
3333333b333333666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666
33b33b3333b33b666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666
33333333333333366666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666

__gff__
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__map__
40415042404040404040404040414241000102030405060708090a0b0c000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
41505050504240404040404041505050101112131415161718191a1b1c1d1e1f000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
51515151515140404040404150505050202122232425262728292a2b2c2d2e2f000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
40404040404040404040405151515151303132333435363738393a3b3c3d3e3f000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
7070707070707070707070707070707000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
454545464646464646464646464545450000000000003f000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
45454546474b484c4b494d464645454500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
4545454646464646464646464645454500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
4545454646464748494a48464645454500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
4545454646464646464646464645454500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
4545454545454545454545454545454500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
4545454545454553575445454545454500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
4545454545454555465645456364676400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
4545454545454555465645456162686200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
4343756060606060606060606060606000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
4376444444444444444444444444444400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__sfx__
010e00000005330615306153061524665306153061530615000533061530615306152466530615306153061500053306153061530615246653061530615306150005330615306153061524665306153061530615
010e000004075040250b0750b02506075060250c0750c025040750402510075100250207502025000750002504075040250c0750c0250b0750b02507075070250b0750b02502075020250c0750c0250b0750b025
010e00000005330605306053060500053306053060530605000533060530605306050005330605306053060500053306053060530605246653060530605306050005330605306053060524665306053060530605
010e0000287752b405287352b4002f775284052f735284002d7752a4052d735000002f775000002f735284053477500000347350000032775000003273500000307752840530735000002f775000002f73500000
010e00001c375000001f3750000023375213750000000000233750000023305233452330500000233250000028375283052837526375263050000028375000000000000000000002d375000002b3752d3752d305
010e00001c375000001f37500000233752137500000000002337500000233052334523305000002332500000213752337526375263052837524000283051f3052b375283752b375283751c3051c3051c3051c305
010e00001c3361f33623336283362832528305283252830523336263362a3362d3362d325283052d3251c3052133624336283362b3362b325000002b325000001f33623336263362a3362a325000002a32500000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__music__
00 02414344
00 00014344
00 00010344
00 00010344
00 00010443
00 00010544
00 00010406
00 00010506
00 00010406
00 00010506
00 40014306
00 40014306
00 40414306
00 40424546
00 41424546
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344

