package com.github.bjakke;

import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.opengl.PShader;

public class Shader {
	private final PShader shader;
	private final PApplet applet;
	private final PGraphics pg;
	private Moonlander ml;
	
	public Shader(PApplet p, PGraphics pg, String fragFilePath, Moonlander ml) {
		this.applet = p;
		this.shader = applet.loadShader(fragFilePath);
		this.pg = pg;
		this.ml = ml;
	}
	
	//call this only from the Processing draw() method
	//pg the grapchis to draw on
	public void draw(float timeSeconds){
		shader.set("u_time_s", timeSeconds);
		shader.set("u_resolution", (float)pg.width, (float)pg.height);
		
		//active scene
		float scene = ml("scene");
		shader.set("u_scene", scene);
		
		float posX = ml("camPosX");
		float posY = ml("camPosY");
		float posZ = ml("camPosZ");
		
		float lookX = ml("camLookX");
		float lookY = ml("camLookY");
		float lookZ = ml("camLookZ");
		
		float camUpX = ml("camUpX"); //1
		float camUpY = ml("camUpY"); //0
		float camUpZ = ml("camUpZ"); //0
		
		shader.set("u_camPos", posX, posY, posZ);
		shader.set("u_camLook", lookX, lookY, lookZ);
		shader.set("u_camUp", camUpX, camUpY, camUpZ);
		
		
		//house scene part
		float houseHight = ml("hHight");
		shader.set("u_houseHight", houseHight);
		
		//sphere rising part
		float sphereHeight = ml("sHeight");
		shader.set("u_sphereHight", sphereHeight);
		
		//draw quad, rest handled in shader
		pg.shader(shader);
		pg.rect(0, 0, pg.width, pg.height);
	}
	
	private float ml(String trackName){
		return (float) ml.getValue(trackName);
	}
	
	private int mli(String trackName){
		return ml.getIntValue(trackName);
	}
}
