/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.analysis;

import ddf.minim.Minim;
import ddf.minim.analysis.WindowFunction;

public class GaussWindow
extends WindowFunction {
    double alpha;

    public GaussWindow(double alpha) {
        if (alpha < 0.0 || alpha > 0.5) {
            Minim.error("Range for GaussWindow out of bounds. Value must be <= 0.5");
            return;
        }
        this.alpha = alpha;
    }

    public GaussWindow() {
        this(0.25);
    }

    protected float value(int length, int index) {
        return (float)Math.pow(Math.E, -0.5 * Math.pow(((double)index - (double)(length - 1) / 2.0) / (this.alpha * (double)(length - 1) / 2.0), 2.0));
    }

    public String toString() {
        return "Gauss Window";
    }
}

