/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioEffect;
import ddf.minim.AudioListener;
import ddf.minim.AudioSignal;
import ddf.minim.MultiChannelBuffer;
import ddf.minim.spi.AudioOut;
import ddf.minim.spi.AudioStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;

class BasicAudioOut
extends Thread
implements AudioOut {
    private AudioFormat format;
    private MultiChannelBuffer buffer;
    private AudioListener listener;
    private AudioStream stream;
    private boolean running;

    public BasicAudioOut(AudioFormat format, int bufferSize) {
        this.format = format;
        this.buffer = new MultiChannelBuffer(bufferSize, format.getChannels());
    }

    public void run() {
        this.running = true;
        while (this.running) {
            int samplesRead = this.stream.read(this.buffer);
            if (samplesRead != this.buffer.getBufferSize()) {
                for (int i = samplesRead; i < this.buffer.getBufferSize(); ++i) {
                    for (int c = 0; c < this.buffer.getChannelCount(); ++c) {
                        this.buffer.setSample(c, i, 0.0f);
                        this.buffer.setSample(c, i, 0.0f);
                    }
                }
            }
            if (this.buffer.getChannelCount() == 1) {
                this.listener.samples(this.buffer.getChannel(0));
            } else {
                this.listener.samples(this.buffer.getChannel(0), this.buffer.getChannel(1));
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void open() {
        this.start();
    }

    public void close() {
        this.running = false;
    }

    public Control[] getControls() {
        return new Control[0];
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int bufferSize() {
        return this.buffer.getBufferSize();
    }

    public void setAudioSignal(AudioSignal signal) {
    }

    public void setAudioStream(AudioStream stream) {
        this.stream = stream;
    }

    public void setAudioEffect(AudioEffect effect) {
    }

    public void setAudioListener(AudioListener listen) {
        this.listener = listen;
    }
}

