/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioFormat {
    protected Encoding encoding;
    protected float sampleRate;
    protected int sampleSizeInBits;
    protected int channels;
    protected int frameSize;
    protected float frameRate;
    protected boolean bigEndian;
    private Map<String, Object> m_properties;
    private Map<String, Object> m_unmodifiableProperties;

    public AudioFormat(Encoding encoding, float fSampleRate, int nSampleSizeInBits, int nChannels, int nFrameSize, float fFrameRate, boolean bBigEndian) {
        this(encoding, fSampleRate, nSampleSizeInBits, nChannels, nFrameSize, fFrameRate, bBigEndian, null);
    }

    public AudioFormat(Encoding encoding, float fSampleRate, int nSampleSizeInBits, int nChannels, int nFrameSize, float fFrameRate, boolean bBigEndian, Map<String, Object> properties) {
        this.encoding = encoding;
        this.sampleRate = fSampleRate;
        this.sampleSizeInBits = nSampleSizeInBits;
        this.channels = nChannels;
        this.frameSize = nFrameSize;
        this.frameRate = fFrameRate;
        this.bigEndian = bBigEndian;
        this.initMaps(properties);
    }

    public AudioFormat(float fSampleRate, int nSampleSizeInBits, int nChannels, boolean bSigned, boolean bBigEndian) {
        this(bSigned ? Encoding.PCM_SIGNED : Encoding.PCM_UNSIGNED, fSampleRate, nSampleSizeInBits, nChannels, nChannels != -1 && nSampleSizeInBits != -1 ? nChannels * nSampleSizeInBits / 8 : -1, fSampleRate, bBigEndian);
    }

    private void initMaps(Map<String, Object> properties) {
        this.m_properties = new HashMap<String, Object>();
        if (properties != null) {
            this.m_properties.putAll(properties);
        }
        this.m_unmodifiableProperties = Collections.unmodifiableMap(this.m_properties);
    }

    public Map<String, Object> properties() {
        return this.m_unmodifiableProperties;
    }

    public Object getProperty(String key) {
        return this.m_properties.get(key);
    }

    protected void setProperty(String key, Object value) {
        this.m_properties.put(key, value);
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleSizeInBits() {
        return this.sampleSizeInBits;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    private static boolean doMatch(int i1, int i2) {
        return i1 == -1 || i2 == -1 || i1 == i2;
    }

    private static boolean doMatch(float f1, float f2) {
        return f1 == -1.0f || f2 == -1.0f || (double)Math.abs(f1 - f2) < 1.0E-9;
    }

    public boolean matches(AudioFormat format) {
        return this.getEncoding().equals(format.getEncoding()) && (format.getSampleSizeInBits() <= 8 || format.getSampleSizeInBits() == -1 || this.isBigEndian() == format.isBigEndian()) && AudioFormat.doMatch(this.getChannels(), format.getChannels()) && AudioFormat.doMatch(this.getSampleSizeInBits(), format.getSampleSizeInBits()) && AudioFormat.doMatch(this.getFrameSize(), format.getFrameSize()) && AudioFormat.doMatch(this.getSampleRate(), format.getSampleRate()) && AudioFormat.doMatch(this.getFrameRate(), format.getFrameRate());
    }

    public String toString() {
        return this.getEncoding() + ", " + this.getChannels() + " channel(s), " + this.getSampleSizeInBits() + " bit samples, " + this.getFrameSize() + " byte frames, " + this.getSampleRate() + " Hz, " + this.getFrameRate() + " frames/second, " + (this.isBigEndian() ? "big endian" : "little endian");
    }

    public static class Encoding {
        public static final Encoding PCM_SIGNED = new Encoding("PCM_SIGNED");
        public static final Encoding PCM_UNSIGNED = new Encoding("PCM_UNSIGNED");
        public static final Encoding ULAW = new Encoding("ULAW");
        public static final Encoding ALAW = new Encoding("ALAW");
        private String m_strName;

        public Encoding(String strName) {
            this.m_strName = strName;
        }

        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }

        public final int hashCode() {
            return this.toString().hashCode();
        }

        public final String toString() {
            return this.m_strName;
        }
    }
}

