/*
 * Decompiled with CFR 0.152.
 */
package com.github.bjakke;

import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.opengl.PShader;

public class Shader {
    private final PShader shader;
    private final PApplet applet;
    private final PGraphics pg;
    private Moonlander ml;

    public Shader(PApplet p, PGraphics pg, String fragFilePath, Moonlander ml) {
        this.applet = p;
        this.shader = this.applet.loadShader(fragFilePath);
        this.pg = pg;
        this.ml = ml;
    }

    public void draw(float timeSeconds) {
        this.shader.set("u_time_s", timeSeconds);
        this.shader.set("u_resolution", (float)this.pg.width, (float)this.pg.height);
        float scene = this.ml("scene");
        this.shader.set("u_scene", scene);
        float posX = this.ml("camPosX");
        float posY = this.ml("camPosY");
        float posZ = this.ml("camPosZ");
        float lookX = this.ml("camLookX");
        float lookY = this.ml("camLookY");
        float lookZ = this.ml("camLookZ");
        float camUpX = this.ml("camUpX");
        float camUpY = this.ml("camUpY");
        float camUpZ = this.ml("camUpZ");
        this.shader.set("u_camPos", posX, posY, posZ);
        this.shader.set("u_camLook", lookX, lookY, lookZ);
        this.shader.set("u_camUp", camUpX, camUpY, camUpZ);
        float houseHight = this.ml("hHight");
        this.shader.set("u_houseHight", houseHight);
        float sphereHeight = this.ml("sHeight");
        this.shader.set("u_sphereHight", sphereHeight);
        this.pg.shader(this.shader);
        this.pg.rect(0.0f, 0.0f, (float)this.pg.width, (float)this.pg.height);
    }

    private float ml(String trackName) {
        return (float)this.ml.getValue(trackName);
    }

    private int mli(String trackName) {
        return this.ml.getIntValue(trackName);
    }
}

