#version 130
varying vec2 tCoord;
varying vec4 pos;
varying float distPosToCam;
uniform sampler2D iChannel0;
uniform vec2 iResolution;
uniform float iGlobalTime;
uniform vec3 cameraPosition;
#define MAX_STEPS 100.
#define MAX_DISTANCE 3.0
#define epsilon 0.002
#define infinite 1e7
#define lightSize 2.8
#define powLight 256.
#define lightColor vec3(0.9,0.9,0.4)
vec3 lightSource = vec3(-2.0,12.0,0.0);

mat3 rotationMatrix(vec3 axis, float angle) {
    axis = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;
    
    return mat3(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,
                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,
                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c);
}
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
float rand(float co){
    return rand(vec2(co));
}
float smin( float a, float b, float k ) {
    float res = exp( -k*a ) + exp( -k*b );
    return -log( res )/k;
}
float sdSphere( vec3 p, float s ){
  return length(p)-s;
}
float udRoundBox( vec3 p, vec3 b, float r ) {
  return length(max(abs(p)-b,0.0))-r;
}
float udBox( vec3 p, vec3 b )
{
  return length(max(abs(p)-b,0.0));
}
float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) +
         length(max(d,0.0));
}
float sdHexPrism( vec3 p, vec2 h )
{
    vec3 q = abs(p);
    q=q.zxy;
    return max(q.z-h.y,max((q.x*0.866025+q.y*0.5),q.y)-h.x);
}

float length2( vec2 p ) {
    return sqrt( p.x*p.x + p.y*p.y );
}

float length6( vec2 p ) {
    p = p*p*p; p = p*p;
    return pow( p.x + p.y, 1.0/6.0 );
}

float length8( vec2 p ) {
    p = p*p; p = p*p; p = p*p;
    return pow( p.x + p.y, 1.0/8.0 );
}
float sdTorus88( vec3 p, vec2 t )
{
  vec2 q = vec2(length8(p.xz)-t.x,p.y);
  return length8(q)-t.y;
}
float sdTorus82( vec3 p, vec2 t )
{
  vec2 q = vec2(length2(p.xz)-t.x,p.y);
  return length8(q)-t.y;
}
float sdCappedCylinder( vec3 p, vec2 h )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - h;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}
float sdCapsule( vec3 p, vec3 a, vec3 b, float r )
{
    vec3 pa = p - a, ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h ) - r;
}

mat2 rotate(float Angle)
{
    mat2 rotation = mat2(
        vec2( cos(Angle),  sin(Angle)),
        vec2(-sin(Angle),  cos(Angle))
    );
    return rotation;
}
float getColorReflection( vec3 position, out vec3 color, out float reflectiveValue) {

    vec3 _position = position;
    vec3 _position2 = position;
    float dist = 1e5;
    _position.xy *= rotate(_position.z/3.);
    dist = min(dist, sdBox(_position-vec3(0.0,-1.2,0.0),vec3(11111.,0.01,11111.)));
    
    _position.y += 1.0;
    _position.x += iGlobalTime/55.;
    _position.z += iGlobalTime;
    _position2 = _position;
    float emt = sin(2.*iGlobalTime+_position.x+_position.z*3.4);
    _position.z=mod(_position.z,0.6)-0.3;
    _position.x=mod(_position.x,0.6)-0.3;
    _position2.y+=emt/12.;
    dist = min(dist, sdHexPrism(_position,vec2(0.2-_position2.y/4.,0.7+sin((_position2.x+_position2.z)*3.)/6.)));
    
    color = vec3(.05)+vec3(floor(mod(_position2.z*2.,2.))+.01)*vec3(1.,0.3,0.2)+vec3(floor(mod(_position2.z*1.4,2.))+.01)*vec3(0.0,0.8,0.8);
    
    color += vec3(.05)+vec3(floor(mod(_position2.x*2.,2.))+.01)*vec3(1.,0.3,0.2)+vec3(floor(mod(_position2.x*1.4,2.))+.01)*vec3(0.0,0.8,0.8);
    color/=2.;
    reflectiveValue = 0.7;
    
    dist -= floor(rand(_position.xz)+rand(_position.zy))/7000.;
    return dist;
}
float getDistance( in vec3 position) {
    vec3 _position = position;
    vec3 c;
    float r;
    return getColorReflection(_position, c, r);
}
vec3 getSurfaceNormal(vec3 position) {
    float e=epsilon;
    vec3 normalVector = vec3(
                            getDistance(position+vec3( e,  0., 0.)) - getDistance(position+vec3(  -e,   0.,  0.)) ,
                            getDistance(position+vec3( 0., e,  0.)) - getDistance(position+vec3(   0., -e,   0.)) ,
                            getDistance(position+vec3( 0., 0., e)) - getDistance(position+vec3(    0.,  0., -e)) );
    normalVector = normalize(normalVector);
    return normalVector;
}
float traceToLight(vec3 rayPosition, vec3 normalVector, vec3 lightSource, float raylightdist){

    vec3 ro = rayPosition;
    vec3 rd = normalize(lightSource - rayPosition);
    float t = 0.2;
    float k = distance(lightSource, rayPosition)/4.;
    float res = 1.0;
    for( int i=0; i<22; i++ )
    {
        float h = getDistance(ro + rd*t);
        h = max( h, 0.0 );
        res = min( res, k*h/t );
        t += clamp( h, 0.001, 0.9 );
        if( h<0.01) break;
    }
    return clamp(res,0.07,9.0);
}
float fastTraceToLight(vec3 rayPosition, vec3 normalVector, vec3 lightSource, float raylightdist){

    vec3 ro = rayPosition;
    vec3 rd = normalize(lightSource - rayPosition);
    float t = 0.08;
    float k = distance(lightSource, rayPosition)/4.;
    float res = 1.0;
    for( int i=0; i<6; i++ )
    {
        float h = getDistance(ro + rd*t);
        h = max( h, 0.0 );
        res = min( res, k*h/t );
        t += clamp( h, 0.001, 0.9 );
        if( h<0.01) break;
    }
    return clamp(res,0.07,9.0);
}
float getSurfaceColor( vec3 curPosition, vec3 normalVector, vec3 lightSource, vec3 lightDirection) {
    float intensity = lightSize * pow( 0.001 + max(0.0, dot( lightDirection, normalVector)),  powLight);
    intensity = lightSize * pow( intensity / distance( curPosition, lightSource),  powLight);
    intensity += pow (max( dot( normalize( lightSource - curPosition), normalVector), 0.0), powLight);
    return intensity;
}

vec3 giTrace(vec3 rayOrigin, vec3 rayDirection) {
    vec3 endColorResult = vec3(0.0);
    vec3 prevPosition = rayOrigin;
    vec3 curPosition = rayOrigin;
    vec3 normalVector;
    vec4 result=vec4( 0., 0., 0., 0.);
    vec3 finalLight = vec3(0.0);
    float dist = 0.0;
    int hit = 0;
    vec3 rna;
    #define maxSamples 2.
        for(float i =1.; i < maxSamples+1.; i++) {
                rna=rayDirection* 0.01 * i;
                vec3 curPosition = 
                    rayOrigin + normalize(rayDirection + rna );
                vec3 color = vec3( 0.0);
                float reflection = 0.0;
                getColorReflection( curPosition, color, reflection);
                normalVector = getSurfaceNormal( curPosition);
                
                float raylightdist = distance( curPosition, lightSource);
                float light = fastTraceToLight( curPosition, normalVector, lightSource, raylightdist);
                vec3 lightDirection = normalize( lightSource - curPosition);
                lightDirection = normalize(lightDirection);
                float directLight = dot(normalVector, lightDirection);
                finalLight += light*max(lightSize*directLight,0.01);
                endColorResult +=  color * finalLight;
        }
    
    return endColorResult / maxSamples;
}
vec4 passTrace(vec3 rayOrigin, vec3 rayDirection, out vec3 inside_colored) {
            if( length( rayOrigin) > MAX_DISTANCE) {
                return vec4(110.);
            }
    vec3 endColorResult = vec3(0.0);
    vec3 prevPosition = rayOrigin;
    vec3 curPosition = rayOrigin;
    vec3 normalVector;
    vec4 result=vec4( 0., 0., 0., 0.);
    float finalLight = 1.0;
    float dist = 0.0;
    float storeColorStrength = 1.0;
    float globalIllumination=0.;
    float lengthGone = 0.0;
    float stepped = 0.0;
    #define LARGE_STEP 0.1
    /*raymarch through with bigger steps*/
        for(float i = 0.; i < MAX_STEPS/4.; i++) {
            stepped += LARGE_STEP;
            float stepable = getDistance( curPosition);
      
            curPosition += LARGE_STEP * rayDirection;
            lengthGone += LARGE_STEP;
            vec3 sLight = lightColor  * distance(curPosition, lightSource);
            inside_colored += LARGE_STEP * lightSize * sLight / (1.0 + pow( distance(lightSource, curPosition) ,  powLight) );
            if( getDistance( curPosition) > epsilon) {
                break;
            } 
            /*too far from begining  point, call it an end*/
            if( length( curPosition) > MAX_DISTANCE) {
                break;
            }
        }
    inside_colored = inside_colored * lengthGone * 0.01;
    return vec4( curPosition, distance(prevPosition,curPosition));
}
float circle(vec2 coord, vec2 pos, float size){
    return min(floor(distance(coord,pos)-size),0.);
}
float roundBox(vec2 coord, vec2 pos, vec2 b ){
  return length(max(abs(coord-pos)-b,0.0));
}
vec3 AO(vec3 rayOrigin, vec3 rayDirection) {
    float AO = 0.0;
    for(float i=1.0; i<6.0; i++) {
        vec3 position =  rayOrigin + i * 0.1 * rayDirection;
        AO += getDistance( position);
    }
    return vec3(AO);
}
vec4 oneTrace(vec3 rayOrigin, vec3 rayDirection) {
            if( length( rayOrigin) > MAX_DISTANCE) {
                return vec4(0.);
            }
    vec3 endColorResult = vec3(0.0);
    vec3 prevPosition = rayOrigin;
    vec3 curPosition = rayOrigin + rayDirection*0.01;
    vec3 normalVector;
    vec4 result=vec4( 0., 0., 0., 0.);
    vec3 finalLight = vec3(0.0);
    float dist = 0.0;
    float storeColorStrength = 1.0;
    int hit = 0;
    
        for(float i = 0.; i < 32.; i++) {
            float stepable = getDistance( curPosition);
            dist += stepable;
            curPosition = prevPosition + dist * rayDirection;

           /*too far from begining point, call it an end*/
            if( abs( stepable) < epsilon*5.) {
                //if( reflection == 0.) {
                //    distanceOfCollision = distance(rayOrigin, curPosition);
                //}
                vec3 color = vec3( 0.0);
                float R = 0.0;
                getColorReflection( curPosition, color, R);
                normalVector = getSurfaceNormal( curPosition);
                
                float raylightdist = distance( curPosition, lightSource);
                float light = 1.;
                vec3 lightDirection = normalize( lightSource - curPosition);
                lightDirection = normalize(lightDirection);
                float directLight = dot(normalVector, lightDirection);
                float albedo = 0.9;
                finalLight += light * max( lightSize * directLight,0.01);
                float surfaceBrightness = length(finalLight);
                vec3 lightColorInside = color + finalLight * lightColor;
               
                vec3 surfaceFinalColor = color * lightColor * storeColorStrength * finalLight;
                
                float surfLight = getSurfaceColor(curPosition, normalVector, lightSource, lightDirection);
                float surfLightBackSide = 0.3333;
                
                float scatterDeathDepth = 0.3333;
                vec3 backSide = vec3(0.0);

                endColorResult += storeColorStrength * pow(max(dot(normalize(lightSource-curPosition),normalVector),0.0),powLight);
                endColorResult += storeColorStrength * (backSide + surfaceFinalColor) / (1.0+surfLight+surfLightBackSide);
                endColorResult += storeColorStrength * (backSide + surfaceFinalColor) * pow(lightColor,vec3(powLight))/ (1.0+surfLight+surfLightBackSide+scatterDeathDepth+pow(distance(curPosition,lightSource),2.) ) ;
                endColorResult += storeColorStrength * (backSide + surfaceFinalColor) * ( (surfLight+surfLightBackSide) ) * R * surfaceFinalColor ;
                
                storeColorStrength *= R / (1.0+scatterDeathDepth);
                hit = 1;
                dist = 0.0;
                break;
            }
            /*too far from begining  point, call it an end*/
            if( length( curPosition) > MAX_DISTANCE) {
                break;
            }
    }
    vec3 lightDir = (lightSource-rayOrigin);
    lightDir = normalize(lightDir);
    float directLight = dot(rayDirection, lightDir);
    vec3 backdrop=min(max( pow(directLight,7.1) * vec3(1.8,1.1,.9) * 5.6, 0.01),1.);
    if(hit==0) endColorResult += backdrop ;
    return vec4( endColorResult, 1.);
}

vec4 march(vec3 rayOrigin, vec3 rayDirection) {
    vec2 p = gl_FragCoord.xy / iResolution.xy;
    vec3 origRayDirection=rayDirection;
    vec3 endColorResult = vec3(0.0);
    vec3 prevPosition = rayOrigin;
    vec3 curPosition = rayOrigin + rayDirection ;
    vec3 normalVector;
    vec4 result=vec4( 0., 0., 0., 0.);
    vec3 finalLight = vec3(0.0);
    float dist = 0.0;
    float storeColorStrength = 1.0;
    int hit = 0;
    float collisions = 0.;
    float distanceOfCollision = 1111110.;
    
    float distanceOfFirstHit = 0.;
    
        for(float i = 0.; i < MAX_STEPS; i++) {
            float stepable = getDistance( curPosition);
            dist += stepable;
            curPosition = prevPosition + dist * rayDirection;

           /*too far from begining point, call it an end*/
            if( abs( stepable) < epsilon) {
                //if( reflection == 0.) {
                //    distanceOfCollision = distance(rayOrigin, curPosition);
                //}
                vec3 color = vec3( 0.0);
                float R = 0.0;
                getColorReflection( curPosition, color, R);
                normalVector = getSurfaceNormal( curPosition);
                
                float raylightdist = distance( curPosition, lightSource);
                float light = traceToLight( curPosition, normalVector, lightSource, raylightdist);
                vec3 lightDirection = normalize( lightSource - curPosition);
                lightDirection = normalize(lightDirection);
                float directLight = dot(normalVector, lightDirection);
                float albedo = 0.9;
                finalLight += light * max( lightSize * directLight,0.01);
                float surfaceBrightness = length(finalLight);
                vec3 lightColorInside = color + finalLight * lightColor;
               
                vec3 surfaceFinalColor = color * lightColor * storeColorStrength * finalLight;
                
                vec4 pos_ilum = passTrace( curPosition + epsilon * rayDirection, normalize(rayDirection*rotationMatrix(normalVector,0.1)), lightColorInside);
                
                float surfLight = getSurfaceColor(curPosition, normalVector, lightSource, lightDirection);
                float surfLightBackSide = getSurfaceColor(-pos_ilum.xyz, -normalVector, lightSource, lightDirection);
                
                float scatterDeathDepth = pow(pos_ilum.w,2.0)*8.0;
                vec3 backSide = ( lightColorInside + color * lightColor * storeColorStrength *  oneTrace(pos_ilum.xyz + 2. * epsilon * rayDirection, rayDirection).rgb ) / (1.0 + scatterDeathDepth);
                            

                endColorResult += (lightColor + color)/2. * storeColorStrength * pow(max(dot(normalize(lightSource-curPosition),normalVector),0.0),powLight);
                endColorResult += storeColorStrength * (backSide + surfaceFinalColor) / (1.0+surfLight+surfLightBackSide);
                endColorResult += storeColorStrength * (backSide + surfaceFinalColor) * pow(lightColor,vec3(powLight))/ (1.0+surfLight+surfLightBackSide+scatterDeathDepth+pow(distance(curPosition,lightSource),2.) ) ;
                endColorResult += storeColorStrength * (backSide + surfaceFinalColor) * ( (surfLight+surfLightBackSide) ) * R * surfaceFinalColor / (1.0+pow(distance( curPosition, pos_ilum.xyz), 6.2 ));
                endColorResult += storeColorStrength * (backSide + surfaceFinalColor) * giTrace(curPosition, normalVector) ;
               
                vec3 AOresult = log(AO(curPosition, normalVector))/3. ;
                endColorResult += storeColorStrength * AOresult /(1.0+(surfLight+surfLightBackSide));;
                endColorResult = max(endColorResult,vec3(0.));
                endColorResult = min(endColorResult,vec3(1.));
                collisions++;
                storeColorStrength *= R / (1.0+scatterDeathDepth);
                hit = 1;
                dist = 0.0;
                prevPosition = curPosition + normalVector;
                curPosition = prevPosition;
                rayDirection = reflect(rayDirection, -normalVector);
                break;
            }
            /*too far from begining  point, call it an end*/
            if( length( curPosition) > MAX_DISTANCE) {
                break;
            }
    }
    
    
    
    vec3 lightDir = (lightSource-rayOrigin);
    lightDir = normalize(lightDir);
    float directLight = dot(rayDirection, lightDir);
    vec3 backdrop=min(max( pow(directLight,40.0) * vec3(1.8,1.1,.9) * 0.6, 0.01),1.);
    
    if(distance(curPosition,lightSource) < distance(rayOrigin,lightSource)) endColorResult += backdrop ;
    endColorResult = max(endColorResult,vec3(0.0));
    return vec4( endColorResult, distanceOfFirstHit);
}
float resolveRaySphereIntersection(vec3 b, vec3 c, vec3 dir){
    vec3 OC=b-c;
    float P=dot(OC,dir);
    if(P<0.) return 1111.0;
    float d=sqrt(pow(length(OC),2.0)-pow(P,2.0));
    return d;
}
float trace(vec3 rayOrigin, vec3 rayDirection) {
    return resolveRaySphereIntersection(vec3(0.0,3.0,2.0), rayOrigin, rayDirection)*3.0;
}
float hash(float c){return fract(sin(dot(c,12.9898))*43758.5453);}

vec4 render( vec2 uv ) {  
    float aspect = iResolution.x / iResolution.y;
    vec3 cameraPosition = vec3( 0., 0., 3.);
    vec3 direction = normalize( vec3(.5 * uv * vec2( aspect, 1.0), 0.5 ) );
    direction *= rotationMatrix(vec3(1.0,0.0,0.0), 0.7);
    cameraPosition *= rotationMatrix(vec3(0.0,1.0,0.0), -0.2);
    direction *= rotationMatrix(vec3(0.0,1.0,0.0), 0.2);
    direction.z *= -1.0;
    
    vec4 color = march( cameraPosition, direction);

    return color;
}

void main( ) {  
    vec2 p = gl_FragCoord.xy / iResolution.xy;
    vec2 uv = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
    float aspect = iResolution.y / iResolution.x;
        vec4 C=render( uv );
        gl_FragColor =  vec4(C.rgb,1.) +  texture2D( iChannel0, p );
    
}
    