; Ogólna koncepcja:
; dane o ścieżce zbudowane są następująco: najpierw 3 bajty pozycji pierwszej kulki - XYZ
; dane każdej następnej z kulek znajdują się w dwóch bajtach:
; w pierwszym bajcie przesunięcia w pozycji X i Y (po 4 bity, najstarszy z bitów do znak)
; w drugim bajcie współrzędna Z 8-bitowa
; później w pamięci ekranów przechowywana jest jako 4-bitowa (nie ma miejsca na więcej),
; ale tutaj jest 8-bitowa żeby kolejne kulki prawie zawsze różniły się od siebie tą współrzędną
; po to aby wiedzieć, czy bieżąca kulka ma być na ekranie przed czy za poprzednią

sciezka:		equ 16384			; adres obszaru roboczego

pozycja_x:		DEFB 0			; pola do zapamiętywania bieżącej pozycji, potrzebne do obliczenia następnej
pozycja_y:		DEFB 0
pozycja_z:		DEFB 0
kulki:							; najpierw kopiujemy odpowiednią ścieżkę do obszaru roboczego
				LD A,12			; są one przechowywane razem z muzyką w banku 12
				OUT (hmpr),A
	kulki_start:LD HL,32768		; adres źródłowy jest modyfikowany
				LD DE,sciezka	; docelowy jest stały
				LD BC,2048		; każda scieżka ma 2048 bajtów 
				LDIR
				LD HL,sciezka	; najpierw odczytujemy pierwsze 3 bajty pozycji i zapamiętujemy w odpowiednich polach
				LD A,(HL)		; pozycja X
				INC HL
				LD (pozycja_x),A	
				SRL A			; dzielimy przez 2, bo w jednym bacjcie są 2 piksele
				LD E,A			; współrzędna X do rejestru E
				LD A,(HL)		; pozycja Y
				INC HL
				LD (pozycja_y),A ; 
				SRL A			; dzielimy przez 2, żeby obliczyć adres na ekranie 
				SET 7,A			; ustawiamy najstarszy bit, bo ekran jest w górnej połówce pamięci
				LD D,A			; przeliczona współrzędna Y do rejestru D
				LD (kulaadr+1),DE ; obliczony adres wrzucamy do procerury rysującej jedną kulkę
				LD A,(HL)		; pozycja Z
				INC HL
				LD (pozycja_z),A	; zapamiętujemy całą 8-bitową liczbę
				RRCA			; ale potem dzielimy ją przez 16, czyli bierzemy pod uwagę tylko tylko starszą 
				RRCA
				RRCA
				RRCA
				AND 15
				LD (glebokosc+1),A	; i wrzucamy do procedury rysującej kulkę
				CALL kulka		; rysyjemy pierwszą kulkę
				; pętla rysująca wszystkie kolejne kulki
	kulki_petla:
				LD A,(HL)			; na początek sprawdzamy, czy to nie koniec ściezki
				CP 255				; na końcu ścieżki jest wartość 255
				JR Z,konieckulek
				XOR A
				RLD					; pobieramy ze ścieżki tylko starszy półbajt spod adresu HL, gdzie jest przesunięcie pozycji X
				BIT 3,A				; sprawdzamy znak przesunięcia
				RES 3,A				; i go kasujemy
				LD C,A				; zapamiętujemy wartość przesunięcia (bez znaku) w C
				LD A,(pozycja_x)	; pobieramy poprzednią pozycję
				JR NZ,x_minus		; jeżeli trzeba odjąć pzesunięcie, to tam skaczemy
				ADD A,C				; dodajemy przesunięcie
				JR $+3				; i przeskakujemy poza kolejny rozkaz (poza odjęcie)
	x_minus:	SUB C				; odejmujemy przesunięcie
				LD (pozycja_x),A	; i aktualizujemy zapamiętaną pozycję X
				SRL A				; dzielimy pozycję przez 2, żeby mieć adres punktu na ekranie
				PUSH AF				; zapamiętujemy go i flagi, bo w CY będzie znak, czy kulka ma być parzysta, czy nieparzysta
				LD E,A				; mniej znaczącą część adresu zapisujemy do rejestru E
									; to samo, co poprzednio, robimy z przesunięciem współrzędnej Y
				XOR A
				RLD					; pobieramy ze ścieżki tylko starszy półbajt spod adresu HL, gdzie teraz jest przesunięcie pozycji Y
				BIT 3,A				; sprawdzamy znak przesunięcia
				RES 3,A				; i go kasujemy
				LD C,A				; zapamiętujemy wartość przesunięcia (bez znaku) w C
				LD A,(pozycja_y)	; pobieramy poprzednią pozycję
				JR NZ,y_minus		; jeżeli trzeba odjąć pzesunięcie, to tam skaczemy
				ADD A,C				; dodajemy przesunięcie
				JR $+3				; i przeskakujemy poza kolejny rozkaz (poza odjęcie)
	y_minus:	SUB C
				LD (pozycja_y),A	; i aktualizujemy zapamiętaną pozycję Y
				SRL A				; dzielimy pozycję przez 2, żeby mieć adres punktu na ekranie
				SET 7,A				; adres w górnej połówce RAMu
				LD D,A				; bardziej znaczącą część adresu zapisujemy do rejestru D
				JR NC,$+4			; jeżeli przy dzieleniu przez 2 była reszta
				SET 7,E				; to dla nieparzystej linii dodajemy 128 do adresu
				LD (kulaadr+1),DE	; adres kulki wrzucamy do procedury ją rysującej
				
				INC HL				; dalej będzie odczytywanie pozycji Z
				LD A,(HL)			; pobieramy pozycję Z ze scieżki (8-bitowa wartość)
				INC HL
				CP (pozycja_z)		; porównujemy z poprzednią
				LD (pozycja_z),A	; i ją ładujemy w miejsce poprzedniej
				PUSH AF				; zapamiętujemy flagi, czyli 
				LD A,0
				JR NC,dalsza		; sprawdzamy znak porównania - czy kolejna kulka ma być za czy przed poprzednią
				LD A,3				; jeżeli jest bliższa, to modyfikujemy kod wstawiając w pole skoku JR wartość 3
	dalsza:		LD (tendencja1+1),A	; a jeżeli dalsza, to wstawiamy wartość 0
				LD (tendencja2+1),A	; kod będzie zmodyfikowany w zależności od tego, jak ma się zachowac dla pikseli o tej samej głębokości, czyli wsp. Z
				POP AF				; wracamy do wartości głębokości
				RRCA				; dzielimy ją przez 16 (bierzmy tylko starszą połówkę)
				RRCA
				RRCA
				RRCA
				AND 15				
				LD (glebokosc+1),A	; i wrzucamy do procedury rysującej kulkę
				SRL A				; dzielimy jeszcze przez 2, żeby obliczyć, jakiej wielkości kulkę rysować (jest ich 8, a głębokości 16)
				ADD A,kulka_src/256	; obliczamy adres tej kulki
				LD (klulka_rozmiar+2),A	; i wrzucamy do kodu rysującego kulkę
				POP AF				; na koniec sprawdzamy, czy kulka ma być prawa czy lewa (w zależności od poz. X, czy była parzysta czy nie
				JR NZ,kulkalewa		; jeżeli kulka lewa, to skaczemy dalej
				LD A,(klulka_rozmiar+2)	; a jak prawa to modyfikujemy jeszcze jej adres, przesuwając o 8 kulek dalej
				ADD A,8
				LD (klulka_rozmiar+2),A
	kulkalewa:	
				CALL kulka			; rysujemy kulkę
				JP kulki_petla		; i idziemy do kolejnej kulki
	konieckulek:				
				RET
				

kulka:		; procedura rysująca jedną kulkę
				PUSH HL				; zapamiętujemy pozycję w ścieżce			
				LD B,2				; czekamy na ramkę, żeby narysować jedną kulkę w jednej ramce (1/50 s)
				CALL czekaj
				LD A,(nr_ekranu+1)	; pobieramy z procedury przerwania linii adres aktualnie wyświetlanego ekranu
				SUB 2				; żeby rysować na poprzednio wyświetlanym, a nie na bieżącym
				AND 31
				OR 16
				OUT (hmpr),A		; ustawiamy	do górnej połówki RAMu ten poprzedni ekran
	klulka_rozmiar:
				LD DE,kulka_src		; adres kulki, zmodyfikowany przez procedurę wyżej
	kulaadr:	LD HL,0				; adres na ekranie, zmodyfikowany przez procedurę wyżej
				PUSH HL				; zamapiętujemy adres na ekranie, żeby obliczyć adres w masce, czyli we współrzędnych Z
				LD BC,16384			; one są 16384 bajty dalej
				ADD HL,BC
				SET 7,H				; w razie wyjścia poza zakres, czyli poza 65535, ustawiamy się z powrotem w górnym ra
				PUSH HL
				EXX
	glebokosc:	LD A,0				; tu siedzi wartość Z obliczona przez procedurę wyżej, 8-bitowa
				LD E,A				; zapamiętujemy ją w E do porównań z młodszą połówką wsp. Z
				OR A				; (tylko dla wyczyszczenia znacznika CY)
				RLA					; mnożymy przez 16
				RLA
				RLA
				RLA
				LD D,A				; i zapamiętujemy w D do porównań ze starszą połówką wsp. Z
				POP HL				; obliczony adres w przestrzeni Z przepisujemy do rejestrów zapasowych H'L'
				EXX
				POP HL				; i wracamy do pozycji na ekranie 
				
	kulaa:				
				LD B,10				; kulka ma 20 punktów szerokości, czyli 10 bajtów
	linijka:	
				LD A,(DE)			; pobieramy wartość z matrycy kulki
				OR A				; sprawdzamy, czy nie jest 0. tutaj 0 oznacza przeźroczystość
				JR Z,tgb1			; jeżeli oba punkty w bajcie są przeźroczyste, to dalej
				EXX					; jeżeli któryś jest nieprzeźroczysty, to przełączamy się na współrzędne Z
				LD A,(HL)			; pobieramy bajt z maski (dla dwóch punktów po 4 bity)
				AND 240				; wybieramy górną połówkę kasując dolną
				CP D				; porównujemy z bieżącą współrzędną Z (w D jest przesunięte do starszej połówki)
				EXX					; wracamy na ekran
	tendencja1:	JR Z,tgb8			; dla odległości równej - skok modyfikowalny, w zależności od tendencji
				JP NC,mlodszepol	; skaczemy dalej dla Z mniejszego, czyli punkt jest dalej nas niż poprzedni	i nie rysujemy go
	tgb8:		LD A,(DE)			; pobieramy wartość z matrycy kulki
				AND 240				; wybieramy górną połówkę kasując dolną
				JR Z,mlodszepol		; jeżeli w górnej połówce punkt przeźroczysty, to skaczemy dalej
				LD C,A				; jezeli nie, to zapamiętujemy ten punkt w C
				LD A,(HL)			; pobieramy bajt z ekranu
				AND 15				; kasujemy starszą część, żeby wrzucić tam punkt z kulki
				OR C				; wrzucamy tam zapamiętany punkt z kulki
				LD (HL),A			; i wrzucamy z powrotem na ekran
				EXX					; przełączamy się na współrzędne Z
				LD A,(HL)			
				AND 15				; i tam w starszej połówce
				OR D				; wpisujemy nową współrzędną Z rysowanego właśnie punktu
				LD (HL),A			; wrzucamy z powrotem współrzędną Z do pamięci
				EXX
	mlodszepol:						; teraz drugi z dwóch punktów w bajcie	
				EXX
				LD A,(HL)			; pobieramy jego współrzędną Z
				AND 15				
				CP E				; i porównujemy z bieżącą, dla rysowanej teraz kulki
				EXX
	tendencja2:	JR Z,tgb9			; dla odległości równej - skok modyfikowalny, w zależności od tendencji
				JP NC,tgb1			; skaczemy dalej dla Z mniejszego, czyli punkt jest dalej nas niż poprzedni	i nie rysujemy go
	tgb9:		LD A,(DE)			; pobieramy wartość z matrycy kulki
				AND 15				; wybieramy dolną połówkę kasując dolną
				JR Z,tgb1			; jeżeli w dolnej połówce punkt przeźroczysty, to skaczemy dalej
				LD C,A				; jezeli nie, to zapamiętujemy ten punkt w C
				LD A,(HL)			; pobieramy bajt z ekranu
				AND 240				; kasujemy młodszą część, żeby wrzucić tam punkt z kulki
				OR C				; wrzucamy tam zapamiętany punkt z kulki
				LD (HL),A			; i wrzucamy z powrotem na ekran
				EXX					; przełączamy się na współrzędne Z
				LD A,(HL)
				AND 240				; i tam w młodszej połówce
				OR E				; wpisujemy nową współrzędną Z rysowanego właśnie punktu
				LD (HL),A			; wrzucamy z powrotem współrzędną Z do pamięci
				EXX
	tgb1:	
				INC E				; przechodzimy do następnego bajtu w matrycy kulki
				INC L				; w pamięci ekranu
				EXX 
				INC L				; i w pamięci współrzędnych Z
				EXX
				DJNZ linijka		; i tak dla 10 bajtów (20 punktów)
				
				EXX
				LD BC,118			; obliczenie adresu następnego wiersza (128 minus szerokość kulki) w przestrzeni Z
				ADD HL,BC
				SET 7,H				; w razie wyjścia poza zakres wracamy do górnej połówki RAMu
				EXX
				LD C,118			; obliczenie adresu następnego wiersza na ekranie
				ADD HL,BC
				LD A,E
				CP 200				; sprawdzamy, czy koniec kulki (kulka ma 200 bajtów)
				JR NZ,kulaa			; jeżeli nie koniec, to następny wiersz kulki
				POP HL				; przywracamy pozycję w ścieżce
				RET