<?
error_reporting(E_ALL);
echo '<pre>';
// use AND A and carry flag always off
// only one DEC RR or use LD SP,HL


/*
w_min = 108, w_max = 164
zx screen code
;	HL` = attr adr
;	D` = ink+paper
;	E` = ink
;	C` = 0
;	B` = 7
	LD (HL),R	;7 ( OR 0)
	INC	L	;4
	LD (HL),R	;7 ( OR 0)
	INC	L	;4
	LD (HL),R	;7 ( OR 0)
	INC	L	;4
	LD (HL),R	;7 ( OR 0)
	INC	HL	;6
	EXX		;4
	RET	NC	;11 /61 //96 total (98 target)

*/



$wait_arr = array(
	4 => 'NOP',
	5 => 'RET C',
	6 => 'DEC HL',	//LD SP,HL
	7 => 'OR 0',	//2b
	8 => 'NOP:NOP', 	//2b
	9 => 'NOP:RET C',	//2b
	10 => 'RET C:RET C', //2b
	11 => 'OR 0:NOP',	//3b
	12 => 'NOP:NOP:NOP', //3b
	13 => 'NOP:NOP:RET C', //3b
	14 => 'NOP:RET C:RET C', //3b
	15 => 'RET C:RET C:RET C', //3b
);
for ($i=16; $i<256; $i++) {
	$wait_arr[$i] = $wait_arr[$i-4] . ':NOP';
}

$code_ret_arr = array(
//--- return variants
	4 => array (
		'code' => 'JP (HL)',
		'precode' => true,
	),
	8 => array (
		'code' => 'NOP:JP (HL)',
		'precode' => true,
	),
	10 => array(
		'code' => 'RET',
		'precode' => true,
	),
	12 => array (
		'code' => 'NOP:NOP:JP (HL)',
		'precode' => true,
	),
);

$out_code_arr = array(
	0 => 'OUT (C),B',
	1 => 'OUT (C),D',
);

$ln_code_arr = array(
	0 => 'LD (HL),E: INC L: ',
	1 => 'LD (HL),C: INC L: ',
	2 => 'LD (HL),B: INC L: ',
	3 => 'LD (HL),D: INC L: ',
	4 => 'OR 0: INC L: '
);
$ln_code_arr_t = array(
	0 => 11,
	1 => 11,
	2 => 11,
	3 => 11,
	4 => 11,
);

/*
	E = 00
	C = 0I
	B = P0
	D = PI
*/


$w_diff = array();
$w_diff2 = array();
$w_min = 224;
$w_max = 0;

/*
	OUT	(C),R	;12	24px
	2t			;2t	4px /14t 28px
	--- left border
	32t 64px
	--- scr
	128t 256px
	--- right border (max invis t variant)
	30t
	OUT (C),R 2t
	---
	10t
	
	free = 8t/10t/12t/14t ...
	

*/

$scr_code_arr = array(
	0 => 'LD (HL),C:',
	7 => 'LD (HL),E:',
	63 => 'LD (HL),D:',
);

$last_wait = array();
$diff_scr_code = array();
$diff_lines_code = array();
$diff_lines_code_ret = array();
$diff_waits = array();
$fazes_jp = array();

$diff_top = array();
$jp_top = array();
$img_mask = file_get_contents("../demo/gfx_concept/masked/masked_with_circles/bw/bw-man-mask.mgs.img");

$first_code_idx = array();
$first_scr_code_ln = array();
//   -14t (28pix)
$fazes_qty = 8;
for ($f=1; $f<=$fazes_qty; $f++) {
	$frame_code_bkp = '';
	$fazes_jp[$f] = array();
	$jp_top[$f] = array();
	$img = imagecreatefrompng('fx/masked/test_masked_frame_' . $f . '.png');
	$img_scr = file_get_contents("../demo/gfx_concept/masked/masked_with_circles/bw/bw" . sprintf('%02d', $f-1) . ".mgs.img");
	//--- calc top border
	for ($y = 4; $y < 16; $y++) {
		$code_ln = array();
		$clr0 = (imagecolorat($img, 0, $y))==0 ? 0 : 1;
		$code_ln[] = $out_code_arr[$clr0];
		$tln = 12;
		$t = 0;
		$x = -1;
		while ($x < 106) {
			$xc = $x < 0 ? 0 : $x;
			$xc = $xc > 95 ? 95 : $xc;
			$clr = imagecolorat($img, $xc, $y)==0 ? 0 : 1;
			if ($clr != $clr0) {
				if ($t != 0) {
					$code_ln[] = 'W_' . $t;
				}
				$code_ln[] = $out_code_arr[$clr];
				$clr0 = $clr;
				$t = -12;
			}
			$t += 2;
			$tln += 2;
			$x++;
		}
		$t -= 2;
		$tw = $t;
		//---
		$w6 = 0;
		$flag_pop = false;
		if ($t==14 || $t >= 18) {
			$t -= 14;
			if ($t != 0) {
				$code_ln[] = 'W_' . $t;
			}
			$code_ln[] = 'NOP:RET';
		} elseif ($t==8 || $t>=12) { //err
			$t -= 8;
			if ($t != 0) {
				$code_ln[] = 'W_' . $t;
			}	
			$code_ln[] = 'NOP:JP (HL)';
			$make_pop = make_pop($code_ln);
			$code_ln = $make_pop['code_ln'];
			$w6 = $make_pop['w6'] + ($t==6 ? 1 : 0);
			$flag_pop = true;
		} elseif ($t==10) {
			$code_ln[] = 'RET';
		} else {
			if (!isset($last_wait[$t])) {
				$last_wait[$t] = 0;
			}
			$last_wait[$t]++;
		}
		//---
		$code_line = '';
		foreach ($code_ln as $code) {
			if (strstr($code, 'W_')) {
				list ($tmp, $t) = explode('_', $code);
				if ($t != 0 && !isset($wait_arr[$t])) {
					echo 'f=' . $f . ', y=' . $y . '<br>';
					echo '<pre>'; print_r($code_ln);
					die();
				}
				$code_line .= "\t;" . $code . "\r\n";
				$code_line .= "\t" . $wait_arr[$t] . "\r\n";
			} else {
				$code_line .= "\t" . $code . "\r\n";
			}
		}
		$diff_top_idx = isset($diff_top[$code_line]) ? $diff_top[$code_line] : sizeof($diff_top);
		$diff_top[$code_line] = $diff_top_idx;
		for ($k=0; $k<4; $k++) {
			$jp_top[$f][] = array(
				'jp' => $diff_top_idx,
				'flag_pop' => $flag_pop,
				'w6' => $w6,
			);
		}
	}

	//--- calc scr first line
	$first_scr_code_ln[$f] = array();
	for ($i=0; $i<8; $i++) {
		$scr_code = "EXX:";
		for ($x=0; $x<4;$x++) {
			$bx = $i*4 + $x;
			$adr = 6144 + $bx;
			$mask = ord($img_mask[$adr]);
			if ($mask == 63) {
				$attr = ord($img_scr[$adr]);	
				$scr_code .= $scr_code_arr[$attr];
			} else {
				$scr_code .= "OR 0:";
			}
			$scr_code .= $x==3 ? "INC HL:" : "INC L:";
		}
		$scr_code .= "\tJP LN_RET\r\n";
        //$scr_code .= "\tPOP AF: JP Z,LN_SWP: NOP: NOP: LD A,E: EXX: RET NC\r\n";
		$diff_scr_code_idx = isset($diff_scr_code[$scr_code]) ? $diff_scr_code[$scr_code] : sizeof($diff_scr_code);
		$diff_scr_code[$scr_code] = $diff_scr_code_idx;
		$first_scr_code_ln[$f][] = $diff_scr_code_idx;
		$first_code_idx[$diff_scr_code_idx] = true;
	}

	//--- calc screen + border
	for ($y = 16; $y < 64; $y++) {
		$scr_code_ln = array();
		for ($i=0; $i<4; $i++) {
			$scr_code = "EXX:";
			for ($x=0; $x<4;$x++) {
				$bx = (($y%2)*16) + $i*4 + $x;
				$adr = 6144 + floor(($y-16)/2 + 1)*32 + $bx;
				$mask = ord($img_mask[$adr]);
				if ($mask == 63 && $y < 62) {
					$attr = ord($img_scr[$adr]);	
					$scr_code .= $scr_code_arr[$attr];
				} else {
					$scr_code .= "OR 0:";
				}
				$scr_code .= $x==3 ? "INC HL:" : "INC L:";
			}
			$scr_code .= "\tJP LN_RET\r\n";
			$diff_scr_code_idx = isset($diff_scr_code[$scr_code]) ? $diff_scr_code[$scr_code] : sizeof($diff_scr_code);
			$diff_scr_code[$scr_code] = $diff_scr_code_idx;
			$scr_code_ln[] = $diff_scr_code_idx;
		}

		$code_ln = array();
		//--- calc left border
		$clr0 = (imagecolorat($img, 0, $y))==0 ? 0 : 1;
		$code_ln[] = $out_code_arr[$clr0];
		$tln = -2;
		$t = 0;
		$x = -1;
		while ($x < 16) {
			$xc = $x < 0 ? 0 : $x;
			$clr = imagecolorat($img, $xc, $y)==0 ? 0 : 1;
			if ($clr != $clr0) {
				if ($t != 0) {
					$code_ln[] = 'W_' . $t;
				}
				$code_ln[] = $out_code_arr[$clr];
				$clr0 = $clr;
				$t = -12;
			}
			$t += 2;
			$tln += 2;
			$x++;
		}
		if ($t != 0) {
			if ($t > 0) {
				if ($t == 2) {
					$code_ln[] = 'W_4';
					$t = -2;
				} else {
					$code_ln[] = 'W_' . $t;
					$t = 0;
				}
			} else {
				$tln -= $t;
				$x -= ($t/2);
				$t = 0;
			}
		}
		//echo '<pre>'; echo 'x=' . $x . ', t=' . $t . ', tln=' . $tln . '<br>'; print_r($code_ln);
		//--- calc right border
		$clr = (imagecolorat($img, 64+16, $y))==0 ? 0 : 1;
		if ($clr0 != $clr) {
			$code_ln[] = $out_code_arr[$clr];
			$clr0 = $clr;
			$tln += 12;
			$x += 6;
		}
		while ($x < 96) {
			$xc = $x < 80 ? 80 : $x;
			$clr = imagecolorat($img, $xc, $y)==0 ? 0 : 1;
			if ($clr != $clr0) {
				if ($t != 0) {
					$code_ln[] = 'W_' . $t;
				}
				$code_ln[] = $out_code_arr[$clr];
				$clr0 = $clr;
				$t = -12;
			}
			$t += 2;
			$tln += 2;
			$x++;
		}
		if ($t != 0) {
			if ($t < 0) {
				$tln -= $t;
				$x -= ($t/2);
				$t = 0;
			}
		}
		$tln += 14;
		$t += 224 - $tln;
		$code_ln_bkp = $code_ln;
		$code_ln_bkp[] = 'W_' . $t;
		//echo '<pre>'; echo 'x=' . $x . ', t=' . $t . ', tln=' . $tln . '<br>'; print_r($code_ln);

		//--- normalize waits ???
		for ($i=0; $i<sizeof($code_ln);$i++) {
			if (isset($code_ln[$i+1]) && strstr($code_ln[$i], 'W_') && strstr($code_ln[$i+1], 'W_')) {
				list ($tmp, $tw1) = explode('_', $code_ln[$i]);
				list ($tmp, $tw2) = explode('_', $code_ln[$i+1]);
				$code_ln[$i+1] = 'W_' . ($tw1 + $tw2);
				unset($code_ln[$i]);
			}
		}
		$code_ln = array_values($code_ln);
		//--- line ret
		$w6 = 0;
		$flag_pop = false;
		if ($t==14 || $t >= 18) {
			$t -= 14;
			if ($t != 0) {
				$code_ln[] = 'W_' . $t;
			}
			$code_ln[] = 'NOP:RET';
		} elseif ($t==8 || $t>=12) { //err
			$t -= 8;
			if ($t != 0) {
				$code_ln[] = 'W_' . $t;
			}	
			$code_ln[] = 'NOP:JP (HL)';
			$make_pop = make_pop($code_ln);
			$code_ln = $make_pop['code_ln'];
			$w6 = $make_pop['w6'] + ($t==6 ? 1 : 0);
			$flag_pop = true;
		} elseif ($t==10) {
			$code_ln[] = 'RET';
		} else {
			if (!isset($last_wait[$t])) {
				$last_wait[$t] = 0;
			}
			$last_wait[$t]++;
		}

		//--- make line
		$code_line = '';
		foreach ($code_ln as $code) {
			if (strstr($code, 'W_')) {
				list ($tmp, $t) = explode('_', $code);
				if ($t >= 108) {
					if (!isset($w_diff[$t])) {
						$w_diff[$t] = 0;
					}
					$w_diff[$t]++;
					$w_min = $t<$w_min ? $t : $w_min;
					$w_max = $t>$w_max ? $t : $w_max;
					$code_line .= "\tLD IX,[LINE_RET_IX]:RET NC\r\n";
					$code_line .= "[LINE_RET]";
					$t -= 108;
				}
				if ($t != 0 && !isset($wait_arr[$t])) {
					echo 'f=' . $f . ', y=' . $y . '<br>';
					echo '<pre>'; print_r($code_ln);
					echo '<pre>'; print_r($code_ln_bkp);
					die();
				}
				if ($t != 0) {
					if (!isset($w_diff2[$t])) {
						$w_diff2[$t] = 0;
					}
					$w_diff2[$t]++;
					$code_line .= "\t;W_" . $t . "\r\n";
					$code_line .= "\t" . $wait_arr[$t] . "\r\n";
				}
			} else {
				$code_line .= "\t" . $code . "\r\n";
			}
		}
		//print_r($code_line); die();

		$code_line_idx = isset($diff_lines_code[$code_line]) ? $diff_lines_code[$code_line] : sizeof($diff_lines_code);
		$diff_lines_code[$code_line] = $code_line_idx;

		for ($k=0; $k<4; $k++) {
			$fazes_jp[$f][] = array(
				'line' => $code_line_idx,
				'flag_pop' => $flag_pop,
				'w6' => $w6,
				'scr_code_ln' => $scr_code_ln[$k],
			);
		}
		//print_r($code_ln_bkp); die();
		$code_line_bkp = '';
		foreach ($code_ln_bkp as $code) {
			if (strstr($code, 'W_')) {
				list ($tmp, $t) = explode('_', $code);
				$code_line_bkp .= "\t" . $wait_arr[$t] . "\r\n";
			} else {
				$code_line_bkp .= "\t" . $code . "\r\n";
			}
		}
		$ln = ";---------------- ln " . $y . "\r\n\tDUP 4\r\n" . $code_line_bkp . "\tEDUP\r\n";
		$frame_code_bkp .= $ln;
		//echo $ln;
	}
	$frame_code_bkp .= "\r\n\tRET\r\n";
	file_put_contents('../demo/kernal/effects/12/generated/frame_' . $f . '.asm', $frame_code_bkp);
}

$diff_lines_code_file = '';
foreach ($diff_lines_code as $line_code=>$line_code_idx) {
    $diff_lines_code_file .= "BLINE_" . $line_code_idx . " ;----------------------------\r\n";
	$line_code = str_replace('[LINE_RET]', 'LCR_' . $line_code_idx . "\r\n" , $line_code);
	$line_code = str_replace('[LINE_RET_IX]', 'LCR_' . $line_code_idx , $line_code);
    $diff_lines_code_file .= $line_code;
}
file_put_contents('../demo/kernal/effects/12/generated/diff_lines_code.asm', $diff_lines_code_file);

$diff_waits_file = '';
foreach ($diff_waits as $tw=>$tw_qty) {
	$diff_waits_file .= "TW_" . $tw . "\r\n";
	$diff_waits_file .=	"\t" . $wait_arr[$tw];
	$diff_waits_file .= ":RET\r\n";
}

file_put_contents('../demo/kernal/effects/12/generated/diff_waits.asm', $diff_waits_file);
print_r($diff_waits_file);

$file = '';
foreach ($diff_scr_code as $code=>$idx) {
	if (isset($first_code_idx[$idx])) {
		$file .= "XSCR_" . $idx . "\tPOP IX\r\n";
	}
	$file .= "SCR_" . $idx . "\r\n";
	$file .= "\t" . $code . "\r\n";
}
file_put_contents('../demo/kernal/effects/12/generated/diff_scr_code.asm', $file);

$file = '';
foreach ($diff_top as $code=>$idx) {
	$file .= "TOP_" . $idx . "\r\n";
	$file .= $code . "\r\n";
}
file_put_contents('../demo/kernal/effects/12/generated/diff_top.asm', $file);


//---------- JP TABLE
foreach ($fazes_jp as $f=>$jp) {
	$fazes_jp_file = "FAZEJP" . $f . "\r\n";
	foreach ($first_scr_code_ln[$f] as $code) {
		$fazes_jp_file .= "\tDW\tXSCR_" . $code . "\r\n";
	}
	
	$w6_top = 0;
	$imax = sizeof($jp_top[$f]);
	for ($i=0; $i<$imax; $i++) {
		$fazes_jp_file .= "\tDW\tTOP_" . $jp_top[$f][$i]['jp'] . " + " . $w6_top . "\r\n";
		$w6_top = $jp_top[$f][$i]['w6'];
	}
	$flag_pop_prev = 0;
	//$w6_prev = 0;
	$imax = sizeof($jp);
	for ($i=0; $i<$imax; $i++) {
		if ($i%4 == 0) {
			$fazes_jp_file .= ";-------- ln " . floor($i/4) . "\r\n";
		}
		if (!$flag_pop_prev) {
			$fazes_jp_file .= "\tDW\tBLINE_" . $jp[$i]['line'] . " + " . $w6_top . "\r\n";
			$w6_top = 0;
		}
		//---
		if ($jp[$i]['flag_pop']) {
			if (isset($jp[$i+1])) {
				$fazes_jp_file .= "\tDW\tBLINE_" . $jp[$i+1]['line'] . " + " . $jp[$i]['w6'] . "\r\n";	
			} else {
				$fazes_jp_file .= "\tDW\tFRAME_RET + " . $jp[$i]['w6'] . "\r\n";
			}
		}
		//---
		$fazes_jp_file .= "\tDW\tSCR_" . $jp[$i]['scr_code_ln'] . "\r\n";
		//---
		//$w6_prev = $jp[$i]['w6'];
		$flag_pop_prev = $jp[$i]['flag_pop'];
		//$w6_top = 0;
	}
	if (!$flag_pop_prev) {
		$fazes_jp_file .= "\tDW\tFRAME_RET\r\n";
	}
	//echo $fazes_jp_file;
	file_put_contents('../demo/kernal/effects/12/generated/fazejp' . $f . '.asm', $fazes_jp_file);
	
}

//---------------- CALC PIX DIFF
$img = array();
$pix_diff = array();
$pix_diff_chunk = array();
$pix_diff_total = 0;
$pix_diff_allow_move = array();
for ($f=1; $f<=$fazes_qty; $f++) {
	$img[$f] = file_get_contents("../demo/gfx_concept/masked/masked_with_circles/bw/bw" . sprintf('%02d', $f-1) . ".mgs.img");
}
for ($f=1; $f<=$fazes_qty; $f++) {
	$pix_diff[$f] = array();
	$f0 = $f==1 ? $fazes_qty : $f-1;
	for ($y=0; $y<24; $y++) {
		for ($x=0; $x<32; $x++) {
			$adr = $x + 32*(7 & $y) + 2048*(floor($y/8));
			$chunk = $chunk0 = array();
			for ($yy=0;$yy<4;$yy++) {
				$adr_yy = $adr + 256*$yy;
				$chunk[] = ord($img[$f][$adr_yy]);
				$chunk0[] = ord($img[$f0][$adr_yy]);
			}
			$chunk = implode(',', $chunk);
			$chunk0 = implode(',', $chunk0);
			if ($chunk != $chunk0) {
				$pix_diff_chunk_idx = isset($pix_diff_chunk[$chunk]) ? $pix_diff_chunk[$chunk] : sizeof($pix_diff_chunk);
				$pix_diff_chunk[$chunk] = $pix_diff_chunk_idx;
				$pix_diff[$f][] = array(
					'x' => $x,
					'y' => $y,
					'adr' => $adr,
					'chunk' => $pix_diff_chunk_idx,
				);
                $pix_diff_total++;
			}
            //---
			$chunk = $chunk0 = array();
			for ($yy=4;$yy<8;$yy++) {
				$adr_yy = $adr + 256*$yy;
				$chunk[] = ord($img[$f][$adr_yy]);
				$chunk0[] = ord($img[$f0][$adr_yy]);
			}
			$chunk = implode(',', $chunk);
			$chunk0 = implode(',', $chunk0);
			if ($chunk != $chunk0) {
				$pix_diff_chunk_idx = isset($pix_diff_chunk[$chunk]) ? $pix_diff_chunk[$chunk] : sizeof($pix_diff_chunk);
				$pix_diff_chunk[$chunk] = $pix_diff_chunk_idx;
				$pix_diff[$f][] = array(
					'x' => $x,
					'y' => $y,
					'adr' => $adr + 256*4,
					'chunk' => $pix_diff_chunk_idx,
				);
                $pix_diff_total++;
			}
            
		}
	}
	echo 'pix diff f_' . $f. ' = ' . sizeof($pix_diff[$f]) . "\r\n";
}
for ($f=1; $f<=$fazes_qty; $f++) {
    $pix_diff_allow_move[$f] = array();
    for ($fmv=1; $fmv<=$fazes_qty; $fmv++) {
        $f0 = $f-$fmv > 0 ? $f-$fmv : $f-$fmv+$fazes_qty;
        $pix_diff_allow_move[$f][$f0] = 0;
        foreach ($pix_diff[$f] as $diff) {
            $attr_adr = 6144 + $diff['y']*32 + $diff['x'];
            $attr = ord($img[$f0][$attr_adr]);
            if ($attr == 63 || $attr == 0) {
                $pix_diff_allow_move[$f][$f0]++;
            }
        }
    }
}
//print_r($pix_diff_allow_move);
$pix_diff_average = $pix_diff_total/$fazes_qty;

echo ';--- pix diff total = ' . $pix_diff_total . ' (~ ' . $pix_diff_average . ' per frame)' . "\r\n";

for ($k=0; $k<30; $k++) {
    for ($f=1; $f<=$fazes_qty; $f++) {
        make_move(&$pix_diff, $f);
    }
}

function make_move($pix_diff, $f) {
    global $pix_diff_average, $img;
    if (sizeof($pix_diff[$f]) > ceil($pix_diff_average)) {
        $f0 = $f==1 ? $fazes_qty : $f-1;
        if (sizeof($pix_diff[$f0]) > ceil($pix_diff_average)) {
            make_move($pix_diff, $f0);
        } else {
            $find = false;
            foreach ($pix_diff[$f] as $k=>$diff) {
                if (!$find) {
                    $attr_adr = 6144 + $diff['y']*32 + $diff['x'];
                    $attr = ord($img[$f0][$attr_adr]);
                    if ($attr == 63 || $attr == 0) {
                        $find = true;
                        $pix_diff[$f0][] = $diff;
                        unset($pix_diff[$f][$k]);
                    }
                }
            }
        }
    }
    
}

echo '<hr>';
for ($f=1; $f<=$fazes_qty; $f++) {
    echo 'pix diff f_' . $f. ' = ' . sizeof($pix_diff[$f]) . "\r\n";
}
$pix_diff_ch = array();
foreach ($pix_diff_chunk as $v=>$k) {
    $pix_diff_ch[$k] = $v;
}
$file = '';
for ($f=1; $f<=$fazes_qty; $f++) {
    $file .= "PIXDIFF_" . $f . "\r\n";
    while (sizeof($pix_diff[$f]) < ceil($pix_diff_average)) {
        $pix_diff[$f][] = $pix_diff[$f][0];
    }
    foreach ($pix_diff[$f] as $diff) {
        $file .= "\tDW\t" . $diff['adr'] . "\r\n";
        $file .= "\tDB\t" . $pix_diff_ch[$diff['chunk']] . "\r\n";
    }
}
file_put_contents('../demo/kernal/effects/12/generated/pixdiff.asm', $file);
//print_r($pix_diff_chunk);



//--- normalize pix diff

//---------------- RESULT
ksort($last_wait);
ksort($w_diff);
ksort($w_diff2);
echo 'last_wait: '; print_r($last_wait);
echo 'w_diff: '; print_r($w_diff);
echo 'w_diff2: '; print_r($w_diff2);
echo 'diff bcode lines: ' . sizeof($diff_lines_code) . "\r\n";
echo 'diff_scr_code: ' . sizeof($diff_scr_code) . "\r\n";
echo 'diff_top: ' .sizeof($diff_top) . "\r\n";
echo ';lines w_min = ' . $w_min . ', w_max = ' . $w_max . "\r\n";

function make_pop($code_ln) {
	$find = false;
	$code_ln2 = array();
	$i = 0;
	$w6 = 0;
	$imax = sizeof($code_ln);
	while ($i < $imax) {
		if (!$find) {
			if (strstr($code_ln[$i], 'W_')) {
				list ($tmp, $t) = explode('_', $code_ln[$i]);
				if ($t==10 || $t >=14) {
					$find = true;
					$code_ln2[] = 'POP HL';
					$t -= 10;
					if ($t != 0) {
						$code_ln[$i] = 'W_' . $t;
						$w6 += $t==6 ? 1 : 0;
					} else {
						unset($code_ln[$i]);
					}
				}
			}
		} elseif ($code_ln[$i] == 'W_6') {
			$w6++;
		}
		if (isset($code_ln[$i])) {
			$code_ln2[] = $code_ln[$i];
		}
		$i++;
	}
	return array (
		'code_ln' => $code_ln2,
		'w6' => $w6,
	);
}