<?
include '_classes/gigascreen.php';
$gigascreen = new gigascreen();

//echo '<pre>'; print_r($gigascreen);

$palette = array(
	0x0000CA,
	0x0073CA,
	0x00CACA,
	0x00CA73,
	0x73CA00,
	0xCACA00,
	0xCA7300,
	0xCA0000,
	0x730000,
	0x7300CA,
);
$palette_bg = array(
	0x000000,
	0x000073,
	0x0000CA,
);

$byte_size = 0;

$imgs = array();
$min_x = 99;
$max_x = 0;

$fazes_qty = 30;

//----- load images & calc statistics
$bg = imagecreatefrompng(__DIR__ . '/fx/color_sosiska/bg.png');
$bg_full = imagecreatefrompng(__DIR__ . '/fx/color_sosiska/bg-full-long.png');
for ($faze = 0; $faze < $fazes_qty; $faze++) {
	$imgs[$faze] = imagecreatefrompng(__DIR__ . '/fx/color_sosiska/fazes/' . sprintf('%02d', ($faze + 1)) . '.png');
	for ($y=0; $y<imagesy($imgs[$faze]); $y++) {
		$bs = 0;
		for ($x=0; $x<imagesy($imgs[$faze]); $x++) {
			$color = imagecolorat($imgs[$faze], $x, $y);
			if ($color != 0) {
				if (!in_array($color, $palette)) {
					die('color error');
				}
				if ($min_x > $x) { $min_x = $x; }
				if ($max_x < $x) { $max_x = $x; }
				$bs++;
			}
		}
		$byte_size += 2 + ceil($bs/2);
	}
}

echo 'Min-X: ' . $min_x . '<br>';
echo 'Max-X: ' . $max_x . '<br>';
echo 'Size-X: ' . ($max_x-$min_x+1) . '<br>';
echo 'byte_size: ~' . ($byte_size) . '<br>';

//----- 1152
$x0 = 6;
$y0 = 0;
$szx = 48;
$szy = 48;
$x_from = 99;
$x_to = 0;
$bg_full_dx = 16;
//----- prepare zx frames
$frames = array();
$frames_x = array();
foreach ($imgs as $faze=>$img) {
	$frames[$faze] = array();
	$frames_x[$faze] = array();
	for ($yy=0; $yy<$szy; $yy++) {
		$y = $y0 + $yy;
		$frames[$faze][$yy] = array();
		$frames_x[$faze][$yy] = array();
		$min_x = 99; $max_x = 0;
		for ($xx=0; $xx<ceil($szx/2); $xx++) {
			$x = $x0 + $xx*2;
			$idx0 = array_search(imagecolorat($img, $x, $y), $palette);
			$idx1 = array_search(imagecolorat($img, $x+1, $y), $palette);
			$idx0_bg = sizeof($palette) + array_search(imagecolorat($bg, $x, $y), $palette_bg);
			$idx1_bg = sizeof($palette) + array_search(imagecolorat($bg, $x+1, $y), $palette_bg);
			$i0 = $idx0!==false ? $idx0 : $idx0_bg;
			$i1 = $idx1!==false ? $idx1 : $idx1_bg;
			$frames[$faze][$yy][$xx] = $i0 + $i1*8;
			if ($idx0!==false or $idx1!==false) {
				if ($min_x > $xx) { $min_x = $xx; }
				if ($max_x < $xx) { $max_x = $xx; }
			}
		}
		$x_from = min($x_from, $max_x - $min_x + 1);
		$x_to = max($x_to, $max_x - $min_x + 1);
		$frames_x[$faze][$yy]['min_x'] = $min_x;
		$frames_x[$faze][$yy]['max_x'] = $max_x;
	}
}
//----- create preview images
$zoom = 4;
foreach ($imgs as $faze=>$img) {
	$preview = imagecreatetruecolor(imagesx($bg_full)*$zoom, $szy*$zoom);
	for ($y=0; $y<$szy; $y++) {
		for ($x=0; $x<imagesx($bg_full); $x++) {
			$color = imagecolorat($img, $x-$x0-$bg_full_dx, $y);
			if ($color == 0) {
				$color = imagecolorat($bg_full, $x, $y);
			}
			$clr = $color;
			imagefilledrectangle($preview, $x*$zoom, $y*$zoom, ($x+1)*$zoom, ($y+1)*$zoom, $clr);
		}
	}
	imagepng($preview, __DIR__ . '/fx/color_sosiska/preview/' . $faze . '.png');
}


//----- calc zx data
$fraw = fopen(__DIR__ . '/fx/color_sosiska/zx-data-raw.bin', 'wb');
$byte_size = 0;
foreach ($frames as $faze=>$frame) {
	$prev = $faze==0 ? sizeof($frames)-1 : $faze-1;
	$f = fopen(__DIR__ . '/fx/color_sosiska/zx-data/frame-' . $faze . '.bin', 'wb');
	for ($y=0; $y<$szy; $y++) {
		$min_x = min($frames_x[$faze][$y]['min_x'], $frames_x[$prev][$y]['min_x']);
		$max_x = max($frames_x[$faze][$y]['max_x'], $frames_x[$prev][$y]['max_x']);
		$byte_size += 2 + ($max_x - $min_x + 1);
		fwrite($f, chr($min_x));
		fwrite($f, chr($max_x - $min_x + 1));
		fwrite($fraw, chr($min_x));
		fwrite($fraw, chr($max_x - $min_x + 1));
		for ($x=$min_x; $x<=$max_x; $x++) {
			fwrite($f, chr($frames[$faze][$y][$x]));
			fwrite($fraw, chr($frames[$faze][$y][$x]));
		}
	}
	fclose($f);
}

echo '<hr>zx data byte size: ' . $byte_size . '<br>';
echo 'min x size: ' . $x_from . '<br>';
echo 'max x size: ' . $x_to . '<br>';
echo 'fazes: ' . $fazes_qty . '<br>';
?>
<html>
	<head>
		<style>
			img {
				border-top: <?=$zoom*16?>px solid black;
				border-bottom: <?=$zoom*11?>px solid black;
			}
			img.original {
				border-top: <?=$zoom*16?>px solid black;
				border-bottom: <?=$zoom*11?>px solid black;
			}
			a.button {
				border: 1px solid #808080;
				background-color: #d0d0d0;
				padding: 5px;
				margin: 0px 5px;
				cursor: pointer;
			}
		</style>
		<script>
			var frame = 0;
			var anim = false;
			function do_anim() {
				document.getElementById('preview').src = 'fx/color_sosiska/preview/' + frame + '.png';
			}
			function anim_stop() {
				if (anim != false) {
					clearInterval(anim);
				}
				anim = false;
			}
			function anim_start() {
				if (anim == false) {
					anim = window.setInterval(function(){
						do_anim();
						frame++;
						if (frame > <?=$fazes_qty-1?>) {
							frame = 0;
						}
					}, 40); //40 ~= 25fps
				}
			}
			setTimeout(function(){
				anim_start()
			}, 100);
			function anim_step_forward() {
				anim_stop();
				frame++;
				if (frame > <?=$fazes_qty-1?>) {
					frame = 0;
				}
				do_anim();
			}
			function anim_step_back() {
				anim_stop();
				frame--;
				if (frame < 0) {
					frame = <?=$fazes_qty-1?>;
				}
				do_anim();
			}			
		</script>
	</head>
	<body>
		<div><img id="preview" src="fx/color_sosiska/preview/0.png" /></div>
		<br />
		<div>
			<a class="button" onclick="anim_start()">start</a>
			<a class="button" onclick="anim_stop()">stop</a>
			<a class="button" onclick="anim_step_forward()">&#9654;</a>
			<a class="button" onclick="anim_step_back()">&#9664;</a>
		</div>
		
	</body>
</html>