<?
error_reporting(E_ALL);
echo '<pre>';
// use AND A and carry flag always off
// only one DEC RR or use LD SP,HL

$wait_arr = array(
	4 => 'NOP',
	5 => 'RET C',
	6 => 'DEC HL',	//LD SP,HL
	7 => 'OR 0',	//2b
	8 => 'NOP:NOP', 	//2b
	9 => 'NOP:RET C',	//2b
	10 => 'RET C:RET C', //2b
	11 => 'OR 0:NOP',	//3b
	12 => 'NOP:NOP:NOP', //3b
	13 => 'NOP:NOP:RET C', //3b
	14 => 'NOP:RET C:RET C', //3b
	15 => 'RET C:RET C:RET C', //3b
);
for ($i=16; $i<256; $i++) {
	$wait_arr[$i] = $wait_arr[$i-4] . ':NOP';
}

//--- return variants
$code_ret_arr = array(
	4 => array (
		'code' => 'JP (HL)',
		'precode' => true,
	),
	8 => array (
		'code' => 'NOP:JP (HL)',
		'precode' => true,
	),
	10 => array(
		'code' => 'RET',
		'precode' => true,
	),
	12 => array (
		'code' => 'NOP:NOP:JP (HL)',
		'precode' => true,
	),
);

$out_code_arr = array(
	0 => 'OUT (C),E',
	1 => 'OUT (C),D',
);

/*
    D - ink+ink
    E - pap+pap
    B - ink+pap
    C - ink+0
    A - pap+0

*/
$scr_code_arr = array(
    '11' => 'LD (HL),D: ',
    '55' => 'LD (HL),E: ',
    '51' => 'LD (HL),B: ',
    '10' => 'LD (HL),C: ',
    '50' => 'LD (HL),A: ',
);

$w_min = 224;
$w_max = 0;

$last_wait = array();
$w_diff = array();
$w_diff2 = array();

$diff_lines_code = array();
$diff_border = array();
$jp_top = array();
$jp_bottom = array();

$diff_scr_code = array();

$first_code_idx = array();
$first_scr_code_ln = array();

$img_mask = file_get_contents('fx/circles_man/circles_man_mask.img');

$fazes_qty = 4;
for ($f=1; $f<=$fazes_qty; $f++) {
    $img = imagecreatefrompng('fx/circles_man/' . $f . '.png');
    $img_scr = file_get_contents('fx/circles_man/' . sprintf('%02d', $f-1) . '.img');
	//--- calc top/bottom border
    for ($border = 0; $border < 2; $border++) {
        $y_from = $border==0 ? 0 : 64;
        $y_to = $border==0 ? 16 : 75;
        for ($y = $y_from; $y < $y_to; $y++) {
            $code_ln = array();
            $clr0 = (imagecolorat($img, 0, $y))==0 ? 0 : 1;
            $code_ln[] = $out_code_arr[$clr0];
            $tln = 12;
            $t = 0;
            $x = -1;
            while ($x < 106) {
                $xc = $x < 0 ? 0 : $x;
                $xc = $xc > 95 ? 95 : $xc;
                $clr = imagecolorat($img, $xc, $y)==0 ? 0 : 1;
                if ($clr != $clr0) {
                    if ($t != 0) {
                        $code_ln[] = 'W_' . $t;
                    }
                    $code_ln[] = $out_code_arr[$clr];
                    $clr0 = $clr;
                    $t = -12;
                }
                $t += 2;
                $tln += 2;
                $x++;
            }
            $t -= 2;
            $tw = $t;
            //---
            $w6 = 0;
            $flag_pop = false;
            if ($t==14 || $t >= 18) {
                $t -= 14;
                if ($t != 0) {
                    $code_ln[] = 'W_' . $t;
                }
                $code_ln[] = 'NOP:RET';
            } elseif ($t==8 || $t>=12) { //err
                $t -= 8;
                if ($t != 0) {
                    $code_ln[] = 'W_' . $t;
                }	
                $code_ln[] = 'NOP:JP (HL)';
                $make_pop = make_pop($code_ln);
                $code_ln = $make_pop['code_ln'];
                $w6 = $make_pop['w6'] + ($t==6 ? 1 : 0);
                $flag_pop = true;
            } elseif ($t==10) {
                $code_ln[] = 'RET';
            } else {
                if (!isset($last_wait[$t])) {
                    $last_wait[$t] = 0;
                }
                $last_wait[$t]++;
            }
            //---
            $code_line = '';
            foreach ($code_ln as $code) {
                if (strstr($code, 'W_')) {
                    list ($tmp, $t) = explode('_', $code);
                    if ($t != 0 && !isset($wait_arr[$t])) {
                        echo 'f=' . $f . ', y=' . $y . ', t=' . $t . '<br>';
                        echo '<pre>'; print_r($code_ln);
                        die();
                    }
                    $code_line .= "\t;" . $code . "\r\n";
                    $code_line .= "\t" . $wait_arr[$t] . "\r\n";
                } else {
                    $code_line .= "\t" . $code . "\r\n";
                }
            }
            $diff_border_idx = isset($diff_border[$code_line]) ? $diff_border[$code_line] : sizeof($diff_border);
            $diff_border[$code_line] = $diff_border_idx;
            for ($k=0; $k<4; $k++) {
                $jp = array(
                    'jp' => $diff_border_idx,
                    'flag_pop' => $flag_pop,
                    'w6' => $w6,
                );
                if ($border == 0) {
                    $jp_top[$f][] = $jp;
                } else {
                    $jp_bottom[$f][] = $jp;
                }
            }
        }
    }
    
	//--- calc scr first line
	$first_scr_code_ln[$f] = array();
	for ($i=0; $i<8; $i++) {
		$scr_code = "EXX:";
        for ($x=0; $x<4;$x++) {
			$bx = $i*4 + $x;
			$adr = 6912 + 6144 + $bx;
            $mask = isset($img_mask[$adr]) ? ord($img_mask[$adr]) : 0;
            if ($mask == 63 || $mask == 7) {
                $attr = 63 & ord($img_scr[$adr]);
                $ink = $attr & 7;
                $pap = ($attr >> 3) & 7;
                $attr_id = $ink . $pap;
                $scr_code .= $scr_code_arr[$attr_id];
            } else {
                $scr_code .= "OR 0:";
            }
            $scr_code .= $x==3 ? "INC HL:" : "INC L:";
        }
		$scr_code .= "\tJP LN_RET\r\n";
		$diff_scr_code_idx = isset($diff_scr_code[$scr_code]) ? $diff_scr_code[$scr_code] : sizeof($diff_scr_code);
		$diff_scr_code[$scr_code] = $diff_scr_code_idx;
		$first_scr_code_ln[$f][] = $diff_scr_code_idx;
		$first_code_idx[$diff_scr_code_idx] = true;
	}
    
    
	//--- calc screen + border
	for ($y = 16; $y < 64; $y++) {
        //--- calc screen
        $scr_code_ln = array();
		for ($i=0; $i<4; $i++) {
			$scr_code = "EXX:";
			for ($x=0; $x<4;$x++) {
				$bx = (($y%2)*16) + $i*4 + $x;
				$adr = 6912 + 6144 + floor(($y-16)/2 + 1)*32 + $bx;
				$mask = isset($img_mask[$adr]) ? ord($img_mask[$adr]) : 0;
				if (($mask == 63 || $mask == 7) && $y < 62) {
                    $attr = 63 & ord($img_scr[$adr]);
                    $ink = $attr & 7;
                    $pap = ($attr >> 3) & 7;
                    $attr_id = $ink . $pap;
					$scr_code .= $scr_code_arr[$attr_id];
				} else {
					$scr_code .= "OR 0:";
				}
				$scr_code .= $x==3 ? "INC HL:" : "INC L:";
			}
			$scr_code .= "JP LN_RET\r\n";
			$diff_scr_code_idx = isset($diff_scr_code[$scr_code]) ? $diff_scr_code[$scr_code] : sizeof($diff_scr_code);
			$diff_scr_code[$scr_code] = $diff_scr_code_idx;
			$scr_code_ln[] = $diff_scr_code_idx;
		}
        
        
        
		//--- calc left border
        $code_ln = array();
		$clr0 = (imagecolorat($img, 0, $y))==0 ? 0 : 1;
		$code_ln[] = $out_code_arr[$clr0];
		$tln = -2;
		$t = 0;
		$x = -1;
		while ($x < 16) {
			$xc = $x < 0 ? 0 : $x;
			$clr = imagecolorat($img, $xc, $y)==0 ? 0 : 1;
			if ($clr != $clr0) {
				if ($t != 0) {
					$code_ln[] = 'W_' . $t;
				}
				$code_ln[] = $out_code_arr[$clr];
				$clr0 = $clr;
				$t = -12;
			}
			$t += 2;
			$tln += 2;
			$x++;
		}
		if ($t != 0) {
			if ($t > 0) {
				if ($t == 2) {
					$code_ln[] = 'W_4';
					$t = -2;
				} else {
					$code_ln[] = 'W_' . $t;
					$t = 0;
				}
			} else {
				$tln -= $t;
				$x -= ($t/2);
				$t = 0;
			}
		}
		//echo '<pre>'; echo 'x=' . $x . ', t=' . $t . ', tln=' . $tln . '<br>'; print_r($code_ln);
		//--- calc right border
		$clr = (imagecolorat($img, 64+16, $y))==0 ? 0 : 1;
		if ($clr0 != $clr) {
			$code_ln[] = $out_code_arr[$clr];
			$clr0 = $clr;
			$tln += 12;
			$x += 6;
		}
		while ($x < 96) {
			$xc = $x < 80 ? 80 : $x;
			$clr = imagecolorat($img, $xc, $y)==0 ? 0 : 1;
			if ($clr != $clr0) {
				if ($t != 0) {
					$code_ln[] = 'W_' . $t;
				}
				$code_ln[] = $out_code_arr[$clr];
				$clr0 = $clr;
				$t = -12;
			}
			$t += 2;
			$tln += 2;
			$x++;
		}
		if ($t != 0) {
			if ($t < 0) {
				$tln -= $t;
				$x -= ($t/2);
				$t = 0;
			}
		}
		$tln += 14;
		$t += 224 - $tln;
		$code_ln_bkp = $code_ln;
		$code_ln_bkp[] = 'W_' . $t;
		//echo '<pre>'; echo 'x=' . $x . ', t=' . $t . ', tln=' . $tln . '<br>'; print_r($code_ln);

		//--- normalize waits ???
		for ($i=0; $i<sizeof($code_ln);$i++) {
			if (isset($code_ln[$i+1]) && strstr($code_ln[$i], 'W_') && strstr($code_ln[$i+1], 'W_')) {
				list ($tmp, $tw1) = explode('_', $code_ln[$i]);
				list ($tmp, $tw2) = explode('_', $code_ln[$i+1]);
				$code_ln[$i+1] = 'W_' . ($tw1 + $tw2);
				unset($code_ln[$i]);
			}
		}
		$code_ln = array_values($code_ln);
		//--- line ret
		$w6 = 0;
		$flag_pop = false;
		if ($t==14 || $t >= 18) {
			$t -= 14;
			if ($t != 0) {
				$code_ln[] = 'W_' . $t;
			}
			$code_ln[] = 'NOP:RET';
		} elseif ($t==8 || $t>=12) { //err
			$t -= 8;
			if ($t != 0) {
				$code_ln[] = 'W_' . $t;
			}	
			$code_ln[] = 'NOP:JP (HL)';
			$make_pop = make_pop($code_ln);
			$code_ln = $make_pop['code_ln'];
			$w6 = $make_pop['w6'] + ($t==6 ? 1 : 0);
			$flag_pop = true;
		} elseif ($t==10) {
			$code_ln[] = 'RET';
		} else {
			if (!isset($last_wait[$t])) {
				$last_wait[$t] = 0;
			}
			$last_wait[$t]++;
		}

		//--- make line
		$code_line = '';
		foreach ($code_ln as $code) {
			if (strstr($code, 'W_')) {
				list ($tmp, $t) = explode('_', $code);
				if ($t >= 110) {
					if (!isset($w_diff[$t])) {
						$w_diff[$t] = 0;
					}
					$w_diff[$t]++;
					$w_min = $t<$w_min ? $t : $w_min;
					$w_max = $t>$w_max ? $t : $w_max;
					$code_line .= "\tLD IX,[LINE_RET_IX]:RET NC\r\n";
					$code_line .= "[LINE_RET]";
					$t -= 110;
				}
				if ($t != 0 && !isset($wait_arr[$t])) {
					echo 'f=' . $f . ', y=' . $y . ', t=' . $t . '<br>';
					echo '<pre>'; print_r($code_ln);
					echo '<pre>'; print_r($code_ln_bkp);
					die('make line error');
				}
				if ($t != 0) {
					if (!isset($w_diff2[$t])) {
						$w_diff2[$t] = 0;
					}
					$w_diff2[$t]++;
					$code_line .= "\t;W_" . $t . "\r\n";
					$code_line .= "\t" . $wait_arr[$t] . "\r\n";
				}
			} else {
				$code_line .= "\t" . $code . "\r\n";
			}
		}
		$code_line_idx = isset($diff_lines_code[$code_line]) ? $diff_lines_code[$code_line] : sizeof($diff_lines_code);
		$diff_lines_code[$code_line] = $code_line_idx;
		for ($k=0; $k<4; $k++) {
			$fazes_jp[$f][] = array(
				'line' => $code_line_idx,
				'flag_pop' => $flag_pop,
				'w6' => $w6,
				'scr_code_ln' => $scr_code_ln[$k],
			);
		}
        
    }
}

echo ';lines w_min = ' . $w_min . ', w_max = ' . $w_max . "\r\n";
echo 'diff_border: ' .sizeof($diff_border) . "\r\n";
echo 'diff_lines_code: ' .sizeof($diff_lines_code) . "\r\n";
echo 'diff_scr_code: ' .sizeof($diff_scr_code) . "\r\n";


ksort($last_wait);
ksort($w_diff);
ksort($w_diff2);
echo 'last_wait: '; print_r($last_wait);
echo 'w_diff: '; print_r($w_diff);
echo 'w_diff2: '; print_r($w_diff2);


//--- save borders diff code
$file = '';
foreach ($diff_border as $code=>$idx) {
	$file .= "BLNX_" . $idx . "\r\n";
	$file .= $code . "\r\n";
}
file_put_contents('../demo/kernal/effects/15/generated/diff_border.asm', $file);
//--- save borders diff_lines_code
$file = '';
foreach ($diff_lines_code as $line_code=>$line_code_idx) {
    $file .= "BLINE_" . $line_code_idx . " ;----------------------------\r\n";
	$line_code = str_replace('[LINE_RET]', 'LCR_' . $line_code_idx . "\r\n" , $line_code);
	$line_code = str_replace('[LINE_RET_IX]', 'LCR_' . $line_code_idx , $line_code);
    $file .= $line_code;
}
file_put_contents('../demo/kernal/effects/15/generated/diff_lines_code.asm', $file);
//--- save diff_scr_code
$file = '';
foreach ($diff_scr_code as $code=>$idx) {
	if (isset($first_code_idx[$idx])) {
		$file .= "XSCR_" . $idx . "\tPOP IX\r\n";
	}
	$file .= "SCR_" . $idx . "\r\n";
	$file .= "\t" . $code . "\r\n";
}
file_put_contents('../demo/kernal/effects/15/generated/diff_scr_code.asm', $file);


//---------- JP TABLE
foreach ($fazes_jp as $f=>$jp) {
	$fazes_jp_file = "FAZEJP" . $f . "\r\n";
    //--- first line code
	foreach ($first_scr_code_ln[$f] as $code) {
		$fazes_jp_file .= "\tDW\tXSCR_" . $code . "\r\n";
	}
    //--- top border
	$w6_top = 0;
    $flag_pop_prev = 0;
	$imax = sizeof($jp_top[$f]);
	for ($i=0; $i<$imax; $i++) {
		$fazes_jp_file .= "\tDW\tBLNX_" . $jp_top[$f][$i]['jp'] . " + " . $w6_top . "\r\n";
		$w6_top = $jp_top[$f][$i]['w6'];
	}
    //--- screen
	$imax = sizeof($jp);
	for ($i=0; $i<$imax; $i++) {
		if ($i%4 == 0) {
			$fazes_jp_file .= ";-------- ln " . floor($i/4) . "\r\n";
		}
		if (!$flag_pop_prev) {
			$fazes_jp_file .= "\tDW\tBLINE_" . $jp[$i]['line'] . " + " . $w6_top . "\r\n";
			$w6_top = 0;
		}
		//---
		if ($jp[$i]['flag_pop']) {
			if (isset($jp[$i+1])) {
				$fazes_jp_file .= "\tDW\tBLINE_" . $jp[$i+1]['line'] . " + " . $jp[$i]['w6'] . "\r\n";	
			} else {
                $fazes_jp_file .= ";----- bottom\r\n";
				$fazes_jp_file .= "\tDW\tBLNX_" . $jp_bottom[$f][0]['jp'] . " + " . $jp[$i]['w6'] . "\r\n";
			}
		}
		//---
		$fazes_jp_file .= "\tDW\tSCR_" . $jp[$i]['scr_code_ln'] . "\r\n";
		//---
		$flag_pop_prev = $jp[$i]['flag_pop'];
	}
    //--- bottom border
    $w6_bott = 0;
    $imax = sizeof($jp_bottom[$f]);
	for ($i=($flag_pop_prev ? 1 : 0); $i<$imax; $i++) {
		$fazes_jp_file .= "\tDW\tBLNX_" . $jp_bottom[$f][$i]['jp'] . " + " . $w6_bott . "\r\n";
		$w6_bott = $jp_bottom[$f][$i]['w6'];
	}
    //--- ret
    $fazes_jp_file .= "\tDW\tFRAME_RET + " . $w6_bott . "\r\n";
    file_put_contents('../demo/kernal/effects/15/generated/fazejp' . $f . '.asm', $fazes_jp_file);
}








function make_pop($code_ln) {
	$find = false;
	$code_ln2 = array();
	$i = 0;
	$w6 = 0;
	$imax = sizeof($code_ln);
	while ($i < $imax) {
		if (!$find) {
			if (strstr($code_ln[$i], 'W_')) {
				list ($tmp, $t) = explode('_', $code_ln[$i]);
				if ($t==10 || $t >=14) {
					$find = true;
					$code_ln2[] = 'POP HL';
					$t -= 10;
					if ($t != 0) {
						$code_ln[$i] = 'W_' . $t;
						$w6 += $t==6 ? 1 : 0;
					} else {
						unset($code_ln[$i]);
					}
				}
			}
		} elseif ($code_ln[$i] == 'W_6') {
			$w6++;
		}
		if (isset($code_ln[$i])) {
			$code_ln2[] = $code_ln[$i];
		}
		$i++;
	}
	return array (
		'code_ln' => $code_ln2,
		'w6' => $w6,
	);
}