<?
error_reporting(E_ALL);
ini_set('display_errors', true);
//------------------------------- part 0
//--- create BG colors
$pal_bg = array(
	//--- bg in smooth
	0x730073 => 'XCLR00',
	//--- bg
	0x00006D => 'XCLR0',
	0x7300CA => 'XCLR1',
	0xCA00CA => 'XCLR2',
	0xCA7300 => 'XCLR3',
	0xCACA00 => 'XCLR4',
	0xFFFFFF => 'XCLR5',
	//--- shadow
	0x000036 => 'XsCLR0',
	0x390065 => 'XsCLR1',
	0x650065 => 'XsCLR2',
	0x653900 => 'XsCLR3',
	0x656500 => 'XsCLR4',
	
);
for ($i=0; $i<8; $i++) {
	$codeA = "BOARD_BG" . $i . "A\r\n";
	$codeB = "BOARD_BG" . $i . "B\r\n";
	$img = imagecreatefrompng("../demo/gfx_concept/board_balls/bg-amin-frames/" . sprintf('%02d', $i) . ".png");
	for ($y=43; $y<43+21; $y++) {
		for ($x=0; $x<32; $x++) {
			$bx = 16 + $x*2;
			$color0 = imagecolorat($img, $bx, $y);
			$color1 = imagecolorat($img, $bx+1, $y);
			$color0_idx = $pal_bg[$color0];
			$color1_idx = $pal_bg[$color1];
			$codeA .= "\tDB\t8 * " . $color0_idx . "A + " . $color1_idx . "A\r\n";
			$codeB .= "\tDB\t8 * " . $color0_idx . "B + " . $color1_idx . "B\r\n";
		}
	}
	file_put_contents("../demo/kernal/effects/07/board_bg/board_bg_" . $i . "A.asm", $codeA);
	file_put_contents("../demo/kernal/effects/07/board_bg/board_bg_" . $i . "B.asm", $codeB);
}

//------------------------------- part 1
//----------------- blue
$pal = array(
	0 => 0,
	0x000073 => 1,
	0x0000CA => 2,
	0x0073CA => 3,
	0x00CACA => 4,
	0xFFFFFF => 5,
	0xCACACA => 99,
);
$pal_zx = array(
	0 => array(0, 0),
	1 => array(0, 1),
	2 => array(1, 1),
	3 => array(1, 5),
	4 => array(5, 5),
	5 => array(7, 7),
);
$code = '';
fn_make_shar('BLUE', 'ball_blue-small.png', $pal, $pal_zx, 0, $code);
//echo '<pre>' . $code;

//----------------- red
$pal = array(
	0 => 0,
	0x730000 => 1,
	0xCA0000 => 2,
	0xCA7300 => 3,
	0xCA7373 => 4,
	0xFFFFFF => 5,
	0xCACACA => 99,
);
$pal_zx = array(
	0 => array(0, 0),
	1 => array(0, 2),
	2 => array(2, 2),
	3 => array(2, 6),
	4 => array(2, 7),
	5 => array(7, 7),
);
$code = '';
fn_make_shar('RED', 'ball_red-small.png', $pal, $pal_zx, 1, $code);
//echo '<pre>' . $code;

//----------------- green
$pal = array(
	0 => 0,
	0x007300 => 1,
	0x00CA00 => 2,
	0x73CA73 => 3,
	0xFFFFFF => 4,
	0xCACACA => 99,
);
$pal_zx = array(
	0 => array(0, 0),
	1 => array(0, 4),
	2 => array(4, 4),
	3 => array(4, 7),
	4 => array(7, 7),
);
$code = '';
fn_make_shar('GREEN', 'ball_green-small.png', $pal, $pal_zx, 2, $code);
//echo '<pre>' . $code;


//------------------------------- part 2
//----------------- generate sin
make_sin(23, 'blue');
make_sin(16, 'red');
make_sin(12, 'green');

function make_sin($r, $name) {
	$f = fopen("../demo/kernal/effects/07/sin_" . $name . ".bin", "w");
	for ($i=0; $i<256; $i++) {
		$val = round($r - $r * sin($i*Pi()/256));
		fputs($f, chr($val));
	}
	fclose($f);	
}



$wait_arr = array(
	4 => 'NOP',
	5 => 'RET C',
	6 => 'DEC BC',
	7 => 'OR 0',
	8 => 'NOP:NOP',
	9 => 'LD R,A',
	10 => 'NOP:DEC BC',
	11 => 'NOP:OR 0',
	12 => 'DEC BC:DEC BC',
	13 => 'DEC BC:OR 0',
	14 => 'DEC BC:NOP:NOP',
	15 => 'LD R,A:DEC BC',
	16 => 'NOP:NOP:NOP:NOP',
	17 => 'LD R,A:NOP:NOP',
	18 => 'DEC BC:DEC BC:DEC BC',
);

//------------------------------- part 3
//blue = 7856, red = 4716, green = 2948

//LDI = 864 top + 672 bottom (some line has only one const color)
// 864 = 771 + 93 = 768 + 96
// 672 = 771 - 99 = 768 - 96

// top_A_96 + top_A_672 + top_A_96	;104
// top_B_96 + top_B_672 + top_B_96	;104
// bot_B_96 + bot_A_672 + bot_B_96 	;104
// ... only 504 bot_B


make_board_ldi(672);


//--- generate board + blue
$shar = '';
$shar .= file_get_contents("../demo/kernal/effects/07/shar_code_small_blue.asm"); //7047
$shar .= "\r\n" . file_get_contents("../demo/kernal/effects/07/shar_code_small_red.asm"); //4528
$shar .= "\r\n" . file_get_contents("../demo/kernal/effects/07/shar_code_small_green.asm"); //2474
make_board_shar('board_shar', $shar);

function make_board_shar($filename, $shar) {
	global $wait_arr;
	$board = file_get_contents("../demo/kernal/effects/07/board.asm");
	$board = explode("\r\n", $board);
	$board_t = $board_t_effective = 0;
	$board_free = array();
	foreach ($board as $idx=>$board_ln) {
		if ($i = strpos($board_ln, ";free")) {
			$t = (int)substr($board_ln, $i+5);
			$board_free[] = array('t' => $t, 'idx' => $idx+1);
			$board_t += $t;
			$board_t_effective += $t>=16 && $t!=17 && $t!=18 && $t!=19 ? $t : 0;
		}
	}
	$shar = explode("\r\n", $shar);
	$shar_arr = array();
	$board_free_idx = 0;
	$bf_used_t = 0;
	$bf_t = $board_free[$board_free_idx]['t'];
	$code = array("\t;--- CODE_BEGIN\r\n\tEXX\t;4");
	$shar_idx = 0;
	while (isset($shar[$shar_idx])) {
		$shar_ln = $shar[$shar_idx];
		if ($i = strpos($shar_ln, "\t;")) {
			$t = (int)substr($shar_ln, $i+2);
			$diff_t = $bf_t - $t;
			if ($diff_t >= 0 && $diff_t!=1 && $diff_t!=2 && $diff_t!=3) {
				$code[] = $shar_ln;
				$bf_t -= $t;
				$bf_used_t += $t;
				$shar_idx++;
			} else {
				if ($bf_t != 0) {
					$code[]	= "\t" . $wait_arr[$bf_t] . "\t;" . $bf_t;
					$bf_used_t += $bf_t;
				}
				$code[] = "\tEXX\t;4\r\n\t;--- CODE_END";
				//--- save code
				$board_idx = $board_free[$board_free_idx]['idx'];
				//echo $board_idx . '<br>';
				$board[$board_idx] = implode("\r\n", $code);
				//--- next ln
				$code = array("\t;--- CODE_BEGIN\r\n\tEXX\t;4");
				$board_free_idx++;
				if (!isset($board_free[$board_free_idx])) {
					die('<br><br>ERROR: NO FREE TAKTS');
				}
				$bf_t = $board_free[$board_free_idx]['t'];
			}
		} else {
			$shar_idx++;
		}
	}
	$content = '';
	$content .= ';board all free takts: ' . $board_t . "\r\n";
	$content .= ';board effective free takts: ' . $board_t_effective . "\r\n";
	$content .= ';bf_used_t: ' . $bf_used_t . "\r\n";
	$content .= ';bf unused free t: ' . ($board_t -= $bf_used_t) . "\r\n";
	$content .= "\r\n" . implode("\r\n", $board);
	echo '<pre>' . $content;
	file_put_contents("../demo/kernal/effects/07/" . $filename . ".asm", $content);
	
}

function make_board_ldi($limit = 0) {
	global $wait_arr;
	$board = file_get_contents("../demo/kernal/effects/07/board.asm");
	$board = explode("\r\n", $board);
	$board_t = $board_t_effective = 0;
	$board_free = array();
	foreach ($board as $idx=>$board_ln) {
		if ($i = strpos($board_ln, ";free")) {
			$t = (int)substr($board_ln, $i+5);
			$board_free[$idx+1] = $t;
			$board_t += $t;
			$board_t_effective += $t>=16 && $t!=17 && $t!=18 && $t!=19 ? $t : 0;
		}
	}
	$ldi_total_qty = 0;
	foreach ($board_free as $idx=>$t) {
		$code = array();
		while ($t >= 16 && $t!=17 && $t!=18 && $t!=19) {
			$ldi_total_qty++;
			if ($limit >= $ldi_total_qty) {
				$code[] = "LDI";
			} else {
				$code[] = "NOP:NOP:NOP:NOP";
			}
			$t -= 16;
		}
		if ($t != 0) {
			$code[] = $wait_arr[$t];
		}
		$code_ln = "\t;--- CODE_BEGIN\r\n\tEXX\t;4\r\n";
		$code_ln .= "\t" . implode(":", $code) . "\r\n";
		$code_ln .= "\tEXX\t;4\r\n\t;--- CODE_END";
		$board[$idx] = $code_ln;
	}
	
	echo 'board all free takts: ' . $board_t . '<br>';
	echo 'board effective free takts: ' . $board_t_effective . '<br>';
	echo 'ldi_total_qty: ' . $ldi_total_qty . '<br>';
	file_put_contents("../demo/kernal/effects/07/board_ldi.asm", implode("\r\n", $board));
}

function fn_make_shar($shar_color, $filename, $pal, $pal_zx, $c, &$code) {
	$transparent = 0xCACACA;
	$img = imagecreatefrompng("../demo/gfx_concept/board_balls/balls/" . $filename);
	$x_len = ceil(imagesx($img) / 2);
	$y_len = imagesy($img);
	//--- make pal
	/*$code .= ";--- color definition\r\n";
	foreach ($pal_zx as $k=>$clr) {
		$code .= "S".$c."C" . $k . "A\tEQU\t" . $clr[0] . "\r\n";
		$code .= "S".$c."C" . $k . "B\tEQU\t" . $clr[1] . "\r\n";
		$code .= ";---\r\n";
	}*/
	//--- make img
	$code_a = $code_b = array();
	$add_begin = 0;
	for ($y=0; $y<$y_len; $y++) {
		$code_a_ln = $code_b_ln = array();
		for ($x=0; $x<$x_len; $x++) {
			$bx = $x * 2;
			$color0 = imagecolorat($img, $bx, $y);
			$color1 = imagecolorat($img, $bx + 1, $y);
			$color0_idx = $pal[$color0];
			$color1_idx = $pal[$color1];
			if ($color0 != $transparent && $color1 != $transparent) {
				$code_a_ln[] = array(
					'code' => "\tLD\t(HL), 8 * S".$c."C" . $color0_idx . "A + S".$c."C" . $color1_idx . "A\r\n",
					't' => 10,
				);
				$code_a_ln[] = array(
					'code' => "\tINC\tL\r\n",
					't' => 4,
				);
				$code_b_ln[] = array(
					'code' => "\tLD\t(HL), 8 * S".$c."C" . $color0_idx . "B + S".$c."C" . $color1_idx . "B\r\n",
					't' => 10,
				);
				$code_b_ln[] = array(
					'code' => "\tINC\tL\r\n",
					't' => 4,
				);
			} elseif ($color0 == $transparent && $color1 == $transparent) {
				if ($y != 0) {
					$code_a_ln[] = array(
						'code' => "\tINC\tL\r\n",
						't' => 4,
					);
					$code_b_ln[] = array(
						'code' => "\tINC\tL\r\n",
						't' => 4,
					);
				} elseif (sizeof($code_a_ln) == 0) {
					$add_begin++;
				}
			} else {
				$mask = $color0 == $transparent ? 7*8 : 7;
				$colorA = $color0 == $transparent ? "S".$c."C" . $color1_idx . "A" : "8 * S".$c."C" . $color0_idx . "A";
				$colorB = $color0 == $transparent ? "S".$c."C" . $color1_idx . "B" : "8 * S".$c."C" . $color0_idx . "B";
				$code_a_ln[] = array(
					'code' => "\tLD\tA,(HL)\r\n",
					't' => 7,
				);
				$code_a_ln[] = array(
					'code' => "\tAND\t" . $mask . "\r\n",
					't' => 7,
				);
				$code_a_ln[] = array(
					'code' => "\tOR\t" . $colorA . "\r\n",
					't' => 7,
				);
				$code_a_ln[] = array(
					'code' => "\tLD\t(HL),A\r\n",
					't' => 7,
				);
				$code_a_ln[] = array(
					'code' => "\tINC\tL\r\n",
					't' => 4,
				);
				//---
				$code_b_ln[] = array(
					'code' => "\tLD\tA,(HL)\r\n",
					't' => 7,
				);
				$code_b_ln[] = array(
					'code' => "\tAND\t" . $mask . "\r\n",
					't' => 7,
				);
				$code_b_ln[] = array(
					'code' => "\tOR\t" . $colorB . "\r\n",
					't' => 7,
				);
				$code_b_ln[] = array(
					'code' => "\tLD\t(HL),A\r\n",
					't' => 7,
				);
				$code_b_ln[] = array(
					'code' => "\tINC\tL\r\n",
					't' => 4,
				);				
			}
		}
		$code_a[$y] = $code_a_ln;
		$code_b[$y] = $code_b_ln;
	}
	$code_a_ext = $code_b_ext = array();
	for ($y=0; $y<$y_len; $y++) {
		//--- a
		$add = 32 - $x_len + ($y==0 ? $add_begin : 0);
		$sz = sizeof($code_a[$y]);
		$flag = true;
		$code_a[$y] = array_values($code_a[$y]);
		for ($i=$sz-1; $i>=0; $i--) {
			if ($flag && $code_a[$y][$i]['code'] == "\tINC\tL\r\n") {
				unset($code_a[$y][$i]);
				$add++;
			} else {
				$flag = false;
			}
		}
		if ($y != $y_len - 1) {
			$sz = sizeof($code_a[$y+1]);
			$flag = true;
			for ($i=0; $i<=$sz; $i++) {
				if ($flag && $code_a[$y+1][$i]['code'] == "\tINC\tL\r\n") {
					unset($code_a[$y+1][$i]);
					$add++;
				} else {
					$flag = false;
				}
			}
		}
		if ($y != $y_len - 1) {
			$code_a[$y] = array_values($code_a[$y]);
			$code_a[$y][] = array(
				'code' => "\tLD\tE," . $add . "\r\n",
				't' => 7,
			);
			$code_a[$y][] = array(
				'code' => "\tADD\tHL,DE\r\n",
				't' => 11,
			);
		}
		//--- b
		$add = 32 - $x_len + ($y==0 ? $add_begin : 0);
		$sz = sizeof($code_b[$y]);
		$flag = true;
		$code_b[$y] = array_values($code_b[$y]);
		for ($i=$sz-1; $i>=0; $i--) {
			if ($flag && $code_b[$y][$i]['code'] == "\tINC\tL\r\n") {
				unset($code_b[$y][$i]);
				$add++;
			} else {
				$flag = false;
			}
		}
		if ($y != $y_len - 1) {
			$sz = sizeof($code_b[$y+1]);
			$flag = true;
			for ($i=0; $i<=$sz; $i++) {
				if ($flag && $code_b[$y+1][$i]['code'] == "\tINC\tL\r\n") {
					unset($code_b[$y+1][$i]);
					$add++;
				} else {
					$flag = false;
				}
			}
		}
		$code_b[$y] = array_values($code_b[$y]);
		if ($y != $y_len - 1) {
			$code_b[$y][] = array(
				'code' => "\tLD\tE," . $add . "\r\n",
				't' => 7,
			);
			$code_b[$y][] = array(
				'code' => "\tADD\tHL,DE\r\n",
				't' => 11,
			);
		}
	}
	//---
	$t = 0;
	$code .= ";----------------------------------\r\n";
	$code .= "\tLD\tHL,SIN_" . $shar_color . "_SCR\t;10\r\n";
	$code .= "SHAR_" . $shar_color . "_ADR_0 EQU $-2\t;0\r\n";
	foreach ($code_a as $y=>$code_ln) {
		$code .= ";------- line A - " . $y . "\r\n";
		foreach ($code_ln as $cln) {
			$code .= str_replace("\r\n", "\t\t;" . $cln['t'] . "\r\n", $cln['code']);
			$t += $cln['t'];
		}
	}
	$code .= ";----------------------------------\r\n";
	$code .= "\tLD\tHL,SIN_" . $shar_color . "_SCR - 1536\t;10\r\n";
	$code .= "SHAR_" . $shar_color . "_ADR_1 EQU $-2\t;0\r\n";
	foreach ($code_b as $y=>$code_ln) {
		$code .= ";------- line B - " . $y . "\r\n";
		foreach ($code_ln as $cln) {
			$code .= str_replace("\r\n", "\t\t;" . $cln['t'] . "\r\n", $cln['code']);
			$t += $cln['t'];
		}
	}
	echo $shar_color . ' takts ~ ' . ($t+20) . '<hr>';
	$code .= ";total takts ~ " . ($t+20) . "\r\n";
	file_put_contents("../demo/kernal/effects/07/shar_code_small_" . strtolower($shar_color) . ".asm", $code);
}