<?
class mgs {

	const SIZE_8X1 = 1;
	const SIZE_8X2 = 2;
	const SIZE_8X4 = 4;
	const SIZE_8X8 = 8;

	public $version = 1;
	public $char_size = 8;
	public $border_color_0 = 0;
	public $border_color_1 = 0;
	public $bitplan0 = array(); // 6144 bytes linear
	public $bitplan1 = array();
	public $attr0 = array(); // 6144 / 3072 / 1536 / 768 bytes
	public $attr1 = array();
	
	private $img_palette;
	private $bitmask = array(128,64,32,16,8,4,2,1);
	private $palette;
	
	private $prepared_attr = array();
	private $img;
	private $masked_rgb = array(
		0 => array(255,200,200),
		1 => array(255,210,210),
		2 => array(255,220,220),
		3 => array(255,230,230),
	);
	private $masked_colors;
	
	public $e_bits;
	public $e_bits_bin = array();
	public $e_attr = array();
	public $e_attr2 = array();
	
	
	public function __construct() {
		$this->img_palette = imagecreatefrompng(__DIR__ . '\gigacolors.png');
		$this->palette = array();
		for ($c0=0; $c0<16; $c0++) {
			for ($c1=0; $c1<16; $c1++) {
				$this->palette[$c0][$c1] = $this->getRGB(imagecolorat($this->img_palette, $c0, $c1));
			}
		}
	}

	public function openFile($filename = false) {
		if ($filename && file_exists($filename)) {
			$bin = file_get_contents($filename);
			$this->openBin($bin);
		}
	}


	public function getStreamBin(&$bin, &$idx, $len) {
		$idx += $len;
		return substr($bin, $idx-$len, $len);
	}

	public function openBin($bin) {
		$idx = 0;
		//--- read header
		$mgs_ident = $this->getStreamBin($bin, &$idx, 3);
		if ($mgs_ident != 'MGS' && $mgs_ident != 'MGH') {
			die('WRONG FILE STRUCTURE');
		}
		$this->version = ord($this->getStreamBin($bin, &$idx, 1));
		$this->char_size = ord($this->getStreamBin($bin, &$idx, 1));
		if ($this->version >= 1) {
			$this->border_color_0 = ord($this->getStreamBin($bin, &$idx, 1));
			$this->border_color_1 = ord($this->getStreamBin($bin, &$idx, 1));
		}
		if ($mgs_ident == 'MGH') {
			$idx = 256;
		}
		//--- read bit data
		for ($i=0; $i<6144; $i++) {
			$this->bitplan0[] = ord($this->getStreamBin($bin, &$idx, 1));
		}
		for ($i=0; $i<6144; $i++) {
			$this->bitplan1[] = ord($this->getStreamBin($bin, &$idx, 1));
		}
		//--- read attr data
		$attr_len = 6144 / $this->char_size;
		for ($i=0; $i<$attr_len; $i++) {
			$this->attr0[] = ord($this->getStreamBin($bin, &$idx, 1));
		}
		for ($i=0; $i<$attr_len; $i++) {
			$this->attr1[] = ord($this->getStreamBin($bin, &$idx, 1));
		}
	}
	
	public function getAttrColor($y, $x) {
		$attr_adr = $y*32 + $x;
		$c0 = (int)$this->attr0[$attr_adr];
		$c1 = (int)$this->attr1[$attr_adr];
		$br0 = ($c0 & 64) == 0 ? 0 : 1;
		$br1 = ($c1 & 64) == 0 ? 0 : 1;

		$cx0 = 2*(floor($c0/8) & 7) + $br0;
		$cx1 = 2*($c0 & 7) + $br0;
		$cy0 = 2*(floor($c1/8) & 7) + $br1;
		$cy1 = 2*($c1 & 7) + $br1;

		$colors = array();
		$colors[0] = $this->palette[$cx0][$cy0];
		$colors[1] = $this->palette[$cx1][$cy0];
		$colors[2] = $this->palette[$cx0][$cy1];
		$colors[3] = $this->palette[$cx1][$cy1];
		return $colors;
	}

	public function getColorAt($x, $y, $params=array()) {
		$params = array_merge(array(
			'masked' => true,
		),$params);
		
		$colors = array();
		$cx = floor($x/8);
		$cy = (floor($y/$this->char_size));
		$c0 = (int)$this->attr0[$cy*32 + $cx];
		$c1 = (int)$this->attr1[$cy*32 + $cx];
		$br0 = ($c0 & 64) == 0 ? 0 : 1;
		$br1 = ($c1 & 64) == 0 ? 0 : 1;
		
		$cx0 = 2*(floor($c0/8) & 7) + $br0;
		$cx1 = 2*($c0 & 7) + $br0;
		$cy0 = 2*(floor($c1/8) & 7) + $br1;
		$cy1 = 2*($c1 & 7) + $br1;

		$colors[0] = $this->palette[$cx0][$cy0];
		$colors[1] = $this->palette[$cx1][$cy0];
		$colors[2] = $this->palette[$cx0][$cy1];
		$colors[3] = $this->palette[$cx1][$cy1];

		if ($params['masked']) {
			$colors = array(array(255,200,200), array(255,210,210), array(255,220,220), array(255,230,230));
		}
		$bit = $x % 8;
		$x = floor($x/8);
		$adr = $x + 256*($y&7) + 32*(7 & floor($y/8)) + 8*256*(floor($y/64));
		$byte0 = (int)$this->bitplan0[$adr];
		$byte1 = (int)$this->bitplan1[$adr];
		$pix0 = (bool)($byte0 & $this->bitmask[$bit]);
		$pix1 = (bool)($byte1 & $this->bitmask[$bit]);
		$rgb = $colors[2 * $pix1 + $pix0];
		return $rgb;
	}
	
	private function getRGB($rgb) {
		$r = ($rgb >> 16) & 0xFF;
		$g = ($rgb >> 8) & 0xFF;
		$b = $rgb & 0xFF;
		$ret = array($r, $g, $b);
		return $ret;
	}
	
	private function png_key($param) {
		return $param['size'];
	}

	/*--- render to png image ---*/
	public function render($param = array()) {
		$param = array_merge(array(
				'size' => 1,
				'with_border' => false,
			), $param
		);
		$this->img = imagecreatetruecolor(256 * $param['size'], 192 * $param['size']);
		$this->masked_colors = array();
		for ($c=0; $c<4; $c++) {
			$this->masked_colors[$c] = imagecolorallocate($this->img, $this->masked_rgb[$c][0], $this->masked_rgb[$c][1], $this->masked_rgb[$c][2]);
		}
		//--- prepare attr for render
		$prepared_attr = array();
		$ysize = floor(192/$this->char_size);
		for ($y=0; $y<$ysize; $y++) {
			$prepared_attr[$y] = array();
			for ($x=0; $x<32; $x++) {
				$colors = $this->getAttrColor($y, $x);
				$prepared_attr[$y][$x] = array(
					'rgb' => $colors,
					'colors' => array(
						0 => imagecolorallocate($this->img, $colors[0][0], $colors[0][1], $colors[0][2]),
						1 => imagecolorallocate($this->img, $colors[1][0], $colors[1][1], $colors[1][2]),
						2 => imagecolorallocate($this->img, $colors[2][0], $colors[2][1], $colors[2][2]),
						3 => imagecolorallocate($this->img, $colors[3][0], $colors[3][1], $colors[3][2]),
					)
				);
			}
		}
		//--- render bitplan
		$e_bits_bytes = 0;
		$e_bits_chars = 0;
		$this->e_bits = '';
		$this->e_colors = '';
		$curr_adr = 0;
		$curr_dy = 24;
		$curr_dx = 5;
		for ($y=0; $y<$ysize; $y++) {
			$tmp_ebits = array();
			$tmp_eattr = array();
			$yy = $y * $this->char_size;
			for ($x=0; $x<32; $x++) {
				$xx = $x*8;
				$colors = $prepared_attr[$y][$x]['colors'];
				$attr_adr = $y*32 + $x;
				$c0 = (int)$this->attr0[$attr_adr];
				$c1 = (int)$this->attr1[$attr_adr];
				$adr = $x + 256*($yy&7) + 32*(7 & floor($yy/8)) + 2048*(floor($yy/64));
				$masked = false;
				$val = 0;
				$bytes = array();
				for ($y_ln=0; $y_ln<$this->char_size; $y_ln++) {
					$y_ln_256 = 256*$y_ln;
					$byte = (int)$this->bitplan0[$adr + $y_ln_256];
					$bytes[] = $byte;
					$val += $byte;
				}
				$m1 = 64 + 4 + 3*8;
				$m2 = 64 + 4;
				$m3 = 64 + 3*8;
				if ($val == 0 || $val == 4*255) {
					$masked = true;
				}
				/*if (($c0 == $m1 && $c1 == $m1)
					|| ($c0 == $m2 && $c1 == $m2)
					|| ($c0 == $m3 && $c1 == $m3)
				) {
					$masked = true;
				}*/
				if ($masked) {
					$colors = $this->masked_colors;
					if ($c0!=0 || $c1!=0) {
						$curr_dadr = $y*$curr_dy+$x-$curr_dx;
						$this->e_attr[] = "\tDB\t" . ($curr_dadr - $curr_adr) . ", " . $c0 . "," . $c1 . "\r\n";
						$curr_adr = $curr_dadr;
					}
				} else {
					$tmp_ebits[] = "\tDB\t" . $x . "," . ($y*2) . ", " . implode(',', $bytes) . "\r\n";
					$e_bits_bytes += 6;
					$e_bits_chars++;
					$curr_dadr = $y*$curr_dy+$x-$curr_dx;
					$this->e_attr[] = "\tDB\t" . ($curr_dadr - $curr_adr) . ", " . $c0 . "," . $c1 . "\r\n";
					$curr_adr = $curr_dadr;
				}
				for ($y_ln=0; $y_ln<$this->char_size; $y_ln++) {
					$yyy = $yy + $y_ln;
					$y_ln_256 = 256*$y_ln;
					for ($bit = 0; $bit<8; $bit++) {
						$xxx = $xx + $bit;
						$byte0 = (int)$this->bitplan0[$adr + $y_ln_256];
						$byte1 = (int)$this->bitplan1[$adr + $y_ln_256];
						$pix0 = (bool)($byte0 & $this->bitmask[$bit]);
						$pix1 = (bool)($byte1 & $this->bitmask[$bit]);
						$color = $colors[2 * $pix1 + $pix0];
						$xi = $xxx * $param['size'];
						$yi = $yyy * $param['size'];
						imagefilledrectangle($this->img, $xi, $yi, $xi + $param['size'] - 1, $yi + $param['size'] - 1, $color);
					}
				}
			}
			$this->e_bits .= ";--- y=" . $y . ', qty=' . sizeof($tmp_ebits) . ', bytes=' . (6*sizeof($tmp_ebits))  . "\r\n"
			. implode('', $tmp_ebits);
			$e_bits_bin[] = sizeof($tmp_ebits);
			foreach ($tmp_ebits as $tb) {
				$e_bits_bin[] = $tb;
			}
		}
		$this->e_bits = ";Total bytes: " . $e_bits_bytes . "\r\n"
			. ";Total chars 8x4: " . $e_bits_chars . "\r\n"
			. $this->e_bits;
			
		$this->e_attr[] = "\tDB\t2, 0,0\r\n";
		$sz = 384 - sizeof($this->e_attr) - 1;
		for ($i=0;$i<$sz;$i++) {
			$this->e_attr[] = "\tDB\t0, 0,0\r\n";
		}
		
		$this->e_attr[] = "\tDB\t" . ($curr_dadr - $curr_adr) . ", " . $c0 . "," . $c1 . "\r\n";
		ob_start();
		imagepng($this->img);
		$this->png[$this->png_key($param)] = ob_get_clean();
	}
	
	public function as_html($param = array()) {
		$param = array_merge(array(
				'size' => 1,
				'with_border' => false,
			), $param
		);
		if (!isset($this->png[$this->png_key($param)])) {
			$this->render($param);
		}
		return 'data:image/jpeg;base64,' . base64_encode($this->png[$this->png_key($param)]);
	}
	
	public function as_png($param = array()) {
		$param = array_merge(array(
				'size' => 1,
				'with_border' => false,
				'base64' => false,
			), $param
		);
		if (!isset($this->png[$this->png_key($param)])) {
			$this->render($param);
		}
		return $param['base64'] ? base64_encode($this->png[$this->png_key($param)]) : $this->png[$this->png_key($param)];
	}


}