<?
//0xRGB

class gigascreen {

	const GIGA_CLR_BNB = 0;
	const GIGA_CLR_B = 1;
	const GIGA_CLR_NB = 2;

	public $giga_colors_bnb;
	public $giga_colors_nb;
	public $giga_colors_b;

	public function __construct() {
		$img = imagecreatefrompng(__DIR__ . '/gigacolors.png');
		for ($y=0; $y<8; $y++) {
			$yy = $y<2 ? $y : $y*2-1;
			for ($x=0; $x<8; $x++) {
				$xx = $x<2 ? $x : $x*2-1;
				$color = imagecolorat($img, $xx, $yy);
				if (!isset($this->giga_colors_nb[$color])) {
					$this->giga_colors_nb[$color] = array($x, $y);
				}
			}
		}
	}

	public function get_colors_by_type($type) {
		$colors = 'giga_colors_bnb';
		if ($type == static::GIGA_CLR_B) {
			$colors = 'giga_colors_b';
		} elseif ($type == static::GIGA_CLR_NB) {
			$colors = 'giga_colors_nb';
		}
		return $colors;
	}

	public function get_palette_from_image($img, $type = self::GIGA_CLR_BNB, $palette = array()) {
		$colors = $this->get_colors_by_type($type);
		$w = imagesx($img);
		$h = imagesy($img);
		for ($y=0; $y<$h; $y++) {
			for ($x=0; $x<$w; $x++) {
				$color = imagecolorat($img, $x, $y);
				if (in_array($color, array_keys($this->$colors))) {
					if (!in_array($color, $palette)) {
						$palette[] = $color;
					}
				} else {
					die ('error color at ' . $x . ', ' . $y . ' = ' . $color);
				}
			}
		}
		return $palette;
	}
}