// FX HEADER
//========================================================
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//========================================================
// FX CONST
//========================================================
;#ED59	OUT(C),E
;#ED51	OUT(C),D

ROT_SPD EQU	4
MV_D	EQU	61	;59
BLN_CLR	EQU	7

ATTR_ADR	EQU	#58A0
CLR0_0	EQU	0
CLR0_1	EQU	0
;--
CLR1_0	EQU	7
CLR1_1	EQU	7
;--
CLR2_0	EQU	2
CLR2_1	EQU	0
;--
CLR3_0	EQU	2
CLR3_1	EQU	6
;--
CLR4_0	EQU	6
CLR4_1	EQU	6
;--
CLR5_0	EQU	6
CLR5_1	EQU	7
;--
CLR6_0	EQU	6
CLR6_1	EQU	7
;------------------
CLR7_0	EQU	5
CLR7_1	EQU	2
;--
CLR8_0	EQU	5
CLR8_1	EQU	2
;--
CLR9_0	EQU	5
CLR9_1	EQU	5
;--
CLR10_0	EQU	5
CLR10_1	EQU	7
;--
CLR11_0	EQU	7
CLR11_1	EQU	7
;----------------
CLR12_0	EQU	1
CLR12_1	EQU	0
;--
CLR13_0	EQU	1
CLR13_1	EQU	1
;--
CLR14_0	EQU	1
CLR14_1	EQU	5
;--
CLR15_0	EQU	5
CLR15_1	EQU	5
//========================================================
// FX INIT
//========================================================
EFF_INI_
	EI
	HALT
	LD	A,7
	OUT	(#FE),A
	
	LD	A,#17
	CALL	PAGER
	LD	HL,#5AFF
	LD	DE,#5AFE
	LD	(HL),7*8+7
	LD	BC,768
	LDDR
	;---
	LD	BC,6143
	LD	(HL),#FF
	LDDR
	;---
	LD	HL,SPR_ACROSS
	LD	DE,#4001
	LD	BC,#200F
	CALL	SPR_OUT
	LD	HL,SPR_EDGE
	LD	DE,#5074
	LD	BC,#280C
	CALL	SPR_OUT
	;---
	LD	HL,#4000
	LD	DE,#C000
	LD	BC,6144
	LDIR

;-- create scroll out code
	LD	HL,TEXT
	LD	B,0
T0	LD	A,(HL)
	RRA
	RRA
	RRA
	RRA
	AND	#0F
	LD	(HL),A
	INC	L
	DJNZ	T0

	LD	DE,A_CODE
	EXX
	LD	HL,ATTR_ADR
	LD	DE,32
	LD	BC,60*256 + %00100010
INI1	
	LD	A,H
	XOR	%10000000
	LD	H,A
	LD	(A_SP+1),HL
	LD	A,0
INI0	EQU	$-1
	XOR	#FF
	LD	(INI0),A
	LD	A,#59	;OUT(C),E
	JP	Z,INIX1
	LD	A,#51	;OUT(C),D
INIX1	LD	(A_OUTPG+1),A
	EXX
	LD	HL,A_BEGIN
	LD	BC,A_END-A_BEGIN
	LDIR
	EXX
	RLC	C
	JP	NC,INI2
	ADD	HL,DE
INI2	LD	A,(A_DE_1+1)
	INC	A
	AND	7
	LD	(A_DE_1+1),A
	DJNZ	INI1
	;--
	EXX
	LD	HL,A_END
	LD	BC,A_END2-A_END
	LDIR
;-----
	LD	HL,OUTDATA
	LD	DE,OUTDATA+1
	LD	(HL),0
	LD	BC,511
	LDIR


	LD	(A_SOHRSP),SP
	EX	DE,HL
	INC	HL
	INC	HL
;	LD	(A_ADRTBL),HL
;	LD	BC,2 * (120*4 + 60*8)
;	ADD	HL,BC
;	LD	SP,HL
	LD	SP,#BE00
	
	LD	HL,OUTDATA + 8 + 3
	CALL	INI4
	LD	HL,OUTDATA + 8 + 2
	CALL	INI4
	
	LD	HL,A_CODE + (A_DE_1 - A_BEGIN) + 1
	CALL	INI6
	LD	HL,A_CODE + (A_DE_2 - A_BEGIN) + 1
	CALL	INI6
	LD	HL,A_CODE + (A_DE_3 - A_BEGIN) + 1
	CALL	INI6
	LD	HL,A_CODE + (A_DE_4 - A_BEGIN) + 1
	CALL	INI6
	LD	HL,A_CODE + (A_DE_5 - A_BEGIN) + 1
	CALL	INI6
	LD	HL,A_CODE + (A_DE_6 - A_BEGIN) + 1
	CALL	INI6
	LD	HL,A_CODE + (A_DE_7 - A_BEGIN) + 1
	CALL	INI6
	LD	HL,A_CODE + (A_DE_8 - A_BEGIN) + 1
	CALL	INI6
	
	LD	HL,OUTDATA + 8 + 1
	CALL	INI4
	LD	HL,OUTDATA + 8 + 0
	CALL	INI4
	
	LD	SP,(A_SOHRSP)
	
	
	LD	DE,CLRTBL1
	LD	A,16
INI7	LD	HL,CLR0
	DUP	16
	LDI
	EDUP
	DEC	A
	JP	NZ,INI7
	LD	DE,CLRTBL2
	LD	A,16
INI8	LD	HL,CLR1
	DUP	16
	LDI
	EDUP
	DEC	A
	JP	NZ,INI8
	;----
	EI
	HALT
	;----
	LD	BC,1700
INIC3	DEC	BC
	LD	A,B
	OR	C
	JP	NZ,INIC3
	LD	HL,COLOR1
	LD	DE,#5800
INIC2	LD	B,(HL)
	INC	HL
	LD	A,(HL)
	INC	HL
	OR	A
	JR	Z,INIRET
INIC1	LD	(DE),A
	INC	DE
	DJNZ	INIC1
	JP	INIC2
INIRET	AND	A
	RET	C
	;RET	C
	;RET	C

	RET
	
COLOR1	DB	1,8, 3,#41, 10,8*BLN_CLR+1, 2,#41, 16,8
	DB	1,8, 3,#41, 10,8*BLN_CLR+1, 2,#41, 16,8
	DB	1,8, 3,#41, 10,8*BLN_CLR+1, 2,#41, 16,8
	DB	1,8, 3,#41, 10,8*BLN_CLR+0, 2,#41, 16,8
	DB	0,8
	DB	224,8
	DB	20,8, 2,#41, 8,8*BLN_CLR+0, 2,#41
	DB	20,8, 2,#41, 8,8*BLN_CLR+1, 2,#41
	DB	20,8, 2,#41, 8,8*BLN_CLR+1, 2,#41
	DB	20,8, 2,#41, 8,8*BLN_CLR+1, 2,#41
	DB	20,8, 2,#41, 8,8*BLN_CLR+1, 2,#41
	DB	0,0
	
	
CLR0	DB	CLR0_0, CLR1_0, CLR2_0, CLR3_0, CLR4_0, CLR5_0, CLR6_0, CLR7_0
	DB	CLR8_0, CLR9_0, CLR10_0, CLR11_0, CLR12_0, CLR13_0, CLR14_0, CLR15_0
CLR1	DB	CLR0_1, CLR1_1, CLR2_1, CLR3_1, CLR4_1, CLR5_1, CLR6_1, CLR7_1
	DB	CLR8_1, CLR9_1, CLR10_1, CLR11_1, CLR12_1, CLR13_1, CLR14_1, CLR15_1
	
	
INI6	LD	A,60
	LD	BC,A_END-A_BEGIN
	JP	INI5
INI4	LD	A,120
	LD	BC,#0004
INI5	POP	IX
INI3	PUSH	HL
	ADD	HL,BC
	DEC	A
	JP	NZ,INI3
	JP	(IX)
//-------------
A_BEGIN
	;--------- 1
	OUTI		;16
	OUTI		;16 /32
	;---
A_DE_1	LD	E,#00	;7
	LD	D,E	;4
	PUSH	DE	;11
	PUSH	DE	;11 /33
	;-
A_DE_2	LD	E,#01	;7
	LD	D,E	;4
	PUSH	DE	;11
	PUSH	DE	;11 /33
	;-
A_DE_3	LD	E,#02	;7
	LD	D,E	;4
	PUSH	DE	;11
	PUSH	DE	;11 /33
	;-
A_DE_4	LD	E,#03	;7
	LD	D,E	;4
	PUSH	DE	;11
A_DE_6	LD	A,#05
	;---
	OUTI		;16
	OUTI		;16 /32
	PUSH	DE	;11
	LD	DE,0
A_DE_5	LD	E,#04	;7
	LD	D,E	;4
	;--------- 2
	OUTI		;16
	OUTI		;16 /32
	;---
	PUSH	DE	;11
	PUSH	DE	;11 /33
	;-
	LD	E,A	;7
	LD	D,E	;4
	PUSH	DE	;11
	PUSH	DE	;11 /33
	;-
A_DE_7	LD	E,#06	;7
	LD	D,E	;4
	PUSH	DE	;11
	PUSH	DE	;11 /33
	;-
A_DE_8	LD	E,#07	;7
	LD	D,E	;4
	PUSH	DE	;11
	PUSH	DE	;11 /33
	;---
A_SP	LD	SP,0	;10 _10
	;---
	OUTI		;16
	OUTI		;16 /32
	;--------- 64 + 128 = 192 / 32b free
	NOP:NOP:NOP
	EXX		;4
A_OUTPG	OUT	(C),E	;12
	EXX		;4 /20
	;---
A_END	XOR	A
	OUT	(#FE),A
	LD	SP,(A_SOHRSP)
	RET
A_END2

SPR_OUT	LD	A,C
	LD	(SPROUT1),A
SPROUT3	PUSH	DE
	LD	C,0
SPROUT1	EQU $-1
SPROUT2	LD	A,(HL)
	LD	(DE),A
	INC	HL
	INC	E
	DEC	C
	JP	NZ,SPROUT2
	POP	DE
	CALL	DOWN_DE
	DJNZ	SPROUT3
	RET
DOWN_DE	INC	D
	LD	A,D
	AND	7
	RET	NZ
	LD	A,E
	ADD	A,#20
	LD	E,A
	RET	C
	LD	A,D
	SUB	8
	LD	D,A
	RET
;--------
A_SOHRSP DW	0
;--------
OUTSCROLL
	LD	A,#17
	CALL	PAGER
	LD	(A_SOHRSP),SP
	LD	SP,ATTR_ADR
	LD	HL,OUTDATA
	LD	BC,#00FE
	EXX
	LD	BC,#7FFD
	LD	DE,#171F
	EXX
	JP	A_CODE
;----------------------------------
MVA1	AND	%00111111	;7
	LD	C,A		;4
	AND	%00110000	;7
	ADD	A,(HL)		;7
	LD	E,A		;4
	LD	A,(BC)		;7
	EX	DE,HL		;4
	ADD	A,(HL)		;7
	EX	DE,HL		;4
	BIT	4,C		;8	
	JP	NZ,MVA1D	;10 //77
MVA1I	;----------------
	EXX		;4
	LD	L,A	;4
	LD	H,#C0	;7
	;---
	LD	A,BLN_CLR	;7
	OUT	(#FE),A	;11
	DEC BC:INC BC:NOP:LD A,R
	XOR	A	;4 /29t    
	OUT	(#FE),A	;11 /33-224
	DEC BC:NOP
	;---
	DUP	20
	DUP	3
	LD	E,(HL)	;7
	INC	H	;4
	LD	A,(DE)	;7
	POP	BC	;10
	LD	(BC),A	;7
	POP	BC	;10
	LD	(BC),A	;7 /52 *60 = 3120
	EDUP
	LD	A,BLN_CLR	;7
	OUT	(#FE),A	;11
	DEC BC:DEC BC:DEC BC
	XOR	A	;4 /29t    
	LD A,0
	OUT	(#FE),A	;11 /33-224
	;18
	DEC BC:NOP
	EDUP
	EXX		;4
	JP	(IY)	;8 /12
MVA1D	;----------------
	EXX			;4
	LD	L,A
	LD	H,#C0 + MV_D
	;---
	LD	A,BLN_CLR	;7
	OUT	(#FE),A	;11
	DEC BC:INC BC:NOP:LD A,R
	XOR	A	;4 /29t    
	OUT	(#FE),A	;11 /33-224
	DEC BC:NOP
	;---
	DUP	20
	DUP	3
	LD	E,(HL)	;7
	DEC	H	;4 debug /DEC H
	LD	A,(DE)	;7
	POP	BC	;10
	LD	(BC),A	;7
	POP	BC	;10
	LD	(BC),A	;7 /52 *60 = 3120
	EDUP
	LD	A,BLN_CLR	;7
	OUT	(#FE),A	;11
	DEC BC:DEC BC:DEC BC
	XOR	A	;4 /29t    
	LD A,0
	OUT	(#FE),A	;11 /33-224
	;18
	DEC BC:NOP
	EDUP
	EXX		;4
	JP	(IY)	;8 /12
;-------------------------------
MVA2	LD	A,C		;4
	INC	A		;4
	AND	%00111111	;7
	LD	C,A		;4
	AND	%00110000	;7
	ADD	A,(HL)		;7
	INC	L		;4
	LD	E,A		;4
	LD	A,(BC)		;7
	EX	AF,AF
	LD	A,BLN_CLR
	LD	A,BLN_CLR
	OUT	(#FE),A
	NOP:NOP:LD A,R
	XOR	A
	OUT	(#FE),A
	EX	AF,AF
	
	EX	DE,HL		;4
	ADD	A,(HL)		;7
	EX	DE,HL		;4
	NOP:NOP:NOP
	
	BIT	4,C		;8	
	RET	C
	JP	NZ,MVA2D	;10 //77
MVA2I	;---
	EXX			;4
	LD	L,A
	LD	H,#C0
	DUP	12
	DUP	3
	LD	E,(HL)	;7
	INC	H	;4
	LD	A,(DE)	;7
	POP	BC	;10
	LD	(BC),A	;7 /35
	EDUP
	LD	A,BLN_CLR	;7
	OUT	(#FE),A	;11
	LD	E,(HL)	;7
	INC	H	;4
	DEC	BC	;6
	XOR A		;4
	OUT	(#FE),A	;11	
	LD	A,(DE)	;7
	POP	BC	;10
	LD	(BC),A	;7 /35
	NOP:DEC BC
	LD	E,(HL)	;7
	INC	H	;4
	LD	A,(DE)	;7
	POP	BC	;10
	LD	(BC),A	;7 /35
	EDUP
	EXX		;4
	JP	(IY)
MVA2D	;---
	EXX			;4
	LD	L,A
	LD	H,#C0 + MV_D
	DUP	12
	DUP	3
	LD	E,(HL)	;7
	DEC	H	;4 debug /DEC H
	LD	A,(DE)	;7
	POP	BC	;10
	LD	(BC),A	;7 /35
	EDUP
	LD	A,BLN_CLR	;7
	OUT	(#FE),A	;11
	LD	E,(HL)	;7
	DEC	H	;4 debug /DEC H
	DEC	BC	;6
	XOR A		;4
	OUT	(#FE),A	;11	
	LD	A,(DE)	;7
	POP	BC	;10
	LD	(BC),A	;7 /35
	NOP:DEC BC
	LD	E,(HL)	;7
	DEC	H	;4 debug /DEC H
	LD	A,(DE)	;7
	POP	BC	;10
	LD	(BC),A	;7 /35
	EDUP
	EXX		;4
	JP	(IY)
;---------------------------------
MVA3	LD	A,C
	INC	A
MVA3A	AND	%00111111	;7
	LD	C,A		;4
	AND	%00110000	;7
	ADD	A,(HL)		;7
	INC	L		;4
	LD	E,A		;4
	LD	A,(BC)		;7
	EX	DE,HL		;4
	ADD	A,(HL)		;7
	EX	DE,HL		;4
	BIT	4,C		;8	
	JP	NZ,MVA3D	;10
MVA3I	;---
	EXX		;4
	LD	L,A	;7
	LD	H,#C0	;7
	DUP	60
	LD	E,(HL)	;7
	INC	H	;4
	LD	A,(DE)	;7
	POP	BC	;10
	LD	(BC),A	;7 /35
	EDUP
	EXX		;4
	JP	(IY)	;8
MVA3D	;---
	EXX		;4
	LD	L,A	;7
	LD	H,#C0 + MV_D ;7
	DUP	60
	LD	E,(HL)	;7
	DEC	H	;4 debug /DEC H
	LD	A,(DE)	;7
	POP	BC	;10
	LD	(BC),A	;7 /35
	EDUP
	EXX		;4
	JP	(IY)	;8
	
//========================================================
// FX MAINLOOP
//========================================================
EFF_RUN_
	EI
	HALT
	;---
	LD	A,13
	DEC	A
	JP	NZ,$-1
	NOP:NOP:DEC BC
	;---
	LD	A,#10
	CALL	PAGER
	LD	(A_SOHRSP),SP
	;---
	LD	D,CLRTBL1/256
A_CLR	EQU	$-1	
	EXX
	LD	HL,TEXT
A_TEXT	EQU	$-2
	LD	A,16
ALPHA	EQU	$-1
	LD	B,M_TBL_0/256
	LD	D,M_TBL_0/256 + 1
	
	ADD	A,0
	LD	SP,#BE00 - 120*2*2 - 60*2*8 - 120*2*2
	LD	IY,$+7
	JP	MVA1

	LD	A,L
	ADD	A,1
	LD	L,A
	LD	A,C
	ADD	A,1
	LD	SP,#BE00 - 120*2*2 - 60*2*8 - 120*2*1
	LD	IY,$+7
	JP	MVA1

	LD	A,L
	ADD	A,9
	LD	L,A	
	LD	A,C
	ADD	A,9
	LD	SP,#BE00 - 120*2*2
	LD	IY,$+7
	JP	MVA1
	
	LD	A,L
	ADD	A,1
	LD	L,A
	LD	A,C
	ADD	A,1
	LD	SP,#BE00 - 120*2*1
	LD	IY,$+7
	JP	MVA1

	
	LD	A,L
	ADD	A,0-9
	LD	L,A
	LD	A,C
	ADD	A,0-9
	LD	SP,#BE00 - 120*2*2 - 60*2*8
	LD	IY,$+7
	JP	MVA3A
	
	LD	SP,(A_SOHRSP)
	
	;--- pause
	LD	A,6
	DEC	A
	JP	NZ,$-1	
	NOP:LD	A,R
	DUP	6
	LD	A,15
	LD	A,15
	DEC	A
	JP	NZ,$-1
	EDUP
	NOP
	;--------------------- OUTSCROLL
	CALL	OUTSCROLL
	;--------------------- MOVE & ROTATE
AWW0	EQU	6
	LD	A,AWW0
AW0	EQU	$-1
	DEC	A
	JP	Z,AW0_1
	;---
	NOP:NOP:NOP:DEC HL
	JP	AW0_0
	;---
AW0_1	LD	HL,A_TEXT	;10
	INC	(HL)		;11
	LD	A,AWW0		;7
AW0_0	;--
	LD	(AW0),A
	;--
	LD	A,ROT_SPD
AW1	EQU	$-1
	DEC	A
	JP	Z,AW1_1
	;---
	OR 0:OR 0:NOP
	JP	AW1_0
	;---
AW1_1	LD	HL,ALPHA	;10
	DEC	(HL)		;11
	LD	A,ROT_SPD
AW1_0	;--
	LD	(AW1),A
	;---
	LD	A,0
MCLR	EQU	$-1
	INC	A
	AND	1
	LD	(MCLR),A
	ADD	A,CLRTBL1/256
	LD	(A_CLR),A
	;---
	;pause
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:NOP:NOP:NOP:LD A,R
	
	;---
	LD	A,#10
	CALL	PAGER
	LD	(A_SOHRSP),SP
	LD	A,(A_CLR)
	LD	D,A
	EXX
	LD	HL,(A_TEXT)
	INC L:INC L:INC L
	LD	A,(ALPHA)
	INC A:INC A:NOP	;INC A:INC A:INC A debug
	LD	C,A
	LD	B,M_TBL_0/256
	LD	D,M_TBL_0/256 + 1
	
	NOP:NOP:LD A,R
	
	
	LD	SP,#BE00 - 120*2*2 - 60*2*7
	LD	IY,$+7
	JP	MVA3

	LD	SP,#BE00 - 120*2*2 - 60*2*6
	LD	IY,$+7
	JP	MVA3
	
	LD	SP,#BE00 - 120*2*2 - 60*2*5
	LD	IY,$+7
	JP	MVA3
	
	LD	SP,#BE00 - 120*2*2 - 60*2*4
	LD	IY,$+7
	JP	MVA2
	
	LD	SP,#BE00 - 120*2*2 - 60*2*3
	LD	IY,$+7
	JP	MVA2
	
	LD	SP,#BE00 - 120*2*2 - 60*2*2
	LD	IY,$+7
	JP	MVA2
	
	LD	SP,#BE00 - 120*2*2 - 60*2*1
	LD	IY,$+7
	JP	MVA2
	

	LD	SP,(A_SOHRSP)
	

	
XXX	;------------- SWAP COLORS
	LD	A,0
SWP	EQU	$-1
	XOR	#FF
	LD	(SWP),A
	JP	Z,SWP1
	LD	HL,SWP_CLR_0
	JP	SWP2
SWP1	LD	HL,SWP_CLR_1
	JP	SWP2
SWP2	;---
	LD	A,(HL)
	LD	(#5AFD),A
	AND	7
	LD	(#5AFE),A
	LD	(#5AD5),A	
	;---
	INC	HL
	LD	A,(HL)
	LD	DE,#5804
	DUP	9
	LD	(DE),A
	INC	E
	EDUP
	LD	(DE),A
	;---
	LD	DE,#5AD6
	DUP	7
	LD	(DE),A
	INC	E
	EDUP
	LD	(DE),A
	;---
	INC	HL
	LD	A,(HL)
	AND	7
	LD	DE,#5821
	LD	(DE),A
	INC	E
	LD	(DE),A
	INC	E
	LD	(DE),A
	INC	E
	LD	A,(HL)
	DUP	10
	LD	(DE),A
	INC	E
	EDUP
	AND	7
	LD	(DE),A
	INC	E
	LD	(DE),A
	;---
	LD	DE,#5AB4
	LD	(DE),A
	INC	E
	LD	(DE),A
	INC	E
	LD	A,(HL)
	DUP	8
	LD	(DE),A
	INC	E
	EDUP
	AND	7
	LD	(DE),A
	;---
	SCF
	RET	NC
	;RET	NC
	;RET	NC
	
	RET
SWP_CLR_0
	DB	8*BLN_CLR + 3
	DB	8*BLN_CLR + 3
	DB	8*BLN_CLR + 3
SWP_CLR_1
	DB	8*BLN_CLR + 7
	DB	8*BLN_CLR + 6
	DB	8*BLN_CLR + 1
//========================================================
SPR_ACROSS	INCBIN "spr_across.bin"
SPR_EDGE	INCBIN "spr_edge.bin"
;-------
	ORG	(($+255)/256)*256
TEXT	INCBIN	"generated/text.bin"
;-------
	ORG	(($+255)/256)*256
M_TBL_0
	DB	15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0
	DB	0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
	DB	15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0
	DB	0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
;-------
	ORG	(($+255)/256)*256
M_TBL_1
	DB	0*16,1*16,2*16,3*16,4*16,6*16,5*16,8*16,7*16,10*16,9*16,11*16,13*16,12*16,15*16,14
	DB	0*16,1*16,2*16,3*16,4*16,5*16,6*16,7*16,8*16,9*16,10*16,11*16,12*16,13*16,14*16,15
	DB	0*16,1*16,2*16,3*16,4*16,5*16,6*16,7*16,8*16,9*16,10*16,11*16,12*16,13*16,14*16,15
	DB	0*16,1*16,2*16,3*16,4*16,6*16,5*16,8*16,7*16,10*16,9*16,11*16,13*16,12*16,15*16,14
;-------
	ORG	(($+255)/256)*256
CLRTBL1	DS	256,0
CLRTBL2	DS	256,0
OUTDATA	DS	512,0
A_CODE	EQU	$

	DISPLAY /A, TEXT