﻿using UnityEngine;
using System.Collections;

public class SpawnController : MonoBehaviour {
	public float MaxVertical = 19f;
	public float SpawnRate = 3f;
	public float SpawnTime = 0f;
	public float SpawnOffset = 40f;
	public GameObject[] SpawnObject;


	// Update is called once per frame
	void Update () {
		if (SpawnTime < 0) {
			SpawnRandom ();
			SpawnTime = Random.Range ((SpawnRate * 0.20f), (SpawnRate * 1.80f));
		} else {
			SpawnTime -= Time.deltaTime;
		}

		//Reduce spawntime to make it more hard
		if (SpawnRate > 0.2f) {
			SpawnRate -= Time.deltaTime * 0.05f;
		}

		if (GUIController.gui.isPlayerDead) {
			gameObject.GetComponent<SpawnController>().enabled = false;
		}
	}

	void SpawnRandom(){
		Debug.Log ("Spawned!");
		int obj = Random.Range (0, SpawnObject.Length);
		Vector3 pos = new Vector3 (transform.position.x + SpawnOffset, Random.Range(-MaxVertical, MaxVertical), 0);
		Instantiate (SpawnObject [obj], pos, Quaternion.identity);
	}
}
