import pygame, sys, os, threading, time, math
sys.path.append("..")
from world import *

class MapWindowThread(threading.Thread):
	
	data = None
	
	def run(self):
		self.tile_width = self.data['world'].tileSize.x
		self.tile_height = self.data['world'].tileSize.y

		self.window_width = self.data['world'].mapSize.x * self.tile_width
		self.window_height = self.data['world'].mapSize.y * self.tile_height
		
		print "MapWindow size is {0}x{1}".format(self.window_width, self.window_height)
		
		pygame.init()
		self.w = pygame.display.set_mode((self.window_width, self.window_height))
		self.screen = pygame.display.get_surface()
		pygame.display.set_caption("Own ID: " + str(self.data['world'].players.own_id))
		
		self.font = pygame.font.SysFont('Terminal',16)
		
		gfxdir = "mapwindow_gfx"
		self.gfx = {
				"-": pygame.image.load(os.path.join(gfxdir,"map-horizontal.bmp")),
				"|": pygame.image.load(os.path.join(gfxdir,"map-vertical.bmp")),
				"\\": pygame.image.load(os.path.join(gfxdir,"map-bottomleft.bmp")),
				"/": pygame.image.load(os.path.join(gfxdir,"map-topleft.bmp")),
				"`": pygame.image.load(os.path.join(gfxdir,"map-topright.bmp")),
				",": pygame.image.load(os.path.join(gfxdir,"map-bottomright.bmp")),
				"+": pygame.image.load(os.path.join(gfxdir,"map-xing.bmp")),
				".": pygame.image.load(os.path.join(gfxdir,"map-none.bmp")),
				"player": pygame.image.load(os.path.join(gfxdir,"car1.bmp")),
				"self": pygame.image.load(os.path.join(gfxdir,"car0.bmp"))
		}
		self.gfx['player'].set_colorkey(pygame.Color(255,0,255))
		self.gfx['self'].set_colorkey(pygame.Color(255,0,255))
		
		self.running = True
		while self.running:
			self.drawTiles()
			for event in pygame.event.get():
				if ((event.type == pygame.QUIT) or (event.type == pygame.KEYDOWN and event.key==pygame.K_ESCAPE)):
					self.running = False

				if (event.type == pygame.KEYDOWN and event.key == pygame.K_KP_PLUS):
					self.data['world'].offsetAmount += 1
					print "New cornering offset:", self.data['world'].offsetAmount

				if (event.type == pygame.KEYDOWN and event.key == pygame.K_KP_MINUS):
					self.data['world'].offsetAmount -= 1
					print "New cornering offset:", self.data['world'].offsetAmount

			time.sleep(0.016)
		
	def setData(self,data):
		self.data = data
	
	def makeTileText(self, actionTile):
		s = ""
		return s

	def makeTileTextForValueTiles(self,actionTile):
		s = ""
		return s

	def drawText(self, s, pos, r=255,g=255,b=255):
		bs = self.font.render(s, True, (r,g,b), (0,0,0))
		self.screen.blit(bs, pos)

	def drawTiles(self):
		self.screen.fill((0, 0, 0))
		
		string = self.font.render("Own ID: " + str(self.data['world'].players.own_id), True, (255,255,255), (0,0,0))
		self.screen.blit(string, (60,20))
		
		#self.screen.blit(self.gfx['compas'], (0,0))
		for x in range(self.data['world'].mapSize.x):
			for y in range(self.data['world'].mapSize.y):
				self.screen.blit(self.gfx[self.data['world'].tiles[y][x]], (x * self.tile_width, y * self.tile_height))
		
		me = self.data['players'].me()

		
		for x in range(self.data['world'].mapSize.x):
			for y in range(self.data['world'].mapSize.y):
						
				#if self.data['hilight'][x][y] > 0:
				#    self.screen.blit(self.gfx['hilight'], (x,y))
								
				if self.data['text'][y][x] != "":
					self.drawText(self.data['text'][y][x], (x * self.tile_width + (self.tile_width / 2) - (string.get_size()[0] / 2), (y * self.tile_height) + (self.tile_height / 2)))
				if self.data['path'][y][x] != "":
					self.drawText(self.data['path'][y][x], (x * self.tile_width + (self.tile_width / 2) - (string.get_size()[0] / 2), (y * self.tile_height) + (self.tile_height / 2)+15),255,0,0)
				if self.data['checkpoints'][y][x] != "":
					self.drawText(self.data['checkpoints'][y][x], (x * self.tile_width + (self.tile_width / 2) - (string.get_size()[0] / 2), (y * self.tile_height) + (self.tile_height / 2)-15),0,255,0)
						
		for item in self.data['world'].items:
			self.screen.fill((0,255,0), pygame.Rect(item['x'], item['y'], item['width'], item['height']))

		for shell in self.data['world'].shells:
			self.screen.fill((255,0,0), pygame.Rect(shell['x'], shell['y'], 16, 16))
		
		for modifier in self.data['world'].modifiers:
			mtype = modifier['type']
			mx = modifier['x']
			my = modifier['y']
			mwidth = modifier['width']
			mheight = modifier['height']
			color = (255,0,255)
			if mtype == "mud":
				color = (152,102,61)
			elif mtype == "booster":
				color = (144,218,239)
			elif mtype == "ice":
				color = (255,255,255)
			self.screen.fill(color, pygame.Rect(mx, my, mwidth, mheight))

		#self.screen.blit(self.gfx['hilight'], (self.jk2x(4,4),self.jk2y(4,4)))
		
		if (me != None):
			self.drawText(str(me['velocity'].magnitude()), (10, 10))

			angle = math.atan2(me['direction'].x, me['direction'].y) * 180 / math.pi
			carImage = pygame.transform.rotate(self.gfx['self'], angle-90)
			carx, cary = carImage.get_size()
			self.screen.blit(carImage, (me['pos'].x-carx/2, me['pos'].y-cary/2))
		
		for player in self.data['players'].enemies():
			if ('pos' in player):
				angle = math.atan2(player['direction'].x, player['direction'].y) * 180 / math.pi
				carImage = pygame.transform.rotate(self.gfx['player'], angle-90)
				carx, cary = carImage.get_size()
				self.screen.blit(carImage, (player['pos'].x-carx/2, player['pos'].y-cary/2))
		
		for line in self.data['lines']:
			pygame.draw.line(self.screen, 0x00ff00, line[0].asTuple(), line[1].asTuple())

		pygame.display.flip()

class MapWindow(object):
	def __init__(self, world, players):
		self.data = {}
		self.data['world'] = world
		self.data['players'] = players
		self.data['lines'] = []

		#self.hilight = [[0] * self.world.size_k] * self.world.size_j
		#self.data['hilight'] = [[0 for row in range(self.data['world'].size_k)] for col in range(self.data['world'].size_k)]
		self.clearTiles()
		
		index = 0
		for checkpoint in world.path:
			self.data['path'][checkpoint.y][checkpoint.x] = str(index)
			index += 1
		index = 0
		for checkpoint in world.checkpoints:
			self.data['checkpoints'][checkpoint.y][checkpoint.x] = str(index)
			index += 1

		thread = MapWindowThread()
		thread.daemon = True
		thread.setData(self.data)
		thread.start()

	def setLine(self, start, end):
		if len(self.data['lines']) == 0:
			self.data['lines'].append((start, end))
		else:
			self.data['lines'][0] = (start, end)
			
	def drawPlayer(self,player):
		return 0
			
	# wipe all debug for new round
	def clearTiles(self):
		#self.data['hilight'] = [[0 for row in range(self.data['world'].size_k)] for col in range(self.data['world'].size_k)]
		self.data['text'] = [["" for row in range(self.data['world'].mapSize.x)] for col in range(self.data['world'].mapSize.y)]
		self.data['path'] = [["" for row in range(self.data['world'].mapSize.x)] for col in range(self.data['world'].mapSize.y)]
		self.data['checkpoints'] = [["" for row in range(self.data['world'].mapSize.x)] for col in range(self.data['world'].mapSize.y)]

	def tileText(self, coord, text):
		self.data['text'][coord.y][coord.x] = text        
			
kart = None

if __name__ == "__main__":
	size_x = 8
	size_y = 6
	start = [3, 1]
	end = [4, 4]
	taken_tiles = [[2, 2]]

	# Create map data and init the gameworld
	import time
	import maploader
	from players import *
	#mapfile = 'maps/zomg/greenish.skyportmap'
	#mapfile = 'maps/zomg/split-start.skyportmap'
	#mapfile = sys.argv[1]
	#mapfile = 'maps/testing/2-players-minimal.skyportmap'
	#mapfile = 'maps/testing/4-players-disconnected.skyportmap'
	mapfile = '../case-server/map1.map'
	map_obj = maploader.loadMapFile(mapfile)
	
	print "Map object: {0}".format(map_obj)

	playerlist = [
		{
			'id': 0,
			'pos': { 'x': 100, 'y': 100 },
			'velocity': { 'x': 0, 'y': 0},
			'direction': { 'x': 0, 'y': 1 }
		}
	]
	
	players = Players(playerlist, 0)

	#path = [{ "tile_x": 3, "tile_y": 1 },{ "tile_x": 4, "tile_y": 1 },{ "tile_x": 5, "tile_y": 1 },{ "tile_x": 5, "tile_y": 2 },
	#        { "tile_x": 5, "tile_y": 3 },{ "tile_x": 5, "tile_y": 4 },{ "tile_x": 4, "tile_y": 4 },{ "tile_x": 3, "tile_y": 4 },
	#        { "tile_x": 2, "tile_y": 4 },{ "tile_x": 1, "tile_y": 4 },{ "tile_x": 1, "tile_y": 3 },{ "tile_x": 1, "tile_y": 2 }]

	path = [{ "tile_x": 3, "tile_y": 1 },{ "tile_x": 5, "tile_y": 3 },{ "tile_x": 3, "tile_y": 5 },{ "tile_x": 1, "tile_y": 3 }]

	gameworld = World(Coord(x=map_obj['width'], y=map_obj['height']), Coord(x=128, y=128), path, map_obj['data'])
	#print gameworld.search(Coord(x=5,y=2), Coord(x=1, y=2))

	#kart = MapWindow(gameworld, players)
	
	#time.sleep(1)
	#kart.tileText(Coord(x=1, y=2), "Target")

	#gameworld.setMapwindow(kart)
	#gameworld.setPlayers(players)
		
	#time.sleep(1000)

#........
#./---`..
#.|...|..
#.|...|..
#.\---,..
#........    