/*
 * Decompiled with CFR 0.152.
 */
package com.petterroea.kartering;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.petterroea.kartering.Box;
import com.petterroea.kartering.Car;
import com.petterroea.kartering.GameState;
import com.petterroea.kartering.Item;
import com.petterroea.kartering.Modifier;
import com.petterroea.kartering.Shell;
import com.petterroea.kartering.abstraction.IServer;
import com.petterroea.kartering.map.MatchData;
import com.petterroea.kartering.map.Tile;
import com.petterroea.kartering.math.FloatVect;
import com.petterroea.kartering.math.IntVect;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;

public class NetworkManager
implements IServer {
    private Socket client;
    private BufferedReader reader;
    private PrintWriter writer;
    private OutputStream outStream;
    private byte[] data = new byte[256];
    private InetSocketAddress endPoint;

    public NetworkManager(String ip, int port, String name) {
        try {
            this.client = new Socket();
            this.endPoint = new InetSocketAddress(ip, port);
            this.client.connect(this.endPoint);
            this.reader = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
            this.outStream = this.client.getOutputStream();
            this.writer = new PrintWriter(this.outStream, true);
            this.send(name);
        }
        catch (Exception e) {
            System.out.println("There was an error!");
            e.printStackTrace();
        }
    }

    public boolean Connected() {
        return this.client.isConnected() && !this.client.isClosed() && !this.writer.checkError();
    }

    public void send(String data) {
        System.out.println("OUT: " + data);
        this.writer.println(data);
        this.writer.flush();
    }

    public void sendByte(int b) {
        System.out.println("OUT: " + b);
        this.send(String.valueOf(b));
    }

    public String readLine() {
        try {
            char c;
            StringBuilder b = new StringBuilder();
            while ((c = (char)this.reader.read()) != '\n') {
                b.append(c);
            }
            System.out.println();
            String l = b.toString();
            System.out.println("IN: " + l);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
            return "";
        }
    }

    @Override
    public MatchData getMapData() {
        String line = this.readLine();
        JsonObject mapData = JsonObject.readFrom(line);
        JsonObject map = mapData.get("map").asObject();
        int selfId = mapData.get("id").asInt();
        int tileWidth = map.get("tile_width").asInt();
        int tileHeight = map.get("tile_height").asInt();
        JsonArray tileArray = map.get("tiles").asArray();
        int mapHeight = tileArray.size();
        int mapWidth = tileArray.get(0).asArray().size();
        Tile[] tiles = new Tile[mapWidth * mapHeight];
        int y = 0;
        while (y < tileArray.size()) {
            JsonArray row = tileArray.get(y).asArray();
            int x = 0;
            while (x < row.size()) {
                tiles[x + y * mapWidth] = new Tile(row.get(x).asString());
                ++x;
            }
            ++y;
        }
        JsonArray modifierList = map.get("modifiers").asArray();
        Modifier[] modifiers = new Modifier[modifierList.size()];
        int i = 0;
        while (i < modifierList.size()) {
            JsonObject modifierObject = modifierList.get(i).asObject();
            modifiers[i] = new Modifier(modifierObject.get("type").asString(), new FloatVect(modifierObject.get("x").asFloat(), modifierObject.get("y").asFloat()), new FloatVect(modifierObject.get("width").asFloat(), modifierObject.get("height").asFloat()));
            ++i;
        }
        JsonArray pathList = map.get("path").asArray();
        IntVect[] path = new IntVect[pathList.size()];
        int i2 = 0;
        while (i2 < pathList.size()) {
            JsonObject point = pathList.get(i2).asObject();
            path[i2] = new IntVect(point.get("tile_x").asInt(), point.get("tile_y").asInt());
            ++i2;
        }
        return new MatchData(selfId, tileWidth, tileHeight, mapWidth, mapHeight, tiles, modifiers, path);
    }

    @Override
    public GameState getGameState() {
        FloatVect velocity;
        String line = this.readLine();
        JsonObject stateData = JsonObject.readFrom(line);
        JsonArray carList = stateData.get("cars").asArray();
        Car[] cars = new Car[carList.size()];
        int i = 0;
        while (i < cars.length) {
            JsonObject carObject = carList.get(i).asObject();
            int id = carObject.get("id").asInt();
            JsonObject directionObject = carObject.get("direction").asObject();
            FloatVect direction = new FloatVect(directionObject.get("x").asFloat(), directionObject.get("y").asFloat());
            JsonObject velocityObject = carObject.get("velocity").asObject();
            velocity = new FloatVect(velocityObject.get("x").asFloat(), velocityObject.get("y").asFloat());
            JsonObject positionObject = carObject.get("pos").asObject();
            FloatVect position = new FloatVect(positionObject.get("x").asFloat(), positionObject.get("y").asFloat());
            boolean drifting = carObject.get("drift").asInt() == 1;
            int width = carObject.get("width").asInt();
            int height = carObject.get("height").asInt();
            cars[i] = new Car(id, direction, velocity, position, width, height, drifting);
            ++i;
        }
        JsonArray shellList = stateData.get("shells").asArray();
        Shell[] shells = new Shell[shellList.size()];
        int i2 = 0;
        while (i2 < shells.length) {
            JsonObject shellObject = shellList.get(i2).asObject();
            String type = shellObject.get("type").asString();
            FloatVect position = new FloatVect(shellObject.get("x").asFloat(), shellObject.get("y").asFloat());
            velocity = new FloatVect(shellObject.get("dx").asFloat(), shellObject.get("dy").asFloat());
            shells[i2] = new Shell(type, position, velocity);
            ++i2;
        }
        JsonArray boxList = stateData.get("boxes").asArray();
        Box[] boxes = new Box[boxList.size()];
        int i3 = 0;
        while (i3 < boxes.length) {
            JsonObject boxObject = boxList.get(i3).asObject();
            FloatVect position = new FloatVect(boxObject.get("x").asFloat(), boxObject.get("y").asFloat());
            FloatVect size = new FloatVect(boxObject.get("width").asFloat(), boxObject.get("height").asFloat());
            boxes[i3] = new Box(position, size);
            ++i3;
        }
        JsonArray itemList = stateData.get("items").asArray();
        Item[] items = new Item[itemList.size()];
        int i4 = 0;
        while (i4 < items.length) {
            JsonObject itemObject = itemList.get(i4).asObject();
            String type = itemObject.get("type").asString();
            FloatVect position = new FloatVect(itemObject.get("x").asFloat(), itemObject.get("y").asFloat());
            FloatVect size = new FloatVect(itemObject.get("width").asFloat(), itemObject.get("height").asFloat());
            items[i4] = new Item(type, position, size);
            ++i4;
        }
        return new GameState(cars, shells, boxes, items);
    }
}

