/*
 * Decompiled with CFR 0.152.
 */
package com.petterroea.kartering;

import com.petterroea.kartering.GameState;
import com.petterroea.kartering.NetworkManager;
import com.petterroea.kartering.map.MatchData;
import com.petterroea.kartering.map.Tile;
import com.petterroea.kartering.math.AStarRoute;
import com.petterroea.kartering.math.AnalysisAStar;
import com.petterroea.kartering.math.FloatVect;
import com.petterroea.kartering.math.IntVect;

public class KarteringAi {
    private MatchData matchData = null;
    private AnalysisAStar astar = new AnalysisAStar();

    public static void main(String[] args) {
        new KarteringAi();
    }

    public KarteringAi() {
        System.out.println("We have started!");
        NetworkManager manager = new NetworkManager("127.0.0.1", 31337, "yoloman");
        this.matchData = manager.getMapData();
        manager.sendByte(0);
        int lastCheckpoint = -1;
        while (manager.Connected()) {
            GameState state = manager.getGameState();
            int checkpoint = state.getCheckpoint(this.matchData);
            if (checkpoint == lastCheckpoint + 1 && (lastCheckpoint = checkpoint) + 1 >= this.matchData.getPath().length) {
                lastCheckpoint = -1;
            }
            System.out.println("Target checkpoint: " + (lastCheckpoint + 1));
            boolean[] map = this.generateCollisionMap(this.matchData);
            IntVect currentCheckpoint = state.getTileCoord(state.getMyCar(this.matchData).getPosition().toIntVect(), this.matchData);
            System.out.println("Generating route from " + currentCheckpoint.getX() + ", " + currentCheckpoint.getY() + " to " + this.matchData.getPath()[lastCheckpoint + 1].getX() + ", " + this.matchData.getPath()[lastCheckpoint + 1].getY());
            AStarRoute route = this.astar.getRoute(map, this.matchData.getMapWidth(), currentCheckpoint, this.matchData.getPath()[lastCheckpoint + 1]);
            if (route != null) {
                System.out.println("Closest route to desstination: ");
                int i = 0;
                while (i < route.getPoints().length) {
                    System.out.print("[" + route.getPoints()[i].getX() + ", " + route.getPoints()[i].getY() + "]");
                    ++i;
                }
                System.out.println();
                manager.sendByte(this.steerTo(state.getCheckpointVector(route.getPoints()[1], this.matchData), state));
                continue;
            }
            manager.sendByte(this.steerTo(state.getCheckpointVector(this.matchData.getPath()[lastCheckpoint + 1], this.matchData), state));
        }
    }

    private int steerTo(FloatVect checkpointVector, GameState state) {
        FloatVect mySpeed = state.getMyCar(this.matchData).getDirection();
        checkpointVector = new FloatVect(checkpointVector.getX() - state.getMyCar(this.matchData).getPosition().getX(), checkpointVector.getY() - state.getMyCar(this.matchData).getPosition().getY());
        float degrees = -1.0f * ((float)Math.toDegrees(Math.atan2(mySpeed.dot(checkpointVector), mySpeed.det(checkpointVector))) - 90.0f);
        System.out.println("Got angle " + degrees);
        boolean steerLeft = false;
        steerLeft = degrees < 0.0f || degrees > 180.0f;
        float abs = Math.abs(degrees);
        if (abs < 10.0f) {
            return 33;
        }
        if (abs > 70.0f) {
            return 16 + (steerLeft ? 4 : 8) + 32;
        }
        return 1 + (steerLeft ? 4 : 8) + 32;
    }

    private boolean[] generateCollisionMap(MatchData matchData) {
        boolean[] map = new boolean[matchData.getMapWidth() * matchData.getMapHeight()];
        int x = 0;
        while (x < matchData.getMapWidth()) {
            int y = 0;
            while (y < matchData.getMapHeight()) {
                map[x + y * matchData.getMapWidth()] = matchData.getTile(x, y).getType() == Tile.TileType.BLANK;
                System.out.print(map[x + y * matchData.getMapWidth()] ? "1" : "0");
                ++y;
            }
            System.out.println();
            ++x;
        }
        return map;
    }
}

