/*
 * Decompiled with CFR 0.152.
 */
package com.petterroea.kartering;

import com.petterroea.kartering.Box;
import com.petterroea.kartering.Car;
import com.petterroea.kartering.Item;
import com.petterroea.kartering.Shell;
import com.petterroea.kartering.map.MatchData;
import com.petterroea.kartering.math.FloatVect;
import com.petterroea.kartering.math.IntVect;

public class GameState {
    private Car[] cars;
    private Shell[] shells;
    private Box[] boxes;
    private Item[] items;

    public GameState(Car[] cars, Shell[] shells, Box[] boxes, Item[] items) {
        this.cars = cars;
        this.shells = shells;
        this.boxes = boxes;
        this.items = items;
    }

    public Car[] getCars() {
        return this.cars;
    }

    public Car getCar(int id) {
        return this.cars[id];
    }

    public Shell[] getShells() {
        return this.shells;
    }

    public Shell getShell(int id) {
        return this.shells[id];
    }

    public Box[] getBoxes() {
        return this.boxes;
    }

    public Box getBox(int id) {
        return this.boxes[id];
    }

    public Item[] getItems() {
        return this.items;
    }

    public Item getItem(int id) {
        return this.items[id];
    }

    public Car getMyCar(MatchData data) {
        return this.cars[data.getSelfId()];
    }

    public IntVect getTileCoord(IntVect coord, MatchData data) {
        return new IntVect(coord.getX() / data.getTileWidth(), coord.getY() / data.getTileHeight());
    }

    public int getCheckpoint(MatchData data) {
        FloatVect myPos = this.getMyCar(data).getPosition();
        IntVect tile = this.getTileCoord(myPos.toIntVect(), data);
        int i = 0;
        while (i < data.getPath().length) {
            IntVect v = data.getPath()[i];
            if (v.getX() == tile.getX() && v.getY() == tile.getY()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public FloatVect getCheckpointVector(IntVect intVect, MatchData data) {
        return new FloatVect((float)(intVect.getX() * data.getTileWidth()) + (float)(data.getTileWidth() / 2), (float)(intVect.getY() * data.getTileHeight()) + (float)(data.getTileHeight() / 2));
    }
}

