#!/usr/bin/env python2
#written by pbsds on TG15
import json, random, socket, time, math, sys

g_ip = "localhost"
g_port = 31337
g_name = "pbsds"

g_CutCorners = True

g_movements = {"up": 1<<0,
               "down": 1<<1,
               "left": 1<<2,
               "right": 1<<3,
               "drift": 1<<4,
               "item": 1<<5}

#helpers:
def PointDistance((x, y), (x2, y2)):
	return math.sqrt((x2-x)*(x2-x) + (y2-y)*(y2-y))
def PointDirection((x, y), (x2, y2)):
	return math.atan2(y-y2, x2-x)/math.pi*180
def LengthDir(Dir, Len):#Dir is from 0-1
	return ( math.cos(float(Dir)*math.pi*2) * Len,
			-math.sin(float(Dir)*math.pi*2) * Len)
def DegreeDiff(dir1, dir2):
	return (((dir2-dir1) % 360)+540) % 360 - 180
def Pytagoras((kat1, kat2)):
	return math.sqrt(kat1**2 + kat2**2)
def PytagorasSq((kat1, kat2)):#squared, less resource intensive
	return kat1**2 + kat2**2
	
#OC content, plz don't steal
class AI:
	def __init__(self):
		self.sock = socket.socket()
		self.sock.connect((g_ip, g_port))
		
		self.write(g_name)
		stageinfo = self.read()
		
		#self.modifiers = stageinfo["map"]["modifiers"]
		self.map = stageinfo["map"]["tiles"]
		self.map_size = [len(self.map[0])*stageinfo["map"]["tile_width"], len(self.map)*stageinfo["map"]["tile_height"]]
		self.id = stageinfo["id"]
		self.path = [[i["tile_x"]*stageinfo["map"]["tile_width"]+stageinfo["map"]["tile_width"]/2, self.map_size[1]-(i["tile_y"]*stageinfo["map"]["tile_height"]+stageinfo["map"]["tile_height"]/2)] for i in stageinfo["map"]["path"]]
		
		#me: 
		self.goal = 0
		self.pos = [0, 0]
		self.dir = [1, 0]
		self.vel = [0, 0]
		self.powerup = "none"
		
		self.others = []
		
		self.sock.setblocking(0)#im ready
		
		self.write(1<<5) # Tell the server we are ready
	def write(self, msg):
		self.sock.sendall(str(msg)+"\n")
	def read(self):
		try:
			data = self.sock.makefile().readline()
			return json.loads(data)
		except:
			pass
	def run(self):
		#self.write(1<<5) # Tell the server we are ready
		
		while 1:
			info = self.read()
			if info:
				self.others = []
				for i in info["cars"]:
					if i["id"] == self.id:
						self.dir[0] = i["direction"]["x"]
						self.dir[1] = -i["direction"]["y"]
						self.pos[0] = i["pos"]["x"]
						self.pos[1] = self.map_size[1]-i["pos"]["y"]
						self.vel[0] = i["velocity"]["x"]
						self.vel[1] = -i["velocity"]["y"]
						#print i
						self.powerup = i["powerup"]
						
						#i["width"]
						#i["height"]
					else:
						self.others.append((i["id"], (i["pos"]["x"], self.map_size[1]-i["pos"]["y"])))
			
			#check if in goal:
			if PointDistance(self.pos, self.path[self.goal]) <= 80:#radius subject to change
				self.goal += 1#advance!
				if self.goal >= len(self.path):
					self.goal = 0
			
			#drive always. :P
			do = 0
			
			#steer:
			goal = self.path[self.goal][:]
			if g_CutCorners and PytagorasSq(self.vel) > 60**2:
				ngoal = self.path[self.goal+1 if self.goal+1 < len(self.path) else 0]
				goal[0] = (goal[0]+ngoal[0])/2
				goal[1] = (goal[1]+ngoal[1])/2
			wanted = PointDirection(self.pos, goal)
			current = PointDirection((0, 0), self.dir)
			diff = DegreeDiff(current, wanted)
			if diff > 1:
				do |= g_movements["right"]
			elif diff < -1:
				do |= g_movements["left"]
			
			#accelerate:
			if diff < 100:
				do |= g_movements["up"]
			
			#use item
			if self.powerup == "none":
				pass
			elif self.powerup == "greenshell":
				pass#aim?
				if random.random() < 0.005:
					do |= g_movements["item"]
			elif self.powerup == "redshell":
				pass#aim?
				if random.random() < 0.005:
					do |= g_movements["item"]
			elif self.powerup in ("banana", "oil", "lightning"):
				do |= g_movements["item"]
			elif self.powerup == "mushroom":
				#only if straight long road:
				ngoal = self.goal
				for _ in xrange(2):
					ngoal += 1
					if ngoal >= len(self.path):
						ngoal = 0
				diff = DegreeDiff(PointDirection(self.pos, self.path[ngoal]), PointDirection((0, 0), self.dir))
				
				if abs(diff) <= 5:
					do |= g_movements["item"]

			#elif self.powerup == "":
			#	pass
			else:
				do |= g_movements["item"]
			
			#debug
			print self.goal, PointDistance((0, 0), self.vel), self.powerup
			
			#do:
			self.write(do)
			time.sleep(0.02)

#main:
def main():
	ai = AI()
	ai.run()
if __name__ == "__main__":
	if len(sys.argv) >= 2:
		if sys.argv[1] == "nocut":
			print "Cutting corners disabled"
			g_CutCorners = False
	main()

