try:
	import ujson23
except:
	import json as ujson
	ujson.decode = ujson.loads
import math
import socket
try:
	import pygame
except:
	pass
import sys

host = "localhost"
port = 31337

if len(sys.argv) > 1:
	host = sys.argv[1]
	if len(sys.argv) > 2:
		port = int(sys.argv[2])

class TheKartering(object):
	class Car(object):
		def __init__(self, json):
			self.x = self.y = self.dir = self.velocity = self.width = self.height = self.powerup = self.drift = self.sprite = None
			try:
				self.__sprite = pygame.image.load("../kart/assets/car0.bmp").convert()
				self.__sprite.set_colorkey((255,0,255))
			except:
				pass
			try:
				self.x        = json["pos"]["x"]
				self.y        = json["pos"]["y"]
				self.velocity = json["velocity"]
				self.powerup  = json["powerup"]
				self.drift    = json["drift"]
				self.setSize(json["width"], json["height"])
				self.setDir(json["direction"]["x"], json["direction"]["y"])
			except Exception, e:
				print "Car.__init__:", e

		def setSize(self, width, height):
			if width != self.width or height != self.height:
				self.width = width
				self.height = height
				self.__dirty = True

		def setDir(self, x, y):
			direction = 180-math.degrees(math.atan2(-y,-x))
			if direction != self.dir:
				self.dir = direction
				self.__dirty = True

		def draw(self, surface):
			if self.__dirty:
				self.__scaledSprite = pygame.transform.scale(self.__sprite, (self.width, self.height))
				self.sprite = pygame.transform.rotate(self.__scaledSprite, self.dir)
				self.rect = self.sprite.get_rect()
			self.__dirty = False

			if self.sprite:
				surface.blit(self.sprite, (
					int(self.x-self.rect.width/2), # x
					int(self.y-self.rect.height/2) # y
				))


	class Tile(object):
		def __init__(self, x, y, width, height, type):
			self.x = self.y = self.type = None
			try:
				sprites = {
					"." : "../kart/assets/map-none.bmp",
					"/" : "../kart/assets/map-topleft.bmp",
					"-" : "../kart/assets/map-horizontal.bmp",
					"`" : "../kart/assets/map-topright.bmp",
					"|" : "../kart/assets/map-vertical.bmp",
					"\\": "../kart/assets/map-bottomleft.bmp",
					"," : "../kart/assets/map-bottomright.bmp",
					"+" : "../kart/assets/map-xing.bmp"
				}
				self.sprite = pygame.image.load(sprites[type]).convert()
			except:
				pass
			try:
				self.x      = x
				self.y      = y
				self.width  = width
				self.height = height
				self.type   = type
			except Exception, e:
				print "Tile.__init__:", e

		def getCenter(self):
			return (int((self.x+0.5)*self.width), int((self.y+0.5)*self.height))

		def getCorners(self):
			return [
				(self.x*self.width, self.y*self.height),
				((self.x+1)*self.width, self.y*self.height),
				((self.x+1)*self.width, (self.y+1)*self.height),
				(self.x*self.width, (self.y+1)*self.height),
			]

		def draw(self, surface):
			surface.blit(self.sprite, (int(self.x*self.width), int(self.y*self.height)))



	def __init__(self, host=host, port=port, gui=False):
		self.socket = socket.socket()
		self.host = host
		self.port = port

		self.name = type(self).__name__
		self.gui = gui

		self.state = None
		self.currentTile = None
		self.nextTile = None
		self.target = None

		pygame.init()
		self.clock = pygame.time.Clock()

		self.UP     = 1<<0
		self.DOWN   = 1<<1
		self.LEFT   = 1<<2
		self.RIGHT  = 1<<3
		self.DRIFT  = 1<<4
		self.ACTION = 1<<5

		self.BLACK = (0, 0, 0)
		self.RED = (255, 0, 0)
		self.GREEN = (0, 255, 0)

		self.car = None
		self.opponents = []
		self.obstacles = []


		self.connect()

		self.refinePath()

		tileSize = (self.__map["tile_width"], self.__map["tile_height"])
		mapData = self.__map["tiles"]

		if gui:
			screenSize = (len(mapData[0])*tileSize[0], len(mapData)*tileSize[1])
			self.__background = pygame.Surface(screenSize)
			self.__background.set_colorkey((255,0,255))
			self.screen = pygame.display.set_mode(screenSize)

		self.map = []
		for y, row in enumerate(mapData):
			self.map.append([])
			for x, tile in enumerate(row):
				self.map[y].append(self.Tile(x, y, tileSize[0], tileSize[1], tile))


		if self.gui:
			# draw map
			for row in self.map:
				for tile in row:
					tile.draw(self.__background)

			modifiers = {
				"mud": pygame.image.load("../kart/assets/mud.bmp").convert(),
				"booster": pygame.image.load("../kart/assets/booster.bmp").convert(),
				"ice": pygame.image.load("../kart/assets/ice.bmp").convert()
			}

			for modifier in modifiers:
				modifiers[modifier].set_colorkey((255,0,255))

			for modifier in self.__map["modifiers"]:
				if modifier["type"] in modifiers:
					self.__background.blit(modifiers[modifier["type"]], (modifier["x"], modifier["y"]))
				else:
					print "unknown modifier: ", modifier


			# points = map(lambda p:(int((p["tile_x"]+0.5)*tileSize[0]), int((p["tile_y"]+0.5)*tileSize[1])), self.path)
			# for point in points:
			# 	pygame.draw.circle(self.__background, self.RED, point, 5, 0)
			# pygame.draw.aalines(self.__background, self.RED, True, points, 1)

		self.run()

	def refinePath(self):
		pass

	def steerTowards(self, point):
		#debug
		if self.gui:
			pygame.draw.aalines(self.screen, self.GREEN, False, [(self.car.x, self.car.y), point], 1)
			pygame.draw.circle(self.screen, self.GREEN, point, 3, 0)

		p2p = 180-math.degrees(math.atan2(-(point[1]-self.car.y), -(point[0]-self.car.x)))
		command = self.UP
		try:
			angle = p2p-self.car.dir
			if angle > 180:
				angle = angle-360
			if angle < -180:
				angle = angle+360

			if angle < 0:
				command |= self.RIGHT
			elif angle > 0:
				command |= self.LEFT
		except Exception, e:
			print "TheKartering.steerTowards:", e

		return command

	def connect(self):
		self.socket.connect((self.host, self.port))
		pygame.time.wait(1000)
		self.sendCommand(self.name)
		self.receiveState()
		self.path = self.state["map"]["path"]
		self.id = int(self.state["id"])
		self.__map = self.state["map"]
		self.sendCommand(1<<5)
		self.socket.setblocking(0)

	def sendCommand(self, command):
		try:
			self.socket.send(str(command)+"\n")
		except Exception, e:
			pass

	def receiveState(self):
		try:
			self.state = ujson.decode(self.socket.recv(2048))
			car = self.state["cars"][self.id]
			if not self.car:
				self.car = self.Car(car)
			else:
				self.car.x        = car["pos"]["x"]+car["width"]/2
				self.car.y        = car["pos"]["y"]+car["height"]/2
				self.car.velocity = car["velocity"]
				self.car.powerup  = car["powerup"]
				self.car.drift    = car["drift"]
				self.car.setSize(car["width"], car["height"])
				self.car.setDir(car["direction"]["x"], car["direction"]["y"])
			
			self.currentTile = self.map[int(self.car.y//self.__map["tile_height"])][int(self.car.x//self.__map["tile_width"])]

			# first run
			if not self.nextTile:
				self.nextTile = self.currentTile
			if not self.target or self.currentTile == self.target:
				self.target = self.tileAfter(self.currentTile)
				# self.lastTarget = self.currentTile

			# if self.currentTile == self.target:
			# 	self.target = self.tileAfter(self.currentTile)
			# only update if we are currently on the tile that we were aiming for
			if self.currentTile == self.nextTile:
				# if not self.realTarget or self.currentTile == self.realTarget:
				# 	self.nextTile = self.tileAfter(self.lastTarget, True)
				#generate route to next tile
				import dijkstra
				graph = {}
				for r,row in enumerate(self.__map['tiles']):
					for t,tile in enumerate(row):
						edges = {}
						if tile == "-":
							edges[(t-1,r)]=1
							edges[(t+1,r)]=1
						elif tile == "|":
							edges[(t,r-1)]=1
							edges[(t,r+1)]=1
						elif tile == "\\":
							edges[(t,r-1)]=1
							edges[(t+1,r)]=1
						elif tile == "/":
							edges[(t,r+1)]=1
							edges[(t+1,r)]=1
						elif tile == ",":
							edges[(t,r-1)]=1
							edges[(t-1,r)]=1
						elif tile == "`":
							edges[(t,r+1)]=1
							edges[(t-1,r)]=1
						elif tile == "+":
							edges[(t,r-1)]=1
							edges[(t,r+1)]=1
							edges[(t-1,r)]=1
							edges[(t+1,r)]=1
						graph[(t,r)]=edges
				dist, path = dijkstra.dijkstra(graph, source=(self.currentTile.x,self.currentTile.y))
				path = dijkstra.shortest_path(graph, (self.currentTile.x,self.currentTile.y), (self.target.x,self.target.y))
				self.nextTile = self.map[path[1][1]][path[1][0]]

		except Exception, e:
			print "TheKartering.receiveState:", e

	def tileAfter(self, tile):
		try:
			currentTileIdx = self.path.index({u'tile_y': tile.y, u'tile_x': tile.x})
			nextTileIdx = (currentTileIdx+1)%len(self.path)
		except:
			nextTileIdx = 0
		return self.map[int(self.path[nextTileIdx]["tile_y"])][int(self.path[nextTileIdx]["tile_x"])]

	def getActionFromKeyboard(self):
		commands = {
			273: self.UP,
			274: self.DOWN,
			276: self.LEFT,
			275: self.RIGHT,
			44:  self.DRIFT,
			46:  self.ACTION
		}
		pressed = pygame.key.get_pressed()
		action = 0
		for key in commands:
			if pressed[key] == 1:
				action |= commands[key]
		return action

	def run(self):
		while True:
			for event in pygame.event.get():
				if event.type == pygame.QUIT:
					pygame.quit()
					sys.exit(0)
			if self.gui:
				self.screen.fill(self.BLACK)
				self.screen.blit(self.__background, (0,0))
				if self.currentTile:
					pygame.draw.aalines(self.screen, self.GREEN, True, self.currentTile.getCorners(), 1)
				if self.nextTile:
					pygame.draw.aalines(self.screen, self.RED, True, self.nextTile.getCorners(), 1)
				if self.car:
					self.car.draw(self.screen)
					pygame.draw.circle(self.__background, self.GREEN, (int(self.car.x),int(self.car.y)), 3, 0)

			command = self.loop()
			self.sendCommand(command)
			self.receiveState()

			if self.gui:
				pygame.display.flip()
			self.clock.tick(20)

	def loop(self):
		print "Remember to re-implement the loop method"