-- Name: reflect.lua

function getFunction(fnname)
  local dt = 0
  if type(fnname) == "string" then
    dt = debug.getinfo(
      load("return " .. string.gsub(fnname, ":", "."))())
  end
  if type(fnname) == "function" then
    dt = debug.getinfo(fnname)
  end
  if dt == 0 then do return "",nil end end
  if string.sub(dt.source, 1,1) == "@" then
    --print(dt.short_src)
    --print(dt.linedefined, dt.lastlinedefined)
    local filetext = readFile(dt.short_src)
    -- this perhaps needs to be written in lua
    local fntext = selectLines(filetext, dt.linedefined, dt.lastlinedefined)
    --print(fntext)
    return fntext,dt
  else
    local fntext = selectLines(dt.source, dt.linedefined, dt.lastlinedefined)
    --print(fntext)
    return fntext,dt
  end
end

function editfn(fnname)
  local fntxt = getFunction(fnname)
  --newBuffer()
  setBufferName(fnname .. ".lua")
  setBufferText(fntxt)
end
