#include "ShaderCommon.fx"
#include "Noise.fx"

Texture2D<float4> InputTexture;

cbuffer DistortionParams
{
	float4 distortionParams;			// x = activation
										// y = power
										// z = distortion multiplier
										// w = time based attenuation
};

float4 DistortionPS(FullScreenVertexOut input) : SV_Target
{
	float2 uv = input.uv;
	float distortion = uv.y * distortionParams.z * 10.0f;
	float d = distortionParams.x * distortion;

	if(d > 0.0f)
	{
		d = pow(abs(d), distortionParams.y * d);
		uv.x += d * noise(float3(uv.y, 0.0f, 0.0f) * distortionParams.w);
	}

	return InputTexture.SampleLevel(BilinearClampSampler, uv, 0);
}