#include "ShaderCommon.fx"

#define LUT_SLICE_SIZE		32.0f

Texture2D<float4> Framebuffer;
Texture2D<float4> LUT;

// Composites the final scene to screen performing colour grading
float4 CompositePS( FullScreenVertexOut input ) : SV_Target0
{
	const float sliceSize = 1.0f / LUT_SLICE_SIZE;
	const float slicePixelSize = sliceSize / LUT_SLICE_SIZE;

	float4 c = Framebuffer.Sample(PointClampSampler, input.uv);
	float4 gradedColor = Sample3D(LUT, c.xyz, sliceSize, slicePixelSize, LUT_SLICE_SIZE);
	gradedColor.a = c.a;
	return gradedColor;
}