#include "ShaderCommon.fx"

cbuffer Params
{
	float2 direction;
	float amount;
	float post_aberration_padding;
};

Texture2D<float4> SceneBuffer;

float4 aberrate(float2 uv)
{
	float4 c = float4(0.0f, 0.0f, 0.0f, 1.0f);
	float2 aberration = direction * amount;
	c.r = SceneBuffer.Sample(BilinearWrapSampler, uv + aberration).r;
	c.g = SceneBuffer.Sample(BilinearWrapSampler, uv ).g;
	c.b = SceneBuffer.Sample(BilinearWrapSampler, uv - aberration).b;
	c.a = SceneBuffer.Sample(BilinearWrapSampler, uv).a;

	return c;
}

float4 PostChromaticAberrationPS(FullScreenVertexOut input) : SV_Target0
{
	float4 finalColor = aberrate(input.uv);
	return finalColor;
}

float4 PostDepthBasedChromaticAberrationPS(FullScreenVertexOut input) : SV_Target0
{
	float depth = DepthBuffer.Sample(PointClampSampler, input.uv).w;
	float4 baseColor = SceneBuffer.Sample(BilinearWrapSampler, input.uv);
	float4 finalColor = aberrate(input.uv);
	return lerp(baseColor, finalColor, 1.0f - depth);
}