#include "inc/uniforms.glsl"
#include "inc/utils.glsl"
#define pi 3.141592653589
uniform vec4 drawColor;
#ifdef VERTEX
#include "inc/geometry_io.vs"


uniform float p_jump;
void process() 
{
	float frak = fract(p_beat);
	vec4 p = in_Position;
	float len2 = sqrt(length(p.xz));
	float jump =  max(0.0, (0.5-frak) ) + max(0.0, -sin(len2*1.0+p_beat*2.0*pi))*0.2;
	
	p.y += jump * 1.0 * p_jump;
	//p.xz *= 1.0 + jump*0.2;
	ex_Position = (viewMatrix*modelMatrix)*p;	
	gl_Position = (modelViewProject)*p;
}

#define PROCESSING_FUNCTION process
#include "inc/geometry.vs"

#endif


#ifdef FRAGMENT
#include "inc/geometry_io.fs"
uniform sampler2D scroller;

void main()
{
	float f = pow(fract(p_beat*4.0), 2.0);
	float f2 = fract(p_beat);
	vec2 uv = ex_Position.xy*(0.05) + vec2(p_beat + sin(p_beat*2.0*pi)*0.1 , 0.0);
	vec4 sample = texture(scroller, uv);
	vec3 col = vec3(f)*12.0 * mix(vec3(1.0), sample.rgb, sample.a);
	out_Color = vec4(col, 1.0);
}
#endif
