#include "inc/uniforms.glsl"
#include "inc/utils.glsl"

#line 3 1

#ifdef VERTEX
#line 1 4
#include "inc/geometry_io.vs"
#line 10 1
flat out int frame;
flat out float bright;
uniform float p_progress;
float slnoise(float a, float s) {
	return fract(299.1*cos(1984.9 + s*199.1*a));
}
void process() 
{
	float j = in_Color.a;

	vec3 pos = vec3(.0, .0, -5.0);

	vec2 orig_pos = mat2(cos(p_beat), sin(p_beat), -sin(p_beat), cos(p_beat))*15.0*vec2(-1.0 + 2.0*slnoise(j, 1.9), -1.0 + 2.0*slnoise(j, 1.7));
	vec3 b = vec3(slnoise(j, 1.3),  slnoise(j, 1.5), .0);
	
	b.z = 1.0 - b.x - b.y;
	if (b.z > .0)
		b = vec3(1.0-b.x, 1.0-b.y, -1.0+b.x+b.y);
	vec2 tri_pos = vec2(.0, -.5);
	for (int k = 0; k < 3; ++k) {
		float angle = float(k) * 3.141592 * 2.0 / 3.0;
		tri_pos += b[(k+int(j))%3]*1.8*vec2(sin(angle), -cos(angle));
	}
	pos.xy += mix(tri_pos, orig_pos, clamp(exp(-p_beat*2+827+exp(b.z)*30.0), .0, 1.0)+clamp((p_beat-435)*.01, .0, .02)*pow(sin(p_beat*3.141592*.25-b.z*2.0),2.0));

	pos.xy = mix(pos.xy, vec2(8.0*sin(p_beat*2.0+pos.y), 10.0), clamp((p_beat - 460)*.1, .0, 1.0));

	frame = int(mod(p_beat*2.0 + j, 4.0));
	bright = 1.0 + 9.0*float(0==int(mod(p_beat*2.0+j, 7.0)));
	float alpha = j;
	float alpha2 = clamp((p_beat - 442.0)*0.05, 0.0, 1.0);
	
	mat2x2 rot = mat2(cos(alpha), sin(alpha), -sin(alpha), cos(alpha));
	mat2x2 rot2 = mat2(cos(alpha2), sin(alpha2), -sin(alpha2), cos(alpha2));
	ex_Position = vec4((rot*in_Position.xy)*.08, -1.0, 1.0) + vec4(pos, .0);

	ex_Position.xy *= 1.0 + .1*exp(1.0 - mod(p_beat, 1.0));
	ex_Position.xy = rot2*ex_Position.xy;

	gl_Position = projectionMatrix * ex_Position;
	
	ex_UV = in_UV;
}

#define PROCESSING_FUNCTION process
#line 1 5
#include "inc/geometry.vs"

#endif


#ifdef FRAGMENT
#line 1 6
//in vec4 ex_Color;
//smooth in vec3 ex_Normal; 
smooth in vec2 ex_UV;
in vec4 ex_Position; //viewspace

layout(location = 0) out vec4 out_Color;

flat in int frame;
flat in float bright;
uniform sampler2D tex;
#line 1 7
void main()
{
	vec4 col = .2*texture(tex, .5*(ex_UV + vec2(float(frame % 2), float(frame / 2))))*vec4(bright);
	out_Color = mix(vec4(col.xyz, 1.0), vec4(vec3(col.x+col.y+col.z), 1.0), .3);
}
#endif
