uniform float u_stretch;
uniform float u_logoalpha;
uniform float u_logoalpha2;
uniform float u_open;
uniform float u_flash;
uniform float u_bright;
uniform float u_sellpoint;
uniform float u_testophase;

float stretch;
vec2 transform(mat3 rotmtx, vec3 pos)
{
	vec3 rot = rotmtx * pos;

	rot.y *= stretch;
//	rot.y = max(rot.y, -1.0);
	
	vec2 tmp = (rot.xy*4.0) / (rot.z + 6.0);
	
	return tmp;
}

float triangle(vec2 v1, vec2 v2, vec2 v3)
{
	if (dot((v2-v1).yx*vec2(1.0,-1.0), (uv2-v1)) > 0.0)
		return 0.0;
	
	if (dot((v3-v2).yx*vec2(1.0,-1.0), (uv2-v2)) > 0.0)
		return 0.0;

	if (dot((v1-v3).yx*vec2(1.0,-1.0), (uv2-v3)) > 0.0)
		return 0.0;
	
	return 1.0;
}

#if 0
float quad(vec2 v1, vec2 v2, vec2 v3, vec2 v4)
{	
	if (dot((v2-v1).yx*vec2(-1.0,1.0), (uv2-v1)) < 0.0)
		return 0.0;
	
	if (dot((v3-v2).yx*vec2(-1.0,1.0), (uv2-v2)) < 0.0)
		return 0.0;

	if (dot((v4-v3).yx*vec2(-1.0,1.0), (uv2-v3)) < 0.0)
		return 0.0;

	if (dot((v1-v4).yx*vec2(-1.0,1.0), (uv2-v4)) < 0.0)
		return 0.0;

	return 1.0;
}
#else
// pöllitty!
float smin( float a, float b, float k )
{
    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return mix( b, a, h ) - k*h*(1.0-h);
}

float quad(vec2 v1, vec2 v2, vec2 v3, vec2 v4)
{
	float test = 1.0;
	vec2 mid = (v1+v2+v3+v4) / 4.0;


	test = smin(test, dot((v2-v1).yx*vec2(-1.0,1.0), (uv2-v1)), 0.02);
	test = smin(test, dot((v3-v2).yx*vec2(-1.0,1.0), (uv2-v2)), 0.02);
	test = smin(test, dot((v4-v3).yx*vec2(-1.0,1.0), (uv2-v3)), 0.02);
	test = smin(test, dot((v1-v4).yx*vec2(-1.0,1.0), (uv2-v4)), 0.02);

	float d = 1.0;
	if (test < 0.0)
		d =  pow(max(0.3 + test * 1.0, 0.0), 1.0);

//	if (length(uv2-mid) < 0.1)
//		d = max(0.0, 1.0 - d);

	return d;
}
#endif

vec4 function(void)
{
	float ft = motionblur(5.0);
	float ang2d = mod(ft * 1.0, 3.14159*2.0) + 3.0 * sin(ft);
	
  mat2 mat2d = mat2(sin(ang2d), cos(ang2d), -cos(ang2d), sin(ang2d));

	float ang = mod(ft * 1.0, 3.14159*2.0) + 1.0 * sin(ft);
	float ang2 = mod(ft * 1.23, 3.14159*2.0) + 5.0 * cos(ft * 0.9);
	float ang3 = ft * 1.255;
//    ang2 = 0.0;
//    ang3 = 0.0;


	vec2 uvr = uv2;
//	ang2 = 1.0;
//	ang3 *= 0.5 + sin(ft) * 0.5;
//	ang = 1.0;

	stretch = 1.0;
//	stretch = max(1.0, 10.0-ft);
	stretch = u_stretch;

//	ang = pow(ft, 2.0);
	ang -= uvr.y * max(0.0, stretch-1.0);

//	stretch = 1.0 + clamp(ft-5.0, 0.0, 10.0);


	
  //  ang += sin((uvr.x + uvr.y)*2.0 + ft) * 0.3;
 //   ang2 += sin((uvr.x + uvr.y)*2.0 + ft) * 0.3;

//	ang3 += sin((uvr.x + uvr.y)*2.0 + ft ) * 0.5;
//	ang += sin((uvr.x * -0.1 + uvr.y)*1.3 + ft * 1.5 ) * 0.5;
	
//    vec3 pp1 = vec3(0.5+ cos(ft * 2.0)*0.4, 0.1 + sin(ft * 2.0)*0.8, 0.0);

	vec4 c = vec4(0.0);

	if (stretch < 10.0)
	{
		vec3 pp1 = vec3(0.5, 0.5, 0.5);
		vec3 pp2 = vec3(-0.5, 0.5, 0.5);
		vec3 pp3 = vec3(-0.5, -0.5, 0.5);
		vec3 pp4 = vec3(0.5, -0.5, 0.5);
		vec3 pp5 = vec3(0.5, 0.5, -0.5);
		vec3 pp6 = vec3(-0.5, 0.5, -0.5);
		vec3 pp7 = vec3(-0.5, -0.5, -0.5);
		vec3 pp8 = vec3(0.5, -0.5, -0.5);
		
		vec3 n1 = vec3(0.0, 0.0, 1.0);
		vec3 n2 = vec3(0.0, 0.0, -1.0);
		vec3 n3 = vec3(0.0, 1.0, 0.0);
		vec3 n4 = vec3(0.0, -1.0, 0.0);
		vec3 n5 = vec3(-1.0, 0.0, 0.0);
		vec3 n6 = vec3(1.0, 0.0, 0.0);
		
		mat3 rot_y = mat3(
			cos(ang), 0.0, -sin(ang),
			0.0,      1.0, 0.0,
			sin(ang), 0.0, cos(ang));
		mat3 rot_x = mat3(
			1.0, 0.0, 0.0,
			0.0, cos(ang2), -sin(ang2),
			0.0, sin(ang2), cos(ang2));
		mat3 rot_z = mat3(
			cos(ang3), -sin(ang3), 0.0,
			sin(ang3), cos(ang3), 0.0,
			0.0, 0.0, 1.0);

		mat3 rot = rot_y * rot_x * rot_z;


		vec2 pv1 = transform(rot, pp1);
		vec2 pv2 = transform(rot, pp2);
		vec2 pv3 = transform(rot, pp3);
		vec2 pv4 = transform(rot, pp4);
		vec2 pv5 = transform(rot, pp5);
		vec2 pv6 = transform(rot, pp6);
		vec2 pv7 = transform(rot, pp7);
		vec2 pv8 = transform(rot, pp8);



		
		vec3 pn1 = rot * n1;
		vec3 pn2 = rot * n2;
		vec3 pn3 = rot * n3;
		vec3 pn4 = rot * n4;
		vec3 pn5 = rot * n5;
		vec3 pn6 = rot * n6;
		
		
		vec3 ld = normalize(vec3(1.0, 0.0, -1.4));
		float l1 = clamp(dot(pn1, ld), 0.1, 1.0);
		float l2 = clamp(dot(pn2, ld), 0.1, 1.0);
		float l3 = clamp(dot(pn3, ld), 0.1, 1.0);
		float l4 = clamp(dot(pn4, ld), 0.1, 1.0);
		float l5 = clamp(dot(pn5, ld), 0.1, 1.0);
		float l6 = clamp(dot(pn6, ld), 0.1, 1.0);
		
		vec3 fc1 = vec3(0.32, 0.72, 0.19) * l1;
		vec3 fc2 = vec3(0.15, 0.83, 0.38) * l2;
		vec3 fc3 = vec3(0.27, 0.75, 0.46) * l3;
		vec3 fc4 = vec3(0.53, 0.41, 0.34) * l4;
		vec3 fc5 = vec3(0.42, 0.22, 0.13) * l5;
		vec3 fc6 = vec3(0.33, 0.76, 0.24) * l6;
		


		float s = 0.0;
		s += pow(texture2D(u_blurnoise, uv2 * 0.08 + vec2(ft * 0.01, 0.3)).r, 13.0) * 0.3;
		s += pow(texture2D(u_blurnoise, uv2 * 0.08 + vec2(ft * 0.04, 0.9)).r, 13.0) * 0.6;
		s += pow(texture2D(u_blurnoise, uv2 * 0.08 + vec2(ft * 0.07, 0.7)).r, 13.0) * 0.8;
		s += pow(texture2D(u_blurnoise, uv2 * 0.08 + vec2(ft * 0.1, 0.5)).r, 13.0) * 1.0;
		c = vec4(s);
#if 1
	c.xyz = mix(c.xyz, fc1,quad(pv4,pv3,pv2, pv1));
	c.xyz = mix(c.xyz, fc2,quad(pv5,pv6,pv7, pv8));

	c.xyz = mix(c.xyz, fc3,quad(pv1,pv2,pv6, pv5));
	c.xyz = mix(c.xyz, fc4,quad(pv3,pv4,pv8, pv7));

	c.xyz = mix(c.xyz, fc5,quad(pv2,pv3,pv7, pv6));
	c.xyz = mix(c.xyz, fc6,quad(pv4,pv1,pv5, pv8));
#endif
		c.xyz = clamp(c.xyz, vec3(0.0), vec3(1.0));

		vec2 uv2swt = uv2;
//		float openings = smoothstep(0.0, 1.0, (u_open-2.0))-1.0;
		float openings = u_open-2.0-1.0;
		uv2swt.x += max(-abs(uv2swt.x), openings) * sign(uv2swt.x);
		vec2 swtuv = uv2swt * 0.5 + vec2(0.5);
		vec4 swtcol = texture2D(iChannel2, swtuv);
//		c = mix(c, swtcol, swtcol.a);
		c.rgb = mix(c.rgb, pow(c.rgb,vec3(2.4))*1.5+swtcol.rgb, swtcol.a);


		vec4 spc = texture2D(iChannel4, uv2 * vec2(0.42,2.2) + vec2(0.5,2.2));
		float realval = 0;

		realval += spc.r * max(0.0, 1.0 - abs(u_sellpoint-1.0)*1.5);
		realval += spc.g * max(0.0, 1.0 - abs(u_sellpoint-2.0)*1.5);
		realval += spc.b * max(0.0, 1.0 - abs(u_sellpoint-3.0)*1.5);

		c += vec4(1.0) * realval;
	}

	vec2 uv2a = uv2;
	uv2a.y = abs(uv2a.y)-u_open;

	vec2 texpos = uv2*0.3*vec2(-0.45/uv2a.y,1.0)+vec2(0.5);
	 float lightsize = 5.0;
	float valomul = max(0.0, length(texpos-vec2(0.5, 0.2))*1.0);

	if (uv2a.y > 0.0)
	{
		c = texture2D(iChannel0, (mat2d*uv2a + vec2(ft+sin(ft*3.4)))*0.6) * 1.0;
		if (uv2.y > 0.0)
		{
			c.rgb = c.bgr;
		}
	}
	else
		valomul += 1.0;




	c *= valomul;
	lightsize += sin(ft * 40.0) * 0.1;
//	c += pow(max(0.0, 1.0 - length(texpos-vec2(0.5, 0.2))*lightsize), 2.0);


	if (uv2a.y > 0.0)
	{
		vec2 uv2b = uv2;
		uv2b.y -= u_open * sign(uv2b.y);


		vec2 paskatexpos;

		vec2 map3d = vec2(1.0-abs(uv2b.x)*0.2, 1.5-abs(uv2b.x)*0.7);
		float wavyness = sin(uv2.x * 1.0 - ft + u_testophase)*u_logoalpha2;
		float scrollpos = ft*0.2+u_testophase * 0.3;
		paskatexpos = uv2a * vec2(0.25,5.0) * map3d + vec2(0.5) + vec2(scrollpos, wavyness);

		float logowater = 1.0;
		if (uv2b.y < 0.0)
		{
			logowater = 0.3;
			paskatexpos.x += sin(ft +  uv2b.y * 55.0) * uv2b.y * 0.04;
		}


		c = mix(c, vec4(1.0), clamp(1.0-abs(uv2b.y)*6.0+abs(uv2b.x)*1.0, 0.0, texture2D(iChannel3, paskatexpos).r*u_logoalpha2*logowater));

		paskatexpos = uv2b * 0.5;
		vec4 mummo = texture2D(iChannel1, paskatexpos + vec2(0.5));
		 c = mix(c, mummo, mummo.a * u_logoalpha);

		 float fc = pow(max(1.0 - (ft-u_flash) * 3.0, 0.0), 2.0);
		 c += vec4(fc);
}


	
	return c + vec4(u_bright);
}