	define SNA_FILENAME "test.sna"
	define TRD_FILENAME "test.trd"
	define BIN_FILENAME "test.bin"

	device zxspectrum128

	define _PLAY_MUSIC
	define _INT_FLOW

	page 0
		
	org #6000
page0s	di : ld sp, $-2
	ld a, #10 : call setPage

	ifdef _PLAY_MUSIC
	call PT3PLAY
	endif
		
	ld a,#5c, i,a, hl,interr, (#5cff),hl : im 2 : ei

	; main flow
	ld a, 0 : out (#fe), a
	ld a, #11 : call setPage
	ld hl,SPLASH_BG, de,#4000, bc,#1b00 : ldir
	ld a, #10 : call setPage
	module splash_delay


	; wait pattern
1	ld a, 3
	ld hl, CUR_PATTERN
	cp (hl) : jr nz, 1b

	
	endmodule
	ld a, 17 : call setPage
	ld hl,MAIN_BG, de,#4000, bc,#1b00 : ldir
	

	ld hl,#5ac0 : ld d,h, e,l : inc de : ld bc,64 - 1, (hl),68 : ldir
		
	
	call ANIMATION1 : halt : jr $-4
	jr $

	;int flow
	ifdef _INT_FLOW
	; Обработчик перываний. Вызывается каждый int
intFlow
	ld hl, INT_DATA
ifMain	ld a, (hl) : inc hl
	cp #ff : ret z	; end of flow
	or a : jr z, ifSkip7
	ld a, (hl) : inc hl : call setPage
	ld a, (hl) : inc hl : ld (ifCall + 1), a
	ld a, (hl) : inc hl : ld (ifCall + 2), a
	push hl 
ifCall	call #0000
	pop hl
	dec (hl) : ld a, (hl) : inc hl : cp #ff : jr nz, ifSkip3
	dec (hl) : ld a, (hl) : inc hl : cp #ff : jr nz, ifSkip2
	; закончили эффект
	ld de, #0006 : sbc hl, de : xor a : ld (hl), a : add hl, de
	inc hl
	ld a, (hl) : inc hl : cp #ff : jr z, ifMain ; после эффекта ничего
	push hl
	call intFlowPush
	pop hl
	jr ifMain
ifSkip7	dup 4 : inc hl : edup
ifSkip3	inc hl	
ifSkip2	inc hl
ifSkip1	inc hl
	jr ifMain

	; Обработчик таймлайна. Вызывается после каждой смены паттерна
timelineUpdate
	; остановить процедуры, если stop_pattern == CUR_PATTERN
	ld hl, CUR_PATTERN
	ld ix, INT_DATA
	ld de, #0008
tuStage1c	ld a, (ix + 0) : cp #ff : jr z, tuStage2
	or a : jr z, tuStage1e
	ld a, (ix + 6) : cp (hl) : jr nz, tuStage1e

	; останавливаем
	xor a : ld (ix + 0), a
tuStage1e	add ix, de
	jr tuStage1c

tuStage2	; сжать main cycle (выкинуть остановленные, остальное уплотнить)
	ld hl, INT_DATA
	ld de, INT_DATA
	ld bc, #0008
tuStage2c	ld a, (hl) : cp #ff : jr z, tuStage3
	or a : jr nz, tuStage2sk
	; переносим
	push bc : ldir : pop bc	
	jr tuStage2c
tuStage2sk	add hl, bc : jr tuStage2c

tuStage3	; добавить процедуры, если start_pattern == CUR_PATTERN
	ld ix, CUR_PATTERN
	ld hl, TIMELINE
	ld de, #0008
tuStage3c	ld a, (hl) : cp #ff : ret z
	cp (ix + 0) : jr nz, tuStage3e
	push hl, de
	call intFlowPushHL
	pop de, hl
tuStage3e	add hl, de : jr tuStage3c

	; Добавляем процедуру в обработчик перываний
	; a - номер процедуры в TIMELINE
intFlowPush
	sla a : sla a : sla a
	ld h, #00 : ld l, a
	ld de, TIMELINE
	add hl, de
intFlowPushHL
	ld de, INT_DATA
	ld bc, #0008
ifpCycle	ld a, (de) 
	or a : jr z, ifpDo
	cp #ff : jr z, ifpDo
	dup 8 : inc de : edup
	jr ifpCycle
ifpDo	ld a, #fe : ld (hl), a ; защита от повторного добавления
	; заносим
	ldir
	ex de, hl : ld de, #0008 : sbc hl, de : ld a, #01 : ld (hl), a ; маркер `run`
	
	ret

INT_DATA	block 16*08, #ff
TIMELINE
	db #03		; start pattern
	db #10		; proc page
	dw INTFLOW0		; proc address
	dw #0004		; ints counter
	db #ff		; stop pattern
	db #01		; next run

	db #fe		; start pattern
	db #13		; proc page
	dw SCROLL_FUNC		; proc address
	dw #ffff		; ints counter
	db #ff		; stop pattern
	db #ff		; next run

	db #03		; start pattern
	db #10		; proc page
	dw INTFLOW2		; proc address
	dw #0004		; ints counter
	db #ff		; stop pattern
	db #03		; next run

	db #fe		; start pattern
	db #10		; proc page
	dw INTFLOW3		; proc address
	dw #ffff		; ints counter
	db #ff		; stop pattern
	db #ff		; next run

	db #03		; start pattern
	db #10		; proc page
	dw INTFLOW4		; proc address
	dw #0004		; ints counter
	db #ff		; stop pattern
	db #05		; next run

	db #fe		; start pattern
	db #10		; proc page
	dw INTFLOW5		; proc address
	dw #ffff		; ints counter
	db #ff		; stop pattern
	db #ff		; next run


	db #ff		; end of TIMELINE

INTFLOW0
	ret

INTFLOW2
	ret

INTFLOW3
ANIMATION2
	module animation2


anima	ld a, #01 : dec a : ld (anima + 1), a : ret nz	; animation pause
anima_p	ld hl, anima_proc
	ld a, (hl) : or a : jr nz, 1f
	ld hl, anima_proc + 4
1	ld a, (hl) : ld (anima + 1), a
	
	; set page
	inc hl : ld a, (hl) : call setPage

	inc hl : ld e, (hl)
	inc hl : ld d, (hl)
	inc hl : ld (anima_p + 1), hl
	ex de, hl

	; determine data flow start
	push hl
1	ld a, (hl) : inc hl : cp %11111111
	jr nz, 1b
	pop ix

	; set start address
	ld a, (hl) : ld e, a : inc hl
	ld a, (hl) : ld d, a : inc hl
_an_cycle	ld a, (ix + 0) : inc ix
	bit 7, a : jr z, 1f
	ld c, a
	and #e0
	cp #a0 : jr z, _anc_jmp100
	ret 
	; end of frame		
1	bit 6, a : jr z, _anc_set
_anc_jmp	; jump screen address
	and #3f
	inc a : ld c, a : ld b, 0
	ex de, hl : add hl, bc : ex de, hl
	jr _an_cycle
_anc_jmp100	ld a, c
	and #0f
	or a : jr z, 1f
	inc d : dec a : jr nz, $-2
1	ld a, c : and %00010000 : jr z, _an_cycle
	ld bc, #0080	; additional jump +128 bytes
	ex de, hl : add hl, bc : ex de, hl
	jr _an_cycle
_anc_set	; copy N bytes from flow to screen
	inc a
	ldi : dec a : jr nz, $-3
	jr _an_cycle
anima_proc
	db 3, 1 : dw A2_1_0000
	db 3, 1 : dw A2_1_0001
	db 3, 1 : dw A2_1_0002
	db 3, 1 : dw A2_1_0003
	db 3, 1 : dw A2_1_0004
	db 3, 1 : dw A2_1_0005
	db 3, 1 : dw A2_1_0006
	db 3, 1 : dw A2_1_0007
	db 3, 1 : dw A2_1_0008
	db 3, 1 : dw A2_1_0009
	db 3, 1 : dw A2_1_000a
	db 3, 1 : dw A2_1_000b
	db 3, 1 : dw A2_1_000c
	db 3, 1 : dw A2_1_000d
	db 3, 1 : dw A2_1_000e
	db 3, 1 : dw A2_1_000f
	db 3, 1 : dw A2_1_0010
	db 3, 1 : dw A2_1_0011
	db 3, 1 : dw A2_1_0012
	db 3, 1 : dw A2_1_0013
	db 3, 1 : dw A2_1_0014
	db 3, 1 : dw A2_1_0015
	db 3, 1 : dw A2_1_0016
	db 3, 1 : dw A2_1_0017
	db 3, 1 : dw A2_1_0018
	db 3, 1 : dw A2_1_0019
	db 3, 1 : dw A2_1_001a
	db 3, 1 : dw A2_1_001b
	db 3, 1 : dw A2_1_001c
	db 3, 1 : dw A2_1_001d
	db 3, 1 : dw A2_1_001e
	db 3, 1 : dw A2_1_001f
	db 3, 1 : dw A2_1_0020
	db 3, 1 : dw A2_1_0021
	db 3, 1 : dw A2_1_0022
	db 3, 1 : dw A2_1_0023
	db 3, 1 : dw A2_1_0024
	db 3, 1 : dw A2_1_0025
	db 3, 1 : dw A2_1_0026
	db 3, 1 : dw A2_1_0027
	db 3, 1 : dw A2_1_0028
	db 3, 1 : dw A2_1_0029
	db 3, 1 : dw A2_1_002a
	db 3, 1 : dw A2_1_002b
	db 3, 1 : dw A2_1_002c
	db 3, 1 : dw A2_1_002d
	db 3, 1 : dw A2_1_002e
	db 3, 1 : dw A2_1_002f
	db 3, 1 : dw A2_1_0030
	db 3, 1 : dw A2_1_0031
	db 3, 1 : dw A2_1_0032
	db 3, 1 : dw A2_1_0033
	db 3, 1 : dw A2_1_0034
	db 3, 1 : dw A2_1_0035
	db 3, 3 : dw A2_3_0036
	db 3, 3 : dw A2_3_0037
	db 3, 3 : dw A2_3_0038
	db 3, 3 : dw A2_3_0039
	db 3, 3 : dw A2_3_003a
	db 3, 3 : dw A2_3_003b
	db 3, 3 : dw A2_3_003c
	db 3, 3 : dw A2_3_003d
	db 3, 3 : dw A2_3_003e
	db 3, 3 : dw A2_3_003f
	db 3, 3 : dw A2_3_0040
	db 3, 3 : dw A2_3_0041
	db 3, 3 : dw A2_3_0042
	db 3, 3 : dw A2_3_0043
	db 3, 3 : dw A2_3_0044
	db 3, 3 : dw A2_3_0045
	db 3, 3 : dw A2_3_0046
	db 3, 1 : dw A2_1_0047
	db 3, 3 : dw A2_3_0048
	db 3, 3 : dw A2_3_0049
	db 3, 3 : dw A2_3_004a
	db 3, 3 : dw A2_3_004b
	db 3, 3 : dw A2_3_004c
	db 3, 3 : dw A2_3_004d
	db 3, 3 : dw A2_3_004e
	db 3, 3 : dw A2_3_004f
	db 3, 3 : dw A2_3_0050
	db 3, 3 : dw A2_3_0051
	db 3, 3 : dw A2_3_0052
	db 3, 3 : dw A2_3_0053
	db 3, 3 : dw A2_3_0054
	db 3, 3 : dw A2_3_0055
	db 3, 3 : dw A2_3_0056
	db 3, 3 : dw A2_3_0057
	db 3, 3 : dw A2_3_0058
	db 3, 3 : dw A2_3_0059
	db 3, 3 : dw A2_3_005a 
	db #00
	
	
	endmodule
INTFLOW4
	ret

INTFLOW5
ANIMATION3
	module animation3


anima	ld a, #01 : dec a : ld (anima + 1), a : ret nz	; animation pause
anima_p	ld hl, anima_proc
	ld a, (hl) : or a : jr nz, 1f
	ld hl, anima_proc + 4			; revert to start of animation
1	ld a, (hl) : ld (anima + 1), a
	inc hl : ld a, (hl) : call setPage
	inc hl : ld e, (hl)
	inc hl : ld d, (hl)
	inc hl : ld (anima_p + 1), hl
	ex de, hl
	jp (hl)
anima_proc
	db 5, 3 : dw A3_3_0000
	db 5, 3 : dw A3_3_0001
	db 5, 3 : dw A3_3_0002
	db 5, 3 : dw A3_3_0003
	db 5, 3 : dw A3_3_0004
	db 5, 3 : dw A3_3_0005
	db 5, 3 : dw A3_3_0006
	db 5, 3 : dw A3_3_0007
	db 5, 3 : dw A3_3_0008
	db 5, 3 : dw A3_3_0009
	db 5, 3 : dw A3_3_000a
	db 5, 3 : dw A3_3_000b
	db 5, 3 : dw A3_3_000c
	db 5, 3 : dw A3_3_000d
	db 5, 4 : dw A3_4_000e
	db 5, 4 : dw A3_4_000f 
	db #00
	
	
	endmodule
	
	endif


CUR_PAGE	db #00
setPage	ld (CUR_PAGE), a : ld bc,#7ffd : out(c), a : ret

	ifdef _PLAY_MUSIC
CUR_PATTERN	db #ff
_curPattern	db #ff	
	align #100
PT3PLAY	include "sources/PTxPlay.asm"
	incbin "res/music"
	else
	; always 0 pattern
CUR_PATTERN	db #00
	endif


interr	di
	push af,bc,de,hl,ix,iy
	exx : ex af, af'
	push af,bc,de,hl,ix,iy
	; save current page
	ld a, (CUR_PAGE)
	ld (_CP_REST + 1), a

	ifdef _INT_FLOW
	call intFlow
	endif

	ifdef _PLAY_MUSIC
	call PT3PLAY + 5
	ld a, (PT3PLAY + 11)
	ld hl, _curPattern 
	cp (hl) : jr z, 1f
	ld (hl), a
	ld hl, CUR_PATTERN : inc (HL)
1	
	endif

	ifdef _INT_FLOW
	call timelineUpdate
	endif

	; restore page
_CP_REST	ld a, #00 : call setPage
	pop iy,ix,hl,de,bc,af
	exx : ex af, af'
	pop iy,ix,hl,de,bc,af
	ei
	ret

ANIMATION1
	module animation1


anima	ld a, #01 : dec a : ld (anima + 1), a : ret nz	; animation pause
anima_p	ld hl, anima_proc
	ld a, (hl) : or a : jr nz, 1f
	ld hl, anima_proc + 4
1	ld a, (hl) : ld (anima + 1), a
	
	; set page
	inc hl : ld a, (hl) : call setPage

	inc hl : ld e, (hl)
	inc hl : ld d, (hl)
	inc hl : ld (anima_p + 1), hl
	ex de, hl

	; determine data flow start
	push hl
1	ld a, (hl) : inc hl : cp %11111111
	jr nz, 1b
	pop ix

	; set start address
	ld a, (hl) : ld e, a : inc hl
	ld a, (hl) : ld d, a : inc hl
_an_cycle	ld a, (ix + 0) : inc ix
	bit 7, a : jr z, 1f
	ld c, a
	and #e0
	cp #a0 : jr z, _anc_jmp100
	ret 
	; end of frame		
1	bit 6, a : jr z, _anc_set
_anc_jmp	; jump screen address
	and #3f
	inc a : ld c, a : ld b, 0
	ex de, hl : add hl, bc : ex de, hl
	jr _an_cycle
_anc_jmp100	ld a, c
	and #0f
	or a : jr z, 1f
	inc d : dec a : jr nz, $-2
1	ld a, c : and %00010000 : jr z, _an_cycle
	ld bc, #0080	; additional jump +128 bytes
	ex de, hl : add hl, bc : ex de, hl
	jr _an_cycle
_anc_set	; copy N bytes from flow to screen
	inc a
	ldi : dec a : jr nz, $-3
	jr _an_cycle
anima_proc
	db 5, 1 : dw A1_1_0000
	db 5, 1 : dw A1_1_0001
	db 5, 1 : dw A1_1_0002
	db 5, 1 : dw A1_1_0003
	db 5, 1 : dw A1_1_0004
	db 5, 1 : dw A1_1_0005
	db 5, 1 : dw A1_1_0006
	db 5, 1 : dw A1_1_0007 
	db #00
	
	
	endmodule
page0e	display /d, 'Page 0 free: ', #ffff - $
	define _page1 : page 1 : org #c000
page1s
SPLASH_BG	incbin "res/splash_bg"
MAIN_BG	incbin "res/main_bg"
A1_1_0000	include "res/A1_1_0000.asm"
A1_1_0001	include "res/A1_1_0001.asm"
A1_1_0002	include "res/A1_1_0002.asm"
A1_1_0003	include "res/A1_1_0003.asm"
A1_1_0004	include "res/A1_1_0004.asm"
A1_1_0005	include "res/A1_1_0005.asm"
A1_1_0006	include "res/A1_1_0006.asm"
A1_1_0007	include "res/A1_1_0007.asm"
A2_1_0000	include "res/A2_1_0000.asm"
A2_1_0001	include "res/A2_1_0001.asm"
A2_1_0002	include "res/A2_1_0002.asm"
A2_1_0003	include "res/A2_1_0003.asm"
A2_1_0004	include "res/A2_1_0004.asm"
A2_1_0005	include "res/A2_1_0005.asm"
A2_1_0006	include "res/A2_1_0006.asm"
A2_1_0007	include "res/A2_1_0007.asm"
A2_1_0008	include "res/A2_1_0008.asm"
A2_1_0009	include "res/A2_1_0009.asm"
A2_1_000a	include "res/A2_1_000a.asm"
A2_1_000b	include "res/A2_1_000b.asm"
A2_1_000c	include "res/A2_1_000c.asm"
A2_1_000d	include "res/A2_1_000d.asm"
A2_1_000e	include "res/A2_1_000e.asm"
A2_1_000f	include "res/A2_1_000f.asm"
A2_1_0010	include "res/A2_1_0010.asm"
A2_1_0011	include "res/A2_1_0011.asm"
A2_1_0012	include "res/A2_1_0012.asm"
A2_1_0013	include "res/A2_1_0013.asm"
A2_1_0014	include "res/A2_1_0014.asm"
A2_1_0015	include "res/A2_1_0015.asm"
A2_1_0016	include "res/A2_1_0016.asm"
A2_1_0017	include "res/A2_1_0017.asm"
A2_1_0018	include "res/A2_1_0018.asm"
A2_1_0019	include "res/A2_1_0019.asm"
A2_1_001a	include "res/A2_1_001a.asm"
A2_1_001b	include "res/A2_1_001b.asm"
A2_1_001c	include "res/A2_1_001c.asm"
A2_1_001d	include "res/A2_1_001d.asm"
A2_1_001e	include "res/A2_1_001e.asm"
A2_1_001f	include "res/A2_1_001f.asm"
A2_1_0020	include "res/A2_1_0020.asm"
A2_1_0021	include "res/A2_1_0021.asm"
A2_1_0022	include "res/A2_1_0022.asm"
A2_1_0023	include "res/A2_1_0023.asm"
A2_1_0024	include "res/A2_1_0024.asm"
A2_1_0025	include "res/A2_1_0025.asm"
A2_1_0026	include "res/A2_1_0026.asm"
A2_1_0027	include "res/A2_1_0027.asm"
A2_1_0028	include "res/A2_1_0028.asm"
A2_1_0029	include "res/A2_1_0029.asm"
A2_1_002a	include "res/A2_1_002a.asm"
A2_1_002b	include "res/A2_1_002b.asm"
A2_1_002c	include "res/A2_1_002c.asm"
A2_1_002d	include "res/A2_1_002d.asm"
A2_1_002e	include "res/A2_1_002e.asm"
A2_1_002f	include "res/A2_1_002f.asm"
A2_1_0030	include "res/A2_1_0030.asm"
A2_1_0031	include "res/A2_1_0031.asm"
A2_1_0032	include "res/A2_1_0032.asm"
A2_1_0033	include "res/A2_1_0033.asm"
A2_1_0034	include "res/A2_1_0034.asm"
A2_1_0035	include "res/A2_1_0035.asm"
A2_1_0047	include "res/A2_1_0047.asm"
page1e	display /d, 'Page 1 free: ', #ffff - $
	define _page3 : page 3 : org #c000
page3s
SCROLL_FUNC
	module scroll_text
	
	
S16CNTP	ld a, #0f : inc a : and #0f : ld (S16CNTP + 1), a
	or a : jr nz, p1scroll
S16CNT	ld hl, SCROLL_TEXT - 1 
	inc hl : ld (S16CNT + 1), hl
	ld a, (hl) : or a : jp nz, 1f
		
	; restart scroll
	ld hl, SCROLL_TEXT 
	ld (S16CNT + 1), hl
	ld a, (hl)

1	call drw_sym16x16
		
p1scroll
	ld de, #50df		; scroll screen address
	ld hl, SCROLL_BUFF + 1
	ld a, #10 : ld (p1sA + 1), a

p1s1	scf : ccf ; reset carry
	
	rl (hl) : dec hl : rl (hl)
	inc hl : inc hl : inc hl

	ex de, hl
	push hl
	dup 32
	rl (hl) : dec hl
	edup
	pop hl
	call downHL
	ex de, hl
p1sA	ld a, #00 : dec a : ld (p1sA + 1), a : ret z : jp p1s1

drw_sym16x16	
	sub #20 : cp #60 : jr C, $+4 : sub #60	; fix chr for cutted font
		
	ld H, #00 : ld L, A
	DUP 5
	add hl, hl ; HL = HL*32
	EDUP
		
	ld bc, FONT16X16
	add hl, bc	; Адрес спрайта
	ld (_ds16SP + 1), SP
	ld sp, hl 
	
	ld hl, SCROLL_BUFF 
	DUP 16
	pop bc : ld (hl), c : inc hl : ld (hl), b : inc hl
	EDUP
_ds16SP	ld SP, #0000	
	ret
downHL	inc h : ld a,h : and #07 : ret nz : ld a,l : sub #e0 : ld l,a : sbc a,a : and #f8 : add a,h : ld h,a : ret
	
	endmodule
SCROLL_BUFF	block 512
SCROLL_TEXT	incbin "res/scroll"
	db #00
FONT16X16	incbin "res/16x16font"
A2_3_0036	include "res/A2_3_0036.asm"
A2_3_0037	include "res/A2_3_0037.asm"
A2_3_0038	include "res/A2_3_0038.asm"
A2_3_0039	include "res/A2_3_0039.asm"
A2_3_003a	include "res/A2_3_003a.asm"
A2_3_003b	include "res/A2_3_003b.asm"
A2_3_003c	include "res/A2_3_003c.asm"
A2_3_003d	include "res/A2_3_003d.asm"
A2_3_003e	include "res/A2_3_003e.asm"
A2_3_003f	include "res/A2_3_003f.asm"
A2_3_0040	include "res/A2_3_0040.asm"
A2_3_0041	include "res/A2_3_0041.asm"
A2_3_0042	include "res/A2_3_0042.asm"
A2_3_0043	include "res/A2_3_0043.asm"
A2_3_0044	include "res/A2_3_0044.asm"
A2_3_0045	include "res/A2_3_0045.asm"
A2_3_0046	include "res/A2_3_0046.asm"
A2_3_0048	include "res/A2_3_0048.asm"
A2_3_0049	include "res/A2_3_0049.asm"
A2_3_004a	include "res/A2_3_004a.asm"
A2_3_004b	include "res/A2_3_004b.asm"
A2_3_004c	include "res/A2_3_004c.asm"
A2_3_004d	include "res/A2_3_004d.asm"
A2_3_004e	include "res/A2_3_004e.asm"
A2_3_004f	include "res/A2_3_004f.asm"
A2_3_0050	include "res/A2_3_0050.asm"
A2_3_0051	include "res/A2_3_0051.asm"
A2_3_0052	include "res/A2_3_0052.asm"
A2_3_0053	include "res/A2_3_0053.asm"
A2_3_0054	include "res/A2_3_0054.asm"
A2_3_0055	include "res/A2_3_0055.asm"
A2_3_0056	include "res/A2_3_0056.asm"
A2_3_0057	include "res/A2_3_0057.asm"
A2_3_0058	include "res/A2_3_0058.asm"
A2_3_0059	include "res/A2_3_0059.asm"
A2_3_005a	include "res/A2_3_005a.asm"
A3_3_0000	include "res/A3_3_0000.asm"
A3_3_0001	include "res/A3_3_0001.asm"
A3_3_0002	include "res/A3_3_0002.asm"
A3_3_0003	include "res/A3_3_0003.asm"
A3_3_0004	include "res/A3_3_0004.asm"
A3_3_0005	include "res/A3_3_0005.asm"
A3_3_0006	include "res/A3_3_0006.asm"
A3_3_0007	include "res/A3_3_0007.asm"
A3_3_0008	include "res/A3_3_0008.asm"
A3_3_0009	include "res/A3_3_0009.asm"
A3_3_000a	include "res/A3_3_000a.asm"
A3_3_000b	include "res/A3_3_000b.asm"
A3_3_000c	include "res/A3_3_000c.asm"
A3_3_000d	include "res/A3_3_000d.asm"
page3e	display /d, 'Page 3 free: ', #ffff - $
	define _page4 : page 4 : org #c000
page4s
A3_4_000e	include "res/A3_4_000e.asm"
A3_4_000f	include "res/A3_4_000f.asm"
page4e	display /d, 'Page 4 free: ', #ffff - $
	include "sources/builder.asm"