
function toHex(c) {
    var hex = c.toString(16);
    return hex.length == 1 ? "0" + hex : hex;
}
function rgbToHex(r,g,b){
    var rHex = toHex(r);
    var gHex = toHex(g);
    var bHex = toHex(b);
    return "0x"+rHex+gHex+bHex;
}
function Effect5() {
    var a = 0,
        map;
    var pp;
    var renderTexture;
    var vertShader;
    var uniforms;
    var ms;
    var q;
    var startTime;
    var light;
    //init START
    renderer.setSize(WIDTH, HEIGHT);
    container.appendChild(renderer.domElement); //linking rendering window to container on the DOM
    //getters
    /*NONE :-)*/
    //setters
    /*
     *updates screen!!!1111onenoneoneelevenelevenonehundredandaeleven
     */


    pp = new THREE.PlaneGeometry(WIDTH / HEIGHT, 6.0);
    renderTexture = new THREE.WebGLRenderTarget(WIDTH, HEIGHT, {
        minFilter: THREE.LinearFilter,
        magFilter: THREE.NearestFilter,
        format: THREE.RGBFormat
    });
    vertShader = [
        'varying vec4 verpos;',
        'void main() {',
        'gl_Position = projectionMatrix *',
        'modelViewMatrix *',
        'vec4(position,1.0);',
        '}'
    ].join('\n');

    uniforms = {
        scene: {
            type: "t",
            value: renderTexture
        },
        iResolution: {
            type: 'v2',
            value: new THREE.Vector2(WIDTH, HEIGHT)
        },
        globalTime: {
            type: 'f',
            value: (new Date()).getDate()
        },
        logo: {type:'t', value:logo}
    };
    ms = /*new THREE.ShaderMaterial({ map:renderTexture, side:THREE.DoubleSide });*/
        new THREE.ShaderMaterial({
            uniforms: uniforms,
            vertexShader: vertShader,
            fragmentShader: document.getElementById('effect5fs').textContent,
            depthWrite: false,
            side: THREE.DoubleSide
        });
    q = new THREE.Mesh(pp, ms);
    var partiCount = 2000;
    var partic = new THREE.Geometry();
    var pmat = new THREE.ParticleBasicMaterial({
        opacity:0.1,
        sizeAttenuation:true,
        color: 0x4f4f5f,
        size:1
    });
    for (var i = 0; i < partiCount; i++) {

        var x = Math.random()*500-250;
        var y = Math.random()*500-250;
        var z = Math.random()*500-250;
        particle = new THREE.Vector3(x, y, z);
        
        partic.vertices.push(particle);
    }
    var partisystem = new THREE.ParticleSystem(partic, pmat);


    this.start = function(){
        q.position.z = -1;
        scene3D.add(camera3D); //lets add our camera to the scene
        scene2D.add(camera2D);
        scene3D.add(partisystem);
        //calculate_effect5();
        startTime = demosong.currentTime;
        drive.position.set(-20.0, 4.0, -70.0);
        scene3D.add(terminal);
        scene3D.add(drive);
        light = new THREE.PointLight();
        light.position.set(50, 150, -1050);
        scene3D.add(light);

    for(var i=0; i<32; i++)
            ribboner[i] = new Ribbon(calculate_ribbon(0, Math.ceil(i)*0.3, 0), 1+i*2.20);

      for (var i = 0; i < 700; i++) 
        scene3D.add(floor[i]);
        scene3D.add(floor[floor.length - 1]);
        scene2D.add(q);
    }
    //snd.play();
    this.updateScreen = function () {
        var time = (demosong.currentTime - startTime);
        this.render3D();
        this.render2D();
        uniforms.globalTime.value = time;
    };
    this.render2D = function () {
        renderer.render(scene2D, camera2D);
    }
    this.cameraMovement = function (time, cameraNumber) {
    	switch(cameraNumber){
    		case 0:
	            camera3D.position.x = time*1.5;
	            camera3D.position.y = 12+time;
	            camera3D.position.z = Math.max(-160.0-time*0.1,-200);
            	camera3D.lookAt(new THREE.Vector3(0.0, 20.0, 0.0));
                scene3D.fog = new THREE.Fog(0x0f0f0f, 300+10*time, 400+11*time);
    			break;
    		case 1:
	            camera3D.position.x = 20.0;
	            camera3D.position.y = 30+time;
	            camera3D.position.z = -200.0;
            	camera3D.lookAt(new THREE.Vector3(20.0, 10.0, -110.0));
        		light.position.set(camera3D.position.x, camera3D.position.y, camera3D.position.z);
                scene3D.fog = new THREE.Fog(0x0f0f0f, 300+10*time, 400+11*time);
    			break;
    		case 2:
	            camera3D.position.x = Math.cos((10+Math.PI*20.0)/180.0+time*0.0025)*444*Math.sin(90+time*0.005);
	            camera3D.position.y = time*0.8;
	            camera3D.position.z = Math.sin((10+Math.PI*20.0)/180.0+time*0.0025)*444*Math.sin(90+time*0.0025);
            	camera3D.lookAt(new THREE.Vector3(0.0, 20.0, 0.0));
        		light.position.set(camera3D.position.x, camera3D.position.y, camera3D.position.z);
                scene3D.fog = new THREE.Fog(0x0f0f0f, 300+10*time, 400+11*time);
    			break;
    		case 3:
	            camera3D.position.x = Math.cos(time*0.0025)*(1200+111*Math.sin(time*0.005));
	            camera3D.position.y = 30+6*time;
	            camera3D.position.z = Math.sin(time*0.0025)*(1200+111*Math.sin(time*0.0025));
            	camera3D.lookAt(new THREE.Vector3(0.0, 20.0, 0.0));
        		light.position.set(0.0, time*3.0, 0.0);
                scene3D.fog = new THREE.Fog(0x0f0f0f, 1200+10*time, 1200+17*time);
    			break;
            case 4:
                camera3D.position.x = 22.0+time*0.25;
                camera3D.position.y = 14.0;
                camera3D.position.z = -193.0;
                camera3D.lookAt(new THREE.Vector3(0.0, 14.0, -110.0));
                light.position.set(0.0, 14.0, -410.0);
                scene3D.fog = new THREE.Fog(0x0f0f0f, 300+10*time, 400+11*time);
                break;

    	}
    }
    this.render3D = function () {
        var time = (demosong.currentTime - startTime);
            for (var i = 0; i < ribboner.length; i++)
                scene3D.remove(obju[i]);
        //var geo =effect5(time);
        if(time<54.0-5.0)
        for (var i = 0; i < floor.length - 2; i++)
            floor[i].position.y = Math.min(floor[i].position.y + floorspeed[i] * (time - passedtime), floorheight[i] / 2.0);
        else
            {
            for (var i = 0; i < 20; i++){
                scene3D.remove(floor[floor.length-1]);
                floor.pop();
                }
            }
        if (time < 54.0-5.0)
            for (var i = 0; i < ribboner.length; i++) {
                var geo = ribboner[i].update(time);
                geo.computeFaceNormals();
                var material = new THREE.MeshPhongMaterial({
                    color: ribbonPalette[i & 7]
                });
                obju[i] = new THREE.Mesh(geo, material);
                obju[i].material.side = THREE.DoubleSide;
                scene3D.add(obju[i]);
            }
        if (time>0 && time<8)
            this.cameraMovement(time, 0);
        else if (time>=8 && time<16)
            this.cameraMovement(time, 4);
        else if (time>=16 && time<24)
            this.cameraMovement(time, 2);
        else if (time>=24 && time<28)
            this.cameraMovement(time, 0);
        else if (time>=28 && time<35)
            this.cameraMovement(time, 1);
        else if (time>=35)
            this.cameraMovement(time, 3);


        //renderer.render(scene3D, camera3D);
        renderer.render(scene3D, camera3D, renderTexture, true);
        passedtime = time;
    }
};