
function Effect3() {
	//init START
	console.log("Width:"+WIDTH+";Height:"+HEIGHT+";");		//size check for browser compatibility
	renderer.setSize(WIDTH, HEIGHT);
	container.appendChild(renderer.domElement);				//linking rendering window to container on the DOM
	scene2D.add(camera2D);										//lets add our camera2D to the scene2D

    var manager = new THREE.LoadingManager();
    manager.onProgress = function (item, loaded, total) {
        console.log(item, loaded, total);
    };
    var texture = new THREE.Texture();
    var loader = new THREE.ImageLoader(manager);
    
	var vertShader = [
		'varying vec4 verpos;',
		'void main() {',
		'gl_Position = projectionMatrix *',
		'modelViewMatrix *',
		'vec4(position,1.0);',
		'}'
		].join('\n'); 
	var startTime = demosong.currentTime;
	var fragShader = document.getElementById( 'effect3fs' ).innerHTML;

	var size = 256;
	var dataColor = new Float32Array( size * 4 );
		for(var i = 0; i < size; i++)
		{
			dataColor[ i * 4 + 0 ] = 0.0;
			dataColor[ i * 4 + 1 ] = 0.0;
			dataColor[ i * 4 + 2 ] = 0.0;
			dataColor[ i * 4 + 3 ] = 0.0;
			//console.log(result[i].end[0] +","+result[i].end[1])
		}
	var map = new THREE.DataTexture(dataColor, size, 1, THREE.RGBAFormat, THREE.FloatType );
	map.needsUpdate = true;


	var uniforms = {
		iResolution: {type: 'v2', value: new THREE.Vector2(WIDTH,HEIGHT)},
		globalTime: {type: 'f', value: (new Date()).getDate()},
		points: {type:'t', value:map},
		background: {type:'t', value:background_effect3}

		}
	var shaderMaterial = new THREE.ShaderMaterial({
		vertexShader: vertShader, 
		fragmentShader: fragShader,
		uniforms: uniforms
		}
		);
	var geo = new THREE.Geometry();
	geo.vertices.push(new THREE.Vector3(-1.0, -1.0, 0.0));
	geo.vertices.push(new THREE.Vector3(1.0, -1.0, 0.0));
	geo.vertices.push(new THREE.Vector3(1.0, 1.0, 0.0));
	geo.vertices.push(new THREE.Vector3(-1.0, 1.0, 0.0));
	geo.faces.push( new THREE.Face3(0,1,2));
	geo.faces.push( new THREE.Face3(0,2,3));
	var cube = new THREE.Mesh( geo, shaderMaterial);
	cube.position.z=-1;
	scene2D.add(cube);
	//getters
	/*NONE :-)*/
	//setters
	/*
	 *updates screen!!!1111onenoneoneelevenelevenonehundredandaeleven
	 */
	this.updateScreen = function() {
		var time = (demosong.currentTime - startTime)+ 5.0;
		var size = 256;
		var dataColor = new Float32Array( size * 4 );
		var result = puutos.get(time);
		puutos.update(time);
		var l = 120;
		for(var i = 0; i < l; i++)
		{
			dataColor[ i * 4 + 0 ] = -0.1*Math.cos(i*0.001+time*0.01345+i/9.10);
			dataColor[ i * 4 + 1 ] = Math.sin(i*0.001+time*0.0135+i/9.22)*0.1;
			dataColor[ i * 4 + 2 ] = (1.0-Math.cos(i/3.0)*0.07)*Math.cos(i*0.001+time*0.0135+i/9.1);
			dataColor[ i * 4 + 3 ] = Math.sin(i*0.001+time*0.0135+i/9.22)*(1.0-Math.cos(i/3.0)*0.07);
		}
		/*
		for (var i = 0; i < size; i ++) {
		    dataColor[ i * 3 ]     = 128+Math.cos(time+i/(8.0*Math.PI))*64*Math.sin(uniforms.globalTime.value);
		    dataColor[ i * 3 + 1 ] = 128+Math.sin(time.value+i/(8.0*Math.PI))*64*Math.sin(uniforms.globalTime.value);
		    dataColor[ i * 3 + 2 ] = 1.0;
		}
		*/
		var map = new THREE.DataTexture(dataColor, size, 1, THREE.RGBAFormat, THREE.FloatType );
		map.needsUpdate = true;

		uniforms.points.value = map;
		uniforms.globalTime.value = time;
		renderer.render(scene2D, camera2D);
	};
};
