//#line 1 90

#include "uniforms.glsl"
#include "utils.glsl"
//#line 3 1

#ifdef VERT_SHADER
//#line 2
#include "geometry_vertex_io.glsl"
//#line 8 1

uniform float p_geom_distort;

void process() 
{
	vec4 pos = (modelMatrix)*in_Position;
	// pos is in world space coords
	
	
	float alpha = pos.z * (1.0 + sin(pos.z*0.4))*0.01;
	alpha *= p_geom_distort;
	mat2 rot = mat2(cos(alpha),  -sin(alpha),
					sin(alpha), cos(alpha));
			
	float roll = p_geom_distort*-0.2;
	roll*= 1.0;
	mat2 rollMat = mat2(cos(roll),  -sin(roll),
					sin(roll), cos(roll));
					
	
	pos.z += sin(pos.z + p_time)*0.2;
	pos.x += sin(pos.x)*0.2;
	pos.z += 8.0;
		
	pos.xy = rot*pos.xy;
	pos.xy = rollMat*pos.xy;
	
	pos.x += 4.0;

	
	//ex_Position = viewMatrix*pos;
	//gl_Position = (viewMatrix*projectionMatrix)*(pos); 
	
	
	ex_Position = viewMatrix*pos;
	//ex_Position = (viewMatrix*modelMatrix)*in_Position;
	//gl_Position = (projectionMatrix*viewMatrix*modelMatrix)*in_Position;
	gl_Position = (projectionMatrix*viewMatrix)*pos; 
}

#define PROCESSING_FUNCTION process
//#line 1 3
#include "geometry_base_vertex.glsl"
#endif
//#line 51 1


#ifdef FRAG_SHADER
//#line 56 4
#include "geometry_base_fragment_io.glsl"
void main()
{
	vec4 sampld = texture(tex, ex_UV.xy);
	vec3 col = sampld.rgb;

	if (sampld.a <= ALPHA_TEST_THRESHOLD) {
		discard;
	}
	
	col.rgb = mix(vec3(0.0, 0.0, 0.0), col.rgb, min(1.0,(400.0/pow(length(ex_Position.z), 2.0))*1.0));
	
	out_Color = vec4(col, 1.0);
	
	out_Position = ex_Position.xyz;
	out_Normal = compressv3(ex_Normal.xyz);
	out_Material = vec4(texture(emitMap, ex_UV.xy).r, 0.0, 0.0, 0.0);
}

#endif

